# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 third_party_provider: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] name: Required. The resource name of the channel. Must be unique within the location on the project.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        pulumi.set(__self__, "location", location)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if third_party_provider is not None:
            pulumi.set(__self__, "third_party_provider", third_party_provider)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name of the channel. Must be unique within the location on the project.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @third_party_provider.setter
    def third_party_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_party_provider", value)


@pulumi.input_type
class _ChannelState:
    def __init__(__self__, *,
                 activation_token: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 third_party_provider: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Channel resources.
        :param pulumi.Input[str] activation_token: Output only. The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        :param pulumi.Input[str] create_time: Output only. The creation time.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the channel. Must be unique within the location on the project.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] pubsub_topic: Output only. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        :param pulumi.Input[str] state: Output only. The state of a Channel. Possible values: STATE_UNSPECIFIED, PENDING, ACTIVE, INACTIVE
        :param pulumi.Input[str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        :param pulumi.Input[str] uid: Output only. Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[str] update_time: Output only. The last-modified time.
        """
        if activation_token is not None:
            pulumi.set(__self__, "activation_token", activation_token)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if third_party_provider is not None:
            pulumi.set(__self__, "third_party_provider", third_party_provider)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        """
        return pulumi.get(self, "activation_token")

    @activation_token.setter
    def activation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_token", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name of the channel. Must be unique within the location on the project.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The state of a Channel. Possible values: STATE_UNSPECIFIED, PENDING, ACTIVE, INACTIVE
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @third_party_provider.setter
    def third_party_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_party_provider", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 third_party_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Eventarc Channel resource

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-west1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key1_member = gcp.kms.CryptoKeyIAMMember("key1_member",
            crypto_key_id=key1["id"],
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.Channel("primary",
            location="us-west1",
            name="channel",
            project=test_project.project_id,
            crypto_key_name=key1["id"],
            third_party_provider=f"projects/{test_project.project_id}/locations/us-west1/providers/datadog",
            opts = pulumi.ResourceOptions(depends_on=[key1_member]))
        ```

        ## Import

        Channel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/channels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Channel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default projects/{{project}}/locations/{{location}}/channels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the channel. Must be unique within the location on the project.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc Channel resource

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-west1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key1_member = gcp.kms.CryptoKeyIAMMember("key1_member",
            crypto_key_id=key1["id"],
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.Channel("primary",
            location="us-west1",
            name="channel",
            project=test_project.project_id,
            crypto_key_name=key1["id"],
            third_party_provider=f"projects/{test_project.project_id}/locations/us-west1/providers/datadog",
            opts = pulumi.ResourceOptions(depends_on=[key1_member]))
        ```

        ## Import

        Channel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/channels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Channel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default projects/{{project}}/locations/{{location}}/channels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 third_party_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            __props__.__dict__["crypto_key_name"] = crypto_key_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["third_party_provider"] = third_party_provider
            __props__.__dict__["activation_token"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["pubsub_topic"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Channel, __self__).__init__(
            'gcp:eventarc/channel:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_token: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            crypto_key_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pubsub_topic: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            third_party_provider: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_token: Output only. The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        :param pulumi.Input[str] create_time: Output only. The creation time.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the channel. Must be unique within the location on the project.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] pubsub_topic: Output only. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        :param pulumi.Input[str] state: Output only. The state of a Channel. Possible values: STATE_UNSPECIFIED, PENDING, ACTIVE, INACTIVE
        :param pulumi.Input[str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        :param pulumi.Input[str] uid: Output only. Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[str] update_time: Output only. The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelState.__new__(_ChannelState)

        __props__.__dict__["activation_token"] = activation_token
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_name"] = crypto_key_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pubsub_topic"] = pubsub_topic
        __props__.__dict__["state"] = state
        __props__.__dict__["third_party_provider"] = third_party_provider
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Channel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> pulumi.Output[str]:
        """
        Output only. The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        """
        return pulumi.get(self, "activation_token")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. The resource name of the channel. Must be unique within the location on the project.



        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Output[str]:
        """
        Output only. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The state of a Channel. Possible values: STATE_UNSPECIFIED, PENDING, ACTIVE, INACTIVE
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

