# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GoogleChannelConfigArgs', 'GoogleChannelConfig']

@pulumi.input_type
class GoogleChannelConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GoogleChannelConfig resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] name: Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        """
        pulumi.set(__self__, "location", location)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _GoogleChannelConfigState:
    def __init__(__self__, *,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GoogleChannelConfig resources.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] update_time: Output only. The last-modified time.
        """
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class GoogleChannelConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Eventarc GoogleChannelConfig resource

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-west1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key1_member = gcp.kms.CryptoKeyIAMMember("key1_member",
            crypto_key_id=key1["id"],
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.GoogleChannelConfig("primary",
            location="us-west1",
            name="channel",
            project=test_project.project_id,
            crypto_key_name=key1["id"],
            opts = pulumi.ResourceOptions(depends_on=[key1_member]))
        ```

        ## Import

        GoogleChannelConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/googleChannelConfig`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, GoogleChannelConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default projects/{{project}}/locations/{{location}}/googleChannelConfig
        ```

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GoogleChannelConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc GoogleChannelConfig resource

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project(project_id="my-project-name")
        test_key_ring = gcp.kms.get_kms_key_ring(name="keyring",
            location="us-west1")
        key = gcp.kms.get_kms_crypto_key(name="key",
            key_ring=test_key_ring.id)
        key1_member = gcp.kms.CryptoKeyIAMMember("key1_member",
            crypto_key_id=key1["id"],
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{test_project.number}@gcp-sa-eventarc.iam.gserviceaccount.com")
        primary = gcp.eventarc.GoogleChannelConfig("primary",
            location="us-west1",
            name="channel",
            project=test_project.project_id,
            crypto_key_name=key1["id"],
            opts = pulumi.ResourceOptions(depends_on=[key1_member]))
        ```

        ## Import

        GoogleChannelConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/googleChannelConfig`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, GoogleChannelConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default projects/{{project}}/locations/{{location}}/googleChannelConfig
        ```

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/googleChannelConfig:GoogleChannelConfig default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param GoogleChannelConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GoogleChannelConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GoogleChannelConfigArgs.__new__(GoogleChannelConfigArgs)

            __props__.__dict__["crypto_key_name"] = crypto_key_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["update_time"] = None
        super(GoogleChannelConfig, __self__).__init__(
            'gcp:eventarc/googleChannelConfig:GoogleChannelConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            crypto_key_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'GoogleChannelConfig':
        """
        Get an existing GoogleChannelConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] crypto_key_name: Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.
               
               
               
               - - -
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] update_time: Output only. The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GoogleChannelConfigState.__new__(_GoogleChannelConfigState)

        __props__.__dict__["crypto_key_name"] = crypto_key_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return GoogleChannelConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.



        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

