# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppCheckPlayIntegrityConfigArgs', 'AppCheckPlayIntegrityConfig']

@pulumi.input_type
class AppCheckPlayIntegrityConfigArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 project: Optional[pulumi.Input[str]] = None,
                 token_ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppCheckPlayIntegrityConfig resource.
        :param pulumi.Input[str] app_id: The ID of an
               [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] token_ttl: Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "app_id", app_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The ID of an
        [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).


        - - -
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_ttl", value)


@pulumi.input_type
class _AppCheckPlayIntegrityConfigState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 token_ttl: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppCheckPlayIntegrityConfig resources.
        :param pulumi.Input[str] app_id: The ID of an
               [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).
               
               
               - - -
        :param pulumi.Input[str] name: The relative resource name of the Play Integrity configuration object
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] token_ttl: Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an
        [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).


        - - -
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the Play Integrity configuration object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_ttl", value)


class AppCheckPlayIntegrityConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 token_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An app's Play Integrity configuration object. Note that your registered SHA-256 certificate fingerprints are used to validate tokens issued by the Play Integrity API.
        Make sure your `firebase.AndroidApp` has at least one `sha256_hashes` present.

        To get more information about PlayIntegrityConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.playIntegrityConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check Play Integrity Config Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Enables the Play Integrity API
        play_integrity = gcp.projects.Service("play_integrity",
            project="my-project-name",
            service="playintegrity.googleapis.com",
            disable_on_destroy=False)
        default = gcp.firebase.AndroidApp("default",
            project="my-project-name",
            display_name="Play Integrity app",
            package_name="package.name.playintegrity",
            sha1_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21c"],
            sha256_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21ca1b2c3d4e5f6123456789abc"])
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_play_integrity_config = gcp.firebase.AppCheckPlayIntegrityConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```
        ### Firebase App Check Play Integrity Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Enables the Play Integrity API
        play_integrity = gcp.projects.Service("play_integrity",
            project="my-project-name",
            service="playintegrity.googleapis.com",
            disable_on_destroy=False)
        default = gcp.firebase.AndroidApp("default",
            project="my-project-name",
            display_name="Play Integrity app",
            package_name="package.name.playintegrity",
            sha1_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21c"],
            sha256_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21ca1b2c3d4e5f6123456789abc"])
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_play_integrity_config = gcp.firebase.AppCheckPlayIntegrityConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        PlayIntegrityConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/playIntegrityConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, PlayIntegrityConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default projects/{{project}}/apps/{{app_id}}/playIntegrityConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ID of an
               [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] token_ttl: Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCheckPlayIntegrityConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An app's Play Integrity configuration object. Note that your registered SHA-256 certificate fingerprints are used to validate tokens issued by the Play Integrity API.
        Make sure your `firebase.AndroidApp` has at least one `sha256_hashes` present.

        To get more information about PlayIntegrityConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.playIntegrityConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check Play Integrity Config Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Enables the Play Integrity API
        play_integrity = gcp.projects.Service("play_integrity",
            project="my-project-name",
            service="playintegrity.googleapis.com",
            disable_on_destroy=False)
        default = gcp.firebase.AndroidApp("default",
            project="my-project-name",
            display_name="Play Integrity app",
            package_name="package.name.playintegrity",
            sha1_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21c"],
            sha256_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21ca1b2c3d4e5f6123456789abc"])
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_play_integrity_config = gcp.firebase.AppCheckPlayIntegrityConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```
        ### Firebase App Check Play Integrity Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Enables the Play Integrity API
        play_integrity = gcp.projects.Service("play_integrity",
            project="my-project-name",
            service="playintegrity.googleapis.com",
            disable_on_destroy=False)
        default = gcp.firebase.AndroidApp("default",
            project="my-project-name",
            display_name="Play Integrity app",
            package_name="package.name.playintegrity",
            sha1_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21c"],
            sha256_hashes=["2145bdf698b8715039bd0e83f2069bed435ac21ca1b2c3d4e5f6123456789abc"])
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_play_integrity_config = gcp.firebase.AppCheckPlayIntegrityConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        PlayIntegrityConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/playIntegrityConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, PlayIntegrityConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default projects/{{project}}/apps/{{app_id}}/playIntegrityConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppCheckPlayIntegrityConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCheckPlayIntegrityConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 token_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCheckPlayIntegrityConfigArgs.__new__(AppCheckPlayIntegrityConfigArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["project"] = project
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["name"] = None
        super(AppCheckPlayIntegrityConfig, __self__).__init__(
            'gcp:firebase/appCheckPlayIntegrityConfig:AppCheckPlayIntegrityConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            token_ttl: Optional[pulumi.Input[str]] = None) -> 'AppCheckPlayIntegrityConfig':
        """
        Get an existing AppCheckPlayIntegrityConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ID of an
               [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).
               
               
               - - -
        :param pulumi.Input[str] name: The relative resource name of the Play Integrity configuration object
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] token_ttl: Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCheckPlayIntegrityConfigState.__new__(_AppCheckPlayIntegrityConfigState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["token_ttl"] = token_ttl
        return AppCheckPlayIntegrityConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The ID of an
        [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).


        - - -
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The relative resource name of the Play Integrity configuration object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[str]:
        """
        Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

