# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ExtensionsInstanceConfig',
    'ExtensionsInstanceErrorStatus',
    'ExtensionsInstanceRuntimeData',
    'ExtensionsInstanceRuntimeDataFatalError',
    'ExtensionsInstanceRuntimeDataProcessingState',
    'HostingCustomDomainCert',
    'HostingCustomDomainCertVerification',
    'HostingCustomDomainCertVerificationDns',
    'HostingCustomDomainCertVerificationDnsDesired',
    'HostingCustomDomainCertVerificationDnsDesiredRecord',
    'HostingCustomDomainCertVerificationDnsDiscovered',
    'HostingCustomDomainCertVerificationDnsDiscoveredRecord',
    'HostingCustomDomainCertVerificationHttp',
    'HostingCustomDomainIssue',
    'HostingCustomDomainRequiredDnsUpdate',
    'HostingCustomDomainRequiredDnsUpdateDesired',
    'HostingCustomDomainRequiredDnsUpdateDesiredRecord',
    'HostingCustomDomainRequiredDnsUpdateDiscovered',
    'HostingCustomDomainRequiredDnsUpdateDiscoveredRecord',
    'HostingVersionConfig',
    'HostingVersionConfigRedirect',
    'HostingVersionConfigRewrite',
    'HostingVersionConfigRewriteRun',
]

@pulumi.output_type
class ExtensionsInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionRef":
            suggest = "extension_ref"
        elif key == "allowedEventTypes":
            suggest = "allowed_event_types"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "eventarcChannel":
            suggest = "eventarc_channel"
        elif key == "extensionVersion":
            suggest = "extension_version"
        elif key == "populatedPostinstallContent":
            suggest = "populated_postinstall_content"
        elif key == "systemParams":
            suggest = "system_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_ref: str,
                 params: Mapping[str, str],
                 allowed_event_types: Optional[Sequence[str]] = None,
                 create_time: Optional[str] = None,
                 eventarc_channel: Optional[str] = None,
                 extension_version: Optional[str] = None,
                 name: Optional[str] = None,
                 populated_postinstall_content: Optional[str] = None,
                 system_params: Optional[Mapping[str, str]] = None):
        """
        :param str extension_ref: The ref of the Extension from the Registry (e.g. publisher-id/awesome-extension)
        :param Mapping[str, str] params: Environment variables that may be configured for the Extension
        :param Sequence[str] allowed_event_types: List of extension events selected by consumer that extension is allowed to
               emit, identified by their types.
        :param str create_time: (Output)
               The time at which the Extension Instance Config was created.
        :param str eventarc_channel: Fully qualified Eventarc resource name that consumers should use for event triggers.
        :param str extension_version: The version of the Extension from the Registry (e.g. 1.0.3). If left blank, latest is assumed.
        :param str name: (Output)
               The unique identifier for this configuration.
        :param str populated_postinstall_content: (Output)
               Postinstall instructions to be shown for this Extension, with
               template strings representing function and parameter values substituted
               with actual values. These strings include: ${param:FOO},
               ${function:myFunc.url},
               ${function:myFunc.name}, and ${function:myFunc.location}
               
               - - -
        :param Mapping[str, str] system_params: Params whose values are only available at deployment time.
               Unlike other params, these will not be set as environment variables on
               functions. See a full list of system parameters at
               https://firebase.google.com/docs/extensions/publishers/parameters#system_parameters
        """
        pulumi.set(__self__, "extension_ref", extension_ref)
        pulumi.set(__self__, "params", params)
        if allowed_event_types is not None:
            pulumi.set(__self__, "allowed_event_types", allowed_event_types)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if eventarc_channel is not None:
            pulumi.set(__self__, "eventarc_channel", eventarc_channel)
        if extension_version is not None:
            pulumi.set(__self__, "extension_version", extension_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if populated_postinstall_content is not None:
            pulumi.set(__self__, "populated_postinstall_content", populated_postinstall_content)
        if system_params is not None:
            pulumi.set(__self__, "system_params", system_params)

    @property
    @pulumi.getter(name="extensionRef")
    def extension_ref(self) -> str:
        """
        The ref of the Extension from the Registry (e.g. publisher-id/awesome-extension)
        """
        return pulumi.get(self, "extension_ref")

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, str]:
        """
        Environment variables that may be configured for the Extension
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="allowedEventTypes")
    def allowed_event_types(self) -> Optional[Sequence[str]]:
        """
        List of extension events selected by consumer that extension is allowed to
        emit, identified by their types.
        """
        return pulumi.get(self, "allowed_event_types")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        (Output)
        The time at which the Extension Instance Config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="eventarcChannel")
    def eventarc_channel(self) -> Optional[str]:
        """
        Fully qualified Eventarc resource name that consumers should use for event triggers.
        """
        return pulumi.get(self, "eventarc_channel")

    @property
    @pulumi.getter(name="extensionVersion")
    def extension_version(self) -> Optional[str]:
        """
        The version of the Extension from the Registry (e.g. 1.0.3). If left blank, latest is assumed.
        """
        return pulumi.get(self, "extension_version")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Output)
        The unique identifier for this configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="populatedPostinstallContent")
    def populated_postinstall_content(self) -> Optional[str]:
        """
        (Output)
        Postinstall instructions to be shown for this Extension, with
        template strings representing function and parameter values substituted
        with actual values. These strings include: ${param:FOO},
        ${function:myFunc.url},
        ${function:myFunc.name}, and ${function:myFunc.location}

        - - -
        """
        return pulumi.get(self, "populated_postinstall_content")

    @property
    @pulumi.getter(name="systemParams")
    def system_params(self) -> Optional[Mapping[str, str]]:
        """
        Params whose values are only available at deployment time.
        Unlike other params, these will not be set as environment variables on
        functions. See a full list of system parameters at
        https://firebase.google.com/docs/extensions/publishers/parameters#system_parameters
        """
        return pulumi.get(self, "system_params")


@pulumi.output_type
class ExtensionsInstanceErrorStatus(dict):
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 details: Optional[Sequence[Mapping[str, str]]] = None,
                 message: Optional[str] = None):
        """
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details.
        :param str message: A developer-facing error message, which should be in English.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A developer-facing error message, which should be in English.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExtensionsInstanceRuntimeData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fatalError":
            suggest = "fatal_error"
        elif key == "processingState":
            suggest = "processing_state"
        elif key == "stateUpdateTime":
            suggest = "state_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fatal_error: Optional['outputs.ExtensionsInstanceRuntimeDataFatalError'] = None,
                 processing_state: Optional['outputs.ExtensionsInstanceRuntimeDataProcessingState'] = None,
                 state_update_time: Optional[str] = None):
        """
        :param 'ExtensionsInstanceRuntimeDataFatalErrorArgs' fatal_error: The fatal error state for the extension instance
               Structure is documented below.
        :param 'ExtensionsInstanceRuntimeDataProcessingStateArgs' processing_state: The processing state for the extension instance
               Structure is documented below.
        :param str state_update_time: The time of the last state update.
        """
        if fatal_error is not None:
            pulumi.set(__self__, "fatal_error", fatal_error)
        if processing_state is not None:
            pulumi.set(__self__, "processing_state", processing_state)
        if state_update_time is not None:
            pulumi.set(__self__, "state_update_time", state_update_time)

    @property
    @pulumi.getter(name="fatalError")
    def fatal_error(self) -> Optional['outputs.ExtensionsInstanceRuntimeDataFatalError']:
        """
        The fatal error state for the extension instance
        Structure is documented below.
        """
        return pulumi.get(self, "fatal_error")

    @property
    @pulumi.getter(name="processingState")
    def processing_state(self) -> Optional['outputs.ExtensionsInstanceRuntimeDataProcessingState']:
        """
        The processing state for the extension instance
        Structure is documented below.
        """
        return pulumi.get(self, "processing_state")

    @property
    @pulumi.getter(name="stateUpdateTime")
    def state_update_time(self) -> Optional[str]:
        """
        The time of the last state update.
        """
        return pulumi.get(self, "state_update_time")


@pulumi.output_type
class ExtensionsInstanceRuntimeDataFatalError(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeDataFatalError. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeDataFatalError.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeDataFatalError.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: Optional[str] = None):
        """
        :param str error_message: The error message. This is set by the extension developer to give
               more detail on why the extension is unusable and must be re-installed
               or reconfigured.
        """
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        The error message. This is set by the extension developer to give
        more detail on why the extension is unusable and must be re-installed
        or reconfigured.
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class ExtensionsInstanceRuntimeDataProcessingState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailMessage":
            suggest = "detail_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionsInstanceRuntimeDataProcessingState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionsInstanceRuntimeDataProcessingState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionsInstanceRuntimeDataProcessingState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_message: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str detail_message: Details about the processing. e.g. This could include the type of
               processing in progress or it could list errors or failures.
               This information will be shown in the console on the detail page
               for the extension instance.
        :param str state: The processing state of the extension instance.
        """
        if detail_message is not None:
            pulumi.set(__self__, "detail_message", detail_message)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="detailMessage")
    def detail_message(self) -> Optional[str]:
        """
        Details about the processing. e.g. This could include the type of
        processing in progress or it could list errors or failures.
        This information will be shown in the console on the detail page
        for the extension instance.
        """
        return pulumi.get(self, "detail_message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The processing state of the extension instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class HostingCustomDomainCert(dict):
    def __init__(__self__, *,
                 state: Optional[str] = None,
                 type: Optional[str] = None,
                 verification: Optional['outputs.HostingCustomDomainCertVerification'] = None):
        """
        :param str state: The state of the certificate. Only the `CERT_ACTIVE` and
               `CERT_EXPIRING_SOON` states provide SSL coverage for a domain name. If the
               state is `PROPAGATING` and Hosting had an active cert for the domain name
               before, that formerly-active cert provides SSL coverage for the domain name
               until the current cert propagates.
        :param str type: The record's type, which determines what data the record contains.
        :param 'HostingCustomDomainCertVerificationArgs' verification: A set of ACME challenges you can add to your DNS records or existing,
               non-Hosting hosting provider to allow Hosting to create an SSL certificate
               for your domain name before you point traffic toward hosting. You can use
               thse challenges as part of a zero downtime transition from your old
               provider to Hosting.
               Structure is documented below.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if verification is not None:
            pulumi.set(__self__, "verification", verification)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the certificate. Only the `CERT_ACTIVE` and
        `CERT_EXPIRING_SOON` states provide SSL coverage for a domain name. If the
        state is `PROPAGATING` and Hosting had an active cert for the domain name
        before, that formerly-active cert provides SSL coverage for the domain name
        until the current cert propagates.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def verification(self) -> Optional['outputs.HostingCustomDomainCertVerification']:
        """
        A set of ACME challenges you can add to your DNS records or existing,
        non-Hosting hosting provider to allow Hosting to create an SSL certificate
        for your domain name before you point traffic toward hosting. You can use
        thse challenges as part of a zero downtime transition from your old
        provider to Hosting.
        Structure is documented below.
        """
        return pulumi.get(self, "verification")


@pulumi.output_type
class HostingCustomDomainCertVerification(dict):
    def __init__(__self__, *,
                 dns: Optional['outputs.HostingCustomDomainCertVerificationDns'] = None,
                 http: Optional['outputs.HostingCustomDomainCertVerificationHttp'] = None):
        """
        :param 'HostingCustomDomainCertVerificationDnsArgs' dns: A `TXT` record to add to your DNS records that confirms your intent to
               let Hosting create an SSL cert for your domain name.
               Structure is documented below.
        :param 'HostingCustomDomainCertVerificationHttpArgs' http: A file to add to your existing, non-Hosting hosting service that confirms
               your intent to let Hosting create an SSL cert for your domain name.
               Structure is documented below.
        """
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @property
    @pulumi.getter
    def dns(self) -> Optional['outputs.HostingCustomDomainCertVerificationDns']:
        """
        A `TXT` record to add to your DNS records that confirms your intent to
        let Hosting create an SSL cert for your domain name.
        Structure is documented below.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HostingCustomDomainCertVerificationHttp']:
        """
        A file to add to your existing, non-Hosting hosting service that confirms
        your intent to let Hosting create an SSL cert for your domain name.
        Structure is documented below.
        """
        return pulumi.get(self, "http")


@pulumi.output_type
class HostingCustomDomainCertVerificationDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkTime":
            suggest = "check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_time: Optional[str] = None,
                 desireds: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesired']] = None,
                 discovereds: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscovered']] = None):
        """
        :param str check_time: (Output)
               The last time Hosting checked your CustomDomain's DNS records.
        :param Sequence['HostingCustomDomainCertVerificationDnsDesiredArgs'] desireds: A text string to serve at the path.
        :param Sequence['HostingCustomDomainCertVerificationDnsDiscoveredArgs'] discovereds: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        """
        if check_time is not None:
            pulumi.set(__self__, "check_time", check_time)
        if desireds is not None:
            pulumi.set(__self__, "desireds", desireds)
        if discovereds is not None:
            pulumi.set(__self__, "discovereds", discovereds)

    @property
    @pulumi.getter(name="checkTime")
    def check_time(self) -> Optional[str]:
        """
        (Output)
        The last time Hosting checked your CustomDomain's DNS records.
        """
        return pulumi.get(self, "check_time")

    @property
    @pulumi.getter
    def desireds(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesired']]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desireds")

    @property
    @pulumi.getter
    def discovereds(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscovered']]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovereds")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDesired(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDesired. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDesired.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDesired.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesiredRecord']] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainCertVerificationDnsDesiredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDesiredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDesiredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDesiredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDesiredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDesiredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 rdata: Optional[str] = None,
                 required_action: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param str required_action: Indicates the a required action for this record.
        :param str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def rdata(self) -> Optional[str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDiscovered(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDiscovered. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDiscovered.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDiscovered.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscoveredRecord']] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainCertVerificationDnsDiscoveredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainCertVerificationDnsDiscoveredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainCertVerificationDnsDiscoveredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationDnsDiscoveredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationDnsDiscoveredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationDnsDiscoveredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 rdata: Optional[str] = None,
                 required_action: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param str required_action: Indicates the a required action for this record.
        :param str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def rdata(self) -> Optional[str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainCertVerificationHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastCheckTime":
            suggest = "last_check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainCertVerificationHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainCertVerificationHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainCertVerificationHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired: Optional[str] = None,
                 discovered: Optional[str] = None,
                 last_check_time: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str desired: A text string to serve at the path.
        :param str discovered: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        :param str last_check_time: (Output)
               The last time Hosting systems checked for the file contents.
        :param str path: The path to the file.
        """
        if desired is not None:
            pulumi.set(__self__, "desired", desired)
        if discovered is not None:
            pulumi.set(__self__, "discovered", discovered)
        if last_check_time is not None:
            pulumi.set(__self__, "last_check_time", last_check_time)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def desired(self) -> Optional[str]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desired")

    @property
    @pulumi.getter
    def discovered(self) -> Optional[str]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovered")

    @property
    @pulumi.getter(name="lastCheckTime")
    def last_check_time(self) -> Optional[str]:
        """
        (Output)
        The last time Hosting systems checked for the file contents.
        """
        return pulumi.get(self, "last_check_time")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the file.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class HostingCustomDomainIssue(dict):
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 details: Optional[str] = None,
                 message: Optional[str] = None):
        """
        :param int code: The status code, which should be an enum value of `google.rpc.Code`
        :param str details: A list of messages that carry the error details.
        :param str message: Error message
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        The status code, which should be an enum value of `google.rpc.Code`
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Error message
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkTime":
            suggest = "check_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_time: Optional[str] = None,
                 desireds: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesired']] = None,
                 discovereds: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscovered']] = None):
        """
        :param str check_time: (Output)
               The last time Hosting checked your CustomDomain's DNS records.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDesiredArgs'] desireds: A text string to serve at the path.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDiscoveredArgs'] discovereds: Whether Hosting was able to find the required file contents on the
               specified path during its last check.
        """
        if check_time is not None:
            pulumi.set(__self__, "check_time", check_time)
        if desireds is not None:
            pulumi.set(__self__, "desireds", desireds)
        if discovereds is not None:
            pulumi.set(__self__, "discovereds", discovereds)

    @property
    @pulumi.getter(name="checkTime")
    def check_time(self) -> Optional[str]:
        """
        (Output)
        The last time Hosting checked your CustomDomain's DNS records.
        """
        return pulumi.get(self, "check_time")

    @property
    @pulumi.getter
    def desireds(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesired']]:
        """
        A text string to serve at the path.
        """
        return pulumi.get(self, "desireds")

    @property
    @pulumi.getter
    def discovereds(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscovered']]:
        """
        Whether Hosting was able to find the required file contents on the
        specified path during its last check.
        """
        return pulumi.get(self, "discovereds")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDesired(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDesired. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesired.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesired.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesiredRecord']] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDesiredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDesiredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDesiredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDesiredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDesiredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 rdata: Optional[str] = None,
                 required_action: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param str required_action: Indicates the a required action for this record.
        :param str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def rdata(self) -> Optional[str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDiscovered(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDiscovered. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscovered.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 records: Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscoveredRecord']] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param Sequence['HostingCustomDomainRequiredDnsUpdateDiscoveredRecordArgs'] records: Records on the domain
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if records is not None:
            pulumi.set(__self__, "records", records)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def records(self) -> Optional[Sequence['outputs.HostingCustomDomainRequiredDnsUpdateDiscoveredRecord']]:
        """
        Records on the domain
        Structure is documented below.
        """
        return pulumi.get(self, "records")


@pulumi.output_type
class HostingCustomDomainRequiredDnsUpdateDiscoveredRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "requiredAction":
            suggest = "required_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingCustomDomainRequiredDnsUpdateDiscoveredRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingCustomDomainRequiredDnsUpdateDiscoveredRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 rdata: Optional[str] = None,
                 required_action: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str domain_name: The domain name the record pertains to, e.g. `foo.bar.com.`.
        :param str rdata: The data of the record. The meaning of the value depends on record type:
               - A and AAAA: IP addresses for the domain name.
               - CNAME: Another domain to check for records.
               - TXT: Arbitrary text strings associated with the domain name. Hosting
               uses TXT records to determine a which Firebase Projects have
               permission to act on the domain name's behalf.
               - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        :param str required_action: Indicates the a required action for this record.
        :param str type: The record's type, which determines what data the record contains.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if required_action is not None:
            pulumi.set(__self__, "required_action", required_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name the record pertains to, e.g. `foo.bar.com.`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def rdata(self) -> Optional[str]:
        """
        The data of the record. The meaning of the value depends on record type:
        - A and AAAA: IP addresses for the domain name.
        - CNAME: Another domain to check for records.
        - TXT: Arbitrary text strings associated with the domain name. Hosting
        uses TXT records to determine a which Firebase Projects have
        permission to act on the domain name's behalf.
        - CAA: The record's flags, tag, and value, e.g. `0 issue "pki.goog"`.
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="requiredAction")
    def required_action(self) -> Optional[str]:
        """
        Indicates the a required action for this record.
        """
        return pulumi.get(self, "required_action")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record's type, which determines what data the record contains.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingVersionConfig(dict):
    def __init__(__self__, *,
                 redirects: Optional[Sequence['outputs.HostingVersionConfigRedirect']] = None,
                 rewrites: Optional[Sequence['outputs.HostingVersionConfigRewrite']] = None):
        """
        :param Sequence['HostingVersionConfigRedirectArgs'] redirects: An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path,
               triggers Hosting to respond with a redirect to the specified destination path.
               Structure is documented below.
        :param Sequence['HostingVersionConfigRewriteArgs'] rewrites: An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the
               request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
               Structure is documented below.
        """
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)
        if rewrites is not None:
            pulumi.set(__self__, "rewrites", rewrites)

    @property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.HostingVersionConfigRedirect']]:
        """
        An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path,
        triggers Hosting to respond with a redirect to the specified destination path.
        Structure is documented below.
        """
        return pulumi.get(self, "redirects")

    @property
    @pulumi.getter
    def rewrites(self) -> Optional[Sequence['outputs.HostingVersionConfigRewrite']]:
        """
        An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the
        request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        Structure is documented below.
        """
        return pulumi.get(self, "rewrites")


@pulumi.output_type
class HostingVersionConfigRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingVersionConfigRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingVersionConfigRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingVersionConfigRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 status_code: int,
                 glob: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str location: The value to put in the HTTP location header of the response.
               The location can contain capture group values from the pattern using a : prefix to identify
               the segment and an optional * to capture the rest of the URL. For example:
        :param int status_code: The status HTTP code to return in the response. It must be a valid 3xx status code.
        :param str glob: The user-supplied glob to match against the request URL path.
        :param str regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "status_code", status_code)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The value to put in the HTTP location header of the response.
        The location can contain capture group values from the pattern using a : prefix to identify
        the segment and an optional * to capture the rest of the URL. For example:
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        The status HTTP code to return in the response. It must be a valid 3xx status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def glob(self) -> Optional[str]:
        """
        The user-supplied glob to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class HostingVersionConfigRewrite(dict):
    def __init__(__self__, *,
                 function: Optional[str] = None,
                 glob: Optional[str] = None,
                 path: Optional[str] = None,
                 regex: Optional[str] = None,
                 run: Optional['outputs.HostingVersionConfigRewriteRun'] = None):
        """
        :param str function: The function to proxy requests to. Must match the exported function name exactly.
        :param str glob: The user-supplied glob to match against the request URL path.
        :param str path: The URL path to rewrite the request to.
        :param str regex: The user-supplied RE2 regular expression to match against the request URL path.
        :param 'HostingVersionConfigRewriteRunArgs' run: The request will be forwarded to Cloud Run.
               Structure is documented below.
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @property
    @pulumi.getter
    def function(self) -> Optional[str]:
        """
        The function to proxy requests to. Must match the exported function name exactly.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def glob(self) -> Optional[str]:
        """
        The user-supplied glob to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The URL path to rewrite the request to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter
    def run(self) -> Optional['outputs.HostingVersionConfigRewriteRun']:
        """
        The request will be forwarded to Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "run")


@pulumi.output_type
class HostingVersionConfigRewriteRun(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceId":
            suggest = "service_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingVersionConfigRewriteRun. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingVersionConfigRewriteRun.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingVersionConfigRewriteRun.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_id: str,
                 region: Optional[str] = None):
        """
        :param str service_id: User-defined ID of the Cloud Run service.
        :param str region: Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        pulumi.set(__self__, "service_id", service_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        """
        User-defined ID of the Cloud Run service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        return pulumi.get(self, "region")


