# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupPlanBackupConfigArgs',
    'BackupPlanBackupConfigArgsDict',
    'BackupPlanBackupConfigEncryptionKeyArgs',
    'BackupPlanBackupConfigEncryptionKeyArgsDict',
    'BackupPlanBackupConfigSelectedApplicationsArgs',
    'BackupPlanBackupConfigSelectedApplicationsArgsDict',
    'BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs',
    'BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgsDict',
    'BackupPlanBackupConfigSelectedNamespacesArgs',
    'BackupPlanBackupConfigSelectedNamespacesArgsDict',
    'BackupPlanBackupScheduleArgs',
    'BackupPlanBackupScheduleArgsDict',
    'BackupPlanBackupScheduleRpoConfigArgs',
    'BackupPlanBackupScheduleRpoConfigArgsDict',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowArgs',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowArgsDict',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgsDict',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgsDict',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs',
    'BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgsDict',
    'BackupPlanIamBindingConditionArgs',
    'BackupPlanIamBindingConditionArgsDict',
    'BackupPlanIamMemberConditionArgs',
    'BackupPlanIamMemberConditionArgsDict',
    'BackupPlanRetentionPolicyArgs',
    'BackupPlanRetentionPolicyArgsDict',
    'RestorePlanIamBindingConditionArgs',
    'RestorePlanIamBindingConditionArgsDict',
    'RestorePlanIamMemberConditionArgs',
    'RestorePlanIamMemberConditionArgsDict',
    'RestorePlanRestoreConfigArgs',
    'RestorePlanRestoreConfigArgsDict',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeArgs',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeArgsDict',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgsDict',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs',
    'RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgsDict',
    'RestorePlanRestoreConfigExcludedNamespacesArgs',
    'RestorePlanRestoreConfigExcludedNamespacesArgsDict',
    'RestorePlanRestoreConfigRestoreOrderArgs',
    'RestorePlanRestoreConfigRestoreOrderArgsDict',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgsDict',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgsDict',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs',
    'RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgsDict',
    'RestorePlanRestoreConfigSelectedApplicationsArgs',
    'RestorePlanRestoreConfigSelectedApplicationsArgsDict',
    'RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs',
    'RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgsDict',
    'RestorePlanRestoreConfigSelectedNamespacesArgs',
    'RestorePlanRestoreConfigSelectedNamespacesArgsDict',
    'RestorePlanRestoreConfigTransformationRuleArgs',
    'RestorePlanRestoreConfigTransformationRuleArgsDict',
    'RestorePlanRestoreConfigTransformationRuleFieldActionArgs',
    'RestorePlanRestoreConfigTransformationRuleFieldActionArgsDict',
    'RestorePlanRestoreConfigTransformationRuleResourceFilterArgs',
    'RestorePlanRestoreConfigTransformationRuleResourceFilterArgsDict',
    'RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs',
    'RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgsDict',
    'RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs',
    'RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgsDict',
]

MYPY = False

if not MYPY:
    class BackupPlanBackupConfigArgsDict(TypedDict):
        all_namespaces: NotRequired[pulumi.Input[bool]]
        """
        If True, include all namespaced resources.
        """
        encryption_key: NotRequired[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgsDict']]
        """
        This defines a customer managed encryption key that will be used to encrypt the "config"
        portion (the Kubernetes resources) of Backups created via this plan.
        Structure is documented below.
        """
        include_secrets: NotRequired[pulumi.Input[bool]]
        """
        This flag specifies whether Kubernetes Secret resources should be included
        when they fall into the scope of Backups.
        """
        include_volume_data: NotRequired[pulumi.Input[bool]]
        """
        This flag specifies whether volume data should be backed up when PVCs are
        included in the scope of a Backup.
        """
        permissive_mode: NotRequired[pulumi.Input[bool]]
        """
        This flag specifies whether Backups will not fail when
        Backup for GKE detects Kubernetes configuration that is
        non-standard or requires additional setup to restore.
        """
        selected_applications: NotRequired[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgsDict']]
        """
        A list of namespaced Kubernetes Resources.
        Structure is documented below.
        """
        selected_namespaces: NotRequired[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgsDict']]
        """
        If set, include just the resources in the listed namespaces.
        Structure is documented below.
        """
elif False:
    BackupPlanBackupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupConfigArgs:
    def __init__(__self__, *,
                 all_namespaces: Optional[pulumi.Input[bool]] = None,
                 encryption_key: Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']] = None,
                 include_secrets: Optional[pulumi.Input[bool]] = None,
                 include_volume_data: Optional[pulumi.Input[bool]] = None,
                 permissive_mode: Optional[pulumi.Input[bool]] = None,
                 selected_applications: Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']] = None,
                 selected_namespaces: Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']] = None):
        """
        :param pulumi.Input[bool] all_namespaces: If True, include all namespaced resources.
        :param pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs'] encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config"
               portion (the Kubernetes resources) of Backups created via this plan.
               Structure is documented below.
        :param pulumi.Input[bool] include_secrets: This flag specifies whether Kubernetes Secret resources should be included
               when they fall into the scope of Backups.
        :param pulumi.Input[bool] include_volume_data: This flag specifies whether volume data should be backed up when PVCs are
               included in the scope of a Backup.
        :param pulumi.Input[bool] permissive_mode: This flag specifies whether Backups will not fail when
               Backup for GKE detects Kubernetes configuration that is
               non-standard or requires additional setup to restore.
        :param pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs'] selected_applications: A list of namespaced Kubernetes Resources.
               Structure is documented below.
        :param pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs'] selected_namespaces: If set, include just the resources in the listed namespaces.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if include_secrets is not None:
            pulumi.set(__self__, "include_secrets", include_secrets)
        if include_volume_data is not None:
            pulumi.set(__self__, "include_volume_data", include_volume_data)
        if permissive_mode is not None:
            pulumi.set(__self__, "permissive_mode", permissive_mode)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, include all namespaced resources.
        """
        return pulumi.get(self, "all_namespaces")

    @all_namespaces.setter
    def all_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_namespaces", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']]:
        """
        This defines a customer managed encryption key that will be used to encrypt the "config"
        portion (the Kubernetes resources) of Backups created via this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether Kubernetes Secret resources should be included
        when they fall into the scope of Backups.
        """
        return pulumi.get(self, "include_secrets")

    @include_secrets.setter
    def include_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_secrets", value)

    @property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether volume data should be backed up when PVCs are
        included in the scope of a Backup.
        """
        return pulumi.get(self, "include_volume_data")

    @include_volume_data.setter
    def include_volume_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_volume_data", value)

    @property
    @pulumi.getter(name="permissiveMode")
    def permissive_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether Backups will not fail when
        Backup for GKE detects Kubernetes configuration that is
        non-standard or requires additional setup to restore.
        """
        return pulumi.get(self, "permissive_mode")

    @permissive_mode.setter
    def permissive_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "permissive_mode", value)

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']]:
        """
        A list of namespaced Kubernetes Resources.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @selected_applications.setter
    def selected_applications(self, value: Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']]):
        pulumi.set(self, "selected_applications", value)

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']]:
        """
        If set, include just the resources in the listed namespaces.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")

    @selected_namespaces.setter
    def selected_namespaces(self, value: Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']]):
        pulumi.set(self, "selected_namespaces", value)


if not MYPY:
    class BackupPlanBackupConfigEncryptionKeyArgsDict(TypedDict):
        gcp_kms_encryption_key: pulumi.Input[str]
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
elif False:
    BackupPlanBackupConfigEncryptionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupConfigEncryptionKeyArgs:
    def __init__(__self__, *,
                 gcp_kms_encryption_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> pulumi.Input[str]:
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "gcp_kms_encryption_key")

    @gcp_kms_encryption_key.setter
    def gcp_kms_encryption_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "gcp_kms_encryption_key", value)


if not MYPY:
    class BackupPlanBackupConfigSelectedApplicationsArgsDict(TypedDict):
        namespaced_names: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgsDict']]]
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
elif False:
    BackupPlanBackupConfigSelectedApplicationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupConfigSelectedApplicationsArgs:
    def __init__(__self__, *,
                 namespaced_names: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")

    @namespaced_names.setter
    def namespaced_names(self, value: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]):
        pulumi.set(self, "namespaced_names", value)


if not MYPY:
    class BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of a Kubernetes Resource.
        """
        namespace: pulumi.Input[str]
        """
        The namespace of a Kubernetes Resource.
        """
elif False:
    BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of a Kubernetes Resource.
        :param pulumi.Input[str] namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class BackupPlanBackupConfigSelectedNamespacesArgsDict(TypedDict):
        namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of Kubernetes Namespaces.
        """
elif False:
    BackupPlanBackupConfigSelectedNamespacesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupConfigSelectedNamespacesArgs:
    def __init__(__self__, *,
                 namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class BackupPlanBackupScheduleArgsDict(TypedDict):
        cron_schedule: NotRequired[pulumi.Input[str]]
        """
        A standard cron string that defines a repeating schedule for
        creating Backups via this BackupPlan.
        This is mutually exclusive with the rpoConfig field since at most one
        schedule can be defined for a BackupPlan.
        If this is defined, then backupRetainDays must also be defined.
        """
        paused: NotRequired[pulumi.Input[bool]]
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        rpo_config: NotRequired[pulumi.Input['BackupPlanBackupScheduleRpoConfigArgsDict']]
        """
        Defines the RPO schedule configuration for this BackupPlan. This is mutually
        exclusive with the cronSchedule field since at most one schedule can be defined
        for a BackupPLan. If this is defined, then backupRetainDays must also be defined.
        Structure is documented below.
        """
elif False:
    BackupPlanBackupScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleArgs:
    def __init__(__self__, *,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 rpo_config: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigArgs']] = None):
        """
        :param pulumi.Input[str] cron_schedule: A standard cron string that defines a repeating schedule for
               creating Backups via this BackupPlan.
               This is mutually exclusive with the rpoConfig field since at most one
               schedule can be defined for a BackupPlan.
               If this is defined, then backupRetainDays must also be defined.
        :param pulumi.Input[bool] paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        :param pulumi.Input['BackupPlanBackupScheduleRpoConfigArgs'] rpo_config: Defines the RPO schedule configuration for this BackupPlan. This is mutually
               exclusive with the cronSchedule field since at most one schedule can be defined
               for a BackupPLan. If this is defined, then backupRetainDays must also be defined.
               Structure is documented below.
        """
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if rpo_config is not None:
            pulumi.set(__self__, "rpo_config", rpo_config)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A standard cron string that defines a repeating schedule for
        creating Backups via this BackupPlan.
        This is mutually exclusive with the rpoConfig field since at most one
        schedule can be defined for a BackupPlan.
        If this is defined, then backupRetainDays must also be defined.
        """
        return pulumi.get(self, "cron_schedule")

    @cron_schedule.setter
    def cron_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_schedule", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="rpoConfig")
    def rpo_config(self) -> Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigArgs']]:
        """
        Defines the RPO schedule configuration for this BackupPlan. This is mutually
        exclusive with the cronSchedule field since at most one schedule can be defined
        for a BackupPLan. If this is defined, then backupRetainDays must also be defined.
        Structure is documented below.
        """
        return pulumi.get(self, "rpo_config")

    @rpo_config.setter
    def rpo_config(self, value: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigArgs']]):
        pulumi.set(self, "rpo_config", value)


if not MYPY:
    class BackupPlanBackupScheduleRpoConfigArgsDict(TypedDict):
        target_rpo_minutes: pulumi.Input[int]
        """
        Defines the target RPO for the BackupPlan in minutes, which means the target
        maximum data loss in time that is acceptable for this BackupPlan. This must be
        at least 60, i.e., 1 hour, and at most 86400, i.e., 60 days.
        """
        exclusion_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowArgsDict']]]]
        """
        User specified time windows during which backup can NOT happen for this BackupPlan.
        Backups should start and finish outside of any given exclusion window. Note: backup
        jobs will be scheduled to start and finish outside the duration of the window as
        much as possible, but running jobs will not get canceled when it runs into the window.
        All the time and date values in exclusionWindows entry in the API are in UTC. We
        only allow <=1 recurrence (daily or weekly) exclusion window for a BackupPlan while no
        restriction on number of single occurrence windows.
        Structure is documented below.
        """
elif False:
    BackupPlanBackupScheduleRpoConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleRpoConfigArgs:
    def __init__(__self__, *,
                 target_rpo_minutes: pulumi.Input[int],
                 exclusion_windows: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowArgs']]]] = None):
        """
        :param pulumi.Input[int] target_rpo_minutes: Defines the target RPO for the BackupPlan in minutes, which means the target
               maximum data loss in time that is acceptable for this BackupPlan. This must be
               at least 60, i.e., 1 hour, and at most 86400, i.e., 60 days.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowArgs']]] exclusion_windows: User specified time windows during which backup can NOT happen for this BackupPlan.
               Backups should start and finish outside of any given exclusion window. Note: backup
               jobs will be scheduled to start and finish outside the duration of the window as
               much as possible, but running jobs will not get canceled when it runs into the window.
               All the time and date values in exclusionWindows entry in the API are in UTC. We
               only allow <=1 recurrence (daily or weekly) exclusion window for a BackupPlan while no
               restriction on number of single occurrence windows.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_rpo_minutes", target_rpo_minutes)
        if exclusion_windows is not None:
            pulumi.set(__self__, "exclusion_windows", exclusion_windows)

    @property
    @pulumi.getter(name="targetRpoMinutes")
    def target_rpo_minutes(self) -> pulumi.Input[int]:
        """
        Defines the target RPO for the BackupPlan in minutes, which means the target
        maximum data loss in time that is acceptable for this BackupPlan. This must be
        at least 60, i.e., 1 hour, and at most 86400, i.e., 60 days.
        """
        return pulumi.get(self, "target_rpo_minutes")

    @target_rpo_minutes.setter
    def target_rpo_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "target_rpo_minutes", value)

    @property
    @pulumi.getter(name="exclusionWindows")
    def exclusion_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowArgs']]]]:
        """
        User specified time windows during which backup can NOT happen for this BackupPlan.
        Backups should start and finish outside of any given exclusion window. Note: backup
        jobs will be scheduled to start and finish outside the duration of the window as
        much as possible, but running jobs will not get canceled when it runs into the window.
        All the time and date values in exclusionWindows entry in the API are in UTC. We
        only allow <=1 recurrence (daily or weekly) exclusion window for a BackupPlan while no
        restriction on number of single occurrence windows.
        Structure is documented below.
        """
        return pulumi.get(self, "exclusion_windows")

    @exclusion_windows.setter
    def exclusion_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowArgs']]]]):
        pulumi.set(self, "exclusion_windows", value)


if not MYPY:
    class BackupPlanBackupScheduleRpoConfigExclusionWindowArgsDict(TypedDict):
        duration: pulumi.Input[str]
        """
        Specifies duration of the window in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Restrictions for duration based on the
        recurrence type to allow some time for backup to happen:
        - single_occurrence_date:  no restriction
        - daily window: duration < 24 hours
        - weekly window:
        - days of week includes all seven days of a week: duration < 24 hours
        - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        """
        start_time: pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgsDict']
        """
        Specifies the start time of the window using time of the day in UTC.
        Structure is documented below.
        """
        daily: NotRequired[pulumi.Input[bool]]
        """
        The exclusion window occurs every day if set to "True".
        Specifying this field to "False" is an error.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        """
        days_of_week: NotRequired[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgsDict']]
        """
        The exclusion window occurs on these days of each week in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
        single_occurrence_date: NotRequired[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgsDict']]
        """
        No recurrence. The exclusion window occurs only once and on this date in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
elif False:
    BackupPlanBackupScheduleRpoConfigExclusionWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 start_time: pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs'],
                 daily: Optional[pulumi.Input[bool]] = None,
                 days_of_week: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs']] = None,
                 single_occurrence_date: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs']] = None):
        """
        :param pulumi.Input[str] duration: Specifies duration of the window in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Restrictions for duration based on the
               recurrence type to allow some time for backup to happen:
               - single_occurrence_date:  no restriction
               - daily window: duration < 24 hours
               - weekly window:
               - days of week includes all seven days of a week: duration < 24 hours
               - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        :param pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs'] start_time: Specifies the start time of the window using time of the day in UTC.
               Structure is documented below.
        :param pulumi.Input[bool] daily: The exclusion window occurs every day if set to "True".
               Specifying this field to "False" is an error.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        :param pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs'] days_of_week: The exclusion window occurs on these days of each week in UTC.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
               Structure is documented below.
        :param pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs'] single_occurrence_date: No recurrence. The exclusion window occurs only once and on this date in UTC.
               Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if single_occurrence_date is not None:
            pulumi.set(__self__, "single_occurrence_date", single_occurrence_date)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        Specifies duration of the window in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Restrictions for duration based on the
        recurrence type to allow some time for backup to happen:
        - single_occurrence_date:  no restriction
        - daily window: duration < 24 hours
        - weekly window:
        - days of week includes all seven days of a week: duration < 24 hours
        - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs']:
        """
        Specifies the start time of the window using time of the day in UTC.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs']):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def daily(self) -> Optional[pulumi.Input[bool]]:
        """
        The exclusion window occurs every day if set to "True".
        Specifying this field to "False" is an error.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        """
        return pulumi.get(self, "daily")

    @daily.setter
    def daily(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "daily", value)

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs']]:
        """
        The exclusion window occurs on these days of each week in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "days_of_week")

    @days_of_week.setter
    def days_of_week(self, value: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs']]):
        pulumi.set(self, "days_of_week", value)

    @property
    @pulumi.getter(name="singleOccurrenceDate")
    def single_occurrence_date(self) -> Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs']]:
        """
        No recurrence. The exclusion window occurs only once and on this date in UTC.
        Only one of singleOccurrenceDate, daily and daysOfWeek may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "single_occurrence_date")

    @single_occurrence_date.setter
    def single_occurrence_date(self, value: Optional[pulumi.Input['BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs']]):
        pulumi.set(self, "single_occurrence_date", value)


if not MYPY:
    class BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgsDict(TypedDict):
        days_of_weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of days of week.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
elif False:
    BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowDaysOfWeekArgs:
    def __init__(__self__, *,
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days_of_weeks: A list of days of week.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of days of week.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "days_of_weeks", value)


if not MYPY:
    class BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgsDict(TypedDict):
        day: NotRequired[pulumi.Input[int]]
        """
        Day of a month.
        """
        month: NotRequired[pulumi.Input[int]]
        """
        Month of a year.
        """
        year: NotRequired[pulumi.Input[int]]
        """
        Year of the date.
        """
elif False:
    BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowSingleOccurrenceDateArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 month: Optional[pulumi.Input[int]] = None,
                 year: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] day: Day of a month.
        :param pulumi.Input[int] month: Month of a year.
        :param pulumi.Input[int] year: Year of the date.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of a month.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def month(self) -> Optional[pulumi.Input[int]]:
        """
        Month of a year.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter
    def year(self) -> Optional[pulumi.Input[int]]:
        """
        Year of the date.
        """
        return pulumi.get(self, "year")

    @year.setter
    def year(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "year", value)


if not MYPY:
    class BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[int]]
        """
        Hours of day in 24 hour format.
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Minutes of hour of day.
        """
        nanos: NotRequired[pulumi.Input[int]]
        """
        Fractions of seconds in nanoseconds.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        Seconds of minutes of the time.
        """
elif False:
    BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupScheduleRpoConfigExclusionWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format.
        :param pulumi.Input[int] minutes: Minutes of hour of day.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class BackupPlanIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[str]
        title: pulumi.Input[str]
        description: NotRequired[pulumi.Input[str]]
elif False:
    BackupPlanIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class BackupPlanIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[str]
        title: pulumi.Input[str]
        description: NotRequired[pulumi.Input[str]]
elif False:
    BackupPlanIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class BackupPlanRetentionPolicyArgsDict(TypedDict):
        backup_delete_lock_days: NotRequired[pulumi.Input[int]]
        """
        Minimum age for a Backup created via this BackupPlan (in days).
        Must be an integer value between 0-90 (inclusive).
        A Backup created under this BackupPlan will not be deletable
        until it reaches Backup's (create time + backup_delete_lock_days).
        Updating this field of a BackupPlan does not affect existing Backups.
        Backups created after a successful update will inherit this new value.
        """
        backup_retain_days: NotRequired[pulumi.Input[int]]
        """
        The default maximum age of a Backup created via this BackupPlan.
        This field MUST be an integer value >= 0 and <= 365. If specified,
        a Backup created under this BackupPlan will be automatically deleted
        after its age reaches (createTime + backupRetainDays).
        If not specified, Backups created under this BackupPlan will NOT be
        subject to automatic deletion. Updating this field does NOT affect
        existing Backups under it. Backups created AFTER a successful update
        will automatically pick up the new value.
        NOTE: backupRetainDays must be >= backupDeleteLockDays.
        If cronSchedule is defined, then this must be <= 360 * the creation interval.
        If rpo_config is defined, then this must be
        <= 360 * targetRpoMinutes/(1440minutes/day)
        """
        locked: NotRequired[pulumi.Input[bool]]
        """
        This flag denotes whether the retention policy of this BackupPlan is locked.
        If set to True, no further update is allowed on this policy, including
        the locked field itself.
        """
elif False:
    BackupPlanRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanRetentionPolicyArgs:
    def __init__(__self__, *,
                 backup_delete_lock_days: Optional[pulumi.Input[int]] = None,
                 backup_retain_days: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] backup_delete_lock_days: Minimum age for a Backup created via this BackupPlan (in days).
               Must be an integer value between 0-90 (inclusive).
               A Backup created under this BackupPlan will not be deletable
               until it reaches Backup's (create time + backup_delete_lock_days).
               Updating this field of a BackupPlan does not affect existing Backups.
               Backups created after a successful update will inherit this new value.
        :param pulumi.Input[int] backup_retain_days: The default maximum age of a Backup created via this BackupPlan.
               This field MUST be an integer value >= 0 and <= 365. If specified,
               a Backup created under this BackupPlan will be automatically deleted
               after its age reaches (createTime + backupRetainDays).
               If not specified, Backups created under this BackupPlan will NOT be
               subject to automatic deletion. Updating this field does NOT affect
               existing Backups under it. Backups created AFTER a successful update
               will automatically pick up the new value.
               NOTE: backupRetainDays must be >= backupDeleteLockDays.
               If cronSchedule is defined, then this must be <= 360 * the creation interval.
               If rpo_config is defined, then this must be
               <= 360 * targetRpoMinutes/(1440minutes/day)
        :param pulumi.Input[bool] locked: This flag denotes whether the retention policy of this BackupPlan is locked.
               If set to True, no further update is allowed on this policy, including
               the locked field itself.
        """
        if backup_delete_lock_days is not None:
            pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        if backup_retain_days is not None:
            pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)

    @property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age for a Backup created via this BackupPlan (in days).
        Must be an integer value between 0-90 (inclusive).
        A Backup created under this BackupPlan will not be deletable
        until it reaches Backup's (create time + backup_delete_lock_days).
        Updating this field of a BackupPlan does not affect existing Backups.
        Backups created after a successful update will inherit this new value.
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @backup_delete_lock_days.setter
    def backup_delete_lock_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_delete_lock_days", value)

    @property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> Optional[pulumi.Input[int]]:
        """
        The default maximum age of a Backup created via this BackupPlan.
        This field MUST be an integer value >= 0 and <= 365. If specified,
        a Backup created under this BackupPlan will be automatically deleted
        after its age reaches (createTime + backupRetainDays).
        If not specified, Backups created under this BackupPlan will NOT be
        subject to automatic deletion. Updating this field does NOT affect
        existing Backups under it. Backups created AFTER a successful update
        will automatically pick up the new value.
        NOTE: backupRetainDays must be >= backupDeleteLockDays.
        If cronSchedule is defined, then this must be <= 360 * the creation interval.
        If rpo_config is defined, then this must be
        <= 360 * targetRpoMinutes/(1440minutes/day)
        """
        return pulumi.get(self, "backup_retain_days")

    @backup_retain_days.setter
    def backup_retain_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retain_days", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked.
        If set to True, no further update is allowed on this policy, including
        the locked field itself.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)


if not MYPY:
    class RestorePlanIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[str]
        title: pulumi.Input[str]
        description: NotRequired[pulumi.Input[str]]
elif False:
    RestorePlanIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class RestorePlanIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[str]
        title: pulumi.Input[str]
        description: NotRequired[pulumi.Input[str]]
elif False:
    RestorePlanIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class RestorePlanRestoreConfigArgsDict(TypedDict):
        all_namespaces: NotRequired[pulumi.Input[bool]]
        """
        If True, restore all namespaced resources in the Backup.
        Setting this field to False will result in an error.
        """
        cluster_resource_conflict_policy: NotRequired[pulumi.Input[str]]
        """
        Defines the behavior for handling the situation where cluster-scoped resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED`
        if `clusterResourceRestoreScope` is anyting other than `noGroupKinds`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
        for more information on each policy option.
        Possible values are: `USE_EXISTING_VERSION`, `USE_BACKUP_VERSION`.
        """
        cluster_resource_restore_scope: NotRequired[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeArgsDict']]
        """
        Identifies the cluster-scoped resources to restore from the Backup.
        Structure is documented below.
        """
        excluded_namespaces: NotRequired[pulumi.Input['RestorePlanRestoreConfigExcludedNamespacesArgsDict']]
        """
        A list of selected namespaces excluded from restoration.
        All namespaces except those in this list will be restored.
        Structure is documented below.
        """
        namespaced_resource_restore_mode: NotRequired[pulumi.Input[str]]
        """
        Defines the behavior for handling the situation where sets of namespaced resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
        for more information on each mode.
        Possible values are: `DELETE_AND_RESTORE`, `FAIL_ON_CONFLICT`, `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT`, `MERGE_REPLACE_ON_CONFLICT`.
        """
        no_namespaces: NotRequired[pulumi.Input[bool]]
        """
        Do not restore any namespaced resources if set to "True".
        Specifying this field to "False" is not allowed.
        """
        restore_order: NotRequired[pulumi.Input['RestorePlanRestoreConfigRestoreOrderArgsDict']]
        """
        It contains custom ordering to use on a Restore.
        Structure is documented below.
        """
        selected_applications: NotRequired[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsArgsDict']]
        """
        A list of selected ProtectedApplications to restore.
        The listed ProtectedApplications and all the resources
        to which they refer will be restored.
        Structure is documented below.
        """
        selected_namespaces: NotRequired[pulumi.Input['RestorePlanRestoreConfigSelectedNamespacesArgsDict']]
        """
        A list of selected namespaces to restore from the Backup.
        The listed Namespaces and all resources contained in them will be restored.
        Structure is documented below.
        """
        transformation_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleArgsDict']]]]
        """
        A list of transformation rules to be applied against Kubernetes
        resources as they are selected for restoration from a Backup.
        Rules are executed in order defined - this order matters,
        as changes made by a rule may impact the filtering logic of subsequent
        rules. An empty list means no transformation will occur.
        Structure is documented below.
        """
        volume_data_restore_policy: NotRequired[pulumi.Input[str]]
        """
        Specifies the mechanism to be used to restore volume data.
        This should be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        If not specified, it will be treated as `NO_VOLUME_DATA_RESTORATION`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        volume_data_restore_policy_bindings: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgsDict']]]]
        """
        A table that binds volumes by their scope to a restore policy. Bindings
        must have a unique scope. Any volumes not scoped in the bindings are
        subject to the policy defined in volume_data_restore_policy.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigArgs:
    def __init__(__self__, *,
                 all_namespaces: Optional[pulumi.Input[bool]] = None,
                 cluster_resource_conflict_policy: Optional[pulumi.Input[str]] = None,
                 cluster_resource_restore_scope: Optional[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeArgs']] = None,
                 excluded_namespaces: Optional[pulumi.Input['RestorePlanRestoreConfigExcludedNamespacesArgs']] = None,
                 namespaced_resource_restore_mode: Optional[pulumi.Input[str]] = None,
                 no_namespaces: Optional[pulumi.Input[bool]] = None,
                 restore_order: Optional[pulumi.Input['RestorePlanRestoreConfigRestoreOrderArgs']] = None,
                 selected_applications: Optional[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsArgs']] = None,
                 selected_namespaces: Optional[pulumi.Input['RestorePlanRestoreConfigSelectedNamespacesArgs']] = None,
                 transformation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleArgs']]]] = None,
                 volume_data_restore_policy: Optional[pulumi.Input[str]] = None,
                 volume_data_restore_policy_bindings: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs']]]] = None):
        """
        :param pulumi.Input[bool] all_namespaces: If True, restore all namespaced resources in the Backup.
               Setting this field to False will result in an error.
        :param pulumi.Input[str] cluster_resource_conflict_policy: Defines the behavior for handling the situation where cluster-scoped resources
               being restored already exist in the target cluster.
               This MUST be set to a value other than `CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED`
               if `clusterResourceRestoreScope` is anyting other than `noGroupKinds`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
               for more information on each policy option.
               Possible values are: `USE_EXISTING_VERSION`, `USE_BACKUP_VERSION`.
        :param pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeArgs'] cluster_resource_restore_scope: Identifies the cluster-scoped resources to restore from the Backup.
               Structure is documented below.
        :param pulumi.Input['RestorePlanRestoreConfigExcludedNamespacesArgs'] excluded_namespaces: A list of selected namespaces excluded from restoration.
               All namespaces except those in this list will be restored.
               Structure is documented below.
        :param pulumi.Input[str] namespaced_resource_restore_mode: Defines the behavior for handling the situation where sets of namespaced resources
               being restored already exist in the target cluster.
               This MUST be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
               if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
               for more information on each mode.
               Possible values are: `DELETE_AND_RESTORE`, `FAIL_ON_CONFLICT`, `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT`, `MERGE_REPLACE_ON_CONFLICT`.
        :param pulumi.Input[bool] no_namespaces: Do not restore any namespaced resources if set to "True".
               Specifying this field to "False" is not allowed.
        :param pulumi.Input['RestorePlanRestoreConfigRestoreOrderArgs'] restore_order: It contains custom ordering to use on a Restore.
               Structure is documented below.
        :param pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsArgs'] selected_applications: A list of selected ProtectedApplications to restore.
               The listed ProtectedApplications and all the resources
               to which they refer will be restored.
               Structure is documented below.
        :param pulumi.Input['RestorePlanRestoreConfigSelectedNamespacesArgs'] selected_namespaces: A list of selected namespaces to restore from the Backup.
               The listed Namespaces and all resources contained in them will be restored.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleArgs']]] transformation_rules: A list of transformation rules to be applied against Kubernetes
               resources as they are selected for restoration from a Backup.
               Rules are executed in order defined - this order matters,
               as changes made by a rule may impact the filtering logic of subsequent
               rules. An empty list means no transformation will occur.
               Structure is documented below.
        :param pulumi.Input[str] volume_data_restore_policy: Specifies the mechanism to be used to restore volume data.
               This should be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
               if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
               If not specified, it will be treated as `NO_VOLUME_DATA_RESTORATION`.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
               for more information on each policy option.
               Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs']]] volume_data_restore_policy_bindings: A table that binds volumes by their scope to a restore policy. Bindings
               must have a unique scope. Any volumes not scoped in the bindings are
               subject to the policy defined in volume_data_restore_policy.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if cluster_resource_conflict_policy is not None:
            pulumi.set(__self__, "cluster_resource_conflict_policy", cluster_resource_conflict_policy)
        if cluster_resource_restore_scope is not None:
            pulumi.set(__self__, "cluster_resource_restore_scope", cluster_resource_restore_scope)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)
        if namespaced_resource_restore_mode is not None:
            pulumi.set(__self__, "namespaced_resource_restore_mode", namespaced_resource_restore_mode)
        if no_namespaces is not None:
            pulumi.set(__self__, "no_namespaces", no_namespaces)
        if restore_order is not None:
            pulumi.set(__self__, "restore_order", restore_order)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)
        if transformation_rules is not None:
            pulumi.set(__self__, "transformation_rules", transformation_rules)
        if volume_data_restore_policy is not None:
            pulumi.set(__self__, "volume_data_restore_policy", volume_data_restore_policy)
        if volume_data_restore_policy_bindings is not None:
            pulumi.set(__self__, "volume_data_restore_policy_bindings", volume_data_restore_policy_bindings)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, restore all namespaced resources in the Backup.
        Setting this field to False will result in an error.
        """
        return pulumi.get(self, "all_namespaces")

    @all_namespaces.setter
    def all_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_namespaces", value)

    @property
    @pulumi.getter(name="clusterResourceConflictPolicy")
    def cluster_resource_conflict_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the behavior for handling the situation where cluster-scoped resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED`
        if `clusterResourceRestoreScope` is anyting other than `noGroupKinds`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
        for more information on each policy option.
        Possible values are: `USE_EXISTING_VERSION`, `USE_BACKUP_VERSION`.
        """
        return pulumi.get(self, "cluster_resource_conflict_policy")

    @cluster_resource_conflict_policy.setter
    def cluster_resource_conflict_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_resource_conflict_policy", value)

    @property
    @pulumi.getter(name="clusterResourceRestoreScope")
    def cluster_resource_restore_scope(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeArgs']]:
        """
        Identifies the cluster-scoped resources to restore from the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_resource_restore_scope")

    @cluster_resource_restore_scope.setter
    def cluster_resource_restore_scope(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeArgs']]):
        pulumi.set(self, "cluster_resource_restore_scope", value)

    @property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigExcludedNamespacesArgs']]:
        """
        A list of selected namespaces excluded from restoration.
        All namespaces except those in this list will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_namespaces")

    @excluded_namespaces.setter
    def excluded_namespaces(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigExcludedNamespacesArgs']]):
        pulumi.set(self, "excluded_namespaces", value)

    @property
    @pulumi.getter(name="namespacedResourceRestoreMode")
    def namespaced_resource_restore_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the behavior for handling the situation where sets of namespaced resources
        being restored already exist in the target cluster.
        This MUST be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
        for more information on each mode.
        Possible values are: `DELETE_AND_RESTORE`, `FAIL_ON_CONFLICT`, `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT`, `MERGE_REPLACE_ON_CONFLICT`.
        """
        return pulumi.get(self, "namespaced_resource_restore_mode")

    @namespaced_resource_restore_mode.setter
    def namespaced_resource_restore_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespaced_resource_restore_mode", value)

    @property
    @pulumi.getter(name="noNamespaces")
    def no_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not restore any namespaced resources if set to "True".
        Specifying this field to "False" is not allowed.
        """
        return pulumi.get(self, "no_namespaces")

    @no_namespaces.setter
    def no_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_namespaces", value)

    @property
    @pulumi.getter(name="restoreOrder")
    def restore_order(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigRestoreOrderArgs']]:
        """
        It contains custom ordering to use on a Restore.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_order")

    @restore_order.setter
    def restore_order(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigRestoreOrderArgs']]):
        pulumi.set(self, "restore_order", value)

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsArgs']]:
        """
        A list of selected ProtectedApplications to restore.
        The listed ProtectedApplications and all the resources
        to which they refer will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @selected_applications.setter
    def selected_applications(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsArgs']]):
        pulumi.set(self, "selected_applications", value)

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigSelectedNamespacesArgs']]:
        """
        A list of selected namespaces to restore from the Backup.
        The listed Namespaces and all resources contained in them will be restored.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")

    @selected_namespaces.setter
    def selected_namespaces(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigSelectedNamespacesArgs']]):
        pulumi.set(self, "selected_namespaces", value)

    @property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleArgs']]]]:
        """
        A list of transformation rules to be applied against Kubernetes
        resources as they are selected for restoration from a Backup.
        Rules are executed in order defined - this order matters,
        as changes made by a rule may impact the filtering logic of subsequent
        rules. An empty list means no transformation will occur.
        Structure is documented below.
        """
        return pulumi.get(self, "transformation_rules")

    @transformation_rules.setter
    def transformation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleArgs']]]]):
        pulumi.set(self, "transformation_rules", value)

    @property
    @pulumi.getter(name="volumeDataRestorePolicy")
    def volume_data_restore_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mechanism to be used to restore volume data.
        This should be set to a value other than `NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED`
        if the `namespacedResourceRestoreScope` is anything other than `noNamespaces`.
        If not specified, it will be treated as `NO_VOLUME_DATA_RESTORATION`.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        return pulumi.get(self, "volume_data_restore_policy")

    @volume_data_restore_policy.setter
    def volume_data_restore_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_data_restore_policy", value)

    @property
    @pulumi.getter(name="volumeDataRestorePolicyBindings")
    def volume_data_restore_policy_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs']]]]:
        """
        A table that binds volumes by their scope to a restore policy. Bindings
        must have a unique scope. Any volumes not scoped in the bindings are
        subject to the policy defined in volume_data_restore_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_data_restore_policy_bindings")

    @volume_data_restore_policy_bindings.setter
    def volume_data_restore_policy_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs']]]]):
        pulumi.set(self, "volume_data_restore_policy_bindings", value)


if not MYPY:
    class RestorePlanRestoreConfigClusterResourceRestoreScopeArgsDict(TypedDict):
        all_group_kinds: NotRequired[pulumi.Input[bool]]
        """
        If True, all valid cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        excluded_group_kinds: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgsDict']]]]
        """
        A list of cluster-scoped resource group kinds to NOT restore from the backup.
        If specified, all valid cluster-scoped resources will be restored except
        for those specified in the list.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        Structure is documented below.
        """
        no_group_kinds: NotRequired[pulumi.Input[bool]]
        """
        If True, no cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        selected_group_kinds: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgsDict']]]]
        """
        A list of cluster-scoped resource group kinds to restore from the backup.
        If specified, only the selected resources will be restored.
        Mutually exclusive to any other field in the `clusterResourceRestoreScope`.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigClusterResourceRestoreScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigClusterResourceRestoreScopeArgs:
    def __init__(__self__, *,
                 all_group_kinds: Optional[pulumi.Input[bool]] = None,
                 excluded_group_kinds: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs']]]] = None,
                 no_group_kinds: Optional[pulumi.Input[bool]] = None,
                 selected_group_kinds: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs']]]] = None):
        """
        :param pulumi.Input[bool] all_group_kinds: If True, all valid cluster-scoped resources will be restored.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs']]] excluded_group_kinds: A list of cluster-scoped resource group kinds to NOT restore from the backup.
               If specified, all valid cluster-scoped resources will be restored except
               for those specified in the list.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
               Structure is documented below.
        :param pulumi.Input[bool] no_group_kinds: If True, no cluster-scoped resources will be restored.
               Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs']]] selected_group_kinds: A list of cluster-scoped resource group kinds to restore from the backup.
               If specified, only the selected resources will be restored.
               Mutually exclusive to any other field in the `clusterResourceRestoreScope`.
               Structure is documented below.
        """
        if all_group_kinds is not None:
            pulumi.set(__self__, "all_group_kinds", all_group_kinds)
        if excluded_group_kinds is not None:
            pulumi.set(__self__, "excluded_group_kinds", excluded_group_kinds)
        if no_group_kinds is not None:
            pulumi.set(__self__, "no_group_kinds", no_group_kinds)
        if selected_group_kinds is not None:
            pulumi.set(__self__, "selected_group_kinds", selected_group_kinds)

    @property
    @pulumi.getter(name="allGroupKinds")
    def all_group_kinds(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, all valid cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        return pulumi.get(self, "all_group_kinds")

    @all_group_kinds.setter
    def all_group_kinds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_group_kinds", value)

    @property
    @pulumi.getter(name="excludedGroupKinds")
    def excluded_group_kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs']]]]:
        """
        A list of cluster-scoped resource group kinds to NOT restore from the backup.
        If specified, all valid cluster-scoped resources will be restored except
        for those specified in the list.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_group_kinds")

    @excluded_group_kinds.setter
    def excluded_group_kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs']]]]):
        pulumi.set(self, "excluded_group_kinds", value)

    @property
    @pulumi.getter(name="noGroupKinds")
    def no_group_kinds(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, no cluster-scoped resources will be restored.
        Mutually exclusive to any other field in `clusterResourceRestoreScope`.
        """
        return pulumi.get(self, "no_group_kinds")

    @no_group_kinds.setter
    def no_group_kinds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_group_kinds", value)

    @property
    @pulumi.getter(name="selectedGroupKinds")
    def selected_group_kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs']]]]:
        """
        A list of cluster-scoped resource group kinds to restore from the backup.
        If specified, only the selected resources will be restored.
        Mutually exclusive to any other field in the `clusterResourceRestoreScope`.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_group_kinds")

    @selected_group_kinds.setter
    def selected_group_kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs']]]]):
        pulumi.set(self, "selected_group_kinds", value)


if not MYPY:
    class RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgsDict(TypedDict):
        resource_group: NotRequired[pulumi.Input[str]]
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        resource_kind: NotRequired[pulumi.Input[str]]
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
elif False:
    RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


if not MYPY:
    class RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgsDict(TypedDict):
        resource_group: NotRequired[pulumi.Input[str]]
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        resource_kind: NotRequired[pulumi.Input[str]]
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
elif False:
    RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


if not MYPY:
    class RestorePlanRestoreConfigExcludedNamespacesArgsDict(TypedDict):
        namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of Kubernetes Namespaces.
        """
elif False:
    RestorePlanRestoreConfigExcludedNamespacesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigExcludedNamespacesArgs:
    def __init__(__self__, *,
                 namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class RestorePlanRestoreConfigRestoreOrderArgsDict(TypedDict):
        group_kind_dependencies: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgsDict']]]
        """
        A list of group kind dependency pairs
        that is used by Backup for GKE to
        generate a group kind restore order.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigRestoreOrderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigRestoreOrderArgs:
    def __init__(__self__, *,
                 group_kind_dependencies: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs']]] group_kind_dependencies: A list of group kind dependency pairs
               that is used by Backup for GKE to
               generate a group kind restore order.
               Structure is documented below.
        """
        pulumi.set(__self__, "group_kind_dependencies", group_kind_dependencies)

    @property
    @pulumi.getter(name="groupKindDependencies")
    def group_kind_dependencies(self) -> pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs']]]:
        """
        A list of group kind dependency pairs
        that is used by Backup for GKE to
        generate a group kind restore order.
        Structure is documented below.
        """
        return pulumi.get(self, "group_kind_dependencies")

    @group_kind_dependencies.setter
    def group_kind_dependencies(self, value: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs']]]):
        pulumi.set(self, "group_kind_dependencies", value)


if not MYPY:
    class RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgsDict(TypedDict):
        requiring: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgsDict']
        """
        The requiring group kind requires that the satisfying
        group kind be restored first.
        Structure is documented below.
        """
        satisfying: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgsDict']
        """
        The satisfying group kind must be restored first
        in order to satisfy the dependency.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependencyArgs:
    def __init__(__self__, *,
                 requiring: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs'],
                 satisfying: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs']):
        """
        :param pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs'] requiring: The requiring group kind requires that the satisfying
               group kind be restored first.
               Structure is documented below.
        :param pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs'] satisfying: The satisfying group kind must be restored first
               in order to satisfy the dependency.
               Structure is documented below.
        """
        pulumi.set(__self__, "requiring", requiring)
        pulumi.set(__self__, "satisfying", satisfying)

    @property
    @pulumi.getter
    def requiring(self) -> pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs']:
        """
        The requiring group kind requires that the satisfying
        group kind be restored first.
        Structure is documented below.
        """
        return pulumi.get(self, "requiring")

    @requiring.setter
    def requiring(self, value: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs']):
        pulumi.set(self, "requiring", value)

    @property
    @pulumi.getter
    def satisfying(self) -> pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs']:
        """
        The satisfying group kind must be restored first
        in order to satisfy the dependency.
        Structure is documented below.
        """
        return pulumi.get(self, "satisfying")

    @satisfying.setter
    def satisfying(self, value: pulumi.Input['RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs']):
        pulumi.set(self, "satisfying", value)


if not MYPY:
    class RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgsDict(TypedDict):
        resource_group: NotRequired[pulumi.Input[str]]
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        resource_kind: NotRequired[pulumi.Input[str]]
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.

        - - -
        """
elif False:
    RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependencyRequiringArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_group: API Group of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
               
               - - -
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.

        - - -
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


if not MYPY:
    class RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgsDict(TypedDict):
        resource_group: NotRequired[pulumi.Input[str]]
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        resource_kind: NotRequired[pulumi.Input[str]]
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
elif False:
    RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigRestoreOrderGroupKindDependencySatisfyingArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_group: API Group of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API Group of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


if not MYPY:
    class RestorePlanRestoreConfigSelectedApplicationsArgsDict(TypedDict):
        namespaced_names: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgsDict']]]
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigSelectedApplicationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigSelectedApplicationsArgs:
    def __init__(__self__, *,
                 namespaced_names: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs']]] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs']]]:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")

    @namespaced_names.setter
    def namespaced_names(self, value: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs']]]):
        pulumi.set(self, "namespaced_names", value)


if not MYPY:
    class RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of a Kubernetes Resource.
        """
        namespace: pulumi.Input[str]
        """
        The namespace of a Kubernetes Resource.
        """
elif False:
    RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigSelectedApplicationsNamespacedNameArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of a Kubernetes Resource.
        :param pulumi.Input[str] namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class RestorePlanRestoreConfigSelectedNamespacesArgsDict(TypedDict):
        namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of Kubernetes Namespaces.
        """
elif False:
    RestorePlanRestoreConfigSelectedNamespacesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigSelectedNamespacesArgs:
    def __init__(__self__, *,
                 namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class RestorePlanRestoreConfigTransformationRuleArgsDict(TypedDict):
        field_actions: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleFieldActionArgsDict']]]
        """
        A list of transformation rule actions to take against candidate
        resources. Actions are executed in order defined - this order
        matters, as they could potentially interfere with each other and
        the first operation could affect the outcome of the second operation.
        Structure is documented below.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description is a user specified string description
        of the transformation rule.
        """
        resource_filter: NotRequired[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterArgsDict']]
        """
        This field is used to specify a set of fields that should be used to
        determine which resources in backup should be acted upon by the
        supplied transformation rule actions, and this will ensure that only
        specific resources are affected by transformation rule actions.
        Structure is documented below.
        """
elif False:
    RestorePlanRestoreConfigTransformationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigTransformationRuleArgs:
    def __init__(__self__, *,
                 field_actions: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleFieldActionArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 resource_filter: Optional[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleFieldActionArgs']]] field_actions: A list of transformation rule actions to take against candidate
               resources. Actions are executed in order defined - this order
               matters, as they could potentially interfere with each other and
               the first operation could affect the outcome of the second operation.
               Structure is documented below.
        :param pulumi.Input[str] description: The description is a user specified string description
               of the transformation rule.
        :param pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterArgs'] resource_filter: This field is used to specify a set of fields that should be used to
               determine which resources in backup should be acted upon by the
               supplied transformation rule actions, and this will ensure that only
               specific resources are affected by transformation rule actions.
               Structure is documented below.
        """
        pulumi.set(__self__, "field_actions", field_actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_filter is not None:
            pulumi.set(__self__, "resource_filter", resource_filter)

    @property
    @pulumi.getter(name="fieldActions")
    def field_actions(self) -> pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleFieldActionArgs']]]:
        """
        A list of transformation rule actions to take against candidate
        resources. Actions are executed in order defined - this order
        matters, as they could potentially interfere with each other and
        the first operation could affect the outcome of the second operation.
        Structure is documented below.
        """
        return pulumi.get(self, "field_actions")

    @field_actions.setter
    def field_actions(self, value: pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleFieldActionArgs']]]):
        pulumi.set(self, "field_actions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description is a user specified string description
        of the transformation rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="resourceFilter")
    def resource_filter(self) -> Optional[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterArgs']]:
        """
        This field is used to specify a set of fields that should be used to
        determine which resources in backup should be acted upon by the
        supplied transformation rule actions, and this will ensure that only
        specific resources are affected by transformation rule actions.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_filter")

    @resource_filter.setter
    def resource_filter(self, value: Optional[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterArgs']]):
        pulumi.set(self, "resource_filter", value)


if not MYPY:
    class RestorePlanRestoreConfigTransformationRuleFieldActionArgsDict(TypedDict):
        op: pulumi.Input[str]
        """
        Specifies the operation to perform.
        Possible values are: `REMOVE`, `MOVE`, `COPY`, `ADD`, `TEST`, `REPLACE`.
        """
        from_path: NotRequired[pulumi.Input[str]]
        """
        A string containing a JSON Pointer value that references the
        location in the target document to move the value from.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        A string containing a JSON-Pointer value that references a
        location within the target document where the operation is performed.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        A string that specifies the desired value in string format
        to use for transformation.
        """
elif False:
    RestorePlanRestoreConfigTransformationRuleFieldActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigTransformationRuleFieldActionArgs:
    def __init__(__self__, *,
                 op: pulumi.Input[str],
                 from_path: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] op: Specifies the operation to perform.
               Possible values are: `REMOVE`, `MOVE`, `COPY`, `ADD`, `TEST`, `REPLACE`.
        :param pulumi.Input[str] from_path: A string containing a JSON Pointer value that references the
               location in the target document to move the value from.
        :param pulumi.Input[str] path: A string containing a JSON-Pointer value that references a
               location within the target document where the operation is performed.
        :param pulumi.Input[str] value: A string that specifies the desired value in string format
               to use for transformation.
        """
        pulumi.set(__self__, "op", op)
        if from_path is not None:
            pulumi.set(__self__, "from_path", from_path)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        Specifies the operation to perform.
        Possible values are: `REMOVE`, `MOVE`, `COPY`, `ADD`, `TEST`, `REPLACE`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter(name="fromPath")
    def from_path(self) -> Optional[pulumi.Input[str]]:
        """
        A string containing a JSON Pointer value that references the
        location in the target document to move the value from.
        """
        return pulumi.get(self, "from_path")

    @from_path.setter
    def from_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "from_path", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        A string containing a JSON-Pointer value that references a
        location within the target document where the operation is performed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        A string that specifies the desired value in string format
        to use for transformation.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RestorePlanRestoreConfigTransformationRuleResourceFilterArgsDict(TypedDict):
        group_kinds: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgsDict']]]]
        """
        (Filtering parameter) Any resource subject to transformation must
        belong to one of the listed "types". If this field is not provided,
        no type filtering will be performed
        (all resources of all types matching previous filtering parameters
        will be candidates for transformation).
        Structure is documented below.
        """
        json_path: NotRequired[pulumi.Input[str]]
        """
        This is a JSONPath expression that matches specific fields of
        candidate resources and it operates as a filtering parameter
        (resources that are not matched with this expression will not
        be candidates for transformation).
        """
        namespaces: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Filtering parameter) Any resource subject to transformation must
        be contained within one of the listed Kubernetes Namespace in the
        Backup. If this field is not provided, no namespace filtering will
        be performed (all resources in all Namespaces, including all
        cluster-scoped resources, will be candidates for transformation).
        To mix cluster-scoped and namespaced resources in the same rule,
        use an empty string ("") as one of the target namespaces.
        """
elif False:
    RestorePlanRestoreConfigTransformationRuleResourceFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigTransformationRuleResourceFilterArgs:
    def __init__(__self__, *,
                 group_kinds: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs']]]] = None,
                 json_path: Optional[pulumi.Input[str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs']]] group_kinds: (Filtering parameter) Any resource subject to transformation must
               belong to one of the listed "types". If this field is not provided,
               no type filtering will be performed
               (all resources of all types matching previous filtering parameters
               will be candidates for transformation).
               Structure is documented below.
        :param pulumi.Input[str] json_path: This is a JSONPath expression that matches specific fields of
               candidate resources and it operates as a filtering parameter
               (resources that are not matched with this expression will not
               be candidates for transformation).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: (Filtering parameter) Any resource subject to transformation must
               be contained within one of the listed Kubernetes Namespace in the
               Backup. If this field is not provided, no namespace filtering will
               be performed (all resources in all Namespaces, including all
               cluster-scoped resources, will be candidates for transformation).
               To mix cluster-scoped and namespaced resources in the same rule,
               use an empty string ("") as one of the target namespaces.
        """
        if group_kinds is not None:
            pulumi.set(__self__, "group_kinds", group_kinds)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter(name="groupKinds")
    def group_kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs']]]]:
        """
        (Filtering parameter) Any resource subject to transformation must
        belong to one of the listed "types". If this field is not provided,
        no type filtering will be performed
        (all resources of all types matching previous filtering parameters
        will be candidates for transformation).
        Structure is documented below.
        """
        return pulumi.get(self, "group_kinds")

    @group_kinds.setter
    def group_kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs']]]]):
        pulumi.set(self, "group_kinds", value)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[pulumi.Input[str]]:
        """
        This is a JSONPath expression that matches specific fields of
        candidate resources and it operates as a filtering parameter
        (resources that are not matched with this expression will not
        be candidates for transformation).
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_path", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Filtering parameter) Any resource subject to transformation must
        be contained within one of the listed Kubernetes Namespace in the
        Backup. If this field is not provided, no namespace filtering will
        be performed (all resources in all Namespaces, including all
        cluster-scoped resources, will be candidates for transformation).
        To mix cluster-scoped and namespaced resources in the same rule,
        use an empty string ("") as one of the target namespaces.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgsDict(TypedDict):
        resource_group: NotRequired[pulumi.Input[str]]
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        resource_kind: NotRequired[pulumi.Input[str]]
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
elif False:
    RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigTransformationRuleResourceFilterGroupKindArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_group: API Group string of a Kubernetes resource, e.g.
               "apiextensions.k8s.io", "storage.k8s.io", etc.
               Use empty string for core group.
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g.
               "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API Group string of a Kubernetes resource, e.g.
        "apiextensions.k8s.io", "storage.k8s.io", etc.
        Use empty string for core group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g.
        "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


if not MYPY:
    class RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgsDict(TypedDict):
        policy: pulumi.Input[str]
        """
        Specifies the mechanism to be used to restore this volume data.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        volume_type: pulumi.Input[str]
        """
        The volume type, as determined by the PVC's
        bound PV, to apply the policy to.
        Possible values are: `GCE_PERSISTENT_DISK`.
        """
elif False:
    RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestorePlanRestoreConfigVolumeDataRestorePolicyBindingArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[str],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] policy: Specifies the mechanism to be used to restore this volume data.
               See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
               for more information on each policy option.
               Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        :param pulumi.Input[str] volume_type: The volume type, as determined by the PVC's
               bound PV, to apply the policy to.
               Possible values are: `GCE_PERSISTENT_DISK`.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        Specifies the mechanism to be used to restore this volume data.
        See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
        for more information on each policy option.
        Possible values are: `RESTORE_VOLUME_DATA_FROM_BACKUP`, `REUSE_VOLUME_HANDLE_FROM_BACKUP`, `NO_VOLUME_DATA_RESTORATION`.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        The volume type, as determined by the PVC's
        bound PV, to apply the policy to.
        Possible values are: `GCE_PERSISTENT_DISK`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


