# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VMwareNodePoolArgs', 'VMwareNodePool']

@pulumi.input_type
class VMwareNodePoolArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['VMwareNodePoolConfigArgs'],
                 location: pulumi.Input[str],
                 vmware_cluster: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_autoscaling: Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VMwareNodePool resource.
        :param pulumi.Input['VMwareNodePoolConfigArgs'] config: The node configuration of the node pool.
               Structure is documented below.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] vmware_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
               and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
               slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
               dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
               only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
               the annotations present on the resource.
        :param pulumi.Input[str] display_name: The display name for the node pool.
        :param pulumi.Input[str] name: The vmware node pool name.
        :param pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs'] node_pool_autoscaling: Node Pool autoscaling config for the node pool.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "vmware_cluster", vmware_cluster)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_autoscaling is not None:
            pulumi.set(__self__, "node_pool_autoscaling", node_pool_autoscaling)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['VMwareNodePoolConfigArgs']:
        """
        The node configuration of the node pool.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['VMwareNodePoolConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="vmwareCluster")
    def vmware_cluster(self) -> pulumi.Input[str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "vmware_cluster")

    @vmware_cluster.setter
    def vmware_cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmware_cluster", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
        and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
        slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
        dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
        only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
        the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the node pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The vmware node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolAutoscaling")
    def node_pool_autoscaling(self) -> Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']]:
        """
        Node Pool autoscaling config for the node pool.
        """
        return pulumi.get(self, "node_pool_autoscaling")

    @node_pool_autoscaling.setter
    def node_pool_autoscaling(self, value: Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']]):
        pulumi.set(self, "node_pool_autoscaling", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _VMwareNodePoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config: Optional[pulumi.Input['VMwareNodePoolConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_autoscaling: Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']] = None,
                 on_prem_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareNodePoolStatusArgs']]]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vmware_cluster: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VMwareNodePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
               and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
               slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
               dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
               only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
               the annotations present on the resource.
        :param pulumi.Input['VMwareNodePoolConfigArgs'] config: The node configuration of the node pool.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[str] display_name: The display name for the node pool.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The vmware node pool name.
        :param pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs'] node_pool_autoscaling: Node Pool autoscaling config for the node pool.
        :param pulumi.Input[str] on_prem_version: Anthos version for the node pool. Defaults to the user cluster version.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the node pool.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareNodePoolStatusArgs']]] statuses: ResourceStatus representing detailed cluster state.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the node pool.
        :param pulumi.Input[str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input[str] vmware_cluster: The cluster this node pool belongs to.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_autoscaling is not None:
            pulumi.set(__self__, "node_pool_autoscaling", node_pool_autoscaling)
        if on_prem_version is not None:
            pulumi.set(__self__, "on_prem_version", on_prem_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vmware_cluster is not None:
            pulumi.set(__self__, "vmware_cluster", vmware_cluster)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
        and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
        slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
        dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
        only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
        the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['VMwareNodePoolConfigArgs']]:
        """
        The node configuration of the node pool.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['VMwareNodePoolConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the node pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The vmware node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolAutoscaling")
    def node_pool_autoscaling(self) -> Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']]:
        """
        Node Pool autoscaling config for the node pool.
        """
        return pulumi.get(self, "node_pool_autoscaling")

    @node_pool_autoscaling.setter
    def node_pool_autoscaling(self, value: Optional[pulumi.Input['VMwareNodePoolNodePoolAutoscalingArgs']]):
        pulumi.set(self, "node_pool_autoscaling", value)

    @property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> Optional[pulumi.Input[str]]:
        """
        Anthos version for the node pool. Defaults to the user cluster version.
        """
        return pulumi.get(self, "on_prem_version")

    @on_prem_version.setter
    def on_prem_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_prem_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, there are currently changes in flight to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VMwareNodePoolStatusArgs']]]]:
        """
        ResourceStatus representing detailed cluster state.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareNodePoolStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the node pool.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vmwareCluster")
    def vmware_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "vmware_cluster")

    @vmware_cluster.setter
    def vmware_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_cluster", value)


class VMwareNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config: Optional[pulumi.Input[Union['VMwareNodePoolConfigArgs', 'VMwareNodePoolConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_autoscaling: Optional[pulumi.Input[Union['VMwareNodePoolNodePoolAutoscalingArgs', 'VMwareNodePoolNodePoolAutoscalingArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 vmware_cluster: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Google Vmware Node Pool.

        ## Example Usage

        ### Gkeonprem Vmware Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.VMwareCluster("default-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 1,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "ingress_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "address_pools": [
                        {
                            "pool": "ingress-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                        {
                            "pool": "lb-test-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                    ],
                },
            })
        nodepool_basic = gcp.gkeonprem.VMwareNodePool("nodepool-basic",
            name="my-nodepool",
            location="us-west1",
            vmware_cluster=default_basic.name,
            config={
                "replicas": 3,
                "image_type": "ubuntu_containerd",
                "enable_load_balancer": True,
            })
        ```
        ### Gkeonprem Vmware Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.VMwareCluster("default-full",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 1,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "ingress_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "address_pools": [
                        {
                            "pool": "ingress-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                        {
                            "pool": "lb-test-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                    ],
                },
            })
        nodepool_full = gcp.gkeonprem.VMwareNodePool("nodepool-full",
            name="my-nodepool",
            location="us-west1",
            vmware_cluster=default_full.name,
            annotations={},
            config={
                "cpus": 4,
                "memory_mb": 8196,
                "replicas": 3,
                "image_type": "ubuntu_containerd",
                "image": "image",
                "boot_disk_size_gb": 10,
                "taints": [
                    {
                        "key": "key",
                        "value": "value",
                    },
                    {
                        "key": "key",
                        "value": "value",
                        "effect": "NO_SCHEDULE",
                    },
                ],
                "labels": {},
                "vsphere_config": {
                    "datastore": "test-datastore",
                    "tags": [
                        {
                            "category": "test-category-1",
                            "tag": "tag-1",
                        },
                        {
                            "category": "test-category-2",
                            "tag": "tag-2",
                        },
                    ],
                    "host_groups": [
                        "host1",
                        "host2",
                    ],
                },
                "enable_load_balancer": True,
            },
            node_pool_autoscaling={
                "min_replicas": 1,
                "max_replicas": 5,
            })
        ```

        ## Import

        VmwareNodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareClusters/{{vmware_cluster}}/vmwareNodePools/{{name}}`

        * `{{project}}/{{location}}/{{vmware_cluster}}/{{name}}`

        * `{{location}}/{{vmware_cluster}}/{{name}}`

        When using the `pulumi import` command, VmwareNodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default projects/{{project}}/locations/{{location}}/vmwareClusters/{{vmware_cluster}}/vmwareNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default {{project}}/{{location}}/{{vmware_cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default {{location}}/{{vmware_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
               and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
               slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
               dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
               only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
               the annotations present on the resource.
        :param pulumi.Input[Union['VMwareNodePoolConfigArgs', 'VMwareNodePoolConfigArgsDict']] config: The node configuration of the node pool.
               Structure is documented below.
        :param pulumi.Input[str] display_name: The display name for the node pool.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The vmware node pool name.
        :param pulumi.Input[Union['VMwareNodePoolNodePoolAutoscalingArgs', 'VMwareNodePoolNodePoolAutoscalingArgsDict']] node_pool_autoscaling: Node Pool autoscaling config for the node pool.
        :param pulumi.Input[str] vmware_cluster: The cluster this node pool belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VMwareNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Vmware Node Pool.

        ## Example Usage

        ### Gkeonprem Vmware Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.VMwareCluster("default-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 1,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "ingress_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "address_pools": [
                        {
                            "pool": "ingress-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                        {
                            "pool": "lb-test-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                    ],
                },
            })
        nodepool_basic = gcp.gkeonprem.VMwareNodePool("nodepool-basic",
            name="my-nodepool",
            location="us-west1",
            vmware_cluster=default_basic.name,
            config={
                "replicas": 3,
                "image_type": "ubuntu_containerd",
                "enable_load_balancer": True,
            })
        ```
        ### Gkeonprem Vmware Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.VMwareCluster("default-full",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            network_config={
                "service_address_cidr_blocks": ["10.96.0.0/12"],
                "pod_address_cidr_blocks": ["192.168.0.0/16"],
                "dhcp_ip_config": {
                    "enabled": True,
                },
            },
            control_plane_node={
                "cpus": 4,
                "memory": 8192,
                "replicas": 1,
            },
            load_balancer={
                "vip_config": {
                    "control_plane_vip": "10.251.133.5",
                    "ingress_vip": "10.251.135.19",
                },
                "metal_lb_config": {
                    "address_pools": [
                        {
                            "pool": "ingress-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                        {
                            "pool": "lb-test-ip",
                            "manual_assign": True,
                            "addresses": ["10.251.135.19"],
                        },
                    ],
                },
            })
        nodepool_full = gcp.gkeonprem.VMwareNodePool("nodepool-full",
            name="my-nodepool",
            location="us-west1",
            vmware_cluster=default_full.name,
            annotations={},
            config={
                "cpus": 4,
                "memory_mb": 8196,
                "replicas": 3,
                "image_type": "ubuntu_containerd",
                "image": "image",
                "boot_disk_size_gb": 10,
                "taints": [
                    {
                        "key": "key",
                        "value": "value",
                    },
                    {
                        "key": "key",
                        "value": "value",
                        "effect": "NO_SCHEDULE",
                    },
                ],
                "labels": {},
                "vsphere_config": {
                    "datastore": "test-datastore",
                    "tags": [
                        {
                            "category": "test-category-1",
                            "tag": "tag-1",
                        },
                        {
                            "category": "test-category-2",
                            "tag": "tag-2",
                        },
                    ],
                    "host_groups": [
                        "host1",
                        "host2",
                    ],
                },
                "enable_load_balancer": True,
            },
            node_pool_autoscaling={
                "min_replicas": 1,
                "max_replicas": 5,
            })
        ```

        ## Import

        VmwareNodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareClusters/{{vmware_cluster}}/vmwareNodePools/{{name}}`

        * `{{project}}/{{location}}/{{vmware_cluster}}/{{name}}`

        * `{{location}}/{{vmware_cluster}}/{{name}}`

        When using the `pulumi import` command, VmwareNodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default projects/{{project}}/locations/{{location}}/vmwareClusters/{{vmware_cluster}}/vmwareNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default {{project}}/{{location}}/{{vmware_cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/vMwareNodePool:VMwareNodePool default {{location}}/{{vmware_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VMwareNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VMwareNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config: Optional[pulumi.Input[Union['VMwareNodePoolConfigArgs', 'VMwareNodePoolConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_autoscaling: Optional[pulumi.Input[Union['VMwareNodePoolNodePoolAutoscalingArgs', 'VMwareNodePoolNodePoolAutoscalingArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 vmware_cluster: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VMwareNodePoolArgs.__new__(VMwareNodePoolArgs)

            __props__.__dict__["annotations"] = annotations
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["node_pool_autoscaling"] = node_pool_autoscaling
            __props__.__dict__["project"] = project
            if vmware_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_cluster'")
            __props__.__dict__["vmware_cluster"] = vmware_cluster
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["on_prem_version"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(VMwareNodePool, __self__).__init__(
            'gcp:gkeonprem/vMwareNodePool:VMwareNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            config: Optional[pulumi.Input[Union['VMwareNodePoolConfigArgs', 'VMwareNodePoolConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_pool_autoscaling: Optional[pulumi.Input[Union['VMwareNodePoolNodePoolAutoscalingArgs', 'VMwareNodePoolNodePoolAutoscalingArgsDict']]] = None,
            on_prem_version: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VMwareNodePoolStatusArgs', 'VMwareNodePoolStatusArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vmware_cluster: Optional[pulumi.Input[str]] = None) -> 'VMwareNodePool':
        """
        Get an existing VMwareNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
               and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
               slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
               dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
               only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
               the annotations present on the resource.
        :param pulumi.Input[Union['VMwareNodePoolConfigArgs', 'VMwareNodePoolConfigArgsDict']] config: The node configuration of the node pool.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[str] display_name: The display name for the node pool.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The vmware node pool name.
        :param pulumi.Input[Union['VMwareNodePoolNodePoolAutoscalingArgs', 'VMwareNodePoolNodePoolAutoscalingArgsDict']] node_pool_autoscaling: Node Pool autoscaling config for the node pool.
        :param pulumi.Input[str] on_prem_version: Anthos version for the node pool. Defaults to the user cluster version.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the node pool.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VMwareNodePoolStatusArgs', 'VMwareNodePoolStatusArgsDict']]]] statuses: ResourceStatus representing detailed cluster state.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the node pool.
        :param pulumi.Input[str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input[str] vmware_cluster: The cluster this node pool belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VMwareNodePoolState.__new__(_VMwareNodePoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool_autoscaling"] = node_pool_autoscaling
        __props__.__dict__["on_prem_version"] = on_prem_version
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vmware_cluster"] = vmware_cluster
        return VMwareNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Annotations on the node Pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys
        and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a
        slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with
        dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is non-authoritative, and will
        only manage the annotations present in your configuration. Please refer to the field 'effective_annotations' for all of
        the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.VMwareNodePoolConfig']:
        """
        The node configuration of the node pool.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name for the node pool.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The vmware node pool name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolAutoscaling")
    def node_pool_autoscaling(self) -> pulumi.Output[Optional['outputs.VMwareNodePoolNodePoolAutoscaling']]:
        """
        Node Pool autoscaling config for the node pool.
        """
        return pulumi.get(self, "node_pool_autoscaling")

    @property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> pulumi.Output[str]:
        """
        Anthos version for the node pool. Defaults to the user cluster version.
        """
        return pulumi.get(self, "on_prem_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        If set, there are currently changes in flight to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.VMwareNodePoolStatus']]:
        """
        ResourceStatus representing detailed cluster state.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The unique identifier of the node pool.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vmwareCluster")
    def vmware_cluster(self) -> pulumi.Output[str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "vmware_cluster")

