# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFhirStoreIamPolicyResult',
    'AwaitableGetFhirStoreIamPolicyResult',
    'get_fhir_store_iam_policy',
    'get_fhir_store_iam_policy_output',
]

@pulumi.output_type
class GetFhirStoreIamPolicyResult:
    """
    A collection of values returned by getFhirStoreIamPolicy.
    """
    def __init__(__self__, etag=None, fhir_store_id=None, id=None, policy_data=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if fhir_store_id and not isinstance(fhir_store_id, str):
            raise TypeError("Expected argument 'fhir_store_id' to be a str")
        pulumi.set(__self__, "fhir_store_id", fhir_store_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fhirStoreId")
    def fhir_store_id(self) -> str:
        return pulumi.get(self, "fhir_store_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetFhirStoreIamPolicyResult(GetFhirStoreIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFhirStoreIamPolicyResult(
            etag=self.etag,
            fhir_store_id=self.fhir_store_id,
            id=self.id,
            policy_data=self.policy_data)


def get_fhir_store_iam_policy(fhir_store_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFhirStoreIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Google Cloud Healthcare FHIR store.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.healthcare.get_fhir_store_iam_policy(fhir_store_id=fhir_store["id"])
    ```


    :param str fhir_store_id: The FHIR store ID, in the form
           `{project_id}/{location_name}/{dataset_name}/{fhir_store_name}` or
           `{location_name}/{dataset_name}/{fhir_store_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    __args__ = dict()
    __args__['fhirStoreId'] = fhir_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:healthcare/getFhirStoreIamPolicy:getFhirStoreIamPolicy', __args__, opts=opts, typ=GetFhirStoreIamPolicyResult).value

    return AwaitableGetFhirStoreIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        fhir_store_id=pulumi.get(__ret__, 'fhir_store_id'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))


@_utilities.lift_output_func(get_fhir_store_iam_policy)
def get_fhir_store_iam_policy_output(fhir_store_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFhirStoreIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Google Cloud Healthcare FHIR store.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.healthcare.get_fhir_store_iam_policy(fhir_store_id=fhir_store["id"])
    ```


    :param str fhir_store_id: The FHIR store ID, in the form
           `{project_id}/{location_name}/{dataset_name}/{fhir_store_name}` or
           `{location_name}/{dataset_name}/{fhir_store_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    ...
