# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConsentStoreIamBindingCondition',
    'ConsentStoreIamMemberCondition',
    'DatasetEncryptionSpec',
    'DatasetIamBindingCondition',
    'DatasetIamMemberCondition',
    'DicomStoreIamBindingCondition',
    'DicomStoreIamMemberCondition',
    'DicomStoreNotificationConfig',
    'DicomStoreStreamConfig',
    'DicomStoreStreamConfigBigqueryDestination',
    'FhirStoreIamBindingCondition',
    'FhirStoreIamMemberCondition',
    'FhirStoreNotificationConfig',
    'FhirStoreStreamConfig',
    'FhirStoreStreamConfigBigqueryDestination',
    'FhirStoreStreamConfigBigqueryDestinationSchemaConfig',
    'FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig',
    'Hl7StoreIamBindingCondition',
    'Hl7StoreIamMemberCondition',
    'Hl7StoreNotificationConfig',
    'Hl7StoreNotificationConfigs',
    'Hl7StoreParserConfig',
    'WorkspaceSettings',
]

@pulumi.output_type
class ConsentStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ConsentStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatasetEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: KMS encryption key that is used to secure this dataset and its sub-resources. The key used for
               encryption and the dataset must be in the same location. If empty, the default Google encryption
               key will be used to secure this dataset. The format is
               projects/{projectId}/locations/{locationId}/keyRings/{keyRingId}/cryptoKeys/{keyId}.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        KMS encryption key that is used to secure this dataset and its sub-resources. The key used for
        encryption and the dataset must be in the same location. If empty, the default Google encryption
        key will be used to secure this dataset. The format is
        projects/{projectId}/locations/{locationId}/keyRings/{keyRingId}/cryptoKeys/{keyId}.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class DatasetIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatasetIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DicomStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DicomStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DicomStoreNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "sendForBulkImport":
            suggest = "send_for_bulk_import"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomStoreNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomStoreNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomStoreNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str,
                 send_for_bulk_import: Optional[bool] = None):
        """
        :param str pubsub_topic: The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
               PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
               It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
               was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
               project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
               Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        :param bool send_for_bulk_import: Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if send_for_bulk_import is not None:
            pulumi.set(__self__, "send_for_bulk_import", send_for_bulk_import)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="sendForBulkImport")
    def send_for_bulk_import(self) -> Optional[bool]:
        """
        Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        return pulumi.get(self, "send_for_bulk_import")


@pulumi.output_type
class DicomStoreStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomStoreStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomStoreStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomStoreStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.DicomStoreStreamConfigBigqueryDestination'):
        """
        :param 'DicomStoreStreamConfigBigqueryDestinationArgs' bigquery_destination: BigQueryDestination to include a fully qualified BigQuery table URI where DICOM instance metadata will be streamed.
               Structure is documented below.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.DicomStoreStreamConfigBigqueryDestination':
        """
        BigQueryDestination to include a fully qualified BigQuery table URI where DICOM instance metadata will be streamed.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_destination")


@pulumi.output_type
class DicomStoreStreamConfigBigqueryDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableUri":
            suggest = "table_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomStoreStreamConfigBigqueryDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomStoreStreamConfigBigqueryDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomStoreStreamConfigBigqueryDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_uri: str):
        """
        :param str table_uri: a fully qualified BigQuery table URI where DICOM instance metadata will be streamed.
        """
        pulumi.set(__self__, "table_uri", table_uri)

    @property
    @pulumi.getter(name="tableUri")
    def table_uri(self) -> str:
        """
        a fully qualified BigQuery table URI where DICOM instance metadata will be streamed.
        """
        return pulumi.get(self, "table_uri")


@pulumi.output_type
class FhirStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FhirStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FhirStoreNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "sendFullResource":
            suggest = "send_full_resource"
        elif key == "sendPreviousResourceOnDelete":
            suggest = "send_previous_resource_on_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirStoreNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirStoreNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirStoreNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str,
                 send_full_resource: Optional[bool] = None,
                 send_previous_resource_on_delete: Optional[bool] = None):
        """
        :param str pubsub_topic: The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
               PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
               It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
               was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
               project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
               Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        :param bool send_full_resource: Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation.
               Note that setting this to true does not guarantee that all resources will be sent in the format of
               full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be
               sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether
               it needs to fetch the full resource as a separate operation.
        :param bool send_previous_resource_on_delete: Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that setting this to
               true does not guarantee that all previous resources will be sent in the format of full FHIR resource. When a
               resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always
               check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full previous
               resource as a separate operation.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if send_full_resource is not None:
            pulumi.set(__self__, "send_full_resource", send_full_resource)
        if send_previous_resource_on_delete is not None:
            pulumi.set(__self__, "send_previous_resource_on_delete", send_previous_resource_on_delete)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="sendFullResource")
    def send_full_resource(self) -> Optional[bool]:
        """
        Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation.
        Note that setting this to true does not guarantee that all resources will be sent in the format of
        full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be
        sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether
        it needs to fetch the full resource as a separate operation.
        """
        return pulumi.get(self, "send_full_resource")

    @property
    @pulumi.getter(name="sendPreviousResourceOnDelete")
    def send_previous_resource_on_delete(self) -> Optional[bool]:
        """
        Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that setting this to
        true does not guarantee that all previous resources will be sent in the format of full FHIR resource. When a
        resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always
        check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full previous
        resource as a separate operation.
        """
        return pulumi.get(self, "send_previous_resource_on_delete")


@pulumi.output_type
class FhirStoreStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirStoreStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirStoreStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirStoreStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.FhirStoreStreamConfigBigqueryDestination',
                 resource_types: Optional[Sequence[str]] = None):
        """
        :param 'FhirStoreStreamConfigBigqueryDestinationArgs' bigquery_destination: The destination BigQuery structure that contains both the dataset location and corresponding schema config.
               The output is organized in one table per resource type. The server reuses the existing tables (if any) that
               are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given
               resource type, the server attempts to create one.
               See the [streaming config reference](https://cloud.google.com/healthcare/docs/reference/rest/v1beta1/projects.locations.datasets.fhirStores#streamconfig) for more details.
               Structure is documented below.
        :param Sequence[str] resource_types: Supply a FHIR resource type (such as "Patient" or "Observation"). See
               https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats
               an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.FhirStoreStreamConfigBigqueryDestination':
        """
        The destination BigQuery structure that contains both the dataset location and corresponding schema config.
        The output is organized in one table per resource type. The server reuses the existing tables (if any) that
        are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given
        resource type, the server attempts to create one.
        See the [streaming config reference](https://cloud.google.com/healthcare/docs/reference/rest/v1beta1/projects.locations.datasets.fhirStores#streamconfig) for more details.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[str]]:
        """
        Supply a FHIR resource type (such as "Patient" or "Observation"). See
        https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats
        an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class FhirStoreStreamConfigBigqueryDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetUri":
            suggest = "dataset_uri"
        elif key == "schemaConfig":
            suggest = "schema_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirStoreStreamConfigBigqueryDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirStoreStreamConfigBigqueryDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirStoreStreamConfigBigqueryDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_uri: str,
                 schema_config: 'outputs.FhirStoreStreamConfigBigqueryDestinationSchemaConfig'):
        """
        :param str dataset_uri: BigQuery URI to a dataset, up to 2000 characters long, in the format bq://projectId.bqDatasetId
        :param 'FhirStoreStreamConfigBigqueryDestinationSchemaConfigArgs' schema_config: The configuration for the exported BigQuery schema.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_uri", dataset_uri)
        pulumi.set(__self__, "schema_config", schema_config)

    @property
    @pulumi.getter(name="datasetUri")
    def dataset_uri(self) -> str:
        """
        BigQuery URI to a dataset, up to 2000 characters long, in the format bq://projectId.bqDatasetId
        """
        return pulumi.get(self, "dataset_uri")

    @property
    @pulumi.getter(name="schemaConfig")
    def schema_config(self) -> 'outputs.FhirStoreStreamConfigBigqueryDestinationSchemaConfig':
        """
        The configuration for the exported BigQuery schema.
        Structure is documented below.
        """
        return pulumi.get(self, "schema_config")


@pulumi.output_type
class FhirStoreStreamConfigBigqueryDestinationSchemaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recursiveStructureDepth":
            suggest = "recursive_structure_depth"
        elif key == "lastUpdatedPartitionConfig":
            suggest = "last_updated_partition_config"
        elif key == "schemaType":
            suggest = "schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirStoreStreamConfigBigqueryDestinationSchemaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirStoreStreamConfigBigqueryDestinationSchemaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirStoreStreamConfigBigqueryDestinationSchemaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recursive_structure_depth: int,
                 last_updated_partition_config: Optional['outputs.FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig'] = None,
                 schema_type: Optional[str] = None):
        """
        :param int recursive_structure_depth: The depth for all recursive structures in the output analytics schema. For example, concept in the CodeSystem
               resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called
               concept.concept but not concept.concept.concept. If not specified or set to 0, the server will use the default
               value 2. The maximum depth allowed is 5.
        :param 'FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigArgs' last_updated_partition_config: The configuration for exported BigQuery tables to be partitioned by FHIR resource's last updated time column.
               Structure is documented below.
        :param str schema_type: Specifies the output schema type.
               * ANALYTICS: Analytics schema defined by the FHIR community.
               See https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md.
               * ANALYTICS_V2: Analytics V2, similar to schema defined by the FHIR community, with added support for extensions with one or more occurrences and contained resources in stringified JSON.
               * LOSSLESS: A data-driven schema generated from the fields present in the FHIR data being exported, with no additional simplification.
               Default value is `ANALYTICS`.
               Possible values are: `ANALYTICS`, `ANALYTICS_V2`, `LOSSLESS`.
        """
        pulumi.set(__self__, "recursive_structure_depth", recursive_structure_depth)
        if last_updated_partition_config is not None:
            pulumi.set(__self__, "last_updated_partition_config", last_updated_partition_config)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="recursiveStructureDepth")
    def recursive_structure_depth(self) -> int:
        """
        The depth for all recursive structures in the output analytics schema. For example, concept in the CodeSystem
        resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called
        concept.concept but not concept.concept.concept. If not specified or set to 0, the server will use the default
        value 2. The maximum depth allowed is 5.
        """
        return pulumi.get(self, "recursive_structure_depth")

    @property
    @pulumi.getter(name="lastUpdatedPartitionConfig")
    def last_updated_partition_config(self) -> Optional['outputs.FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig']:
        """
        The configuration for exported BigQuery tables to be partitioned by FHIR resource's last updated time column.
        Structure is documented below.
        """
        return pulumi.get(self, "last_updated_partition_config")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[str]:
        """
        Specifies the output schema type.
        * ANALYTICS: Analytics schema defined by the FHIR community.
        See https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md.
        * ANALYTICS_V2: Analytics V2, similar to schema defined by the FHIR community, with added support for extensions with one or more occurrences and contained resources in stringified JSON.
        * LOSSLESS: A data-driven schema generated from the fields present in the FHIR data being exported, with no additional simplification.
        Default value is `ANALYTICS`.
        Possible values are: `ANALYTICS`, `ANALYTICS_V2`, `LOSSLESS`.
        """
        return pulumi.get(self, "schema_type")


@pulumi.output_type
class FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationMs":
            suggest = "expiration_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirStoreStreamConfigBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 expiration_ms: Optional[str] = None):
        """
        :param str type: Type of partitioning.
               Possible values are: `PARTITION_TYPE_UNSPECIFIED`, `HOUR`, `DAY`, `MONTH`, `YEAR`.
        :param str expiration_ms: Number of milliseconds for which to keep the storage for a partition.
        """
        pulumi.set(__self__, "type", type)
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of partitioning.
        Possible values are: `PARTITION_TYPE_UNSPECIFIED`, `HOUR`, `DAY`, `MONTH`, `YEAR`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[str]:
        """
        Number of milliseconds for which to keep the storage for a partition.
        """
        return pulumi.get(self, "expiration_ms")


@pulumi.output_type
class Hl7StoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class Hl7StoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class Hl7StoreNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7StoreNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7StoreNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7StoreNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str):
        """
        :param str pubsub_topic: The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
               PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
               It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
               was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
               project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
               Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class Hl7StoreNotificationConfigs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7StoreNotificationConfigs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7StoreNotificationConfigs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7StoreNotificationConfigs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str,
                 filter: Optional[str] = None):
        """
        :param str pubsub_topic: The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
               PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
               It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
               was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
               project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
               Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
               If a notification cannot be published to Cloud Pub/Sub, errors will be logged to Stackdriver
        :param str filter: Restricts notifications sent for messages matching a filter. If this is empty, all messages
               are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
               Fields/functions available for filtering are:
               * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
               * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
               * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
               * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
               * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
               * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
        If a notification cannot be published to Cloud Pub/Sub, errors will be logged to Stackdriver
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        Restricts notifications sent for messages matching a filter. If this is empty, all messages
        are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
        Fields/functions available for filtering are:
        * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
        * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
        * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
        * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
        * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
        * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class Hl7StoreParserConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNullHeader":
            suggest = "allow_null_header"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7StoreParserConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7StoreParserConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7StoreParserConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_null_header: Optional[bool] = None,
                 schema: Optional[str] = None,
                 segment_terminator: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param bool allow_null_header: Determines whether messages with no header are allowed.
        :param str schema: JSON encoded string for schemas used to parse messages in this
               store if schematized parsing is desired.
        :param str segment_terminator: Byte(s) to be used as the segment terminator. If this is unset, '\\r' will be used as segment terminator.
               A base64-encoded string.
        :param str version: The version of the unschematized parser to be used when a custom `schema` is not set.
               Default value is `V1`.
               Possible values are: `V1`, `V2`, `V3`.
        """
        if allow_null_header is not None:
            pulumi.set(__self__, "allow_null_header", allow_null_header)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="allowNullHeader")
    def allow_null_header(self) -> Optional[bool]:
        """
        Determines whether messages with no header are allowed.
        """
        return pulumi.get(self, "allow_null_header")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        JSON encoded string for schemas used to parse messages in this
        store if schematized parsing is desired.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[str]:
        """
        Byte(s) to be used as the segment terminator. If this is unset, '\\r' will be used as segment terminator.
        A base64-encoded string.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the unschematized parser to be used when a custom `schema` is not set.
        Default value is `V1`.
        Possible values are: `V1`, `V2`, `V3`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WorkspaceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataProjectIds":
            suggest = "data_project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_project_ids: Sequence[str]):
        """
        :param Sequence[str] data_project_ids: Project IDs for data projects hosted in a workspace.
               
               - - -
        """
        pulumi.set(__self__, "data_project_ids", data_project_ids)

    @property
    @pulumi.getter(name="dataProjectIds")
    def data_project_ids(self) -> Sequence[str]:
        """
        Project IDs for data projects hosted in a workspace.

        - - -
        """
        return pulumi.get(self, "data_project_ids")


