# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessBoundaryPolicyRule',
    'AccessBoundaryPolicyRuleAccessBoundaryRule',
    'AccessBoundaryPolicyRuleAccessBoundaryRuleAvailabilityCondition',
    'DenyPolicyRule',
    'DenyPolicyRuleDenyRule',
    'DenyPolicyRuleDenyRuleDenialCondition',
    'WorkforcePoolAccessRestrictions',
    'WorkforcePoolAccessRestrictionsAllowedService',
    'WorkforcePoolProviderExtraAttributesOauth2Client',
    'WorkforcePoolProviderExtraAttributesOauth2ClientClientSecret',
    'WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue',
    'WorkforcePoolProviderExtraAttributesOauth2ClientQueryParameters',
    'WorkforcePoolProviderOidc',
    'WorkforcePoolProviderOidcClientSecret',
    'WorkforcePoolProviderOidcClientSecretValue',
    'WorkforcePoolProviderOidcWebSsoConfig',
    'WorkforcePoolProviderSaml',
    'WorkloadIdentityPoolProviderAws',
    'WorkloadIdentityPoolProviderOidc',
    'WorkloadIdentityPoolProviderSaml',
    'WorkloadIdentityPoolProviderX509',
    'WorkloadIdentityPoolProviderX509TrustStore',
    'WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa',
    'WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor',
    'GetTestablePermissionsPermissionResult',
    'GetWorkloadIdentityPoolProviderAwResult',
    'GetWorkloadIdentityPoolProviderOidcResult',
    'GetWorkloadIdentityPoolProviderSamlResult',
    'GetWorkloadIdentityPoolProviderX509Result',
    'GetWorkloadIdentityPoolProviderX509TrustStoreResult',
    'GetWorkloadIdentityPoolProviderX509TrustStoreIntermediateCaResult',
    'GetWorkloadIdentityPoolProviderX509TrustStoreTrustAnchorResult',
]

@pulumi.output_type
class AccessBoundaryPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessBoundaryRule":
            suggest = "access_boundary_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessBoundaryPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessBoundaryPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessBoundaryPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_boundary_rule: Optional['outputs.AccessBoundaryPolicyRuleAccessBoundaryRule'] = None,
                 description: Optional[str] = None):
        """
        :param 'AccessBoundaryPolicyRuleAccessBoundaryRuleArgs' access_boundary_rule: An access boundary rule in an IAM policy.
               Structure is documented below.
        :param str description: The description of the rule.
        """
        if access_boundary_rule is not None:
            pulumi.set(__self__, "access_boundary_rule", access_boundary_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="accessBoundaryRule")
    def access_boundary_rule(self) -> Optional['outputs.AccessBoundaryPolicyRuleAccessBoundaryRule']:
        """
        An access boundary rule in an IAM policy.
        Structure is documented below.
        """
        return pulumi.get(self, "access_boundary_rule")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AccessBoundaryPolicyRuleAccessBoundaryRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityCondition":
            suggest = "availability_condition"
        elif key == "availablePermissions":
            suggest = "available_permissions"
        elif key == "availableResource":
            suggest = "available_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessBoundaryPolicyRuleAccessBoundaryRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessBoundaryPolicyRuleAccessBoundaryRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessBoundaryPolicyRuleAccessBoundaryRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_condition: Optional['outputs.AccessBoundaryPolicyRuleAccessBoundaryRuleAvailabilityCondition'] = None,
                 available_permissions: Optional[Sequence[str]] = None,
                 available_resource: Optional[str] = None):
        """
        :param 'AccessBoundaryPolicyRuleAccessBoundaryRuleAvailabilityConditionArgs' availability_condition: The availability condition further constrains the access allowed by the access boundary rule.
               Structure is documented below.
        :param Sequence[str] available_permissions: A list of permissions that may be allowed for use on the specified resource.
        :param str available_resource: The full resource name of a Google Cloud resource entity.
        """
        if availability_condition is not None:
            pulumi.set(__self__, "availability_condition", availability_condition)
        if available_permissions is not None:
            pulumi.set(__self__, "available_permissions", available_permissions)
        if available_resource is not None:
            pulumi.set(__self__, "available_resource", available_resource)

    @property
    @pulumi.getter(name="availabilityCondition")
    def availability_condition(self) -> Optional['outputs.AccessBoundaryPolicyRuleAccessBoundaryRuleAvailabilityCondition']:
        """
        The availability condition further constrains the access allowed by the access boundary rule.
        Structure is documented below.
        """
        return pulumi.get(self, "availability_condition")

    @property
    @pulumi.getter(name="availablePermissions")
    def available_permissions(self) -> Optional[Sequence[str]]:
        """
        A list of permissions that may be allowed for use on the specified resource.
        """
        return pulumi.get(self, "available_permissions")

    @property
    @pulumi.getter(name="availableResource")
    def available_resource(self) -> Optional[str]:
        """
        The full resource name of a Google Cloud resource entity.
        """
        return pulumi.get(self, "available_resource")


@pulumi.output_type
class AccessBoundaryPolicyRuleAccessBoundaryRuleAvailabilityCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression. This is a longer text which describes the expression,
               e.g. when hovered over it in a UI.
        :param str location: String indicating the location of the expression for error reporting,
               e.g. a file name and a position in the file.
               
               - - -
        :param str title: Title for the expression, i.e. a short string describing its purpose.
               This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression. This is a longer text which describes the expression,
        e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting,
        e.g. a file name and a position in the file.

        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class DenyPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denyRule":
            suggest = "deny_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DenyPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DenyPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DenyPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deny_rule: Optional['outputs.DenyPolicyRuleDenyRule'] = None,
                 description: Optional[str] = None):
        """
        :param 'DenyPolicyRuleDenyRuleArgs' deny_rule: A deny rule in an IAM deny policy.
               Structure is documented below.
        :param str description: The description of the rule.
        """
        if deny_rule is not None:
            pulumi.set(__self__, "deny_rule", deny_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="denyRule")
    def deny_rule(self) -> Optional['outputs.DenyPolicyRuleDenyRule']:
        """
        A deny rule in an IAM deny policy.
        Structure is documented below.
        """
        return pulumi.get(self, "deny_rule")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DenyPolicyRuleDenyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denialCondition":
            suggest = "denial_condition"
        elif key == "deniedPermissions":
            suggest = "denied_permissions"
        elif key == "deniedPrincipals":
            suggest = "denied_principals"
        elif key == "exceptionPermissions":
            suggest = "exception_permissions"
        elif key == "exceptionPrincipals":
            suggest = "exception_principals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DenyPolicyRuleDenyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DenyPolicyRuleDenyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DenyPolicyRuleDenyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 denial_condition: Optional['outputs.DenyPolicyRuleDenyRuleDenialCondition'] = None,
                 denied_permissions: Optional[Sequence[str]] = None,
                 denied_principals: Optional[Sequence[str]] = None,
                 exception_permissions: Optional[Sequence[str]] = None,
                 exception_principals: Optional[Sequence[str]] = None):
        """
        :param 'DenyPolicyRuleDenyRuleDenialConditionArgs' denial_condition: User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
               Structure is documented below.
        :param Sequence[str] denied_permissions: The permissions that are explicitly denied by this rule. Each permission uses the format `{service-fqdn}/{resource}.{verb}`,
               where `{service-fqdn}` is the fully qualified domain name for the service. For example, `iam.googleapis.com/roles.list`.
        :param Sequence[str] denied_principals: The identities that are prevented from using one or more permissions on Google Cloud resources.
        :param Sequence[str] exception_permissions: Specifies the permissions that this rule excludes from the set of denied permissions given by deniedPermissions.
               If a permission appears in deniedPermissions and in exceptionPermissions then it will not be denied.
               The excluded permissions can be specified using the same syntax as deniedPermissions.
        :param Sequence[str] exception_principals: The identities that are excluded from the deny rule, even if they are listed in the deniedPrincipals.
               For example, you could add a Google group to the deniedPrincipals, then exclude specific users who belong to that group.
        """
        if denial_condition is not None:
            pulumi.set(__self__, "denial_condition", denial_condition)
        if denied_permissions is not None:
            pulumi.set(__self__, "denied_permissions", denied_permissions)
        if denied_principals is not None:
            pulumi.set(__self__, "denied_principals", denied_principals)
        if exception_permissions is not None:
            pulumi.set(__self__, "exception_permissions", exception_permissions)
        if exception_principals is not None:
            pulumi.set(__self__, "exception_principals", exception_principals)

    @property
    @pulumi.getter(name="denialCondition")
    def denial_condition(self) -> Optional['outputs.DenyPolicyRuleDenyRuleDenialCondition']:
        """
        User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
        Structure is documented below.
        """
        return pulumi.get(self, "denial_condition")

    @property
    @pulumi.getter(name="deniedPermissions")
    def denied_permissions(self) -> Optional[Sequence[str]]:
        """
        The permissions that are explicitly denied by this rule. Each permission uses the format `{service-fqdn}/{resource}.{verb}`,
        where `{service-fqdn}` is the fully qualified domain name for the service. For example, `iam.googleapis.com/roles.list`.
        """
        return pulumi.get(self, "denied_permissions")

    @property
    @pulumi.getter(name="deniedPrincipals")
    def denied_principals(self) -> Optional[Sequence[str]]:
        """
        The identities that are prevented from using one or more permissions on Google Cloud resources.
        """
        return pulumi.get(self, "denied_principals")

    @property
    @pulumi.getter(name="exceptionPermissions")
    def exception_permissions(self) -> Optional[Sequence[str]]:
        """
        Specifies the permissions that this rule excludes from the set of denied permissions given by deniedPermissions.
        If a permission appears in deniedPermissions and in exceptionPermissions then it will not be denied.
        The excluded permissions can be specified using the same syntax as deniedPermissions.
        """
        return pulumi.get(self, "exception_permissions")

    @property
    @pulumi.getter(name="exceptionPrincipals")
    def exception_principals(self) -> Optional[Sequence[str]]:
        """
        The identities that are excluded from the deny rule, even if they are listed in the deniedPrincipals.
        For example, you could add a Google group to the deniedPrincipals, then exclude specific users who belong to that group.
        """
        return pulumi.get(self, "exception_principals")


@pulumi.output_type
class DenyPolicyRuleDenyRuleDenialCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression. This is a longer text which describes the expression,
               e.g. when hovered over it in a UI.
        :param str location: String indicating the location of the expression for error reporting,
               e.g. a file name and a position in the file.
               
               - - -
        :param str title: Title for the expression, i.e. a short string describing its purpose.
               This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression. This is a longer text which describes the expression,
        e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting,
        e.g. a file name and a position in the file.

        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class WorkforcePoolAccessRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "disableProgrammaticSignin":
            suggest = "disable_programmatic_signin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolAccessRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolAccessRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolAccessRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Optional[Sequence['outputs.WorkforcePoolAccessRestrictionsAllowedService']] = None,
                 disable_programmatic_signin: Optional[bool] = None):
        """
        :param Sequence['WorkforcePoolAccessRestrictionsAllowedServiceArgs'] allowed_services: Services allowed for web sign-in with the workforce pool.
               If not set by default there are no restrictions.
               Structure is documented below.
        :param bool disable_programmatic_signin: Disable programmatic sign-in by disabling token issue via the Security Token API endpoint.
               See [Security Token Service API](https://cloud.google.com/iam/docs/reference/sts/rest).
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if disable_programmatic_signin is not None:
            pulumi.set(__self__, "disable_programmatic_signin", disable_programmatic_signin)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence['outputs.WorkforcePoolAccessRestrictionsAllowedService']]:
        """
        Services allowed for web sign-in with the workforce pool.
        If not set by default there are no restrictions.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="disableProgrammaticSignin")
    def disable_programmatic_signin(self) -> Optional[bool]:
        """
        Disable programmatic sign-in by disabling token issue via the Security Token API endpoint.
        See [Security Token Service API](https://cloud.google.com/iam/docs/reference/sts/rest).
        """
        return pulumi.get(self, "disable_programmatic_signin")


@pulumi.output_type
class WorkforcePoolAccessRestrictionsAllowedService(dict):
    def __init__(__self__, *,
                 domain: Optional[str] = None):
        """
        :param str domain: Domain name of the service.
               Example: console.cloud.google
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain name of the service.
        Example: console.cloud.google
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class WorkforcePoolProviderExtraAttributesOauth2Client(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributesType":
            suggest = "attributes_type"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "issuerUri":
            suggest = "issuer_uri"
        elif key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderExtraAttributesOauth2Client. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderExtraAttributesOauth2Client.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderExtraAttributesOauth2Client.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes_type: str,
                 client_id: str,
                 client_secret: 'outputs.WorkforcePoolProviderExtraAttributesOauth2ClientClientSecret',
                 issuer_uri: str,
                 query_parameters: Optional['outputs.WorkforcePoolProviderExtraAttributesOauth2ClientQueryParameters'] = None):
        """
        :param str attributes_type: Represents the IdP and type of claims that should be fetched.
               * AZURE_AD_GROUPS_MAIL: Used to get the user's group claims from the Azure AD identity provider using configuration provided
               in ExtraAttributesOAuth2Client and 'mail' property of the 'microsoft.graph.group' object is used for claim mapping.
               See https://learn.microsoft.com/en-us/graph/api/resources/group?view=graph-rest-1.0#properties for more details on
               'microsoft.graph.group' properties. The attributes obtained from idntity provider are mapped to 'assertion.groups'. Possible values: ["AZURE_AD_GROUPS_MAIL"]
        :param str client_id: The OAuth 2.0 client ID for retrieving extra attributes from the identity provider. Required to get the Access Token using client credentials grant flow.
        :param 'WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretArgs' client_secret: The OAuth 2.0 client secret for retrieving extra attributes from the identity provider. Required to get the Access Token using client credentials grant flow.
        :param str issuer_uri: The OIDC identity provider's issuer URI. Must be a valid URI using the 'https' scheme. Required to get the OIDC discovery document.
        :param 'WorkforcePoolProviderExtraAttributesOauth2ClientQueryParametersArgs' query_parameters: Represents the parameters to control which claims are fetched from an IdP.
        """
        pulumi.set(__self__, "attributes_type", attributes_type)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer_uri", issuer_uri)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="attributesType")
    def attributes_type(self) -> str:
        """
        Represents the IdP and type of claims that should be fetched.
        * AZURE_AD_GROUPS_MAIL: Used to get the user's group claims from the Azure AD identity provider using configuration provided
        in ExtraAttributesOAuth2Client and 'mail' property of the 'microsoft.graph.group' object is used for claim mapping.
        See https://learn.microsoft.com/en-us/graph/api/resources/group?view=graph-rest-1.0#properties for more details on
        'microsoft.graph.group' properties. The attributes obtained from idntity provider are mapped to 'assertion.groups'. Possible values: ["AZURE_AD_GROUPS_MAIL"]
        """
        return pulumi.get(self, "attributes_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The OAuth 2.0 client ID for retrieving extra attributes from the identity provider. Required to get the Access Token using client credentials grant flow.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> 'outputs.WorkforcePoolProviderExtraAttributesOauth2ClientClientSecret':
        """
        The OAuth 2.0 client secret for retrieving extra attributes from the identity provider. Required to get the Access Token using client credentials grant flow.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> str:
        """
        The OIDC identity provider's issuer URI. Must be a valid URI using the 'https' scheme. Required to get the OIDC discovery document.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional['outputs.WorkforcePoolProviderExtraAttributesOauth2ClientQueryParameters']:
        """
        Represents the parameters to control which claims are fetched from an IdP.
        """
        return pulumi.get(self, "query_parameters")


@pulumi.output_type
class WorkforcePoolProviderExtraAttributesOauth2ClientClientSecret(dict):
    def __init__(__self__, *,
                 value: Optional['outputs.WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue'] = None):
        """
        :param 'WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValueArgs' value: The value of the client secret.
               Structure is documented below.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue']:
        """
        The value of the client secret.
        Structure is documented below.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "plainText":
            suggest = "plain_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderExtraAttributesOauth2ClientClientSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plain_text: str,
                 thumbprint: Optional[str] = None):
        """
        :param str plain_text: The plain text of the client secret value.
        :param str thumbprint: (Output)
               A thumbprint to represent the current client secret value.
        """
        pulumi.set(__self__, "plain_text", plain_text)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="plainText")
    def plain_text(self) -> str:
        """
        The plain text of the client secret value.
        """
        return pulumi.get(self, "plain_text")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        (Output)
        A thumbprint to represent the current client secret value.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class WorkforcePoolProviderExtraAttributesOauth2ClientQueryParameters(dict):
    def __init__(__self__, *,
                 filter: Optional[str] = None):
        """
        :param str filter: The filter used to request specific records from IdP. In case of attributes type as AZURE_AD_GROUPS_MAIL, it represents the
               filter used to request specific groups for users from IdP. By default, all of the groups associated with the user are fetched. The
               groups should be mail enabled and security enabled. See https://learn.microsoft.com/en-us/graph/search-query-parameter for more details.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        The filter used to request specific records from IdP. In case of attributes type as AZURE_AD_GROUPS_MAIL, it represents the
        filter used to request specific groups for users from IdP. By default, all of the groups associated with the user are fetched. The
        groups should be mail enabled and security enabled. See https://learn.microsoft.com/en-us/graph/search-query-parameter for more details.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class WorkforcePoolProviderOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUri":
            suggest = "issuer_uri"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksJson":
            suggest = "jwks_json"
        elif key == "webSsoConfig":
            suggest = "web_sso_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 issuer_uri: str,
                 client_secret: Optional['outputs.WorkforcePoolProviderOidcClientSecret'] = None,
                 jwks_json: Optional[str] = None,
                 web_sso_config: Optional['outputs.WorkforcePoolProviderOidcWebSsoConfig'] = None):
        """
        :param str client_id: The client ID. Must match the audience claim of the JWT issued by the identity provider.
        :param str issuer_uri: The OIDC issuer URI. Must be a valid URI using the 'https' scheme.
        :param 'WorkforcePoolProviderOidcClientSecretArgs' client_secret: The optional client secret. Required to enable Authorization Code flow for web sign-in.
               Structure is documented below.
        :param str jwks_json: OIDC JWKs in JSON String format. For details on definition of a
               JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
               use the `jwks_uri` from the discovery document fetched from the
               .well-known path for the `issuer_uri`. Currently, RSA and EC asymmetric
               keys are supported. The JWK must use following format and include only
               the following fields:
               ```
               {
               "keys": [
               {
               "kty": "RSA/EC",
               "alg": "<algorithm>",
               "use": "sig",
               "kid": "<key-id>",
               "n": "",
               "e": "",
               "x": "",
               "y": "",
               "crv": ""
               }
               ]
               }
               ```
        :param 'WorkforcePoolProviderOidcWebSsoConfigArgs' web_sso_config: Configuration for web single sign-on for the OIDC provider. Here, web sign-in refers to console sign-in and gcloud sign-in through the browser.
               Structure is documented below.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_uri", issuer_uri)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if jwks_json is not None:
            pulumi.set(__self__, "jwks_json", jwks_json)
        if web_sso_config is not None:
            pulumi.set(__self__, "web_sso_config", web_sso_config)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID. Must match the audience claim of the JWT issued by the identity provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> str:
        """
        The OIDC issuer URI. Must be a valid URI using the 'https' scheme.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional['outputs.WorkforcePoolProviderOidcClientSecret']:
        """
        The optional client secret. Required to enable Authorization Code flow for web sign-in.
        Structure is documented below.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="jwksJson")
    def jwks_json(self) -> Optional[str]:
        """
        OIDC JWKs in JSON String format. For details on definition of a
        JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
        use the `jwks_uri` from the discovery document fetched from the
        .well-known path for the `issuer_uri`. Currently, RSA and EC asymmetric
        keys are supported. The JWK must use following format and include only
        the following fields:
        ```
        {
        "keys": [
        {
        "kty": "RSA/EC",
        "alg": "<algorithm>",
        "use": "sig",
        "kid": "<key-id>",
        "n": "",
        "e": "",
        "x": "",
        "y": "",
        "crv": ""
        }
        ]
        }
        ```
        """
        return pulumi.get(self, "jwks_json")

    @property
    @pulumi.getter(name="webSsoConfig")
    def web_sso_config(self) -> Optional['outputs.WorkforcePoolProviderOidcWebSsoConfig']:
        """
        Configuration for web single sign-on for the OIDC provider. Here, web sign-in refers to console sign-in and gcloud sign-in through the browser.
        Structure is documented below.
        """
        return pulumi.get(self, "web_sso_config")


@pulumi.output_type
class WorkforcePoolProviderOidcClientSecret(dict):
    def __init__(__self__, *,
                 value: Optional['outputs.WorkforcePoolProviderOidcClientSecretValue'] = None):
        """
        :param 'WorkforcePoolProviderOidcClientSecretValueArgs' value: The value of the client secret.
               Structure is documented below.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.WorkforcePoolProviderOidcClientSecretValue']:
        """
        The value of the client secret.
        Structure is documented below.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkforcePoolProviderOidcClientSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "plainText":
            suggest = "plain_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderOidcClientSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderOidcClientSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderOidcClientSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plain_text: str,
                 thumbprint: Optional[str] = None):
        """
        :param str plain_text: The plain text of the client secret value.
        :param str thumbprint: (Output)
               A thumbprint to represent the current client secret value.
        """
        pulumi.set(__self__, "plain_text", plain_text)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="plainText")
    def plain_text(self) -> str:
        """
        The plain text of the client secret value.
        """
        return pulumi.get(self, "plain_text")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        (Output)
        A thumbprint to represent the current client secret value.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class WorkforcePoolProviderOidcWebSsoConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assertionClaimsBehavior":
            suggest = "assertion_claims_behavior"
        elif key == "responseType":
            suggest = "response_type"
        elif key == "additionalScopes":
            suggest = "additional_scopes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderOidcWebSsoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderOidcWebSsoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderOidcWebSsoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assertion_claims_behavior: str,
                 response_type: str,
                 additional_scopes: Optional[Sequence[str]] = None):
        """
        :param str assertion_claims_behavior: The behavior for how OIDC Claims are included in the `assertion` object used for attribute mapping and attribute condition.
               * MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS: Merge the UserInfo Endpoint Claims with ID Token Claims, preferring UserInfo Claim Values for the same Claim Name. This option is available only for the Authorization Code Flow.
               * ONLY_ID_TOKEN_CLAIMS: Only include ID Token Claims.
               Possible values are: `MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS`, `ONLY_ID_TOKEN_CLAIMS`.
        :param str response_type: The Response Type to request for in the OIDC Authorization Request for web sign-in.
               The `CODE` Response Type is recommended to avoid the Implicit Flow, for security reasons.
               * CODE: The `response_type=code` selection uses the Authorization Code Flow for web sign-in. Requires a configured client secret.
               * ID_TOKEN: The `response_type=id_token` selection uses the Implicit Flow for web sign-in.
               Possible values are: `CODE`, `ID_TOKEN`.
        :param Sequence[str] additional_scopes: Additional scopes to request for in the OIDC authentication request on top of scopes requested by default. By default, the `openid`, `profile` and `email` scopes that are supported by the identity provider are requested.
               Each additional scope may be at most 256 characters. A maximum of 10 additional scopes may be configured.
               
               <a name="nested_extra_attributes_oauth2_client"></a>The `extra_attributes_oauth2_client` block supports:
        """
        pulumi.set(__self__, "assertion_claims_behavior", assertion_claims_behavior)
        pulumi.set(__self__, "response_type", response_type)
        if additional_scopes is not None:
            pulumi.set(__self__, "additional_scopes", additional_scopes)

    @property
    @pulumi.getter(name="assertionClaimsBehavior")
    def assertion_claims_behavior(self) -> str:
        """
        The behavior for how OIDC Claims are included in the `assertion` object used for attribute mapping and attribute condition.
        * MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS: Merge the UserInfo Endpoint Claims with ID Token Claims, preferring UserInfo Claim Values for the same Claim Name. This option is available only for the Authorization Code Flow.
        * ONLY_ID_TOKEN_CLAIMS: Only include ID Token Claims.
        Possible values are: `MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS`, `ONLY_ID_TOKEN_CLAIMS`.
        """
        return pulumi.get(self, "assertion_claims_behavior")

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> str:
        """
        The Response Type to request for in the OIDC Authorization Request for web sign-in.
        The `CODE` Response Type is recommended to avoid the Implicit Flow, for security reasons.
        * CODE: The `response_type=code` selection uses the Authorization Code Flow for web sign-in. Requires a configured client secret.
        * ID_TOKEN: The `response_type=id_token` selection uses the Implicit Flow for web sign-in.
        Possible values are: `CODE`, `ID_TOKEN`.
        """
        return pulumi.get(self, "response_type")

    @property
    @pulumi.getter(name="additionalScopes")
    def additional_scopes(self) -> Optional[Sequence[str]]:
        """
        Additional scopes to request for in the OIDC authentication request on top of scopes requested by default. By default, the `openid`, `profile` and `email` scopes that are supported by the identity provider are requested.
        Each additional scope may be at most 256 characters. A maximum of 10 additional scopes may be configured.

        <a name="nested_extra_attributes_oauth2_client"></a>The `extra_attributes_oauth2_client` block supports:
        """
        return pulumi.get(self, "additional_scopes")


@pulumi.output_type
class WorkforcePoolProviderSaml(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpMetadataXml":
            suggest = "idp_metadata_xml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkforcePoolProviderSaml. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkforcePoolProviderSaml.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkforcePoolProviderSaml.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_metadata_xml: str):
        """
        :param str idp_metadata_xml: SAML Identity provider configuration metadata xml doc.
               The xml document should comply with [SAML 2.0 specification](https://docs.oasis-open.org/security/saml/v2.0/saml-metadata-2.0-os.pdf).
               The max size of the acceptable xml document will be bounded to 128k characters.
               The metadata xml document should satisfy the following constraints:
               1) Must contain an Identity Provider Entity ID.
               2) Must contain at least one non-expired signing key certificate.
               3) For each signing key:
               a) Valid from should be no more than 7 days from now.
               b) Valid to should be no more than 10 years in the future.
               4) Up to 3 IdP signing keys are allowed in the metadata xml.
               When updating the provider's metadata xml, at least one non-expired signing key
               must overlap with the existing metadata. This requirement is skipped if there are
               no non-expired signing keys present in the existing metadata.
        """
        pulumi.set(__self__, "idp_metadata_xml", idp_metadata_xml)

    @property
    @pulumi.getter(name="idpMetadataXml")
    def idp_metadata_xml(self) -> str:
        """
        SAML Identity provider configuration metadata xml doc.
        The xml document should comply with [SAML 2.0 specification](https://docs.oasis-open.org/security/saml/v2.0/saml-metadata-2.0-os.pdf).
        The max size of the acceptable xml document will be bounded to 128k characters.
        The metadata xml document should satisfy the following constraints:
        1) Must contain an Identity Provider Entity ID.
        2) Must contain at least one non-expired signing key certificate.
        3) For each signing key:
        a) Valid from should be no more than 7 days from now.
        b) Valid to should be no more than 10 years in the future.
        4) Up to 3 IdP signing keys are allowed in the metadata xml.
        When updating the provider's metadata xml, at least one non-expired signing key
        must overlap with the existing metadata. This requirement is skipped if there are
        no non-expired signing keys present in the existing metadata.
        """
        return pulumi.get(self, "idp_metadata_xml")


@pulumi.output_type
class WorkloadIdentityPoolProviderAws(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderAws. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderAws.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderAws.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str):
        """
        :param str account_id: The AWS account ID.
        """
        pulumi.set(__self__, "account_id", account_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The AWS account ID.
        """
        return pulumi.get(self, "account_id")


@pulumi.output_type
class WorkloadIdentityPoolProviderOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerUri":
            suggest = "issuer_uri"
        elif key == "allowedAudiences":
            suggest = "allowed_audiences"
        elif key == "jwksJson":
            suggest = "jwks_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_uri: str,
                 allowed_audiences: Optional[Sequence[str]] = None,
                 jwks_json: Optional[str] = None):
        """
        :param str issuer_uri: The OIDC issuer URL.
        :param Sequence[str] allowed_audiences: Acceptable values for the `aud` field (audience) in the OIDC token. Token exchange
               requests are rejected if the token audience does not match one of the configured
               values. Each audience may be at most 256 characters. A maximum of 10 audiences may
               be configured.
               If this list is empty, the OIDC token audience must be equal to the full canonical
               resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
               For example:
               ```
               //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
               https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
               ```
        :param str jwks_json: OIDC JWKs in JSON String format. For details on definition of a
               JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
               use the `jwks_uri` from the discovery document fetched from the
               .well-known path for the `issuer_uri`. Currently, RSA and EC asymmetric
               keys are supported. The JWK must use following format and include only
               the following fields:
               ```
               {
               "keys": [
               {
               "kty": "RSA/EC",
               "alg": "<algorithm>",
               "use": "sig",
               "kid": "<key-id>",
               "n": "",
               "e": "",
               "x": "",
               "y": "",
               "crv": ""
               }
               ]
               }
               ```
        """
        pulumi.set(__self__, "issuer_uri", issuer_uri)
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if jwks_json is not None:
            pulumi.set(__self__, "jwks_json", jwks_json)

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> str:
        """
        The OIDC issuer URL.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[Sequence[str]]:
        """
        Acceptable values for the `aud` field (audience) in the OIDC token. Token exchange
        requests are rejected if the token audience does not match one of the configured
        values. Each audience may be at most 256 characters. A maximum of 10 audiences may
        be configured.
        If this list is empty, the OIDC token audience must be equal to the full canonical
        resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
        For example:
        ```
        //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
        https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
        ```
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="jwksJson")
    def jwks_json(self) -> Optional[str]:
        """
        OIDC JWKs in JSON String format. For details on definition of a
        JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
        use the `jwks_uri` from the discovery document fetched from the
        .well-known path for the `issuer_uri`. Currently, RSA and EC asymmetric
        keys are supported. The JWK must use following format and include only
        the following fields:
        ```
        {
        "keys": [
        {
        "kty": "RSA/EC",
        "alg": "<algorithm>",
        "use": "sig",
        "kid": "<key-id>",
        "n": "",
        "e": "",
        "x": "",
        "y": "",
        "crv": ""
        }
        ]
        }
        ```
        """
        return pulumi.get(self, "jwks_json")


@pulumi.output_type
class WorkloadIdentityPoolProviderSaml(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpMetadataXml":
            suggest = "idp_metadata_xml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderSaml. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderSaml.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderSaml.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_metadata_xml: str):
        """
        :param str idp_metadata_xml: SAML Identity provider configuration metadata xml doc.
               
               <a name="nested_x509"></a>The `x509` block supports:
        """
        pulumi.set(__self__, "idp_metadata_xml", idp_metadata_xml)

    @property
    @pulumi.getter(name="idpMetadataXml")
    def idp_metadata_xml(self) -> str:
        """
        SAML Identity provider configuration metadata xml doc.

        <a name="nested_x509"></a>The `x509` block supports:
        """
        return pulumi.get(self, "idp_metadata_xml")


@pulumi.output_type
class WorkloadIdentityPoolProviderX509(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustStore":
            suggest = "trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderX509. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderX509.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderX509.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_store: 'outputs.WorkloadIdentityPoolProviderX509TrustStore'):
        """
        :param 'WorkloadIdentityPoolProviderX509TrustStoreArgs' trust_store: A Trust store, use this trust store as a wrapper to config the trust
               anchor and optional intermediate cas to help build the trust chain for
               the incoming end entity certificate. Follow the x509 guidelines to
               define those PEM encoded certs. Only 1 trust store is currently
               supported.
        """
        pulumi.set(__self__, "trust_store", trust_store)

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> 'outputs.WorkloadIdentityPoolProviderX509TrustStore':
        """
        A Trust store, use this trust store as a wrapper to config the trust
        anchor and optional intermediate cas to help build the trust chain for
        the incoming end entity certificate. Follow the x509 guidelines to
        define those PEM encoded certs. Only 1 trust store is currently
        supported.
        """
        return pulumi.get(self, "trust_store")


@pulumi.output_type
class WorkloadIdentityPoolProviderX509TrustStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustAnchors":
            suggest = "trust_anchors"
        elif key == "intermediateCas":
            suggest = "intermediate_cas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderX509TrustStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderX509TrustStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderX509TrustStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_anchors: Sequence['outputs.WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor'],
                 intermediate_cas: Optional[Sequence['outputs.WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa']] = None):
        """
        :param Sequence['WorkloadIdentityPoolProviderX509TrustStoreTrustAnchorArgs'] trust_anchors: List of Trust Anchors to be used while performing validation
               against a given TrustStore. The incoming end entity's certificate
               must be chained up to one of the trust anchors here.
               Structure is documented below.
        :param Sequence['WorkloadIdentityPoolProviderX509TrustStoreIntermediateCaArgs'] intermediate_cas: Set of intermediate CA certificates used for building the trust chain to
               trust anchor.
               IMPORTANT: Intermediate CAs are only supported when configuring x509 federation.
               Structure is documented below.
        """
        pulumi.set(__self__, "trust_anchors", trust_anchors)
        if intermediate_cas is not None:
            pulumi.set(__self__, "intermediate_cas", intermediate_cas)

    @property
    @pulumi.getter(name="trustAnchors")
    def trust_anchors(self) -> Sequence['outputs.WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor']:
        """
        List of Trust Anchors to be used while performing validation
        against a given TrustStore. The incoming end entity's certificate
        must be chained up to one of the trust anchors here.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_anchors")

    @property
    @pulumi.getter(name="intermediateCas")
    def intermediate_cas(self) -> Optional[Sequence['outputs.WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa']]:
        """
        Set of intermediate CA certificates used for building the trust chain to
        trust anchor.
        IMPORTANT: Intermediate CAs are only supported when configuring x509 federation.
        Structure is documented below.
        """
        return pulumi.get(self, "intermediate_cas")


@pulumi.output_type
class WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificate":
            suggest = "pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderX509TrustStoreIntermediateCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificate: Optional[str] = None):
        """
        :param str pem_certificate: PEM certificate of the PKI used for validation. Must only contain one
               ca certificate(either root or intermediate cert).
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[str]:
        """
        PEM certificate of the PKI used for validation. Must only contain one
        ca certificate(either root or intermediate cert).
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificate":
            suggest = "pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityPoolProviderX509TrustStoreTrustAnchor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificate: Optional[str] = None):
        """
        :param str pem_certificate: PEM certificate of the PKI used for validation. Must only contain one
               ca certificate(either root or intermediate cert).
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[str]:
        """
        PEM certificate of the PKI used for validation. Must only contain one
        ca certificate(either root or intermediate cert).
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class GetTestablePermissionsPermissionResult(dict):
    def __init__(__self__, *,
                 api_disabled: bool,
                 custom_support_level: str,
                 name: str,
                 stage: str,
                 title: str):
        """
        :param bool api_disabled: Whether the corresponding API has been enabled for the resource.
        :param str custom_support_level: The level of support for custom roles. Can be one of `"NOT_SUPPORTED"`, `"SUPPORTED"`, `"TESTING"`. Default is `"SUPPORTED"`
        :param str name: Name of the permission.
        :param str stage: Release stage of the permission.
        :param str title: Human readable title of the permission.
        """
        pulumi.set(__self__, "api_disabled", api_disabled)
        pulumi.set(__self__, "custom_support_level", custom_support_level)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="apiDisabled")
    def api_disabled(self) -> bool:
        """
        Whether the corresponding API has been enabled for the resource.
        """
        return pulumi.get(self, "api_disabled")

    @property
    @pulumi.getter(name="customSupportLevel")
    def custom_support_level(self) -> str:
        """
        The level of support for custom roles. Can be one of `"NOT_SUPPORTED"`, `"SUPPORTED"`, `"TESTING"`. Default is `"SUPPORTED"`
        """
        return pulumi.get(self, "custom_support_level")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the permission.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        Release stage of the permission.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title of the permission.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderAwResult(dict):
    def __init__(__self__, *,
                 account_id: str):
        """
        :param str account_id: The AWS account ID.
        """
        pulumi.set(__self__, "account_id", account_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The AWS account ID.
        """
        return pulumi.get(self, "account_id")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderOidcResult(dict):
    def __init__(__self__, *,
                 allowed_audiences: Sequence[str],
                 issuer_uri: str,
                 jwks_json: str):
        """
        :param Sequence[str] allowed_audiences: Acceptable values for the 'aud' field (audience) in the OIDC token. Token exchange
               requests are rejected if the token audience does not match one of the configured
               values. Each audience may be at most 256 characters. A maximum of 10 audiences may
               be configured.
               
               If this list is empty, the OIDC token audience must be equal to the full canonical
               resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
               For example:
               '''
               //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
               https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
               '''
        :param str issuer_uri: The OIDC issuer URL.
        :param str jwks_json: OIDC JWKs in JSON String format. For details on definition of a
               JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
               use the 'jwks_uri' from the discovery document fetched from the
               .well-known path for the 'issuer_uri'. Currently, RSA and EC asymmetric
               keys are supported. The JWK must use following format and include only
               the following fields:
               '''
               {
                 "keys": [
                   {
                         "kty": "RSA/EC",
                         "alg": "<algorithm>",
                         "use": "sig",
                         "kid": "<key-id>",
                         "n": "",
                         "e": "",
                         "x": "",
                         "y": "",
                         "crv": ""
                   }
                 ]
               }
               '''
        """
        pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        pulumi.set(__self__, "issuer_uri", issuer_uri)
        pulumi.set(__self__, "jwks_json", jwks_json)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Sequence[str]:
        """
        Acceptable values for the 'aud' field (audience) in the OIDC token. Token exchange
        requests are rejected if the token audience does not match one of the configured
        values. Each audience may be at most 256 characters. A maximum of 10 audiences may
        be configured.

        If this list is empty, the OIDC token audience must be equal to the full canonical
        resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
        For example:
        '''
        //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
        https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
        '''
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> str:
        """
        The OIDC issuer URL.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter(name="jwksJson")
    def jwks_json(self) -> str:
        """
        OIDC JWKs in JSON String format. For details on definition of a
        JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
        use the 'jwks_uri' from the discovery document fetched from the
        .well-known path for the 'issuer_uri'. Currently, RSA and EC asymmetric
        keys are supported. The JWK must use following format and include only
        the following fields:
        '''
        {
          "keys": [
            {
                  "kty": "RSA/EC",
                  "alg": "<algorithm>",
                  "use": "sig",
                  "kid": "<key-id>",
                  "n": "",
                  "e": "",
                  "x": "",
                  "y": "",
                  "crv": ""
            }
          ]
        }
        '''
        """
        return pulumi.get(self, "jwks_json")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderSamlResult(dict):
    def __init__(__self__, *,
                 idp_metadata_xml: str):
        """
        :param str idp_metadata_xml: SAML Identity provider configuration metadata xml doc.
        """
        pulumi.set(__self__, "idp_metadata_xml", idp_metadata_xml)

    @property
    @pulumi.getter(name="idpMetadataXml")
    def idp_metadata_xml(self) -> str:
        """
        SAML Identity provider configuration metadata xml doc.
        """
        return pulumi.get(self, "idp_metadata_xml")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderX509Result(dict):
    def __init__(__self__, *,
                 trust_stores: Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreResult']):
        """
        :param Sequence['GetWorkloadIdentityPoolProviderX509TrustStoreArgs'] trust_stores: A Trust store, use this trust store as a wrapper to config the trust
               anchor and optional intermediate cas to help build the trust chain for
               the incoming end entity certificate. Follow the x509 guidelines to
               define those PEM encoded certs. Only 1 trust store is currently
               supported.
        """
        pulumi.set(__self__, "trust_stores", trust_stores)

    @property
    @pulumi.getter(name="trustStores")
    def trust_stores(self) -> Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreResult']:
        """
        A Trust store, use this trust store as a wrapper to config the trust
        anchor and optional intermediate cas to help build the trust chain for
        the incoming end entity certificate. Follow the x509 guidelines to
        define those PEM encoded certs. Only 1 trust store is currently
        supported.
        """
        return pulumi.get(self, "trust_stores")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderX509TrustStoreResult(dict):
    def __init__(__self__, *,
                 intermediate_cas: Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreIntermediateCaResult'],
                 trust_anchors: Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreTrustAnchorResult']):
        """
        :param Sequence['GetWorkloadIdentityPoolProviderX509TrustStoreIntermediateCaArgs'] intermediate_cas: Set of intermediate CA certificates used for building the trust chain to
               trust anchor.
               IMPORTANT: Intermediate CAs are only supported when configuring x509 federation.
        :param Sequence['GetWorkloadIdentityPoolProviderX509TrustStoreTrustAnchorArgs'] trust_anchors: List of Trust Anchors to be used while performing validation
               against a given TrustStore. The incoming end entity's certificate
               must be chained up to one of the trust anchors here.
        """
        pulumi.set(__self__, "intermediate_cas", intermediate_cas)
        pulumi.set(__self__, "trust_anchors", trust_anchors)

    @property
    @pulumi.getter(name="intermediateCas")
    def intermediate_cas(self) -> Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreIntermediateCaResult']:
        """
        Set of intermediate CA certificates used for building the trust chain to
        trust anchor.
        IMPORTANT: Intermediate CAs are only supported when configuring x509 federation.
        """
        return pulumi.get(self, "intermediate_cas")

    @property
    @pulumi.getter(name="trustAnchors")
    def trust_anchors(self) -> Sequence['outputs.GetWorkloadIdentityPoolProviderX509TrustStoreTrustAnchorResult']:
        """
        List of Trust Anchors to be used while performing validation
        against a given TrustStore. The incoming end entity's certificate
        must be chained up to one of the trust anchors here.
        """
        return pulumi.get(self, "trust_anchors")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderX509TrustStoreIntermediateCaResult(dict):
    def __init__(__self__, *,
                 pem_certificate: str):
        """
        :param str pem_certificate: PEM certificate of the PKI used for validation. Must only contain one
               ca certificate(either root or intermediate cert).
        """
        pulumi.set(__self__, "pem_certificate", pem_certificate)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> str:
        """
        PEM certificate of the PKI used for validation. Must only contain one
        ca certificate(either root or intermediate cert).
        """
        return pulumi.get(self, "pem_certificate")


@pulumi.output_type
class GetWorkloadIdentityPoolProviderX509TrustStoreTrustAnchorResult(dict):
    def __init__(__self__, *,
                 pem_certificate: str):
        """
        :param str pem_certificate: PEM certificate of the PKI used for validation. Must only contain one
               ca certificate(either root or intermediate cert).
        """
        pulumi.set(__self__, "pem_certificate", pem_certificate)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> str:
        """
        PEM certificate of the PKI used for validation. Must only contain one
        ca certificate(either root or intermediate cert).
        """
        return pulumi.get(self, "pem_certificate")


