# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TenantArgs', 'Tenant']

@pulumi.input_type
class TenantArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 allow_password_signup: Optional[pulumi.Input[bool]] = None,
                 disable_auth: Optional[pulumi.Input[bool]] = None,
                 enable_email_link_signin: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Tenant resource.
        :param pulumi.Input[str] display_name: Human friendly display name of the tenant.
               
               
               - - -
        :param pulumi.Input[bool] allow_password_signup: Whether to allow email/password user authentication.
        :param pulumi.Input[bool] disable_auth: Whether authentication is disabled for the tenant. If true, the users under
               the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
               are not able to manage its users.
        :param pulumi.Input[bool] enable_email_link_signin: Whether to enable email link user authentication.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        if allow_password_signup is not None:
            pulumi.set(__self__, "allow_password_signup", allow_password_signup)
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if enable_email_link_signin is not None:
            pulumi.set(__self__, "enable_email_link_signin", enable_email_link_signin)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Human friendly display name of the tenant.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="allowPasswordSignup")
    def allow_password_signup(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow email/password user authentication.
        """
        return pulumi.get(self, "allow_password_signup")

    @allow_password_signup.setter
    def allow_password_signup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_password_signup", value)

    @property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether authentication is disabled for the tenant. If true, the users under
        the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
        are not able to manage its users.
        """
        return pulumi.get(self, "disable_auth")

    @disable_auth.setter
    def disable_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auth", value)

    @property
    @pulumi.getter(name="enableEmailLinkSignin")
    def enable_email_link_signin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable email link user authentication.
        """
        return pulumi.get(self, "enable_email_link_signin")

    @enable_email_link_signin.setter
    def enable_email_link_signin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_email_link_signin", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TenantState:
    def __init__(__self__, *,
                 allow_password_signup: Optional[pulumi.Input[bool]] = None,
                 disable_auth: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_email_link_signin: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Tenant resources.
        :param pulumi.Input[bool] allow_password_signup: Whether to allow email/password user authentication.
        :param pulumi.Input[bool] disable_auth: Whether authentication is disabled for the tenant. If true, the users under
               the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
               are not able to manage its users.
        :param pulumi.Input[str] display_name: Human friendly display name of the tenant.
               
               
               - - -
        :param pulumi.Input[bool] enable_email_link_signin: Whether to enable email link user authentication.
        :param pulumi.Input[str] name: The name of the tenant that is generated by the server
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if allow_password_signup is not None:
            pulumi.set(__self__, "allow_password_signup", allow_password_signup)
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_email_link_signin is not None:
            pulumi.set(__self__, "enable_email_link_signin", enable_email_link_signin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="allowPasswordSignup")
    def allow_password_signup(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow email/password user authentication.
        """
        return pulumi.get(self, "allow_password_signup")

    @allow_password_signup.setter
    def allow_password_signup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_password_signup", value)

    @property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether authentication is disabled for the tenant. If true, the users under
        the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
        are not able to manage its users.
        """
        return pulumi.get(self, "disable_auth")

    @disable_auth.setter
    def disable_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auth", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human friendly display name of the tenant.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableEmailLinkSignin")
    def enable_email_link_signin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable email link user authentication.
        """
        return pulumi.get(self, "enable_email_link_signin")

    @enable_email_link_signin.setter
    def enable_email_link_signin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_email_link_signin", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that is generated by the server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Tenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_password_signup: Optional[pulumi.Input[bool]] = None,
                 disable_auth: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_email_link_signin: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Tenant configuration in a multi-tenant project.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        You must [enable multi-tenancy](https://cloud.google.com/identity-platform/docs/multi-tenancy-quickstart) via
        the Cloud Console prior to creating tenants.

        ## Example Usage

        ### Identity Platform Tenant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant",
            display_name="tenant",
            allow_password_signup=True)
        ```

        ## Import

        Tenant can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Tenant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default projects/{{project}}/tenants/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_password_signup: Whether to allow email/password user authentication.
        :param pulumi.Input[bool] disable_auth: Whether authentication is disabled for the tenant. If true, the users under
               the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
               are not able to manage its users.
        :param pulumi.Input[str] display_name: Human friendly display name of the tenant.
               
               
               - - -
        :param pulumi.Input[bool] enable_email_link_signin: Whether to enable email link user authentication.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Tenant configuration in a multi-tenant project.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        You must [enable multi-tenancy](https://cloud.google.com/identity-platform/docs/multi-tenancy-quickstart) via
        the Cloud Console prior to creating tenants.

        ## Example Usage

        ### Identity Platform Tenant Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant",
            display_name="tenant",
            allow_password_signup=True)
        ```

        ## Import

        Tenant can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Tenant can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default projects/{{project}}/tenants/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenant:Tenant default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_password_signup: Optional[pulumi.Input[bool]] = None,
                 disable_auth: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_email_link_signin: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantArgs.__new__(TenantArgs)

            __props__.__dict__["allow_password_signup"] = allow_password_signup
            __props__.__dict__["disable_auth"] = disable_auth
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_email_link_signin"] = enable_email_link_signin
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(Tenant, __self__).__init__(
            'gcp:identityplatform/tenant:Tenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_password_signup: Optional[pulumi.Input[bool]] = None,
            disable_auth: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enable_email_link_signin: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'Tenant':
        """
        Get an existing Tenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_password_signup: Whether to allow email/password user authentication.
        :param pulumi.Input[bool] disable_auth: Whether authentication is disabled for the tenant. If true, the users under
               the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
               are not able to manage its users.
        :param pulumi.Input[str] display_name: Human friendly display name of the tenant.
               
               
               - - -
        :param pulumi.Input[bool] enable_email_link_signin: Whether to enable email link user authentication.
        :param pulumi.Input[str] name: The name of the tenant that is generated by the server
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantState.__new__(_TenantState)

        __props__.__dict__["allow_password_signup"] = allow_password_signup
        __props__.__dict__["disable_auth"] = disable_auth
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_email_link_signin"] = enable_email_link_signin
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return Tenant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowPasswordSignup")
    def allow_password_signup(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow email/password user authentication.
        """
        return pulumi.get(self, "allow_password_signup")

    @property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether authentication is disabled for the tenant. If true, the users under
        the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
        are not able to manage its users.
        """
        return pulumi.get(self, "disable_auth")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human friendly display name of the tenant.


        - - -
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableEmailLinkSignin")
    def enable_email_link_signin(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable email link user authentication.
        """
        return pulumi.get(self, "enable_email_link_signin")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the tenant that is generated by the server
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

