# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutokeyConfigArgs', 'AutokeyConfig']

@pulumi.input_type
class AutokeyConfigArgs:
    def __init__(__self__, *,
                 folder: pulumi.Input[str],
                 key_project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AutokeyConfig resource.
        :param pulumi.Input[str] folder: The folder for which to retrieve config.
               
               
               - - -
        :param pulumi.Input[str] key_project: The target key project for a given folder where KMS Autokey will provision a
               CryptoKey for any new KeyHandle the Developer creates. Should have the form
               `projects/<project_id_or_number>`.
        """
        pulumi.set(__self__, "folder", folder)
        if key_project is not None:
            pulumi.set(__self__, "key_project", key_project)

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Input[str]:
        """
        The folder for which to retrieve config.


        - - -
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[str]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="keyProject")
    def key_project(self) -> Optional[pulumi.Input[str]]:
        """
        The target key project for a given folder where KMS Autokey will provision a
        CryptoKey for any new KeyHandle the Developer creates. Should have the form
        `projects/<project_id_or_number>`.
        """
        return pulumi.get(self, "key_project")

    @key_project.setter
    def key_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_project", value)


@pulumi.input_type
class _AutokeyConfigState:
    def __init__(__self__, *,
                 folder: Optional[pulumi.Input[str]] = None,
                 key_project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutokeyConfig resources.
        :param pulumi.Input[str] folder: The folder for which to retrieve config.
               
               
               - - -
        :param pulumi.Input[str] key_project: The target key project for a given folder where KMS Autokey will provision a
               CryptoKey for any new KeyHandle the Developer creates. Should have the form
               `projects/<project_id_or_number>`.
        """
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if key_project is not None:
            pulumi.set(__self__, "key_project", key_project)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The folder for which to retrieve config.


        - - -
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="keyProject")
    def key_project(self) -> Optional[pulumi.Input[str]]:
        """
        The target key project for a given folder where KMS Autokey will provision a
        CryptoKey for any new KeyHandle the Developer creates. Should have the form
        `projects/<project_id_or_number>`.
        """
        return pulumi.get(self, "key_project")

    @key_project.setter
    def key_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_project", value)


class AutokeyConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 key_project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Kms Autokey Config All

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Create Folder in GCP Organization
        autokms_folder = gcp.organizations.Folder("autokms_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        # Create the key project
        key_project = gcp.organizations.Project("key_project",
            project_id="key-proj",
            name="key-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Enable the Cloud KMS API
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=key_project.project_id,
            disable_on_destroy=False,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[key_project]))
        # Wait delay after enabling APIs
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        #Create KMS Service Agent
        kms_service_agent = gcp.projects.ServiceIdentity("kms_service_agent",
            service="cloudkms.googleapis.com",
            project=key_project.number,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        # Wait delay after creating service agent.
        wait_service_agent = time.index.Sleep("wait_service_agent", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[kms_service_agent]))
        #Grant the KMS Service Agent the Cloud KMS Admin role
        autokey_project_admin = gcp.projects.IAMMember("autokey_project_admin",
            project=key_project.project_id,
            role="roles/cloudkms.admin",
            member=key_project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-cloudkms.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[wait_service_agent]))
        # Wait delay after granting IAM permissions
        wait_srv_acc_permissions = time.index.Sleep("wait_srv_acc_permissions", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_project_admin]))
        example_autokeyconfig = gcp.kms.AutokeyConfig("example-autokeyconfig",
            folder=autokms_folder.id,
            key_project=key_project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[wait_srv_acc_permissions]))
        # Wait delay after setting AutokeyConfig, to prevent diffs on reapply,
        # because setting the config takes a little to fully propagate.
        wait_autokey_propagation = time.index.Sleep("wait_autokey_propagation", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[example_autokeyconfig]))
        ```

        ## Import

        AutokeyConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/autokeyConfig`

        * `{{folder}}`

        When using the `pulumi import` command, AutokeyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/autokeyConfig:AutokeyConfig default folders/{{folder}}/autokeyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/autokeyConfig:AutokeyConfig default {{folder}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] folder: The folder for which to retrieve config.
               
               
               - - -
        :param pulumi.Input[str] key_project: The target key project for a given folder where KMS Autokey will provision a
               CryptoKey for any new KeyHandle the Developer creates. Should have the form
               `projects/<project_id_or_number>`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutokeyConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Kms Autokey Config All

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Create Folder in GCP Organization
        autokms_folder = gcp.organizations.Folder("autokms_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        # Create the key project
        key_project = gcp.organizations.Project("key_project",
            project_id="key-proj",
            name="key-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Enable the Cloud KMS API
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=key_project.project_id,
            disable_on_destroy=False,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[key_project]))
        # Wait delay after enabling APIs
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        #Create KMS Service Agent
        kms_service_agent = gcp.projects.ServiceIdentity("kms_service_agent",
            service="cloudkms.googleapis.com",
            project=key_project.number,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        # Wait delay after creating service agent.
        wait_service_agent = time.index.Sleep("wait_service_agent", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[kms_service_agent]))
        #Grant the KMS Service Agent the Cloud KMS Admin role
        autokey_project_admin = gcp.projects.IAMMember("autokey_project_admin",
            project=key_project.project_id,
            role="roles/cloudkms.admin",
            member=key_project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-cloudkms.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[wait_service_agent]))
        # Wait delay after granting IAM permissions
        wait_srv_acc_permissions = time.index.Sleep("wait_srv_acc_permissions", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_project_admin]))
        example_autokeyconfig = gcp.kms.AutokeyConfig("example-autokeyconfig",
            folder=autokms_folder.id,
            key_project=key_project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[wait_srv_acc_permissions]))
        # Wait delay after setting AutokeyConfig, to prevent diffs on reapply,
        # because setting the config takes a little to fully propagate.
        wait_autokey_propagation = time.index.Sleep("wait_autokey_propagation", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[example_autokeyconfig]))
        ```

        ## Import

        AutokeyConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/autokeyConfig`

        * `{{folder}}`

        When using the `pulumi import` command, AutokeyConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/autokeyConfig:AutokeyConfig default folders/{{folder}}/autokeyConfig
        ```

        ```sh
        $ pulumi import gcp:kms/autokeyConfig:AutokeyConfig default {{folder}}
        ```

        :param str resource_name: The name of the resource.
        :param AutokeyConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutokeyConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 key_project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutokeyConfigArgs.__new__(AutokeyConfigArgs)

            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            __props__.__dict__["key_project"] = key_project
        super(AutokeyConfig, __self__).__init__(
            'gcp:kms/autokeyConfig:AutokeyConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            folder: Optional[pulumi.Input[str]] = None,
            key_project: Optional[pulumi.Input[str]] = None) -> 'AutokeyConfig':
        """
        Get an existing AutokeyConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] folder: The folder for which to retrieve config.
               
               
               - - -
        :param pulumi.Input[str] key_project: The target key project for a given folder where KMS Autokey will provision a
               CryptoKey for any new KeyHandle the Developer creates. Should have the form
               `projects/<project_id_or_number>`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutokeyConfigState.__new__(_AutokeyConfigState)

        __props__.__dict__["folder"] = folder
        __props__.__dict__["key_project"] = key_project
        return AutokeyConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[str]:
        """
        The folder for which to retrieve config.


        - - -
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="keyProject")
    def key_project(self) -> pulumi.Output[Optional[str]]:
        """
        The target key project for a given folder where KMS Autokey will provision a
        CryptoKey for any new KeyHandle the Developer creates. Should have the form
        `projects/<project_id_or_number>`.
        """
        return pulumi.get(self, "key_project")

