# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCryptoKeysResult',
    'AwaitableGetCryptoKeysResult',
    'get_crypto_keys',
    'get_crypto_keys_output',
]

@pulumi.output_type
class GetCryptoKeysResult:
    """
    A collection of values returned by getCryptoKeys.
    """
    def __init__(__self__, filter=None, id=None, key_ring=None, keys=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_ring and not isinstance(key_ring, str):
            raise TypeError("Expected argument 'key_ring' to be a str")
        pulumi.set(__self__, "key_ring", key_ring)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> str:
        return pulumi.get(self, "key_ring")

    @property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetCryptoKeysKeyResult']:
        """
        A list of all the retrieved keys from the provided key ring. This list is influenced by the provided filter argument.
        """
        return pulumi.get(self, "keys")


class AwaitableGetCryptoKeysResult(GetCryptoKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCryptoKeysResult(
            filter=self.filter,
            id=self.id,
            key_ring=self.key_ring,
            keys=self.keys)


def get_crypto_keys(filter: Optional[str] = None,
                    key_ring: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCryptoKeysResult:
    """
    Provides access to all Google Cloud Platform KMS CryptoKeys in a given KeyRing. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/object-hierarchy#key)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys).

    A CryptoKey is an interface to key material which can be used to encrypt and decrypt data. A CryptoKey belongs to a
    Google Cloud KMS KeyRing.


    :param str filter: The filter argument is used to add a filter query parameter that limits which keys are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}.
           
           * `"name:my-key-"` will retrieve keys that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring/cryptoKeys/my-key-1"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    :param str key_ring: The key ring that the keys belongs to. Format: 'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'.,
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['keyRing'] = key_ring
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getCryptoKeys:getCryptoKeys', __args__, opts=opts, typ=GetCryptoKeysResult).value

    return AwaitableGetCryptoKeysResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        key_ring=pulumi.get(__ret__, 'key_ring'),
        keys=pulumi.get(__ret__, 'keys'))


@_utilities.lift_output_func(get_crypto_keys)
def get_crypto_keys_output(filter: Optional[pulumi.Input[Optional[str]]] = None,
                           key_ring: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCryptoKeysResult]:
    """
    Provides access to all Google Cloud Platform KMS CryptoKeys in a given KeyRing. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/object-hierarchy#key)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys).

    A CryptoKey is an interface to key material which can be used to encrypt and decrypt data. A CryptoKey belongs to a
    Google Cloud KMS KeyRing.


    :param str filter: The filter argument is used to add a filter query parameter that limits which keys are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}.
           
           * `"name:my-key-"` will retrieve keys that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring/cryptoKeys/my-key-1"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    :param str key_ring: The key ring that the keys belongs to. Format: 'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'.,
    """
    ...
