# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKMSSecretResult',
    'AwaitableGetKMSSecretResult',
    'get_kms_secret',
    'get_kms_secret_output',
]

@pulumi.output_type
class GetKMSSecretResult:
    """
    A collection of values returned by getKMSSecret.
    """
    def __init__(__self__, additional_authenticated_data=None, ciphertext=None, crypto_key=None, id=None, plaintext=None):
        if additional_authenticated_data and not isinstance(additional_authenticated_data, str):
            raise TypeError("Expected argument 'additional_authenticated_data' to be a str")
        pulumi.set(__self__, "additional_authenticated_data", additional_authenticated_data)
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crypto_key and not isinstance(crypto_key, str):
            raise TypeError("Expected argument 'crypto_key' to be a str")
        pulumi.set(__self__, "crypto_key", crypto_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @property
    @pulumi.getter(name="additionalAuthenticatedData")
    def additional_authenticated_data(self) -> Optional[str]:
        return pulumi.get(self, "additional_authenticated_data")

    @property
    @pulumi.getter
    def ciphertext(self) -> str:
        return pulumi.get(self, "ciphertext")

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> str:
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def plaintext(self) -> str:
        """
        Contains the result of decrypting the provided ciphertext.
        """
        return pulumi.get(self, "plaintext")


class AwaitableGetKMSSecretResult(GetKMSSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKMSSecretResult(
            additional_authenticated_data=self.additional_authenticated_data,
            ciphertext=self.ciphertext,
            crypto_key=self.crypto_key,
            id=self.id,
            plaintext=self.plaintext)


def get_kms_secret(additional_authenticated_data: Optional[str] = None,
                   ciphertext: Optional[str] = None,
                   crypto_key: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKMSSecretResult:
    """
    This data source allows you to use data encrypted with Google Cloud KMS
    within your resource definitions.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/encrypt-decrypt).

    > **NOTE:** Using this data provider will allow you to conceal secret data within your
    resource definitions, but it does not take care of protecting that data in the
    logging output, plan output, or state output.  Please take care to secure your secret
    data outside of resource definitions.

    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id)
    ```

    Next, use the [Cloud SDK](https://cloud.google.com/sdk/gcloud/reference/kms/encrypt) to encrypt some
    sensitive information:

    Finally, reference the encrypted ciphertext in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_random as random

    sql_user_password = gcp.kms.get_kms_secret(crypto_key=my_crypto_key["id"],
        ciphertext="CiQAqD+xX4SXOSziF4a8JYvq4spfAuWhhYSNul33H85HnVtNQW4SOgDu2UZ46dQCRFl5MF6ekabviN8xq+F+2035ZJ85B+xTYXqNf4mZs0RJitnWWuXlYQh6axnnJYu3kDU=")
    db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
    main = gcp.sql.DatabaseInstance("main",
        name=db_name_suffix.hex.apply(lambda hex: f"main-instance-{hex}"),
        database_version="MYSQL_5_7",
        settings={
            "tier": "db-f1-micro",
        })
    users = gcp.sql.User("users",
        name="me",
        instance=main.name,
        host="me.com",
        password=sql_user_password.plaintext)
    ```

    This will result in a Cloud SQL user being created with password `my-secret-password`.


    :param str additional_authenticated_data: The [additional authenticated data](https://cloud.google.com/kms/docs/additional-authenticated-data) used for integrity checks during encryption and decryption.
    :param str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param str crypto_key: The id of the CryptoKey that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `{projectId}/{location}/{keyRingName}/{cryptoKeyName}`.
    """
    __args__ = dict()
    __args__['additionalAuthenticatedData'] = additional_authenticated_data
    __args__['ciphertext'] = ciphertext
    __args__['cryptoKey'] = crypto_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKMSSecret:getKMSSecret', __args__, opts=opts, typ=GetKMSSecretResult).value

    return AwaitableGetKMSSecretResult(
        additional_authenticated_data=pulumi.get(__ret__, 'additional_authenticated_data'),
        ciphertext=pulumi.get(__ret__, 'ciphertext'),
        crypto_key=pulumi.get(__ret__, 'crypto_key'),
        id=pulumi.get(__ret__, 'id'),
        plaintext=pulumi.get(__ret__, 'plaintext'))


@_utilities.lift_output_func(get_kms_secret)
def get_kms_secret_output(additional_authenticated_data: Optional[pulumi.Input[Optional[str]]] = None,
                          ciphertext: Optional[pulumi.Input[str]] = None,
                          crypto_key: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKMSSecretResult]:
    """
    This data source allows you to use data encrypted with Google Cloud KMS
    within your resource definitions.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/encrypt-decrypt).

    > **NOTE:** Using this data provider will allow you to conceal secret data within your
    resource definitions, but it does not take care of protecting that data in the
    logging output, plan output, or state output.  Please take care to secure your secret
    data outside of resource definitions.

    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id)
    ```

    Next, use the [Cloud SDK](https://cloud.google.com/sdk/gcloud/reference/kms/encrypt) to encrypt some
    sensitive information:

    Finally, reference the encrypted ciphertext in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_random as random

    sql_user_password = gcp.kms.get_kms_secret(crypto_key=my_crypto_key["id"],
        ciphertext="CiQAqD+xX4SXOSziF4a8JYvq4spfAuWhhYSNul33H85HnVtNQW4SOgDu2UZ46dQCRFl5MF6ekabviN8xq+F+2035ZJ85B+xTYXqNf4mZs0RJitnWWuXlYQh6axnnJYu3kDU=")
    db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
    main = gcp.sql.DatabaseInstance("main",
        name=db_name_suffix.hex.apply(lambda hex: f"main-instance-{hex}"),
        database_version="MYSQL_5_7",
        settings={
            "tier": "db-f1-micro",
        })
    users = gcp.sql.User("users",
        name="me",
        instance=main.name,
        host="me.com",
        password=sql_user_password.plaintext)
    ```

    This will result in a Cloud SQL user being created with password `my-secret-password`.


    :param str additional_authenticated_data: The [additional authenticated data](https://cloud.google.com/kms/docs/additional-authenticated-data) used for integrity checks during encryption and decryption.
    :param str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param str crypto_key: The id of the CryptoKey that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `{projectId}/{location}/{keyRingName}/{cryptoKeyName}`.
    """
    ...
