# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceAdminSettings',
    'InstanceCustomDomain',
    'InstanceDenyMaintenancePeriod',
    'InstanceDenyMaintenancePeriodEndDate',
    'InstanceDenyMaintenancePeriodStartDate',
    'InstanceDenyMaintenancePeriodTime',
    'InstanceEncryptionConfig',
    'InstanceMaintenanceWindow',
    'InstanceMaintenanceWindowStartTime',
    'InstanceOauthConfig',
    'InstancePscConfig',
    'InstancePscConfigServiceAttachment',
    'InstanceUserMetadata',
]

@pulumi.output_type
class InstanceAdminSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedEmailDomains":
            suggest = "allowed_email_domains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAdminSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAdminSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAdminSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_email_domains: Optional[Sequence[str]] = None):
        if allowed_email_domains is not None:
            pulumi.set(__self__, "allowed_email_domains", allowed_email_domains)

    @property
    @pulumi.getter(name="allowedEmailDomains")
    def allowed_email_domains(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_email_domains")


@pulumi.output_type
class InstanceCustomDomain(dict):
    def __init__(__self__, *,
                 domain: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str domain: Domain name
        :param str state: (Output)
               Status of the custom domain.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        Status of the custom domain.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InstanceDenyMaintenancePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDenyMaintenancePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDenyMaintenancePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDenyMaintenancePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: 'outputs.InstanceDenyMaintenancePeriodEndDate',
                 start_date: 'outputs.InstanceDenyMaintenancePeriodStartDate',
                 time: 'outputs.InstanceDenyMaintenancePeriodTime'):
        """
        :param 'InstanceDenyMaintenancePeriodEndDateArgs' end_date: Required. Start date of the deny maintenance period
               Structure is documented below.
        :param 'InstanceDenyMaintenancePeriodStartDateArgs' start_date: Required. Start date of the deny maintenance period
               Structure is documented below.
        :param 'InstanceDenyMaintenancePeriodTimeArgs' time: Required. Start time of the window in UTC time.
               Structure is documented below.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> 'outputs.InstanceDenyMaintenancePeriodEndDate':
        """
        Required. Start date of the deny maintenance period
        Structure is documented below.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> 'outputs.InstanceDenyMaintenancePeriodStartDate':
        """
        Required. Start date of the deny maintenance period
        Structure is documented below.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> 'outputs.InstanceDenyMaintenancePeriodTime':
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class InstanceDenyMaintenancePeriodEndDate(dict):
    def __init__(__self__, *,
                 day: Optional[int] = None,
                 month: Optional[int] = None,
                 year: Optional[int] = None):
        """
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
               to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a
               month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without
               a year.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> Optional[int]:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
        to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> Optional[int]:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a
        month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> Optional[int]:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without
        a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class InstanceDenyMaintenancePeriodStartDate(dict):
    def __init__(__self__, *,
                 day: Optional[int] = None,
                 month: Optional[int] = None,
                 year: Optional[int] = None):
        """
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
               to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a
               month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without
               a year.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> Optional[int]:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
        to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> Optional[int]:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a
        month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> Optional[int]:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without
        a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class InstanceDenyMaintenancePeriodTime(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class InstanceEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyNameVersion":
            suggest = "kms_key_name_version"
        elif key == "kmsKeyState":
            suggest = "kms_key_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None,
                 kms_key_name_version: Optional[str] = None,
                 kms_key_state: Optional[str] = None):
        """
        :param str kms_key_name: Name of the customer managed encryption key (CMEK) in KMS.
        :param str kms_key_name_version: (Output)
               Full name and version of the CMEK key currently in use to encrypt Looker data.
        :param str kms_key_state: (Output)
               Status of the customer managed encryption key (CMEK) in KMS.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_name_version is not None:
            pulumi.set(__self__, "kms_key_name_version", kms_key_name_version)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        Name of the customer managed encryption key (CMEK) in KMS.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyNameVersion")
    def kms_key_name_version(self) -> Optional[str]:
        """
        (Output)
        Full name and version of the CMEK key currently in use to encrypt Looker data.
        """
        return pulumi.get(self, "kms_key_name_version")

    @property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[str]:
        """
        (Output)
        Status of the customer managed encryption key (CMEK) in KMS.
        """
        return pulumi.get(self, "kms_key_state")


@pulumi.output_type
class InstanceMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 start_time: 'outputs.InstanceMaintenanceWindowStartTime'):
        """
        :param str day_of_week: Required. Day of the week for this MaintenanceWindow (in UTC).
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'InstanceMaintenanceWindowStartTimeArgs' start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Required. Day of the week for this MaintenanceWindow (in UTC).
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.InstanceMaintenanceWindowStartTime':
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class InstanceOauthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceOauthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceOauthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceOauthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str):
        """
        :param str client_id: The client ID for the Oauth config.
        :param str client_secret: The client secret for the Oauth config.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID for the Oauth config.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret for the Oauth config.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class InstancePscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedVpcs":
            suggest = "allowed_vpcs"
        elif key == "lookerServiceAttachmentUri":
            suggest = "looker_service_attachment_uri"
        elif key == "serviceAttachments":
            suggest = "service_attachments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_vpcs: Optional[Sequence[str]] = None,
                 looker_service_attachment_uri: Optional[str] = None,
                 service_attachments: Optional[Sequence['outputs.InstancePscConfigServiceAttachment']] = None):
        """
        :param Sequence[str] allowed_vpcs: List of VPCs that are allowed ingress into the Looker instance.
        :param str looker_service_attachment_uri: (Output)
               URI of the Looker service attachment.
        :param Sequence['InstancePscConfigServiceAttachmentArgs'] service_attachments: List of egress service attachment configurations.
               Structure is documented below.
        """
        if allowed_vpcs is not None:
            pulumi.set(__self__, "allowed_vpcs", allowed_vpcs)
        if looker_service_attachment_uri is not None:
            pulumi.set(__self__, "looker_service_attachment_uri", looker_service_attachment_uri)
        if service_attachments is not None:
            pulumi.set(__self__, "service_attachments", service_attachments)

    @property
    @pulumi.getter(name="allowedVpcs")
    def allowed_vpcs(self) -> Optional[Sequence[str]]:
        """
        List of VPCs that are allowed ingress into the Looker instance.
        """
        return pulumi.get(self, "allowed_vpcs")

    @property
    @pulumi.getter(name="lookerServiceAttachmentUri")
    def looker_service_attachment_uri(self) -> Optional[str]:
        """
        (Output)
        URI of the Looker service attachment.
        """
        return pulumi.get(self, "looker_service_attachment_uri")

    @property
    @pulumi.getter(name="serviceAttachments")
    def service_attachments(self) -> Optional[Sequence['outputs.InstancePscConfigServiceAttachment']]:
        """
        List of egress service attachment configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "service_attachments")


@pulumi.output_type
class InstancePscConfigServiceAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "localFqdn":
            suggest = "local_fqdn"
        elif key == "targetServiceAttachmentUri":
            suggest = "target_service_attachment_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscConfigServiceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscConfigServiceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscConfigServiceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: Optional[str] = None,
                 local_fqdn: Optional[str] = None,
                 target_service_attachment_uri: Optional[str] = None):
        """
        :param str connection_status: (Output)
               Status of the service attachment connection.
        :param str local_fqdn: Fully qualified domain name that will be used in the private DNS record created for the service attachment.
        :param str target_service_attachment_uri: URI of the service attachment to connect to.
        """
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if local_fqdn is not None:
            pulumi.set(__self__, "local_fqdn", local_fqdn)
        if target_service_attachment_uri is not None:
            pulumi.set(__self__, "target_service_attachment_uri", target_service_attachment_uri)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[str]:
        """
        (Output)
        Status of the service attachment connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="localFqdn")
    def local_fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name that will be used in the private DNS record created for the service attachment.
        """
        return pulumi.get(self, "local_fqdn")

    @property
    @pulumi.getter(name="targetServiceAttachmentUri")
    def target_service_attachment_uri(self) -> Optional[str]:
        """
        URI of the service attachment to connect to.
        """
        return pulumi.get(self, "target_service_attachment_uri")


@pulumi.output_type
class InstanceUserMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDeveloperUserCount":
            suggest = "additional_developer_user_count"
        elif key == "additionalStandardUserCount":
            suggest = "additional_standard_user_count"
        elif key == "additionalViewerUserCount":
            suggest = "additional_viewer_user_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceUserMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceUserMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceUserMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_developer_user_count: Optional[int] = None,
                 additional_standard_user_count: Optional[int] = None,
                 additional_viewer_user_count: Optional[int] = None):
        """
        :param int additional_developer_user_count: Number of additional Developer Users to allocate to the Looker Instance.
        :param int additional_standard_user_count: Number of additional Standard Users to allocate to the Looker Instance.
        :param int additional_viewer_user_count: Number of additional Viewer Users to allocate to the Looker Instance.
        """
        if additional_developer_user_count is not None:
            pulumi.set(__self__, "additional_developer_user_count", additional_developer_user_count)
        if additional_standard_user_count is not None:
            pulumi.set(__self__, "additional_standard_user_count", additional_standard_user_count)
        if additional_viewer_user_count is not None:
            pulumi.set(__self__, "additional_viewer_user_count", additional_viewer_user_count)

    @property
    @pulumi.getter(name="additionalDeveloperUserCount")
    def additional_developer_user_count(self) -> Optional[int]:
        """
        Number of additional Developer Users to allocate to the Looker Instance.
        """
        return pulumi.get(self, "additional_developer_user_count")

    @property
    @pulumi.getter(name="additionalStandardUserCount")
    def additional_standard_user_count(self) -> Optional[int]:
        """
        Number of additional Standard Users to allocate to the Looker Instance.
        """
        return pulumi.get(self, "additional_standard_user_count")

    @property
    @pulumi.getter(name="additionalViewerUserCount")
    def additional_viewer_user_count(self) -> Optional[int]:
        """
        Number of additional Viewer Users to allocate to the Looker Instance.
        """
        return pulumi.get(self, "additional_viewer_user_count")


