# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterCapacityConfigArgs',
    'ClusterCapacityConfigArgsDict',
    'ClusterGcpConfigArgs',
    'ClusterGcpConfigArgsDict',
    'ClusterGcpConfigAccessConfigArgs',
    'ClusterGcpConfigAccessConfigArgsDict',
    'ClusterGcpConfigAccessConfigNetworkConfigArgs',
    'ClusterGcpConfigAccessConfigNetworkConfigArgsDict',
    'ClusterRebalanceConfigArgs',
    'ClusterRebalanceConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterCapacityConfigArgsDict(TypedDict):
        memory_bytes: pulumi.Input[str]
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.

        - - -
        """
        vcpu_count: pulumi.Input[str]
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
elif False:
    ClusterCapacityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCapacityConfigArgs:
    def __init__(__self__, *,
                 memory_bytes: pulumi.Input[str],
                 vcpu_count: pulumi.Input[str]):
        """
        :param pulumi.Input[str] memory_bytes: The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.
               
               - - -
        :param pulumi.Input[str] vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> pulumi.Input[str]:
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.

        - - -
        """
        return pulumi.get(self, "memory_bytes")

    @memory_bytes.setter
    def memory_bytes(self, value: pulumi.Input[str]):
        pulumi.set(self, "memory_bytes", value)

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> pulumi.Input[str]:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")

    @vcpu_count.setter
    def vcpu_count(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcpu_count", value)


if not MYPY:
    class ClusterGcpConfigArgsDict(TypedDict):
        access_config: pulumi.Input['ClusterGcpConfigAccessConfigArgsDict']
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        kms_key: NotRequired[pulumi.Input[str]]
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
elif False:
    ClusterGcpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigArgs:
    def __init__(__self__, *,
                 access_config: pulumi.Input['ClusterGcpConfigAccessConfigArgs'],
                 kms_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ClusterGcpConfigAccessConfigArgs'] access_config: The configuration of access to the Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[str] kms_key: The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        pulumi.set(__self__, "access_config", access_config)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Input['ClusterGcpConfigAccessConfigArgs']:
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: pulumi.Input['ClusterGcpConfigAccessConfigArgs']):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class ClusterGcpConfigAccessConfigArgsDict(TypedDict):
        network_configs: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgsDict']]]
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
elif False:
    ClusterGcpConfigAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigAccessConfigArgs:
    def __init__(__self__, *,
                 network_configs: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @network_configs.setter
    def network_configs(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        pulumi.set(self, "network_configs", value)


if not MYPY:
    class ClusterGcpConfigAccessConfigNetworkConfigArgsDict(TypedDict):
        subnet: pulumi.Input[str]
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. The subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
elif False:
    ClusterGcpConfigAccessConfigNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigAccessConfigNetworkConfigArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[str]):
        """
        :param pulumi.Input[str] subnet: Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. The subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. The subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)


if not MYPY:
    class ClusterRebalanceConfigArgsDict(TypedDict):
        mode: NotRequired[pulumi.Input[str]]
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
elif False:
    ClusterRebalanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRebalanceConfigArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mode: The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


