# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterCapacityConfig',
    'ClusterGcpConfig',
    'ClusterGcpConfigAccessConfig',
    'ClusterGcpConfigAccessConfigNetworkConfig',
    'ClusterRebalanceConfig',
]

@pulumi.output_type
class ClusterCapacityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "vcpuCount":
            suggest = "vcpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_bytes: str,
                 vcpu_count: str):
        """
        :param str memory_bytes: The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.
               
               - - -
        :param str vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> str:
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.

        - - -
        """
        return pulumi.get(self, "memory_bytes")

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> str:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")


@pulumi.output_type
class ClusterGcpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfig":
            suggest = "access_config"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterGcpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterGcpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterGcpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_config: 'outputs.ClusterGcpConfigAccessConfig',
                 kms_key: Optional[str] = None):
        """
        :param 'ClusterGcpConfigAccessConfigArgs' access_config: The configuration of access to the Kafka cluster.
               Structure is documented below.
        :param str kms_key: The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        pulumi.set(__self__, "access_config", access_config)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> 'outputs.ClusterGcpConfigAccessConfig':
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class ClusterGcpConfigAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkConfigs":
            suggest = "network_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterGcpConfigAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterGcpConfigAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterGcpConfigAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_configs: Sequence['outputs.ClusterGcpConfigAccessConfigNetworkConfig']):
        """
        :param Sequence['ClusterGcpConfigAccessConfigNetworkConfigArgs'] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Sequence['outputs.ClusterGcpConfigAccessConfigNetworkConfig']:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")


@pulumi.output_type
class ClusterGcpConfigAccessConfigNetworkConfig(dict):
    def __init__(__self__, *,
                 subnet: str):
        """
        :param str subnet: Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. The subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. The subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ClusterRebalanceConfig(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None):
        """
        :param str mode: The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        return pulumi.get(self, "mode")


