# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 node_config: pulumi.Input['InstanceNodeConfigArgs'],
                 node_count: pulumi.Input[int],
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 memcache_parameters: Optional[pulumi.Input['InstanceMemcacheParametersArgs']] = None,
                 memcache_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceNodeConfigArgs'] node_config: Configuration for memcache nodes.
               Structure is documented below.
        :param pulumi.Input[int] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
        :param pulumi.Input['InstanceMemcacheParametersArgs'] memcache_parameters: User-specified parameters for this memcache instance.
        :param pulumi.Input[str] memcache_version: The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
               supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
               latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input[str] region: The region of the Memcache instance. If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserved_ip_range_ids: Contains the name of allocated IP address ranges associated with the private service access connection for example,
               "test-default" associated with IP range 10.0.0.0/29.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        pulumi.set(__self__, "node_config", node_config)
        pulumi.set(__self__, "node_count", node_count)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if memcache_parameters is not None:
            pulumi.set(__self__, "memcache_parameters", memcache_parameters)
        if memcache_version is not None:
            pulumi.set(__self__, "memcache_version", memcache_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_range_ids is not None:
            pulumi.set(__self__, "reserved_ip_range_ids", reserved_ip_range_ids)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Input['InstanceNodeConfigArgs']:
        """
        Configuration for memcache nodes.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: pulumi.Input['InstanceNodeConfigArgs']):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[int]:
        """
        Number of nodes in the memcache instance.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-visible name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter(name="memcacheParameters")
    def memcache_parameters(self) -> Optional[pulumi.Input['InstanceMemcacheParametersArgs']]:
        """
        User-specified parameters for this memcache instance.
        """
        return pulumi.get(self, "memcache_parameters")

    @memcache_parameters.setter
    def memcache_parameters(self, value: Optional[pulumi.Input['InstanceMemcacheParametersArgs']]):
        pulumi.set(self, "memcache_parameters", value)

    @property
    @pulumi.getter(name="memcacheVersion")
    def memcache_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
        supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
        latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        """
        return pulumi.get(self, "memcache_version")

    @memcache_version.setter
    def memcache_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memcache_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the Memcache instance. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedIpRangeIds")
    def reserved_ip_range_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains the name of allocated IP address ranges associated with the private service access connection for example,
        "test-default" associated with IP range 10.0.0.0/29.
        """
        return pulumi.get(self, "reserved_ip_range_ids")

    @reserved_ip_range_ids.setter
    def reserved_ip_range_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reserved_ip_range_ids", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 discovery_endpoint: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]] = None,
                 memcache_full_version: Optional[pulumi.Input[str]] = None,
                 memcache_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMemcacheNodeArgs']]]] = None,
                 memcache_parameters: Optional[pulumi.Input['InstanceMemcacheParametersArgs']] = None,
                 memcache_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input['InstanceNodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        :param pulumi.Input[str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] discovery_endpoint: Endpoint for Discovery API
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]] maintenance_schedules: Output only. Published maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[str] memcache_full_version: The full version of memcached server running on this instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMemcacheNodeArgs']]] memcache_nodes: Additional information about the instance state, if available.
               Structure is documented below.
        :param pulumi.Input['InstanceMemcacheParametersArgs'] memcache_parameters: User-specified parameters for this memcache instance.
        :param pulumi.Input[str] memcache_version: The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
               supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
               latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input['InstanceNodeConfigArgs'] node_config: Configuration for memcache nodes.
               Structure is documented below.
        :param pulumi.Input[int] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] region: The region of the Memcache instance. If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserved_ip_range_ids: Contains the name of allocated IP address ranges associated with the private service access connection for example,
               "test-default" associated with IP range 10.0.0.0/29.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if discovery_endpoint is not None:
            pulumi.set(__self__, "discovery_endpoint", discovery_endpoint)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if memcache_full_version is not None:
            pulumi.set(__self__, "memcache_full_version", memcache_full_version)
        if memcache_nodes is not None:
            pulumi.set(__self__, "memcache_nodes", memcache_nodes)
        if memcache_parameters is not None:
            pulumi.set(__self__, "memcache_parameters", memcache_parameters)
        if memcache_version is not None:
            pulumi.set(__self__, "memcache_version", memcache_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_range_ids is not None:
            pulumi.set(__self__, "reserved_ip_range_ids", reserved_ip_range_ids)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="discoveryEndpoint")
    def discovery_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint for Discovery API
        """
        return pulumi.get(self, "discovery_endpoint")

    @discovery_endpoint.setter
    def discovery_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_endpoint", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-visible name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]:
        """
        Output only. Published maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @property
    @pulumi.getter(name="memcacheFullVersion")
    def memcache_full_version(self) -> Optional[pulumi.Input[str]]:
        """
        The full version of memcached server running on this instance.
        """
        return pulumi.get(self, "memcache_full_version")

    @memcache_full_version.setter
    def memcache_full_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memcache_full_version", value)

    @property
    @pulumi.getter(name="memcacheNodes")
    def memcache_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMemcacheNodeArgs']]]]:
        """
        Additional information about the instance state, if available.
        Structure is documented below.
        """
        return pulumi.get(self, "memcache_nodes")

    @memcache_nodes.setter
    def memcache_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMemcacheNodeArgs']]]]):
        pulumi.set(self, "memcache_nodes", value)

    @property
    @pulumi.getter(name="memcacheParameters")
    def memcache_parameters(self) -> Optional[pulumi.Input['InstanceMemcacheParametersArgs']]:
        """
        User-specified parameters for this memcache instance.
        """
        return pulumi.get(self, "memcache_parameters")

    @memcache_parameters.setter
    def memcache_parameters(self, value: Optional[pulumi.Input['InstanceMemcacheParametersArgs']]):
        pulumi.set(self, "memcache_parameters", value)

    @property
    @pulumi.getter(name="memcacheVersion")
    def memcache_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
        supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
        latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        """
        return pulumi.get(self, "memcache_version")

    @memcache_version.setter
    def memcache_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memcache_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['InstanceNodeConfigArgs']]:
        """
        Configuration for memcache nodes.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['InstanceNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes in the memcache instance.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the Memcache instance. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedIpRangeIds")
    def reserved_ip_range_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains the name of allocated IP address ranges associated with the private service access connection for example,
        "test-default" associated with IP range 10.0.0.0/29.
        """
        return pulumi.get(self, "reserved_ip_range_ids")

    @reserved_ip_range_ids.setter
    def reserved_ip_range_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reserved_ip_range_ids", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 memcache_parameters: Optional[pulumi.Input[Union['InstanceMemcacheParametersArgs', 'InstanceMemcacheParametersArgsDict']]] = None,
                 memcache_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        A Google Cloud Memcache instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/memcached/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memcache/docs/creating-instances)

        ## Example Usage

        ### Memcache Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Memcache instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        memcache_network = gcp.compute.Network("memcache_network", name="test-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=memcache_network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=memcache_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        instance = gcp.memcache.Instance("instance",
            name="test-instance",
            authorized_network=private_service_connection.network,
            labels={
                "env": "test",
            },
            node_config={
                "cpu_count": 1,
                "memory_size_mb": 1024,
            },
            node_count=1,
            memcache_version="MEMCACHE_1_5",
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "SATURDAY",
                    "duration": "14400s",
                    "start_time": {
                        "hours": 0,
                        "minutes": 30,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for an instance.
        :param pulumi.Input[Union['InstanceMemcacheParametersArgs', 'InstanceMemcacheParametersArgsDict']] memcache_parameters: User-specified parameters for this memcache instance.
        :param pulumi.Input[str] memcache_version: The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
               supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
               latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']] node_config: Configuration for memcache nodes.
               Structure is documented below.
        :param pulumi.Input[int] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[str] region: The region of the Memcache instance. If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserved_ip_range_ids: Contains the name of allocated IP address ranges associated with the private service access connection for example,
               "test-default" associated with IP range 10.0.0.0/29.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Memcache instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/memcached/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memcache/docs/creating-instances)

        ## Example Usage

        ### Memcache Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Memcache instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        memcache_network = gcp.compute.Network("memcache_network", name="test-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=memcache_network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=memcache_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        instance = gcp.memcache.Instance("instance",
            name="test-instance",
            authorized_network=private_service_connection.network,
            labels={
                "env": "test",
            },
            node_config={
                "cpu_count": 1,
                "memory_size_mb": 1024,
            },
            node_count=1,
            memcache_version="MEMCACHE_1_5",
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "SATURDAY",
                    "duration": "14400s",
                    "start_time": {
                        "hours": 0,
                        "minutes": 30,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memcache/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 memcache_parameters: Optional[pulumi.Input[Union['InstanceMemcacheParametersArgs', 'InstanceMemcacheParametersArgsDict']]] = None,
                 memcache_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["memcache_parameters"] = memcache_parameters
            __props__.__dict__["memcache_version"] = memcache_version
            __props__.__dict__["name"] = name
            if node_config is None and not opts.urn:
                raise TypeError("Missing required property 'node_config'")
            __props__.__dict__["node_config"] = node_config
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_ip_range_ids"] = reserved_ip_range_ids
            __props__.__dict__["zones"] = zones
            __props__.__dict__["create_time"] = None
            __props__.__dict__["discovery_endpoint"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["maintenance_schedules"] = None
            __props__.__dict__["memcache_full_version"] = None
            __props__.__dict__["memcache_nodes"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:memcache/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_network: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            discovery_endpoint: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
            maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]]] = None,
            memcache_full_version: Optional[pulumi.Input[str]] = None,
            memcache_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMemcacheNodeArgs', 'InstanceMemcacheNodeArgsDict']]]]] = None,
            memcache_parameters: Optional[pulumi.Input[Union['InstanceMemcacheParametersArgs', 'InstanceMemcacheParametersArgsDict']]] = None,
            memcache_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_config: Optional[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            reserved_ip_range_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        :param pulumi.Input[str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] discovery_endpoint: Endpoint for Discovery API
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for an instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]] maintenance_schedules: Output only. Published maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[str] memcache_full_version: The full version of memcached server running on this instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMemcacheNodeArgs', 'InstanceMemcacheNodeArgsDict']]]] memcache_nodes: Additional information about the instance state, if available.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceMemcacheParametersArgs', 'InstanceMemcacheParametersArgsDict']] memcache_parameters: User-specified parameters for this memcache instance.
        :param pulumi.Input[str] memcache_version: The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
               supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
               latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']] node_config: Configuration for memcache nodes.
               Structure is documented below.
        :param pulumi.Input[int] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] region: The region of the Memcache instance. If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserved_ip_range_ids: Contains the name of allocated IP address ranges associated with the private service access connection for example,
               "test-default" associated with IP range 10.0.0.0/29.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["authorized_network"] = authorized_network
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["discovery_endpoint"] = discovery_endpoint
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedules"] = maintenance_schedules
        __props__.__dict__["memcache_full_version"] = memcache_full_version
        __props__.__dict__["memcache_nodes"] = memcache_nodes
        __props__.__dict__["memcache_parameters"] = memcache_parameters
        __props__.__dict__["memcache_version"] = memcache_version
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_ip_range_ids"] = reserved_ip_range_ids
        __props__.__dict__["zones"] = zones
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[str]:
        """
        The full name of the GCE network to connect the instance to. If not provided, 'default' will be used.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="discoveryEndpoint")
    def discovery_endpoint(self) -> pulumi.Output[str]:
        """
        Endpoint for Discovery API
        """
        return pulumi.get(self, "discovery_endpoint")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-visible name for the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource labels to represent user-provided metadata. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.InstanceMaintenancePolicy']]:
        """
        Maintenance policy for an instance.
        """
        return pulumi.get(self, "maintenance_policy")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> pulumi.Output[Sequence['outputs.InstanceMaintenanceSchedule']]:
        """
        Output only. Published maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter(name="memcacheFullVersion")
    def memcache_full_version(self) -> pulumi.Output[str]:
        """
        The full version of memcached server running on this instance.
        """
        return pulumi.get(self, "memcache_full_version")

    @property
    @pulumi.getter(name="memcacheNodes")
    def memcache_nodes(self) -> pulumi.Output[Sequence['outputs.InstanceMemcacheNode']]:
        """
        Additional information about the instance state, if available.
        Structure is documented below.
        """
        return pulumi.get(self, "memcache_nodes")

    @property
    @pulumi.getter(name="memcacheParameters")
    def memcache_parameters(self) -> pulumi.Output[Optional['outputs.InstanceMemcacheParameters']]:
        """
        User-specified parameters for this memcache instance.
        """
        return pulumi.get(self, "memcache_parameters")

    @property
    @pulumi.getter(name="memcacheVersion")
    def memcache_version(self) -> pulumi.Output[Optional[str]]:
        """
        The major version of Memcached software. If not provided, latest supported version will be used. Currently the latest
        supported major version is MEMCACHE_1_5. The minor version will be automatically determined by our system based on the
        latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5", "MEMCACHE_1_6_15"]
        """
        return pulumi.get(self, "memcache_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.InstanceNodeConfig']:
        """
        Configuration for memcache nodes.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        Number of nodes in the memcache instance.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region of the Memcache instance. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservedIpRangeIds")
    def reserved_ip_range_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Contains the name of allocated IP address ranges associated with the private service access connection for example,
        "test-default" associated with IP range 10.0.0.0/29.
        """
        return pulumi.get(self, "reserved_ip_range_ids")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Zones where memcache nodes should be provisioned. If not provided, all zones will be used.
        """
        return pulumi.get(self, "zones")

