# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceDesiredPscAutoConnectionArgs',
    'InstanceDesiredPscAutoConnectionArgsDict',
    'InstanceDiscoveryEndpointArgs',
    'InstanceDiscoveryEndpointArgsDict',
    'InstanceNodeConfigArgs',
    'InstanceNodeConfigArgsDict',
    'InstancePersistenceConfigArgs',
    'InstancePersistenceConfigArgsDict',
    'InstancePersistenceConfigAofConfigArgs',
    'InstancePersistenceConfigAofConfigArgsDict',
    'InstancePersistenceConfigRdbConfigArgs',
    'InstancePersistenceConfigRdbConfigArgsDict',
    'InstancePscAutoConnectionArgs',
    'InstancePscAutoConnectionArgsDict',
    'InstanceStateInfoArgs',
    'InstanceStateInfoArgsDict',
    'InstanceStateInfoUpdateInfoArgs',
    'InstanceStateInfoUpdateInfoArgsDict',
    'InstanceZoneDistributionConfigArgs',
    'InstanceZoneDistributionConfigArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceDesiredPscAutoConnectionArgsDict(TypedDict):
        network: pulumi.Input[str]
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        project_id: pulumi.Input[str]
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
elif False:
    InstanceDesiredPscAutoConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDesiredPscAutoConnectionArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[str],
                 project_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param pulumi.Input[str] project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)


if not MYPY:
    class InstanceDiscoveryEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. IP address of the exposed endpoint clients connect to.
        """
        network: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        (Output)
        Output only. The port number of the exposed endpoint.
        """
elif False:
    InstanceDiscoveryEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDiscoveryEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: (Output)
               Output only. IP address of the exposed endpoint clients connect to.
        :param pulumi.Input[str] network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param pulumi.Input[int] port: (Output)
               Output only. The port number of the exposed endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. IP address of the exposed endpoint clients connect to.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        Output only. The port number of the exposed endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class InstanceNodeConfigArgsDict(TypedDict):
        size_gb: NotRequired[pulumi.Input[float]]
        """
        (Output)
        Output only. Memory size in GB of the node.
        """
elif False:
    InstanceNodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNodeConfigArgs:
    def __init__(__self__, *,
                 size_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] size_gb: (Output)
               Output only. Memory size in GB of the node.
        """
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        (Output)
        Output only. Memory size in GB of the node.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size_gb", value)


if not MYPY:
    class InstancePersistenceConfigArgsDict(TypedDict):
        aof_config: NotRequired[pulumi.Input['InstancePersistenceConfigAofConfigArgsDict']]
        """
        Configuration for AOF based persistence.
        Structure is documented below.
        """
        mode: NotRequired[pulumi.Input[str]]
        """
        Optional. Current persistence mode.
        Possible values:
        DISABLED
        RDB
        AOF
        Possible values are: `DISABLED`, `RDB`, `AOF`.
        """
        rdb_config: NotRequired[pulumi.Input['InstancePersistenceConfigRdbConfigArgsDict']]
        """
        Configuration for RDB based persistence.
        Structure is documented below.
        """
elif False:
    InstancePersistenceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePersistenceConfigArgs:
    def __init__(__self__, *,
                 aof_config: Optional[pulumi.Input['InstancePersistenceConfigAofConfigArgs']] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 rdb_config: Optional[pulumi.Input['InstancePersistenceConfigRdbConfigArgs']] = None):
        """
        :param pulumi.Input['InstancePersistenceConfigAofConfigArgs'] aof_config: Configuration for AOF based persistence.
               Structure is documented below.
        :param pulumi.Input[str] mode: Optional. Current persistence mode.
               Possible values:
               DISABLED
               RDB
               AOF
               Possible values are: `DISABLED`, `RDB`, `AOF`.
        :param pulumi.Input['InstancePersistenceConfigRdbConfigArgs'] rdb_config: Configuration for RDB based persistence.
               Structure is documented below.
        """
        if aof_config is not None:
            pulumi.set(__self__, "aof_config", aof_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rdb_config is not None:
            pulumi.set(__self__, "rdb_config", rdb_config)

    @property
    @pulumi.getter(name="aofConfig")
    def aof_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigAofConfigArgs']]:
        """
        Configuration for AOF based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "aof_config")

    @aof_config.setter
    def aof_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigAofConfigArgs']]):
        pulumi.set(self, "aof_config", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Current persistence mode.
        Possible values:
        DISABLED
        RDB
        AOF
        Possible values are: `DISABLED`, `RDB`, `AOF`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="rdbConfig")
    def rdb_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigRdbConfigArgs']]:
        """
        Configuration for RDB based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "rdb_config")

    @rdb_config.setter
    def rdb_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigRdbConfigArgs']]):
        pulumi.set(self, "rdb_config", value)


if not MYPY:
    class InstancePersistenceConfigAofConfigArgsDict(TypedDict):
        append_fsync: NotRequired[pulumi.Input[str]]
        """
        Optional. The fsync mode.
        Possible values:
        NEVER
        EVERY_SEC
        ALWAYS
        """
elif False:
    InstancePersistenceConfigAofConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePersistenceConfigAofConfigArgs:
    def __init__(__self__, *,
                 append_fsync: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] append_fsync: Optional. The fsync mode.
               Possible values:
               NEVER
               EVERY_SEC
               ALWAYS
        """
        if append_fsync is not None:
            pulumi.set(__self__, "append_fsync", append_fsync)

    @property
    @pulumi.getter(name="appendFsync")
    def append_fsync(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The fsync mode.
        Possible values:
        NEVER
        EVERY_SEC
        ALWAYS
        """
        return pulumi.get(self, "append_fsync")

    @append_fsync.setter
    def append_fsync(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "append_fsync", value)


if not MYPY:
    class InstancePersistenceConfigRdbConfigArgsDict(TypedDict):
        rdb_snapshot_period: NotRequired[pulumi.Input[str]]
        """
        Optional. Period between RDB snapshots.
        Possible values:
        ONE_HOUR
        SIX_HOURS
        TWELVE_HOURS
        TWENTY_FOUR_HOURS
        """
        rdb_snapshot_start_time: NotRequired[pulumi.Input[str]]
        """
        Optional. Time that the first snapshot was/will be attempted, and to which future
        snapshots will be aligned. If not provided, the current time will be
        used.
        """
elif False:
    InstancePersistenceConfigRdbConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePersistenceConfigRdbConfigArgs:
    def __init__(__self__, *,
                 rdb_snapshot_period: Optional[pulumi.Input[str]] = None,
                 rdb_snapshot_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] rdb_snapshot_period: Optional. Period between RDB snapshots.
               Possible values:
               ONE_HOUR
               SIX_HOURS
               TWELVE_HOURS
               TWENTY_FOUR_HOURS
        :param pulumi.Input[str] rdb_snapshot_start_time: Optional. Time that the first snapshot was/will be attempted, and to which future
               snapshots will be aligned. If not provided, the current time will be
               used.
        """
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Period between RDB snapshots.
        Possible values:
        ONE_HOUR
        SIX_HOURS
        TWELVE_HOURS
        TWENTY_FOUR_HOURS
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @rdb_snapshot_period.setter
    def rdb_snapshot_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdb_snapshot_period", value)

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Time that the first snapshot was/will be attempted, and to which future
        snapshots will be aligned. If not provided, the current time will be
        used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")

    @rdb_snapshot_start_time.setter
    def rdb_snapshot_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdb_snapshot_start_time", value)


if not MYPY:
    class InstancePscAutoConnectionArgsDict(TypedDict):
        forwarding_rule: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        ip_address: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        network: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        project_id: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        psc_connection_id: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
elif False:
    InstancePscAutoConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePscAutoConnectionArgs:
    def __init__(__self__, *,
                 forwarding_rule: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 psc_connection_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] forwarding_rule: (Output)
               Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param pulumi.Input[str] ip_address: (Output)
               Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param pulumi.Input[str] network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param pulumi.Input[str] project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        :param pulumi.Input[str] psc_connection_id: (Output)
               Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        """
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @forwarding_rule.setter
    def forwarding_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forwarding_rule", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @psc_connection_id.setter
    def psc_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_connection_id", value)


if not MYPY:
    class InstanceStateInfoArgsDict(TypedDict):
        update_infos: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoUpdateInfoArgsDict']]]]
        """
        (Output)
        Represents information about instance with state UPDATING.
        Structure is documented below.
        """
elif False:
    InstanceStateInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceStateInfoArgs:
    def __init__(__self__, *,
                 update_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoUpdateInfoArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoUpdateInfoArgs']]] update_infos: (Output)
               Represents information about instance with state UPDATING.
               Structure is documented below.
        """
        if update_infos is not None:
            pulumi.set(__self__, "update_infos", update_infos)

    @property
    @pulumi.getter(name="updateInfos")
    def update_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoUpdateInfoArgs']]]]:
        """
        (Output)
        Represents information about instance with state UPDATING.
        Structure is documented below.
        """
        return pulumi.get(self, "update_infos")

    @update_infos.setter
    def update_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoUpdateInfoArgs']]]]):
        pulumi.set(self, "update_infos", value)


if not MYPY:
    class InstanceStateInfoUpdateInfoArgsDict(TypedDict):
        target_replica_count: NotRequired[pulumi.Input[int]]
        """
        (Output)
        Output only. Target number of replica nodes per shard for the instance.
        """
        target_shard_count: NotRequired[pulumi.Input[int]]
        """
        (Output)
        Output only. Target number of shards for the instance.
        """
elif False:
    InstanceStateInfoUpdateInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceStateInfoUpdateInfoArgs:
    def __init__(__self__, *,
                 target_replica_count: Optional[pulumi.Input[int]] = None,
                 target_shard_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] target_replica_count: (Output)
               Output only. Target number of replica nodes per shard for the instance.
        :param pulumi.Input[int] target_shard_count: (Output)
               Output only. Target number of shards for the instance.
        """
        if target_replica_count is not None:
            pulumi.set(__self__, "target_replica_count", target_replica_count)
        if target_shard_count is not None:
            pulumi.set(__self__, "target_shard_count", target_shard_count)

    @property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        Output only. Target number of replica nodes per shard for the instance.
        """
        return pulumi.get(self, "target_replica_count")

    @target_replica_count.setter
    def target_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_replica_count", value)

    @property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        Output only. Target number of shards for the instance.
        """
        return pulumi.get(self, "target_shard_count")

    @target_shard_count.setter
    def target_shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_shard_count", value)


if not MYPY:
    class InstanceZoneDistributionConfigArgsDict(TypedDict):
        mode: NotRequired[pulumi.Input[str]]
        """
        Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
        Possible values:
        MULTI_ZONE
        SINGLE_ZONE
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
        Ignored for MULTI_ZONE mode.
        """
elif False:
    InstanceZoneDistributionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceZoneDistributionConfigArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mode: Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
               Possible values:
               MULTI_ZONE
               SINGLE_ZONE
               Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        :param pulumi.Input[str] zone: Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
               Ignored for MULTI_ZONE mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
        Possible values:
        MULTI_ZONE
        SINGLE_ZONE
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
        Ignored for MULTI_ZONE mode.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


