# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 desired_psc_auto_connections: pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]],
                 instance_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 shard_count: pulumi.Input[int],
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]] desired_psc_auto_connections: Required. Immutable. User inputs for the auto-created PSC connections.
        :param pulumi.Input[str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
               
               
               - - -
        :param pulumi.Input[str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[str] engine_version: Optional. Immutable. Engine version of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] node_type: Optional. Immutable. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input['InstanceZoneDistributionConfigArgs'] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "desired_psc_auto_connections", desired_psc_auto_connections)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "shard_count", shard_count)
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if engine_configs is not None:
            pulumi.set(__self__, "engine_configs", engine_configs)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @property
    @pulumi.getter(name="desiredPscAutoConnections")
    def desired_psc_auto_connections(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]:
        """
        Required. Immutable. User inputs for the auto-created PSC connections.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @desired_psc_auto_connections.setter
    def desired_psc_auto_connections(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]):
        pulumi.set(self, "desired_psc_auto_connections", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location


        - - -
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Input[int]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_mode", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @engine_configs.setter
    def engine_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "engine_configs", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]] = None,
                 discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[str] create_time: Output only. Creation timestamp of the instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]] desired_psc_auto_connections: Required. Immutable. User inputs for the auto-created PSC connections.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]] discovery_endpoints: Output only. Endpoints clients can connect to the instance through. Currently only one
               discovery endpoint is supported.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[str] engine_version: Optional. Immutable. Engine version of the instance.
        :param pulumi.Input[str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[str] name: Identifier. Unique name of the instance.
               Format: projects/{project}/locations/{location}/instances/{instance}
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]] node_configs: Represents configuration for nodes of the instance.
               Structure is documented below.
        :param pulumi.Input[str] node_type: Optional. Immutable. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]] psc_auto_connections: Output only. User inputs and resource details of the auto-created PSC connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[str] state: Output only. Current state of the instance.
               Possible values:
               CREATING
               ACTIVE
               UPDATING
               DELETING
        :param pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]] state_infos: Additional information about the state of the instance.
               Structure is documented below.
        :param pulumi.Input[str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[str] uid: Output only. System assigned, unique identifier for the instance.
        :param pulumi.Input[str] update_time: Output only. Latest update timestamp of the instance.
        :param pulumi.Input['InstanceZoneDistributionConfigArgs'] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if desired_psc_auto_connections is not None:
            pulumi.set(__self__, "desired_psc_auto_connections", desired_psc_auto_connections)
        if discovery_endpoints is not None:
            pulumi.set(__self__, "discovery_endpoints", discovery_endpoints)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if engine_configs is not None:
            pulumi.set(__self__, "engine_configs", engine_configs)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_configs is not None:
            pulumi.set(__self__, "node_configs", node_configs)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_infos is not None:
            pulumi.set(__self__, "state_infos", state_infos)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_mode", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Creation timestamp of the instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="desiredPscAutoConnections")
    def desired_psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]:
        """
        Required. Immutable. User inputs for the auto-created PSC connections.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @desired_psc_auto_connections.setter
    def desired_psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredPscAutoConnectionArgs']]]]):
        pulumi.set(self, "desired_psc_auto_connections", value)

    @property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]]:
        """
        Output only. Endpoints clients can connect to the instance through. Currently only one
        discovery endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @discovery_endpoints.setter
    def discovery_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiscoveryEndpointArgs']]]]):
        pulumi.set(self, "discovery_endpoints", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @engine_configs.setter
    def engine_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "engine_configs", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location


        - - -
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier. Unique name of the instance.
        Format: projects/{project}/locations/{location}/instances/{instance}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]]:
        """
        Represents configuration for nodes of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "node_configs")

    @node_configs.setter
    def node_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeConfigArgs']]]]):
        pulumi.set(self, "node_configs", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]]:
        """
        Output only. User inputs and resource details of the auto-created PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connections")

    @psc_auto_connections.setter
    def psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePscAutoConnectionArgs']]]]):
        pulumi.set(self, "psc_auto_connections", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Current state of the instance.
        Possible values:
        CREATING
        ACTIVE
        UPDATING
        DELETING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]]:
        """
        Additional information about the state of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @state_infos.setter
    def state_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStateInfoArgs']]]]):
        pulumi.set(self, "state_infos", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. System assigned, unique identifier for the instance.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Latest update timestamp of the instance.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['InstanceZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Memorystore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_basic = gcp.memorystore.Instance("instance-basic",
            instance_id="basic-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_full = gcp.memorystore.Instance("instance-full",
            instance_id="full-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            replica_count=2,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-b",
            },
            engine_version="VALKEY_7_2",
            deletion_protection_enabled=False,
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Persistence Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_persistence_aof = gcp.memorystore.Instance("instance-persistence-aof",
            instance_id="aof-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERY_SEC",
                },
            },
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]] desired_psc_auto_connections: Required. Immutable. User inputs for the auto-created PSC connections.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[str] engine_version: Optional. Immutable. Engine version of the instance.
        :param pulumi.Input[str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[str] node_type: Optional. Immutable. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Memorystore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_basic = gcp.memorystore.Instance("instance-basic",
            instance_id="basic-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_full = gcp.memorystore.Instance("instance-full",
            instance_id="full-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            replica_count=2,
            node_type="SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_DISABLED",
            authorization_mode="AUTH_DISABLED",
            engine_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-b",
            },
            engine_version="VALKEY_7_2",
            deletion_protection_enabled=False,
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            labels={
                "abc": "xyz",
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Memorystore Instance Persistence Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="my-network",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        project = gcp.organizations.get_project()
        instance_persistence_aof = gcp.memorystore.Instance("instance-persistence-aof",
            instance_id="aof-instance",
            shard_count=3,
            desired_psc_auto_connections=[{
                "network": producer_net.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERY_SEC",
                },
            },
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
                 engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["authorization_mode"] = authorization_mode
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            if desired_psc_auto_connections is None and not opts.urn:
                raise TypeError("Missing required property 'desired_psc_auto_connections'")
            __props__.__dict__["desired_psc_auto_connections"] = desired_psc_auto_connections
            __props__.__dict__["engine_configs"] = engine_configs
            __props__.__dict__["engine_version"] = engine_version
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["persistence_config"] = persistence_config
            __props__.__dict__["project"] = project
            __props__.__dict__["replica_count"] = replica_count
            if shard_count is None and not opts.urn:
                raise TypeError("Missing required property 'shard_count'")
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["zone_distribution_config"] = zone_distribution_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["discovery_endpoints"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["node_configs"] = None
            __props__.__dict__["psc_auto_connections"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_infos"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:memorystore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_mode: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
            desired_psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]]] = None,
            discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiscoveryEndpointArgs', 'InstanceDiscoveryEndpointArgsDict']]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            engine_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]]]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAutoConnectionArgs', 'InstancePscAutoConnectionArgsDict']]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            replica_count: Optional[pulumi.Input[int]] = None,
            shard_count: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceStateInfoArgs', 'InstanceStateInfoArgsDict']]]]] = None,
            transit_encryption_mode: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            zone_distribution_config: Optional[pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_mode: Optional. Immutable. Authorization mode of the instance. Possible values:
               AUTH_DISABLED
               IAM_AUTH
        :param pulumi.Input[str] create_time: Output only. Creation timestamp of the instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. If set to true deletion of the instance will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredPscAutoConnectionArgs', 'InstanceDesiredPscAutoConnectionArgsDict']]]] desired_psc_auto_connections: Required. Immutable. User inputs for the auto-created PSC connections.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiscoveryEndpointArgs', 'InstanceDiscoveryEndpointArgsDict']]]] discovery_endpoints: Output only. Endpoints clients can connect to the instance through. Currently only one
               discovery endpoint is supported.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] engine_configs: Optional. User-provided engine configurations for the instance.
        :param pulumi.Input[str] engine_version: Optional. Immutable. Engine version of the instance.
        :param pulumi.Input[str] instance_id: Required. The ID to use for the instance, which will become the final component of
               the instance's resource name.
               This value is subject to the following restrictions:
               * Must be 4-63 characters in length
               * Must begin with a letter or digit
               * Must contain only lowercase letters, digits, and hyphens
               * Must not end with a hyphen
               * Must be unique within a location
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        :param pulumi.Input[str] name: Identifier. Unique name of the instance.
               Format: projects/{project}/locations/{location}/instances/{instance}
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeConfigArgs', 'InstanceNodeConfigArgsDict']]]] node_configs: Represents configuration for nodes of the instance.
               Structure is documented below.
        :param pulumi.Input[str] node_type: Optional. Immutable. Machine type for individual nodes of the instance.
               Possible values:
               SHARED_CORE_NANO
               HIGHMEM_MEDIUM
               HIGHMEM_XLARGE
               STANDARD_SMALL
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Represents persistence configuration for a instance.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePscAutoConnectionArgs', 'InstancePscAutoConnectionArgsDict']]]] psc_auto_connections: Output only. User inputs and resource details of the auto-created PSC connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[int] replica_count: Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the instance.
        :param pulumi.Input[str] state: Output only. Current state of the instance.
               Possible values:
               CREATING
               ACTIVE
               UPDATING
               DELETING
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceStateInfoArgs', 'InstanceStateInfoArgsDict']]]] state_infos: Additional information about the state of the instance.
               Structure is documented below.
        :param pulumi.Input[str] transit_encryption_mode: Optional. Immutable. In-transit encryption mode of the instance.
               Possible values:
               TRANSIT_ENCRYPTION_DISABLED
               SERVER_AUTHENTICATION
        :param pulumi.Input[str] uid: Output only. System assigned, unique identifier for the instance.
        :param pulumi.Input[str] update_time: Output only. Latest update timestamp of the instance.
        :param pulumi.Input[Union['InstanceZoneDistributionConfigArgs', 'InstanceZoneDistributionConfigArgsDict']] zone_distribution_config: Zone distribution configuration for allocation of instance resources.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["authorization_mode"] = authorization_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["desired_psc_auto_connections"] = desired_psc_auto_connections
        __props__.__dict__["discovery_endpoints"] = discovery_endpoints
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["engine_configs"] = engine_configs
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["node_configs"] = node_configs
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["persistence_config"] = persistence_config
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_auto_connections"] = psc_auto_connections
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["state"] = state
        __props__.__dict__["state_infos"] = state_infos
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zone_distribution_config"] = zone_distribution_config
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> pulumi.Output[str]:
        """
        Optional. Immutable. Authorization mode of the instance. Possible values:
        AUTH_DISABLED
        IAM_AUTH
        """
        return pulumi.get(self, "authorization_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. Creation timestamp of the instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. If set to true deletion of the instance will fail.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="desiredPscAutoConnections")
    def desired_psc_auto_connections(self) -> pulumi.Output[Sequence['outputs.InstanceDesiredPscAutoConnection']]:
        """
        Required. Immutable. User inputs for the auto-created PSC connections.
        """
        return pulumi.get(self, "desired_psc_auto_connections")

    @property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceDiscoveryEndpoint']]:
        """
        Output only. Endpoints clients can connect to the instance through. Currently only one
        discovery endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="engineConfigs")
    def engine_configs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. User-provided engine configurations for the instance.
        """
        return pulumi.get(self, "engine_configs")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Optional. Immutable. Engine version of the instance.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the instance, which will become the final component of
        the instance's resource name.
        This value is subject to the following restrictions:
        * Must be 4-63 characters in length
        * Must begin with a letter or digit
        * Must contain only lowercase letters, digits, and hyphens
        * Must not end with a hyphen
        * Must be unique within a location


        - - -
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. Labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122. See documentation for resource type `memorystore.googleapis.com/CertificateAuthority`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier. Unique name of the instance.
        Format: projects/{project}/locations/{location}/instances/{instance}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> pulumi.Output[Sequence['outputs.InstanceNodeConfig']]:
        """
        Represents configuration for nodes of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        Optional. Immutable. Machine type for individual nodes of the instance.
        Possible values:
        SHARED_CORE_NANO
        HIGHMEM_MEDIUM
        HIGHMEM_XLARGE
        STANDARD_SMALL
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> pulumi.Output['outputs.InstancePersistenceConfig']:
        """
        Represents persistence configuration for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> pulumi.Output[Sequence['outputs.InstancePscAutoConnection']]:
        """
        Output only. User inputs and resource details of the auto-created PSC connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connections")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[int]:
        """
        Optional. Number of replica nodes per shard. If omitted the default is 0 replicas.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[int]:
        """
        Required. Number of shards for the instance.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. Current state of the instance.
        Possible values:
        CREATING
        ACTIVE
        UPDATING
        DELETING
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> pulumi.Output[Sequence['outputs.InstanceStateInfo']]:
        """
        Additional information about the state of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[str]:
        """
        Optional. Immutable. In-transit encryption mode of the instance.
        Possible values:
        TRANSIT_ENCRYPTION_DISABLED
        SERVER_AUTHENTICATION
        """
        return pulumi.get(self, "transit_encryption_mode")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. System assigned, unique identifier for the instance.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. Latest update timestamp of the instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> pulumi.Output['outputs.InstanceZoneDistributionConfig']:
        """
        Zone distribution configuration for allocation of instance resources.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

