# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceDesiredPscAutoConnection',
    'InstanceDiscoveryEndpoint',
    'InstanceNodeConfig',
    'InstancePersistenceConfig',
    'InstancePersistenceConfigAofConfig',
    'InstancePersistenceConfigRdbConfig',
    'InstancePscAutoConnection',
    'InstanceStateInfo',
    'InstanceStateInfoUpdateInfo',
    'InstanceZoneDistributionConfig',
]

@pulumi.output_type
class InstanceDesiredPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDesiredPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDesiredPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDesiredPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: str,
                 project_id: str):
        """
        :param str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class InstanceDiscoveryEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 network: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str address: (Output)
               Output only. IP address of the exposed endpoint clients connect to.
        :param str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param int port: (Output)
               Output only. The port number of the exposed endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        (Output)
        Output only. IP address of the exposed endpoint clients connect to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Output)
        Output only. The port number of the exposed endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_gb: Optional[float] = None):
        """
        :param float size_gb: (Output)
               Output only. Memory size in GB of the node.
        """
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[float]:
        """
        (Output)
        Output only. Memory size in GB of the node.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class InstancePersistenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aofConfig":
            suggest = "aof_config"
        elif key == "rdbConfig":
            suggest = "rdb_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aof_config: Optional['outputs.InstancePersistenceConfigAofConfig'] = None,
                 mode: Optional[str] = None,
                 rdb_config: Optional['outputs.InstancePersistenceConfigRdbConfig'] = None):
        """
        :param 'InstancePersistenceConfigAofConfigArgs' aof_config: Configuration for AOF based persistence.
               Structure is documented below.
        :param str mode: Optional. Current persistence mode.
               Possible values:
               DISABLED
               RDB
               AOF
               Possible values are: `DISABLED`, `RDB`, `AOF`.
        :param 'InstancePersistenceConfigRdbConfigArgs' rdb_config: Configuration for RDB based persistence.
               Structure is documented below.
        """
        if aof_config is not None:
            pulumi.set(__self__, "aof_config", aof_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rdb_config is not None:
            pulumi.set(__self__, "rdb_config", rdb_config)

    @property
    @pulumi.getter(name="aofConfig")
    def aof_config(self) -> Optional['outputs.InstancePersistenceConfigAofConfig']:
        """
        Configuration for AOF based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "aof_config")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Optional. Current persistence mode.
        Possible values:
        DISABLED
        RDB
        AOF
        Possible values are: `DISABLED`, `RDB`, `AOF`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="rdbConfig")
    def rdb_config(self) -> Optional['outputs.InstancePersistenceConfigRdbConfig']:
        """
        Configuration for RDB based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "rdb_config")


@pulumi.output_type
class InstancePersistenceConfigAofConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendFsync":
            suggest = "append_fsync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfigAofConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfigAofConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfigAofConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_fsync: Optional[str] = None):
        """
        :param str append_fsync: Optional. The fsync mode.
               Possible values:
               NEVER
               EVERY_SEC
               ALWAYS
        """
        if append_fsync is not None:
            pulumi.set(__self__, "append_fsync", append_fsync)

    @property
    @pulumi.getter(name="appendFsync")
    def append_fsync(self) -> Optional[str]:
        """
        Optional. The fsync mode.
        Possible values:
        NEVER
        EVERY_SEC
        ALWAYS
        """
        return pulumi.get(self, "append_fsync")


@pulumi.output_type
class InstancePersistenceConfigRdbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rdbSnapshotPeriod":
            suggest = "rdb_snapshot_period"
        elif key == "rdbSnapshotStartTime":
            suggest = "rdb_snapshot_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfigRdbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfigRdbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfigRdbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rdb_snapshot_period: Optional[str] = None,
                 rdb_snapshot_start_time: Optional[str] = None):
        """
        :param str rdb_snapshot_period: Optional. Period between RDB snapshots.
               Possible values:
               ONE_HOUR
               SIX_HOURS
               TWELVE_HOURS
               TWENTY_FOUR_HOURS
        :param str rdb_snapshot_start_time: Optional. Time that the first snapshot was/will be attempted, and to which future
               snapshots will be aligned. If not provided, the current time will be
               used.
        """
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[str]:
        """
        Optional. Period between RDB snapshots.
        Possible values:
        ONE_HOUR
        SIX_HOURS
        TWELVE_HOURS
        TWENTY_FOUR_HOURS
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[str]:
        """
        Optional. Time that the first snapshot was/will be attempted, and to which future
        snapshots will be aligned. If not provided, the current time will be
        used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class InstancePscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_rule: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 network: Optional[str] = None,
                 project_id: Optional[str] = None,
                 psc_connection_id: Optional[str] = None):
        """
        :param str forwarding_rule: (Output)
               Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param str ip_address: (Output)
               Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        :param str psc_connection_id: (Output)
               Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        """
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[str]:
        """
        (Output)
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        (Output)
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[str]:
        """
        (Output)
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")


@pulumi.output_type
class InstanceStateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateInfos":
            suggest = "update_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_infos: Optional[Sequence['outputs.InstanceStateInfoUpdateInfo']] = None):
        """
        :param Sequence['InstanceStateInfoUpdateInfoArgs'] update_infos: (Output)
               Represents information about instance with state UPDATING.
               Structure is documented below.
        """
        if update_infos is not None:
            pulumi.set(__self__, "update_infos", update_infos)

    @property
    @pulumi.getter(name="updateInfos")
    def update_infos(self) -> Optional[Sequence['outputs.InstanceStateInfoUpdateInfo']]:
        """
        (Output)
        Represents information about instance with state UPDATING.
        Structure is documented below.
        """
        return pulumi.get(self, "update_infos")


@pulumi.output_type
class InstanceStateInfoUpdateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReplicaCount":
            suggest = "target_replica_count"
        elif key == "targetShardCount":
            suggest = "target_shard_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStateInfoUpdateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStateInfoUpdateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStateInfoUpdateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_replica_count: Optional[int] = None,
                 target_shard_count: Optional[int] = None):
        """
        :param int target_replica_count: (Output)
               Output only. Target number of replica nodes per shard for the instance.
        :param int target_shard_count: (Output)
               Output only. Target number of shards for the instance.
        """
        if target_replica_count is not None:
            pulumi.set(__self__, "target_replica_count", target_replica_count)
        if target_shard_count is not None:
            pulumi.set(__self__, "target_shard_count", target_shard_count)

    @property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> Optional[int]:
        """
        (Output)
        Output only. Target number of replica nodes per shard for the instance.
        """
        return pulumi.get(self, "target_replica_count")

    @property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> Optional[int]:
        """
        (Output)
        Output only. Target number of shards for the instance.
        """
        return pulumi.get(self, "target_shard_count")


@pulumi.output_type
class InstanceZoneDistributionConfig(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str mode: Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
               Possible values:
               MULTI_ZONE
               SINGLE_ZONE
               Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        :param str zone: Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
               Ignored for MULTI_ZONE mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
        Possible values:
        MULTI_ZONE
        SINGLE_ZONE
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
        Ignored for MULTI_ZONE mode.
        """
        return pulumi.get(self, "zone")


