# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppEngineServiceResult',
    'AwaitableGetAppEngineServiceResult',
    'get_app_engine_service',
    'get_app_engine_service_output',
]

@pulumi.output_type
class GetAppEngineServiceResult:
    """
    A collection of values returned by getAppEngineService.
    """
    def __init__(__self__, display_name=None, id=None, module_id=None, name=None, project=None, service_id=None, telemetries=None, user_labels=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if module_id and not isinstance(module_id, str):
            raise TypeError("Expected argument 'module_id' to be a str")
        pulumi.set(__self__, "module_id", module_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if telemetries and not isinstance(telemetries, list):
            raise TypeError("Expected argument 'telemetries' to be a list")
        pulumi.set(__self__, "telemetries", telemetries)
        if user_labels and not isinstance(user_labels, dict):
            raise TypeError("Expected argument 'user_labels' to be a dict")
        pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name used for UI elements listing this (Monitoring) Service.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> str:
        return pulumi.get(self, "module_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The full REST resource name for this channel. The syntax is:
        `projects/[PROJECT_ID]/services/[SERVICE_ID]`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def telemetries(self) -> Sequence['outputs.GetAppEngineServiceTelemetryResult']:
        """
        Configuration for how to query telemetry on the Service. Structure is documented below.
        """
        return pulumi.get(self, "telemetries")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "user_labels")


class AwaitableGetAppEngineServiceResult(GetAppEngineServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppEngineServiceResult(
            display_name=self.display_name,
            id=self.id,
            module_id=self.module_id,
            name=self.name,
            project=self.project,
            service_id=self.service_id,
            telemetries=self.telemetries,
            user_labels=self.user_labels)


def get_app_engine_service(module_id: Optional[str] = None,
                           project: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppEngineServiceResult:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    An App Engine monitoring service is automatically created by GCP to monitor
    App Engine services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring App Engine Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bucket = gcp.storage.Bucket("bucket",
        name="appengine-static-content",
        location="US")
    object = gcp.storage.BucketObject("object",
        name="hello-world.zip",
        bucket=bucket.name,
        source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
    myapp = gcp.appengine.StandardAppVersion("myapp",
        version_id="v1",
        service="myapp",
        runtime="nodejs20",
        entrypoint={
            "shell": "node ./app.js",
        },
        deployment={
            "zip": {
                "source_url": pulumi.Output.all(
                    bucketName=bucket.name,
                    objectName=object.name
    ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
    ,
            },
        },
        env_variables={
            "port": "8080",
        },
        delete_service_on_destroy=False)
    # Monitors the default AppEngine service
    srv = gcp.monitoring.get_app_engine_service_output(module_id=myapp.service)
    ```


    :param str module_id: The ID of the App Engine module underlying this
           service. Corresponds to the moduleId resource label in the [gae_app](https://cloud.google.com/monitoring/api/resources#tag_gae_app) monitored resource, or the service/module name.
           
           - - -
           
           Other optional fields include:
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['moduleId'] = module_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:monitoring/getAppEngineService:getAppEngineService', __args__, opts=opts, typ=GetAppEngineServiceResult).value

    return AwaitableGetAppEngineServiceResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        module_id=pulumi.get(__ret__, 'module_id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        service_id=pulumi.get(__ret__, 'service_id'),
        telemetries=pulumi.get(__ret__, 'telemetries'),
        user_labels=pulumi.get(__ret__, 'user_labels'))


@_utilities.lift_output_func(get_app_engine_service)
def get_app_engine_service_output(module_id: Optional[pulumi.Input[str]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppEngineServiceResult]:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    An App Engine monitoring service is automatically created by GCP to monitor
    App Engine services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring App Engine Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bucket = gcp.storage.Bucket("bucket",
        name="appengine-static-content",
        location="US")
    object = gcp.storage.BucketObject("object",
        name="hello-world.zip",
        bucket=bucket.name,
        source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
    myapp = gcp.appengine.StandardAppVersion("myapp",
        version_id="v1",
        service="myapp",
        runtime="nodejs20",
        entrypoint={
            "shell": "node ./app.js",
        },
        deployment={
            "zip": {
                "source_url": pulumi.Output.all(
                    bucketName=bucket.name,
                    objectName=object.name
    ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
    ,
            },
        },
        env_variables={
            "port": "8080",
        },
        delete_service_on_destroy=False)
    # Monitors the default AppEngine service
    srv = gcp.monitoring.get_app_engine_service_output(module_id=myapp.service)
    ```


    :param str module_id: The ID of the App Engine module underlying this
           service. Corresponds to the moduleId resource label in the [gae_app](https://cloud.google.com/monitoring/api/resources#tag_gae_app) monitored resource, or the service/module name.
           
           - - -
           
           Other optional fields include:
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    ...
