# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationChannelArgs', 'NotificationChannel']

@pulumi.input_type
class NotificationChannelArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sensitive_labels: Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NotificationChannel resource.
        :param pulumi.Input[str] type: The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
               
               
               - - -
        :param pulumi.Input[str] description: An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        :param pulumi.Input[str] display_name: An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        :param pulumi.Input[bool] enabled: Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        :param pulumi.Input[bool] force_delete: If true, the notification channel will be deleted regardless
               of its use in alert policies (the policies will be updated
               to remove the channel). If false, channels that are still
               referenced by an existing alerting policy will fail to be
               deleted in a delete operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Configuration fields that define the channel and its behavior. The
               permissible and required labels are specified in the
               NotificationChannelDescriptor corresponding to the type field.
               Labels with sensitive data are obfuscated by the API and therefore the provider cannot
               determine if there are upstream changes to these fields. They can also be configured via
               the sensitive_labels block, but cannot be configured in both places.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['NotificationChannelSensitiveLabelsArgs'] sensitive_labels: Different notification type behaviors are configured primarily using the the `labels` field on this
               resource. This block contains the labels which contain secrets or passwords so that they can be marked
               sensitive and hidden from plan output. The name of the field, eg: password, will be the key
               in the `labels` map in the api request.
               Credentials may not be specified in both locations and will cause an error. Changing from one location
               to a different credential configuration in the config will require an apply to update state.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sensitive_labels is not None:
            pulumi.set(__self__, "sensitive_labels", sensitive_labels)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the notification channel will be deleted regardless
        of its use in alert policies (the policies will be updated
        to remove the channel). If false, channels that are still
        referenced by an existing alerting policy will fail to be
        deleted in a delete operation.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configuration fields that define the channel and its behavior. The
        permissible and required labels are specified in the
        NotificationChannelDescriptor corresponding to the type field.
        Labels with sensitive data are obfuscated by the API and therefore the provider cannot
        determine if there are upstream changes to these fields. They can also be configured via
        the sensitive_labels block, but cannot be configured in both places.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sensitiveLabels")
    def sensitive_labels(self) -> Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']]:
        """
        Different notification type behaviors are configured primarily using the the `labels` field on this
        resource. This block contains the labels which contain secrets or passwords so that they can be marked
        sensitive and hidden from plan output. The name of the field, eg: password, will be the key
        in the `labels` map in the api request.
        Credentials may not be specified in both locations and will cause an error. Changing from one location
        to a different credential configuration in the config will require an apply to update state.
        Structure is documented below.
        """
        return pulumi.get(self, "sensitive_labels")

    @sensitive_labels.setter
    def sensitive_labels(self, value: Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']]):
        pulumi.set(self, "sensitive_labels", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)


@pulumi.input_type
class _NotificationChannelState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sensitive_labels: Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 verification_status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NotificationChannel resources.
        :param pulumi.Input[str] description: An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        :param pulumi.Input[str] display_name: An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        :param pulumi.Input[bool] enabled: Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        :param pulumi.Input[bool] force_delete: If true, the notification channel will be deleted regardless
               of its use in alert policies (the policies will be updated
               to remove the channel). If false, channels that are still
               referenced by an existing alerting policy will fail to be
               deleted in a delete operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Configuration fields that define the channel and its behavior. The
               permissible and required labels are specified in the
               NotificationChannelDescriptor corresponding to the type field.
               Labels with sensitive data are obfuscated by the API and therefore the provider cannot
               determine if there are upstream changes to these fields. They can also be configured via
               the sensitive_labels block, but cannot be configured in both places.
        :param pulumi.Input[str] name: The full REST resource name for this channel. The syntax is:
               projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
               The [CHANNEL_ID] is automatically assigned by the server on creation.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['NotificationChannelSensitiveLabelsArgs'] sensitive_labels: Different notification type behaviors are configured primarily using the the `labels` field on this
               resource. This block contains the labels which contain secrets or passwords so that they can be marked
               sensitive and hidden from plan output. The name of the field, eg: password, will be the key
               in the `labels` map in the api request.
               Credentials may not be specified in both locations and will cause an error. Changing from one location
               to a different credential configuration in the config will require an apply to update state.
               Structure is documented below.
        :param pulumi.Input[str] type: The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        :param pulumi.Input[str] verification_status: Indicates whether this channel has been verified or not. On a ListNotificationChannels or GetNotificationChannel operation, this field is expected to be populated.If the value is UNVERIFIED, then it indicates that the channel is non-functioning (it both requires verification and lacks verification); otherwise, it is assumed that the channel works.If the channel is neither VERIFIED nor UNVERIFIED, it implies that the channel is of a type that does not require verification or that this specific channel has been exempted from verification because it was created prior to verification being required for channels of this type.This field cannot be modified using a standard UpdateNotificationChannel operation. To change the value of this field, you must call VerifyNotificationChannel.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sensitive_labels is not None:
            pulumi.set(__self__, "sensitive_labels", sensitive_labels)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if verification_status is not None:
            pulumi.set(__self__, "verification_status", verification_status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the notification channel will be deleted regardless
        of its use in alert policies (the policies will be updated
        to remove the channel). If false, channels that are still
        referenced by an existing alerting policy will fail to be
        deleted in a delete operation.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configuration fields that define the channel and its behavior. The
        permissible and required labels are specified in the
        NotificationChannelDescriptor corresponding to the type field.
        Labels with sensitive data are obfuscated by the API and therefore the provider cannot
        determine if there are upstream changes to these fields. They can also be configured via
        the sensitive_labels block, but cannot be configured in both places.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The full REST resource name for this channel. The syntax is:
        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
        The [CHANNEL_ID] is automatically assigned by the server on creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sensitiveLabels")
    def sensitive_labels(self) -> Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']]:
        """
        Different notification type behaviors are configured primarily using the the `labels` field on this
        resource. This block contains the labels which contain secrets or passwords so that they can be marked
        sensitive and hidden from plan output. The name of the field, eg: password, will be the key
        in the `labels` map in the api request.
        Credentials may not be specified in both locations and will cause an error. Changing from one location
        to a different credential configuration in the config will require an apply to update state.
        Structure is documented below.
        """
        return pulumi.get(self, "sensitive_labels")

    @sensitive_labels.setter
    def sensitive_labels(self, value: Optional[pulumi.Input['NotificationChannelSensitiveLabelsArgs']]):
        pulumi.set(self, "sensitive_labels", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter(name="verificationStatus")
    def verification_status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether this channel has been verified or not. On a ListNotificationChannels or GetNotificationChannel operation, this field is expected to be populated.If the value is UNVERIFIED, then it indicates that the channel is non-functioning (it both requires verification and lacks verification); otherwise, it is assumed that the channel works.If the channel is neither VERIFIED nor UNVERIFIED, it implies that the channel is of a type that does not require verification or that this specific channel has been exempted from verification because it was created prior to verification being required for channels of this type.This field cannot be modified using a standard UpdateNotificationChannel operation. To change the value of this field, you must call VerifyNotificationChannel.
        """
        return pulumi.get(self, "verification_status")

    @verification_status.setter
    def verification_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_status", value)


class NotificationChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sensitive_labels: Optional[pulumi.Input[Union['NotificationChannelSensitiveLabelsArgs', 'NotificationChannelSensitiveLabelsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        A NotificationChannel is a medium through which an alert is delivered
        when a policy violation is detected. Examples of channels include email, SMS,
        and third-party messaging applications. Fields containing sensitive information
        like authentication tokens or contact info are only partially populated on retrieval.

        Notification Channels are designed to be flexible and are made up of a supported `type`
        and labels to configure that channel. Each `type` has specific labels that need to be
        present for that channel to be correctly configured. The labels that are required to be
        present for one channel `type` are often different than those required for another.
        Due to these loose constraints it's often best to set up a channel through the UI
        and import it to the provider when setting up a brand new channel type to determine which
        labels are required.

        A list of supported channels per project the `list` endpoint can be
        accessed programmatically or through the api explorer at  https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list .
        This provides the channel type and all of the required labels that must be passed.

        To get more information about NotificationChannel, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannels)
        * How-to Guides
            * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)
            * [Notification Options](https://cloud.google.com/monitoring/support/notification-options)

        ## Example Usage

        ### Notification Channel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.NotificationChannel("basic",
            display_name="Test Notification Channel",
            type="email",
            labels={
                "email_address": "fake_email@blahblah.com",
            },
            force_delete=False)
        ```
        ### Notification Channel Sensitive

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.monitoring.NotificationChannel("default",
            display_name="Test Slack Channel",
            type="slack",
            labels={
                "channel_name": "#foobar",
            },
            sensitive_labels={
                "auth_token": "one",
            })
        ```

        ## Import

        NotificationChannel can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, NotificationChannel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/notificationChannel:NotificationChannel default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        :param pulumi.Input[str] display_name: An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        :param pulumi.Input[bool] enabled: Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        :param pulumi.Input[bool] force_delete: If true, the notification channel will be deleted regardless
               of its use in alert policies (the policies will be updated
               to remove the channel). If false, channels that are still
               referenced by an existing alerting policy will fail to be
               deleted in a delete operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Configuration fields that define the channel and its behavior. The
               permissible and required labels are specified in the
               NotificationChannelDescriptor corresponding to the type field.
               Labels with sensitive data are obfuscated by the API and therefore the provider cannot
               determine if there are upstream changes to these fields. They can also be configured via
               the sensitive_labels block, but cannot be configured in both places.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['NotificationChannelSensitiveLabelsArgs', 'NotificationChannelSensitiveLabelsArgsDict']] sensitive_labels: Different notification type behaviors are configured primarily using the the `labels` field on this
               resource. This block contains the labels which contain secrets or passwords so that they can be marked
               sensitive and hidden from plan output. The name of the field, eg: password, will be the key
               in the `labels` map in the api request.
               Credentials may not be specified in both locations and will cause an error. Changing from one location
               to a different credential configuration in the config will require an apply to update state.
               Structure is documented below.
        :param pulumi.Input[str] type: The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A NotificationChannel is a medium through which an alert is delivered
        when a policy violation is detected. Examples of channels include email, SMS,
        and third-party messaging applications. Fields containing sensitive information
        like authentication tokens or contact info are only partially populated on retrieval.

        Notification Channels are designed to be flexible and are made up of a supported `type`
        and labels to configure that channel. Each `type` has specific labels that need to be
        present for that channel to be correctly configured. The labels that are required to be
        present for one channel `type` are often different than those required for another.
        Due to these loose constraints it's often best to set up a channel through the UI
        and import it to the provider when setting up a brand new channel type to determine which
        labels are required.

        A list of supported channels per project the `list` endpoint can be
        accessed programmatically or through the api explorer at  https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list .
        This provides the channel type and all of the required labels that must be passed.

        To get more information about NotificationChannel, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannels)
        * How-to Guides
            * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)
            * [Notification Options](https://cloud.google.com/monitoring/support/notification-options)

        ## Example Usage

        ### Notification Channel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.NotificationChannel("basic",
            display_name="Test Notification Channel",
            type="email",
            labels={
                "email_address": "fake_email@blahblah.com",
            },
            force_delete=False)
        ```
        ### Notification Channel Sensitive

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.monitoring.NotificationChannel("default",
            display_name="Test Slack Channel",
            type="slack",
            labels={
                "channel_name": "#foobar",
            },
            sensitive_labels={
                "auth_token": "one",
            })
        ```

        ## Import

        NotificationChannel can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, NotificationChannel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/notificationChannel:NotificationChannel default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NotificationChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sensitive_labels: Optional[pulumi.Input[Union['NotificationChannelSensitiveLabelsArgs', 'NotificationChannelSensitiveLabelsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationChannelArgs.__new__(NotificationChannelArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["labels"] = labels
            __props__.__dict__["project"] = project
            __props__.__dict__["sensitive_labels"] = sensitive_labels
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_labels"] = user_labels
            __props__.__dict__["name"] = None
            __props__.__dict__["verification_status"] = None
        super(NotificationChannel, __self__).__init__(
            'gcp:monitoring/notificationChannel:NotificationChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            sensitive_labels: Optional[pulumi.Input[Union['NotificationChannelSensitiveLabelsArgs', 'NotificationChannelSensitiveLabelsArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            verification_status: Optional[pulumi.Input[str]] = None) -> 'NotificationChannel':
        """
        Get an existing NotificationChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        :param pulumi.Input[str] display_name: An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        :param pulumi.Input[bool] enabled: Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        :param pulumi.Input[bool] force_delete: If true, the notification channel will be deleted regardless
               of its use in alert policies (the policies will be updated
               to remove the channel). If false, channels that are still
               referenced by an existing alerting policy will fail to be
               deleted in a delete operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Configuration fields that define the channel and its behavior. The
               permissible and required labels are specified in the
               NotificationChannelDescriptor corresponding to the type field.
               Labels with sensitive data are obfuscated by the API and therefore the provider cannot
               determine if there are upstream changes to these fields. They can also be configured via
               the sensitive_labels block, but cannot be configured in both places.
        :param pulumi.Input[str] name: The full REST resource name for this channel. The syntax is:
               projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
               The [CHANNEL_ID] is automatically assigned by the server on creation.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['NotificationChannelSensitiveLabelsArgs', 'NotificationChannelSensitiveLabelsArgsDict']] sensitive_labels: Different notification type behaviors are configured primarily using the the `labels` field on this
               resource. This block contains the labels which contain secrets or passwords so that they can be marked
               sensitive and hidden from plan output. The name of the field, eg: password, will be the key
               in the `labels` map in the api request.
               Credentials may not be specified in both locations and will cause an error. Changing from one location
               to a different credential configuration in the config will require an apply to update state.
               Structure is documented below.
        :param pulumi.Input[str] type: The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        :param pulumi.Input[str] verification_status: Indicates whether this channel has been verified or not. On a ListNotificationChannels or GetNotificationChannel operation, this field is expected to be populated.If the value is UNVERIFIED, then it indicates that the channel is non-functioning (it both requires verification and lacks verification); otherwise, it is assumed that the channel works.If the channel is neither VERIFIED nor UNVERIFIED, it implies that the channel is of a type that does not require verification or that this specific channel has been exempted from verification because it was created prior to verification being required for channels of this type.This field cannot be modified using a standard UpdateNotificationChannel operation. To change the value of this field, you must call VerifyNotificationChannel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationChannelState.__new__(_NotificationChannelState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["sensitive_labels"] = sensitive_labels
        __props__.__dict__["type"] = type
        __props__.__dict__["user_labels"] = user_labels
        __props__.__dict__["verification_status"] = verification_status
        return NotificationChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the notification channel will be deleted regardless
        of its use in alert policies (the policies will be updated
        to remove the channel). If false, channels that are still
        referenced by an existing alerting policy will fail to be
        deleted in a delete operation.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Configuration fields that define the channel and its behavior. The
        permissible and required labels are specified in the
        NotificationChannelDescriptor corresponding to the type field.
        Labels with sensitive data are obfuscated by the API and therefore the provider cannot
        determine if there are upstream changes to these fields. They can also be configured via
        the sensitive_labels block, but cannot be configured in both places.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The full REST resource name for this channel. The syntax is:
        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
        The [CHANNEL_ID] is automatically assigned by the server on creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sensitiveLabels")
    def sensitive_labels(self) -> pulumi.Output[Optional['outputs.NotificationChannelSensitiveLabels']]:
        """
        Different notification type behaviors are configured primarily using the the `labels` field on this
        resource. This block contains the labels which contain secrets or passwords so that they can be marked
        sensitive and hidden from plan output. The name of the field, eg: password, will be the key
        in the `labels` map in the api request.
        Credentials may not be specified in both locations and will cause an error. Changing from one location
        to a different credential configuration in the config will require an apply to update state.
        Structure is documented below.
        """
        return pulumi.get(self, "sensitive_labels")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...


        - - -
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter(name="verificationStatus")
    def verification_status(self) -> pulumi.Output[str]:
        """
        Indicates whether this channel has been verified or not. On a ListNotificationChannels or GetNotificationChannel operation, this field is expected to be populated.If the value is UNVERIFIED, then it indicates that the channel is non-functioning (it both requires verification and lacks verification); otherwise, it is assumed that the channel works.If the channel is neither VERIFIED nor UNVERIFIED, it implies that the channel is of a type that does not require verification or that this specific channel has been exempted from verification because it was created prior to verification being required for channels of this type.This field cannot be modified using a standard UpdateNotificationChannel operation. To change the value of this field, you must call VerifyNotificationChannel.
        """
        return pulumi.get(self, "verification_status")

