# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SloArgs', 'Slo']

@pulumi.input_type
class SloArgs:
    def __init__(__self__, *,
                 goal: pulumi.Input[float],
                 service: pulumi.Input[str],
                 basic_sli: Optional[pulumi.Input['SloBasicSliArgs']] = None,
                 calendar_period: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input['SloRequestBasedSliArgs']] = None,
                 rolling_period_days: Optional[pulumi.Input[int]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_based_sli: Optional[pulumi.Input['SloWindowsBasedSliArgs']] = None):
        """
        The set of arguments for constructing a Slo resource.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
               
               
               - - -
        :param pulumi.Input['SloBasicSliArgs'] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
               Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SloRequestBasedSliArgs'] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[int] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        :param pulumi.Input['SloWindowsBasedSliArgs'] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "service", service)
        if basic_sli is not None:
            pulumi.set(__self__, "basic_sli", basic_sli)
        if calendar_period is not None:
            pulumi.set(__self__, "calendar_period", calendar_period)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_based_sli is not None:
            pulumi.set(__self__, "request_based_sli", request_based_sli)
        if rolling_period_days is not None:
            pulumi.set(__self__, "rolling_period_days", rolling_period_days)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if windows_based_sli is not None:
            pulumi.set(__self__, "windows_based_sli", windows_based_sli)

    @property
    @pulumi.getter
    def goal(self) -> pulumi.Input[float]:
        """
        The fraction of service that must be good in order for this objective
        to be met. 0 < goal <= 0.999
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: pulumi.Input[float]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        ID of the service to which this SLO belongs.


        - - -
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="basicSli")
    def basic_sli(self) -> Optional[pulumi.Input['SloBasicSliArgs']]:
        """
        Basic Service-Level Indicator (SLI) on a well-known service type.
        Performance will be computed on the basis of pre-defined metrics.
        SLIs are used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "basic_sli")

    @basic_sli.setter
    def basic_sli(self, value: Optional[pulumi.Input['SloBasicSliArgs']]):
        pulumi.set(self, "basic_sli", value)

    @property
    @pulumi.getter(name="calendarPeriod")
    def calendar_period(self) -> Optional[pulumi.Input[str]]:
        """
        A calendar period, semantically "since the start of the current
        <calendarPeriod>".
        Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        """
        return pulumi.get(self, "calendar_period")

    @calendar_period.setter
    def calendar_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "calendar_period", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name used for UI elements listing this SLO.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> Optional[pulumi.Input['SloRequestBasedSliArgs']]:
        """
        A request-based SLI defines a SLI for which atomic units of
        service are counted directly.
        A SLI describes a good service.
        It is used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "request_based_sli")

    @request_based_sli.setter
    def request_based_sli(self, value: Optional[pulumi.Input['SloRequestBasedSliArgs']]):
        pulumi.set(self, "request_based_sli", value)

    @property
    @pulumi.getter(name="rollingPeriodDays")
    def rolling_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        A rolling time period, semantically "in the past X days".
        Must be between 1 to 30 days, inclusive.
        """
        return pulumi.get(self, "rolling_period_days")

    @rolling_period_days.setter
    def rolling_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rolling_period_days", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slo_id", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter(name="windowsBasedSli")
    def windows_based_sli(self) -> Optional[pulumi.Input['SloWindowsBasedSliArgs']]:
        """
        A windows-based SLI defines the criteria for time windows.
        good_service is defined based off the count of these time windows
        for which the provided service was of good quality.
        A SLI describes a good service. It is used to measure and calculate
        the quality of the Service's performance with respect to a single
        aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "windows_based_sli")

    @windows_based_sli.setter
    def windows_based_sli(self, value: Optional[pulumi.Input['SloWindowsBasedSliArgs']]):
        pulumi.set(self, "windows_based_sli", value)


@pulumi.input_type
class _SloState:
    def __init__(__self__, *,
                 basic_sli: Optional[pulumi.Input['SloBasicSliArgs']] = None,
                 calendar_period: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input['SloRequestBasedSliArgs']] = None,
                 rolling_period_days: Optional[pulumi.Input[int]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_based_sli: Optional[pulumi.Input['SloWindowsBasedSliArgs']] = None):
        """
        Input properties used for looking up and filtering Slo resources.
        :param pulumi.Input['SloBasicSliArgs'] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
               Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] name: The full resource name for this service. The syntax is:
               projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SloRequestBasedSliArgs'] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[int] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
               
               
               - - -
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        :param pulumi.Input['SloWindowsBasedSliArgs'] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        """
        if basic_sli is not None:
            pulumi.set(__self__, "basic_sli", basic_sli)
        if calendar_period is not None:
            pulumi.set(__self__, "calendar_period", calendar_period)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if goal is not None:
            pulumi.set(__self__, "goal", goal)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_based_sli is not None:
            pulumi.set(__self__, "request_based_sli", request_based_sli)
        if rolling_period_days is not None:
            pulumi.set(__self__, "rolling_period_days", rolling_period_days)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if windows_based_sli is not None:
            pulumi.set(__self__, "windows_based_sli", windows_based_sli)

    @property
    @pulumi.getter(name="basicSli")
    def basic_sli(self) -> Optional[pulumi.Input['SloBasicSliArgs']]:
        """
        Basic Service-Level Indicator (SLI) on a well-known service type.
        Performance will be computed on the basis of pre-defined metrics.
        SLIs are used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "basic_sli")

    @basic_sli.setter
    def basic_sli(self, value: Optional[pulumi.Input['SloBasicSliArgs']]):
        pulumi.set(self, "basic_sli", value)

    @property
    @pulumi.getter(name="calendarPeriod")
    def calendar_period(self) -> Optional[pulumi.Input[str]]:
        """
        A calendar period, semantically "since the start of the current
        <calendarPeriod>".
        Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        """
        return pulumi.get(self, "calendar_period")

    @calendar_period.setter
    def calendar_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "calendar_period", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name used for UI elements listing this SLO.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def goal(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of service that must be good in order for this objective
        to be met. 0 < goal <= 0.999
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name for this service. The syntax is:
        projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> Optional[pulumi.Input['SloRequestBasedSliArgs']]:
        """
        A request-based SLI defines a SLI for which atomic units of
        service are counted directly.
        A SLI describes a good service.
        It is used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "request_based_sli")

    @request_based_sli.setter
    def request_based_sli(self, value: Optional[pulumi.Input['SloRequestBasedSliArgs']]):
        pulumi.set(self, "request_based_sli", value)

    @property
    @pulumi.getter(name="rollingPeriodDays")
    def rolling_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        A rolling time period, semantically "in the past X days".
        Must be between 1 to 30 days, inclusive.
        """
        return pulumi.get(self, "rolling_period_days")

    @rolling_period_days.setter
    def rolling_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rolling_period_days", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the service to which this SLO belongs.


        - - -
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slo_id", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter(name="windowsBasedSli")
    def windows_based_sli(self) -> Optional[pulumi.Input['SloWindowsBasedSliArgs']]:
        """
        A windows-based SLI defines the criteria for time windows.
        good_service is defined based off the count of these time windows
        for which the provided service was of good quality.
        A SLI describes a good service. It is used to measure and calculate
        the quality of the Service's performance with respect to a single
        aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "windows_based_sli")

    @windows_based_sli.setter
    def windows_based_sli(self, value: Optional[pulumi.Input['SloWindowsBasedSliArgs']]):
        pulumi.set(self, "windows_based_sli", value)


class Slo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_sli: Optional[pulumi.Input[Union['SloBasicSliArgs', 'SloBasicSliArgsDict']]] = None,
                 calendar_period: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input[float]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input[Union['SloRequestBasedSliArgs', 'SloRequestBasedSliArgsDict']]] = None,
                 rolling_period_days: Optional[pulumi.Input[int]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_based_sli: Optional[pulumi.Input[Union['SloWindowsBasedSliArgs', 'SloWindowsBasedSliArgsDict']]] = None,
                 __props__=None):
        """
        A Service-Level Objective (SLO) describes the level of desired good
        service. It consists of a service-level indicator (SLI), a performance
        goal, and a period over which the objective is to be evaluated against
        that goal. The SLO can use SLIs defined in a number of different manners.
        Typical SLOs might include "99% of requests in each rolling week have
        latency below 200 milliseconds" or "99.5% of requests in each calendar
        month return successfully."

        To get more information about Slo, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services.serviceLevelObjectives)
        * How-to Guides
            * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)
            * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)

        ## Example Usage

        ### Monitoring Slo Appengine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.monitoring.get_app_engine_service(module_id="default")
        appeng_slo = gcp.monitoring.Slo("appeng_slo",
            service=default.service_id,
            slo_id="ae-slo",
            display_name="Test SLO for App Engine",
            goal=0.9,
            calendar_period="DAY",
            basic_sli={
                "latency": {
                    "threshold": "1s",
                },
            },
            user_labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            })
        ```
        ### Monitoring Slo Request Based

        ```python
        import pulumi
        import pulumi_gcp as gcp

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-request-slos",
            display_name="My Custom Service")
        request_based_slo = gcp.monitoring.Slo("request_based_slo",
            service=customsrv.service_id,
            slo_id="consumed-api-slo",
            display_name="Test SLO with request based SLI (good total ratio)",
            goal=0.9,
            rolling_period_days=30,
            request_based_sli={
                "distribution_cut": {
                    "distribution_filter": "metric.type=\\"serviceruntime.googleapis.com/api/request_latencies\\" resource.type=\\"api\\"  ",
                    "range": {
                        "max": 0.5,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Good Bad Metric Filter

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.95,
            calendar_period="FORTNIGHT",
            windows_based_sli={
                "window_period": "400s",
                "good_bad_metric_filter": std.join(separator=" AND ",
                    input=[
                        "metric.type=\\"monitoring.googleapis.com/uptime_check/check_passed\\"",
                        "resource.type=\\"uptime_url\\"",
                    ]).result,
            })
        ```
        ### Monitoring Slo Windows Based Metric Mean

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "600s",
                "metric_mean_in_range": {
                    "time_series": std.join(separator=" AND ",
                        input=[
                            "metric.type=\\"agent.googleapis.com/cassandra/client_request/latency/95p\\"",
                            "resource.type=\\"gce_instance\\"",
                        ]).result,
                    "range": {
                        "max": 5,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Metric Sum

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "400s",
                "metric_sum_in_range": {
                    "time_series": std.join(separator=" AND ",
                        input=[
                            "metric.type=\\"monitoring.googleapis.com/uptime_check/request_latency\\"",
                            "resource.type=\\"uptime_url\\"",
                        ]).result,
                    "range": {
                        "max": 5000,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Ratio Threshold

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "100s",
                "good_total_ratio_threshold": {
                    "threshold": 0.1,
                    "performance": {
                        "distribution_cut": {
                            "distribution_filter": std.join(separator=" AND ",
                                input=[
                                    "metric.type=\\"serviceruntime.googleapis.com/api/request_latencies\\"",
                                    "resource.type=\\"consumed_api\\"",
                                ]).result,
                            "range": {
                                "min": 1,
                                "max": 9,
                            },
                        },
                    },
                },
            })
        ```

        ## Import

        Slo can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Slo can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/slo:Slo default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SloBasicSliArgs', 'SloBasicSliArgsDict']] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
               Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SloRequestBasedSliArgs', 'SloRequestBasedSliArgsDict']] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[int] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
               
               
               - - -
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        :param pulumi.Input[Union['SloWindowsBasedSliArgs', 'SloWindowsBasedSliArgsDict']] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SloArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Service-Level Objective (SLO) describes the level of desired good
        service. It consists of a service-level indicator (SLI), a performance
        goal, and a period over which the objective is to be evaluated against
        that goal. The SLO can use SLIs defined in a number of different manners.
        Typical SLOs might include "99% of requests in each rolling week have
        latency below 200 milliseconds" or "99.5% of requests in each calendar
        month return successfully."

        To get more information about Slo, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services.serviceLevelObjectives)
        * How-to Guides
            * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)
            * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)

        ## Example Usage

        ### Monitoring Slo Appengine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.monitoring.get_app_engine_service(module_id="default")
        appeng_slo = gcp.monitoring.Slo("appeng_slo",
            service=default.service_id,
            slo_id="ae-slo",
            display_name="Test SLO for App Engine",
            goal=0.9,
            calendar_period="DAY",
            basic_sli={
                "latency": {
                    "threshold": "1s",
                },
            },
            user_labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            })
        ```
        ### Monitoring Slo Request Based

        ```python
        import pulumi
        import pulumi_gcp as gcp

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-request-slos",
            display_name="My Custom Service")
        request_based_slo = gcp.monitoring.Slo("request_based_slo",
            service=customsrv.service_id,
            slo_id="consumed-api-slo",
            display_name="Test SLO with request based SLI (good total ratio)",
            goal=0.9,
            rolling_period_days=30,
            request_based_sli={
                "distribution_cut": {
                    "distribution_filter": "metric.type=\\"serviceruntime.googleapis.com/api/request_latencies\\" resource.type=\\"api\\"  ",
                    "range": {
                        "max": 0.5,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Good Bad Metric Filter

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.95,
            calendar_period="FORTNIGHT",
            windows_based_sli={
                "window_period": "400s",
                "good_bad_metric_filter": std.join(separator=" AND ",
                    input=[
                        "metric.type=\\"monitoring.googleapis.com/uptime_check/check_passed\\"",
                        "resource.type=\\"uptime_url\\"",
                    ]).result,
            })
        ```
        ### Monitoring Slo Windows Based Metric Mean

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "600s",
                "metric_mean_in_range": {
                    "time_series": std.join(separator=" AND ",
                        input=[
                            "metric.type=\\"agent.googleapis.com/cassandra/client_request/latency/95p\\"",
                            "resource.type=\\"gce_instance\\"",
                        ]).result,
                    "range": {
                        "max": 5,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Metric Sum

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "400s",
                "metric_sum_in_range": {
                    "time_series": std.join(separator=" AND ",
                        input=[
                            "metric.type=\\"monitoring.googleapis.com/uptime_check/request_latency\\"",
                            "resource.type=\\"uptime_url\\"",
                        ]).result,
                    "range": {
                        "max": 5000,
                    },
                },
            })
        ```
        ### Monitoring Slo Windows Based Ratio Threshold

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        customsrv = gcp.monitoring.CustomService("customsrv",
            service_id="custom-srv-windows-slos",
            display_name="My Custom Service")
        windows_based = gcp.monitoring.Slo("windows_based",
            service=customsrv.service_id,
            display_name="Test SLO with window based SLI",
            goal=0.9,
            rolling_period_days=20,
            windows_based_sli={
                "window_period": "100s",
                "good_total_ratio_threshold": {
                    "threshold": 0.1,
                    "performance": {
                        "distribution_cut": {
                            "distribution_filter": std.join(separator=" AND ",
                                input=[
                                    "metric.type=\\"serviceruntime.googleapis.com/api/request_latencies\\"",
                                    "resource.type=\\"consumed_api\\"",
                                ]).result,
                            "range": {
                                "min": 1,
                                "max": 9,
                            },
                        },
                    },
                },
            })
        ```

        ## Import

        Slo can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Slo can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/slo:Slo default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SloArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SloArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_sli: Optional[pulumi.Input[Union['SloBasicSliArgs', 'SloBasicSliArgsDict']]] = None,
                 calendar_period: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input[float]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input[Union['SloRequestBasedSliArgs', 'SloRequestBasedSliArgsDict']]] = None,
                 rolling_period_days: Optional[pulumi.Input[int]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 windows_based_sli: Optional[pulumi.Input[Union['SloWindowsBasedSliArgs', 'SloWindowsBasedSliArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SloArgs.__new__(SloArgs)

            __props__.__dict__["basic_sli"] = basic_sli
            __props__.__dict__["calendar_period"] = calendar_period
            __props__.__dict__["display_name"] = display_name
            if goal is None and not opts.urn:
                raise TypeError("Missing required property 'goal'")
            __props__.__dict__["goal"] = goal
            __props__.__dict__["project"] = project
            __props__.__dict__["request_based_sli"] = request_based_sli
            __props__.__dict__["rolling_period_days"] = rolling_period_days
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["slo_id"] = slo_id
            __props__.__dict__["user_labels"] = user_labels
            __props__.__dict__["windows_based_sli"] = windows_based_sli
            __props__.__dict__["name"] = None
        super(Slo, __self__).__init__(
            'gcp:monitoring/slo:Slo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            basic_sli: Optional[pulumi.Input[Union['SloBasicSliArgs', 'SloBasicSliArgsDict']]] = None,
            calendar_period: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            goal: Optional[pulumi.Input[float]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            request_based_sli: Optional[pulumi.Input[Union['SloRequestBasedSliArgs', 'SloRequestBasedSliArgsDict']]] = None,
            rolling_period_days: Optional[pulumi.Input[int]] = None,
            service: Optional[pulumi.Input[str]] = None,
            slo_id: Optional[pulumi.Input[str]] = None,
            user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            windows_based_sli: Optional[pulumi.Input[Union['SloWindowsBasedSliArgs', 'SloWindowsBasedSliArgsDict']]] = None) -> 'Slo':
        """
        Get an existing Slo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SloBasicSliArgs', 'SloBasicSliArgsDict']] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
               Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] name: The full resource name for this service. The syntax is:
               projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SloRequestBasedSliArgs', 'SloRequestBasedSliArgsDict']] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        :param pulumi.Input[int] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
               
               
               - - -
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        :param pulumi.Input[Union['SloWindowsBasedSliArgs', 'SloWindowsBasedSliArgsDict']] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SloState.__new__(_SloState)

        __props__.__dict__["basic_sli"] = basic_sli
        __props__.__dict__["calendar_period"] = calendar_period
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["goal"] = goal
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["request_based_sli"] = request_based_sli
        __props__.__dict__["rolling_period_days"] = rolling_period_days
        __props__.__dict__["service"] = service
        __props__.__dict__["slo_id"] = slo_id
        __props__.__dict__["user_labels"] = user_labels
        __props__.__dict__["windows_based_sli"] = windows_based_sli
        return Slo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="basicSli")
    def basic_sli(self) -> pulumi.Output[Optional['outputs.SloBasicSli']]:
        """
        Basic Service-Level Indicator (SLI) on a well-known service type.
        Performance will be computed on the basis of pre-defined metrics.
        SLIs are used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "basic_sli")

    @property
    @pulumi.getter(name="calendarPeriod")
    def calendar_period(self) -> pulumi.Output[Optional[str]]:
        """
        A calendar period, semantically "since the start of the current
        <calendarPeriod>".
        Possible values are: `DAY`, `WEEK`, `FORTNIGHT`, `MONTH`.
        """
        return pulumi.get(self, "calendar_period")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name used for UI elements listing this SLO.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def goal(self) -> pulumi.Output[float]:
        """
        The fraction of service that must be good in order for this objective
        to be met. 0 < goal <= 0.999
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The full resource name for this service. The syntax is:
        projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> pulumi.Output[Optional['outputs.SloRequestBasedSli']]:
        """
        A request-based SLI defines a SLI for which atomic units of
        service are counted directly.
        A SLI describes a good service.
        It is used to measure and calculate the quality of the Service's
        performance with respect to a single aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "request_based_sli")

    @property
    @pulumi.getter(name="rollingPeriodDays")
    def rolling_period_days(self) -> pulumi.Output[Optional[int]]:
        """
        A rolling time period, semantically "in the past X days".
        Must be between 1 to 30 days, inclusive.
        """
        return pulumi.get(self, "rolling_period_days")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        ID of the service to which this SLO belongs.


        - - -
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Output[str]:
        """
        The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        """
        return pulumi.get(self, "slo_id")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter(name="windowsBasedSli")
    def windows_based_sli(self) -> pulumi.Output[Optional['outputs.SloWindowsBasedSli']]:
        """
        A windows-based SLI defines the criteria for time windows.
        good_service is defined based off the count of these time windows
        for which the provided service was of good quality.
        A SLI describes a good service. It is used to measure and calculate
        the quality of the Service's performance with respect to a single
        aspect of service quality.
        Exactly one of the following must be set:
        `basic_sli`, `request_based_sli`, `windows_based_sli`
        Structure is documented below.
        """
        return pulumi.get(self, "windows_based_sli")

