# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'VolumeBackupConfigArgs',
    'VolumeBackupConfigArgsDict',
    'VolumeExportPolicyArgs',
    'VolumeExportPolicyArgsDict',
    'VolumeExportPolicyRuleArgs',
    'VolumeExportPolicyRuleArgsDict',
    'VolumeMountOptionArgs',
    'VolumeMountOptionArgsDict',
    'VolumeReplicationDestinationVolumeParametersArgs',
    'VolumeReplicationDestinationVolumeParametersArgsDict',
    'VolumeReplicationTransferStatArgs',
    'VolumeReplicationTransferStatArgsDict',
    'VolumeRestoreParametersArgs',
    'VolumeRestoreParametersArgsDict',
    'VolumeSnapshotPolicyArgs',
    'VolumeSnapshotPolicyArgsDict',
    'VolumeSnapshotPolicyDailyScheduleArgs',
    'VolumeSnapshotPolicyDailyScheduleArgsDict',
    'VolumeSnapshotPolicyHourlyScheduleArgs',
    'VolumeSnapshotPolicyHourlyScheduleArgsDict',
    'VolumeSnapshotPolicyMonthlyScheduleArgs',
    'VolumeSnapshotPolicyMonthlyScheduleArgsDict',
    'VolumeSnapshotPolicyWeeklyScheduleArgs',
    'VolumeSnapshotPolicyWeeklyScheduleArgsDict',
    'VolumeTieringPolicyArgs',
    'VolumeTieringPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class VolumeBackupConfigArgsDict(TypedDict):
        backup_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        backup_vault: NotRequired[pulumi.Input[str]]
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        scheduled_backup_enabled: NotRequired[pulumi.Input[bool]]
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
elif False:
    VolumeBackupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeBackupConfigArgs:
    def __init__(__self__, *,
                 backup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_vault: Optional[pulumi.Input[str]] = None,
                 scheduled_backup_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_policies: Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        :param pulumi.Input[str] backup_vault: ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
               Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        :param pulumi.Input[bool] scheduled_backup_enabled: When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if scheduled_backup_enabled is not None:
            pulumi.set(__self__, "scheduled_backup_enabled", scheduled_backup_enabled)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        return pulumi.get(self, "backup_policies")

    @backup_policies.setter
    def backup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_policies", value)

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        return pulumi.get(self, "backup_vault")

    @backup_vault.setter
    def backup_vault(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_vault", value)

    @property
    @pulumi.getter(name="scheduledBackupEnabled")
    def scheduled_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        return pulumi.get(self, "scheduled_backup_enabled")

    @scheduled_backup_enabled.setter
    def scheduled_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scheduled_backup_enabled", value)


if not MYPY:
    class VolumeExportPolicyArgsDict(TypedDict):
        rules: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgsDict']]]
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
elif False:
    VolumeExportPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeExportPolicyArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]] rules: Export rules (up to 5) control NFS volume access.
               Structure is documented below.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]:
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class VolumeExportPolicyRuleArgsDict(TypedDict):
        access_type: NotRequired[pulumi.Input[str]]
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        allowed_clients: NotRequired[pulumi.Input[str]]
        """
        Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
        """
        has_root_access: NotRequired[pulumi.Input[str]]
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        """
        kerberos5_read_only: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        kerberos5_read_write: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        kerberos5i_read_only: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        kerberos5i_read_write: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        kerberos5p_read_only: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        kerberos5p_read_write: NotRequired[pulumi.Input[bool]]
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        nfsv3: NotRequired[pulumi.Input[bool]]
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        nfsv4: NotRequired[pulumi.Input[bool]]
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
elif False:
    VolumeExportPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeExportPolicyRuleArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[str]] = None,
                 allowed_clients: Optional[pulumi.Input[str]] = None,
                 has_root_access: Optional[pulumi.Input[str]] = None,
                 kerberos5_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5_read_write: Optional[pulumi.Input[bool]] = None,
                 kerberos5i_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5i_read_write: Optional[pulumi.Input[bool]] = None,
                 kerberos5p_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5p_read_write: Optional[pulumi.Input[bool]] = None,
                 nfsv3: Optional[pulumi.Input[bool]] = None,
                 nfsv4: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] access_type: Defines the access type for clients matching the `allowedClients` specification.
               Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        :param pulumi.Input[str] allowed_clients: Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
        :param pulumi.Input[str] has_root_access: If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        :param pulumi.Input[bool] kerberos5_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        :param pulumi.Input[bool] kerberos5_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[bool] kerberos5i_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        :param pulumi.Input[bool] kerberos5i_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[bool] kerberos5p_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        :param pulumi.Input[bool] kerberos5p_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        :param pulumi.Input[bool] nfsv3: Enable to apply the export rule to NFSV3 clients.
        :param pulumi.Input[bool] nfsv4: Enable to apply the export rule to NFSV4.1 clients.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv4 is not None:
            pulumi.set(__self__, "nfsv4", nfsv4)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[pulumi.Input[str]]:
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        """
        return pulumi.get(self, "has_root_access")

    @has_root_access.setter
    def has_root_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "has_root_access", value)

    @property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5_read_only")

    @kerberos5_read_only.setter
    def kerberos5_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5_read_only", value)

    @property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5_read_write")

    @kerberos5_read_write.setter
    def kerberos5_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5_read_write", value)

    @property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @kerberos5i_read_only.setter
    def kerberos5i_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5i_read_only", value)

    @property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @kerberos5i_read_write.setter
    def kerberos5i_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5i_read_write", value)

    @property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @kerberos5p_read_only.setter
    def kerberos5p_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5p_read_only", value)

    @property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @kerberos5p_read_write.setter
    def kerberos5p_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5p_read_write", value)

    @property
    @pulumi.getter
    def nfsv3(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        return pulumi.get(self, "nfsv3")

    @nfsv3.setter
    def nfsv3(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfsv3", value)

    @property
    @pulumi.getter
    def nfsv4(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        return pulumi.get(self, "nfsv4")

    @nfsv4.setter
    def nfsv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfsv4", value)


if not MYPY:
    class VolumeMountOptionArgsDict(TypedDict):
        export: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Export path of the volume.
        """
        export_full: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        instructions: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Human-readable mount instructions.
        """
        protocol: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Protocol to mount with.
        """
elif False:
    VolumeMountOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeMountOptionArgs:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input[str]] = None,
                 export_full: Optional[pulumi.Input[str]] = None,
                 instructions: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] export: (Output)
               Export path of the volume.
        :param pulumi.Input[str] export_full: (Output)
               Full export path of the volume.
               Format for NFS volumes: `<export_ip>:/<shareName>`
               Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        :param pulumi.Input[str] instructions: (Output)
               Human-readable mount instructions.
        :param pulumi.Input[str] protocol: (Output)
               Protocol to mount with.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if export_full is not None:
            pulumi.set(__self__, "export_full", export_full)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Export path of the volume.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export", value)

    @property
    @pulumi.getter(name="exportFull")
    def export_full(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        return pulumi.get(self, "export_full")

    @export_full.setter
    def export_full(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_full", value)

    @property
    @pulumi.getter
    def instructions(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Human-readable mount instructions.
        """
        return pulumi.get(self, "instructions")

    @instructions.setter
    def instructions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instructions", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Protocol to mount with.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class VolumeReplicationDestinationVolumeParametersArgsDict(TypedDict):
        storage_pool: pulumi.Input[str]
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        description: NotRequired[pulumi.Input[str]]
        """
        Description for the destination volume.
        """
        share_name: NotRequired[pulumi.Input[str]]
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        volume_id: NotRequired[pulumi.Input[str]]
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
elif False:
    VolumeReplicationDestinationVolumeParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationDestinationVolumeParametersArgs:
    def __init__(__self__, *,
                 storage_pool: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] storage_pool: Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        :param pulumi.Input[str] description: Description for the destination volume.
        :param pulumi.Input[str] share_name: Share name for destination volume. If not specified, name of source volume's share name will be used.
        :param pulumi.Input[str] volume_id: Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        pulumi.set(__self__, "storage_pool", storage_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> pulumi.Input[str]:
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the destination volume.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[str]]:
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


if not MYPY:
    class VolumeReplicationTransferStatArgsDict(TypedDict):
        lag_duration: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        last_transfer_bytes: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        last_transfer_duration: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Time taken during last completed transfer.
        """
        last_transfer_end_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        last_transfer_error: NotRequired[pulumi.Input[str]]
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        total_transfer_duration: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        transfer_bytes: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        update_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
elif False:
    VolumeReplicationTransferStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeReplicationTransferStatArgs:
    def __init__(__self__, *,
                 lag_duration: Optional[pulumi.Input[str]] = None,
                 last_transfer_bytes: Optional[pulumi.Input[str]] = None,
                 last_transfer_duration: Optional[pulumi.Input[str]] = None,
                 last_transfer_end_time: Optional[pulumi.Input[str]] = None,
                 last_transfer_error: Optional[pulumi.Input[str]] = None,
                 total_transfer_duration: Optional[pulumi.Input[str]] = None,
                 transfer_bytes: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] lag_duration: (Output)
               The elapsed time since the creation of the snapshot on the source volume that was last replicated
               to the destination volume. Lag time represents the difference in age of the destination volume
               data in relation to the source volume data.
        :param pulumi.Input[str] last_transfer_bytes: (Output)
               Size of last completed transfer in bytes.
        :param pulumi.Input[str] last_transfer_duration: (Output)
               Time taken during last completed transfer.
        :param pulumi.Input[str] last_transfer_end_time: (Output)
               Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[str] last_transfer_error: (Output)
               A message describing the cause of the last transfer failure.
        :param pulumi.Input[str] total_transfer_duration: (Output)
               Cumulative time taken across all transfers for the replication relationship.
        :param pulumi.Input[str] transfer_bytes: (Output)
               Cumulative bytes transferred so far for the replication relationship.
        :param pulumi.Input[str] update_time: (Output)
               Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        if lag_duration is not None:
            pulumi.set(__self__, "lag_duration", lag_duration)
        if last_transfer_bytes is not None:
            pulumi.set(__self__, "last_transfer_bytes", last_transfer_bytes)
        if last_transfer_duration is not None:
            pulumi.set(__self__, "last_transfer_duration", last_transfer_duration)
        if last_transfer_end_time is not None:
            pulumi.set(__self__, "last_transfer_end_time", last_transfer_end_time)
        if last_transfer_error is not None:
            pulumi.set(__self__, "last_transfer_error", last_transfer_error)
        if total_transfer_duration is not None:
            pulumi.set(__self__, "total_transfer_duration", total_transfer_duration)
        if transfer_bytes is not None:
            pulumi.set(__self__, "transfer_bytes", transfer_bytes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="lagDuration")
    def lag_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        return pulumi.get(self, "lag_duration")

    @lag_duration.setter
    def lag_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lag_duration", value)

    @property
    @pulumi.getter(name="lastTransferBytes")
    def last_transfer_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        return pulumi.get(self, "last_transfer_bytes")

    @last_transfer_bytes.setter
    def last_transfer_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transfer_bytes", value)

    @property
    @pulumi.getter(name="lastTransferDuration")
    def last_transfer_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Time taken during last completed transfer.
        """
        return pulumi.get(self, "last_transfer_duration")

    @last_transfer_duration.setter
    def last_transfer_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transfer_duration", value)

    @property
    @pulumi.getter(name="lastTransferEndTime")
    def last_transfer_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "last_transfer_end_time")

    @last_transfer_end_time.setter
    def last_transfer_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transfer_end_time", value)

    @property
    @pulumi.getter(name="lastTransferError")
    def last_transfer_error(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        return pulumi.get(self, "last_transfer_error")

    @last_transfer_error.setter
    def last_transfer_error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transfer_error", value)

    @property
    @pulumi.getter(name="totalTransferDuration")
    def total_transfer_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        return pulumi.get(self, "total_transfer_duration")

    @total_transfer_duration.setter
    def total_transfer_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_transfer_duration", value)

    @property
    @pulumi.getter(name="transferBytes")
    def transfer_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        return pulumi.get(self, "transfer_bytes")

    @transfer_bytes.setter
    def transfer_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transfer_bytes", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


if not MYPY:
    class VolumeRestoreParametersArgsDict(TypedDict):
        source_backup: NotRequired[pulumi.Input[str]]
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        source_snapshot: NotRequired[pulumi.Input[str]]
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
elif False:
    VolumeRestoreParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeRestoreParametersArgs:
    def __init__(__self__, *,
                 source_backup: Optional[pulumi.Input[str]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_backup: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        :param pulumi.Input[str] source_snapshot: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        return pulumi.get(self, "source_backup")

    @source_backup.setter
    def source_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_backup", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot", value)


if not MYPY:
    class VolumeSnapshotPolicyArgsDict(TypedDict):
        daily_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgsDict']]
        """
        Daily schedule policy.
        Structure is documented below.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        hourly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgsDict']]
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        monthly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgsDict']]
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        weekly_schedule: NotRequired[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgsDict']]
        """
        Weekly schedule policy.
        Structure is documented below.
        """
elif False:
    VolumeSnapshotPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyArgs:
    def __init__(__self__, *,
                 daily_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 hourly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']] = None,
                 monthly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']] = None,
                 weekly_schedule: Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']] = None):
        """
        :param pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs'] daily_schedule: Daily schedule policy.
               Structure is documented below.
        :param pulumi.Input[bool] enabled: Enables automated snapshot creation according to defined schedule. Default is false.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        :param pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs'] hourly_schedule: Hourly schedule policy.
               Structure is documented below.
        :param pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs'] monthly_schedule: Monthly schedule policy.
               Structure is documented below.
        :param pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs'] weekly_schedule: Weekly schedule policy.
               Structure is documented below.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']]:
        """
        Daily schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyDailyScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']]:
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly_schedule")

    @hourly_schedule.setter
    def hourly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyHourlyScheduleArgs']]):
        pulumi.set(self, "hourly_schedule", value)

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']]:
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyMonthlyScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']]:
        """
        Weekly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyWeeklyScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


if not MYPY:
    class VolumeSnapshotPolicyDailyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[int]
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        hour: NotRequired[pulumi.Input[int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyDailyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyDailyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[int],
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] snapshots_to_keep: The maximum number of snapshots to keep for the daily schedule.
        :param pulumi.Input[int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[int]:
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyHourlyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[int]
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        minute: NotRequired[pulumi.Input[int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyHourlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyHourlyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[int],
                 minute: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] snapshots_to_keep: The maximum number of snapshots to keep for the hourly schedule.
        :param pulumi.Input[int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[int]:
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyMonthlyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[int]
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        days_of_month: NotRequired[pulumi.Input[str]]
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        hour: NotRequired[pulumi.Input[int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyMonthlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyMonthlyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[int],
                 days_of_month: Optional[pulumi.Input[str]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] snapshots_to_keep: The maximum number of snapshots to keep for the monthly schedule
        :param pulumi.Input[str] days_of_month: Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        :param pulumi.Input[int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[int]:
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[pulumi.Input[str]]:
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        return pulumi.get(self, "days_of_month")

    @days_of_month.setter
    def days_of_month(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "days_of_month", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeSnapshotPolicyWeeklyScheduleArgsDict(TypedDict):
        snapshots_to_keep: pulumi.Input[int]
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        day: NotRequired[pulumi.Input[str]]
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        hour: NotRequired[pulumi.Input[int]]
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        minute: NotRequired[pulumi.Input[int]]
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
elif False:
    VolumeSnapshotPolicyWeeklyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSnapshotPolicyWeeklyScheduleArgs:
    def __init__(__self__, *,
                 snapshots_to_keep: pulumi.Input[int],
                 day: Optional[pulumi.Input[str]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] snapshots_to_keep: The maximum number of snapshots to keep for the weekly schedule.
        :param pulumi.Input[str] day: Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        :param pulumi.Input[int] hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param pulumi.Input[int] minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[int]:
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[int]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[str]]:
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)


if not MYPY:
    class VolumeTieringPolicyArgsDict(TypedDict):
        cooling_threshold_days: NotRequired[pulumi.Input[int]]
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 7-183.
        Default is 31.
        """
        tier_action: NotRequired[pulumi.Input[str]]
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
elif False:
    VolumeTieringPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_threshold_days: Optional[pulumi.Input[int]] = None,
                 tier_action: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 7-183.
               Default is 31.
        :param pulumi.Input[str] tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 7-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @cooling_threshold_days.setter
    def cooling_threshold_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooling_threshold_days", value)

    @property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")

    @tier_action.setter
    def tier_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier_action", value)


