# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'VolumeBackupConfig',
    'VolumeExportPolicy',
    'VolumeExportPolicyRule',
    'VolumeMountOption',
    'VolumeReplicationDestinationVolumeParameters',
    'VolumeReplicationTransferStat',
    'VolumeRestoreParameters',
    'VolumeSnapshotPolicy',
    'VolumeSnapshotPolicyDailySchedule',
    'VolumeSnapshotPolicyHourlySchedule',
    'VolumeSnapshotPolicyMonthlySchedule',
    'VolumeSnapshotPolicyWeeklySchedule',
    'VolumeTieringPolicy',
]

@pulumi.output_type
class VolumeBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicies":
            suggest = "backup_policies"
        elif key == "backupVault":
            suggest = "backup_vault"
        elif key == "scheduledBackupEnabled":
            suggest = "scheduled_backup_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policies: Optional[Sequence[str]] = None,
                 backup_vault: Optional[str] = None,
                 scheduled_backup_enabled: Optional[bool] = None):
        """
        :param Sequence[str] backup_policies: Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        :param str backup_vault: ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
               Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        :param bool scheduled_backup_enabled: When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if scheduled_backup_enabled is not None:
            pulumi.set(__self__, "scheduled_backup_enabled", scheduled_backup_enabled)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[Sequence[str]]:
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[str]:
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        return pulumi.get(self, "backup_vault")

    @property
    @pulumi.getter(name="scheduledBackupEnabled")
    def scheduled_backup_enabled(self) -> Optional[bool]:
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        return pulumi.get(self, "scheduled_backup_enabled")


@pulumi.output_type
class VolumeExportPolicy(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.VolumeExportPolicyRule']):
        """
        :param Sequence['VolumeExportPolicyRuleArgs'] rules: Export rules (up to 5) control NFS volume access.
               Structure is documented below.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.VolumeExportPolicyRule']:
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class VolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "hasRootAccess":
            suggest = "has_root_access"
        elif key == "kerberos5ReadOnly":
            suggest = "kerberos5_read_only"
        elif key == "kerberos5ReadWrite":
            suggest = "kerberos5_read_write"
        elif key == "kerberos5iReadOnly":
            suggest = "kerberos5i_read_only"
        elif key == "kerberos5iReadWrite":
            suggest = "kerberos5i_read_write"
        elif key == "kerberos5pReadOnly":
            suggest = "kerberos5p_read_only"
        elif key == "kerberos5pReadWrite":
            suggest = "kerberos5p_read_write"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: Optional[str] = None,
                 allowed_clients: Optional[str] = None,
                 has_root_access: Optional[str] = None,
                 kerberos5_read_only: Optional[bool] = None,
                 kerberos5_read_write: Optional[bool] = None,
                 kerberos5i_read_only: Optional[bool] = None,
                 kerberos5i_read_write: Optional[bool] = None,
                 kerberos5p_read_only: Optional[bool] = None,
                 kerberos5p_read_write: Optional[bool] = None,
                 nfsv3: Optional[bool] = None,
                 nfsv4: Optional[bool] = None):
        """
        :param str access_type: Defines the access type for clients matching the `allowedClients` specification.
               Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        :param str allowed_clients: Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
        :param str has_root_access: If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        :param bool kerberos5_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        :param bool kerberos5_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        :param bool kerberos5i_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        :param bool kerberos5i_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        :param bool kerberos5p_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        :param bool kerberos5p_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        :param bool nfsv3: Enable to apply the export rule to NFSV3 clients.
        :param bool nfsv4: Enable to apply the export rule to NFSV4.1 clients.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv4 is not None:
            pulumi.set(__self__, "nfsv4", nfsv4)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[str]:
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[str]:
        """
        Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[str]:
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        """
        return pulumi.get(self, "has_root_access")

    @property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5_read_only")

    @property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5_read_write")

    @property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @property
    @pulumi.getter
    def nfsv3(self) -> Optional[bool]:
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        return pulumi.get(self, "nfsv3")

    @property
    @pulumi.getter
    def nfsv4(self) -> Optional[bool]:
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        return pulumi.get(self, "nfsv4")


@pulumi.output_type
class VolumeMountOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportFull":
            suggest = "export_full"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export: Optional[str] = None,
                 export_full: Optional[str] = None,
                 instructions: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str export: (Output)
               Export path of the volume.
        :param str export_full: (Output)
               Full export path of the volume.
               Format for NFS volumes: `<export_ip>:/<shareName>`
               Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        :param str instructions: (Output)
               Human-readable mount instructions.
        :param str protocol: (Output)
               Protocol to mount with.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if export_full is not None:
            pulumi.set(__self__, "export_full", export_full)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def export(self) -> Optional[str]:
        """
        (Output)
        Export path of the volume.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter(name="exportFull")
    def export_full(self) -> Optional[str]:
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        return pulumi.get(self, "export_full")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[str]:
        """
        (Output)
        Human-readable mount instructions.
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        (Output)
        Protocol to mount with.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class VolumeReplicationDestinationVolumeParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storagePool":
            suggest = "storage_pool"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationDestinationVolumeParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_pool: str,
                 description: Optional[str] = None,
                 share_name: Optional[str] = None,
                 volume_id: Optional[str] = None):
        """
        :param str storage_pool: Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        :param str description: Description for the destination volume.
        :param str share_name: Share name for destination volume. If not specified, name of source volume's share name will be used.
        :param str volume_id: Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        pulumi.set(__self__, "storage_pool", storage_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> str:
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        return pulumi.get(self, "storage_pool")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for the destination volume.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[str]:
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class VolumeReplicationTransferStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lagDuration":
            suggest = "lag_duration"
        elif key == "lastTransferBytes":
            suggest = "last_transfer_bytes"
        elif key == "lastTransferDuration":
            suggest = "last_transfer_duration"
        elif key == "lastTransferEndTime":
            suggest = "last_transfer_end_time"
        elif key == "lastTransferError":
            suggest = "last_transfer_error"
        elif key == "totalTransferDuration":
            suggest = "total_transfer_duration"
        elif key == "transferBytes":
            suggest = "transfer_bytes"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationTransferStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lag_duration: Optional[str] = None,
                 last_transfer_bytes: Optional[str] = None,
                 last_transfer_duration: Optional[str] = None,
                 last_transfer_end_time: Optional[str] = None,
                 last_transfer_error: Optional[str] = None,
                 total_transfer_duration: Optional[str] = None,
                 transfer_bytes: Optional[str] = None,
                 update_time: Optional[str] = None):
        """
        :param str lag_duration: (Output)
               The elapsed time since the creation of the snapshot on the source volume that was last replicated
               to the destination volume. Lag time represents the difference in age of the destination volume
               data in relation to the source volume data.
        :param str last_transfer_bytes: (Output)
               Size of last completed transfer in bytes.
        :param str last_transfer_duration: (Output)
               Time taken during last completed transfer.
        :param str last_transfer_end_time: (Output)
               Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param str last_transfer_error: (Output)
               A message describing the cause of the last transfer failure.
        :param str total_transfer_duration: (Output)
               Cumulative time taken across all transfers for the replication relationship.
        :param str transfer_bytes: (Output)
               Cumulative bytes transferred so far for the replication relationship.
        :param str update_time: (Output)
               Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        if lag_duration is not None:
            pulumi.set(__self__, "lag_duration", lag_duration)
        if last_transfer_bytes is not None:
            pulumi.set(__self__, "last_transfer_bytes", last_transfer_bytes)
        if last_transfer_duration is not None:
            pulumi.set(__self__, "last_transfer_duration", last_transfer_duration)
        if last_transfer_end_time is not None:
            pulumi.set(__self__, "last_transfer_end_time", last_transfer_end_time)
        if last_transfer_error is not None:
            pulumi.set(__self__, "last_transfer_error", last_transfer_error)
        if total_transfer_duration is not None:
            pulumi.set(__self__, "total_transfer_duration", total_transfer_duration)
        if transfer_bytes is not None:
            pulumi.set(__self__, "transfer_bytes", transfer_bytes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="lagDuration")
    def lag_duration(self) -> Optional[str]:
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        return pulumi.get(self, "lag_duration")

    @property
    @pulumi.getter(name="lastTransferBytes")
    def last_transfer_bytes(self) -> Optional[str]:
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        return pulumi.get(self, "last_transfer_bytes")

    @property
    @pulumi.getter(name="lastTransferDuration")
    def last_transfer_duration(self) -> Optional[str]:
        """
        (Output)
        Time taken during last completed transfer.
        """
        return pulumi.get(self, "last_transfer_duration")

    @property
    @pulumi.getter(name="lastTransferEndTime")
    def last_transfer_end_time(self) -> Optional[str]:
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "last_transfer_end_time")

    @property
    @pulumi.getter(name="lastTransferError")
    def last_transfer_error(self) -> Optional[str]:
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        return pulumi.get(self, "last_transfer_error")

    @property
    @pulumi.getter(name="totalTransferDuration")
    def total_transfer_duration(self) -> Optional[str]:
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        return pulumi.get(self, "total_transfer_duration")

    @property
    @pulumi.getter(name="transferBytes")
    def transfer_bytes(self) -> Optional[str]:
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        return pulumi.get(self, "transfer_bytes")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class VolumeRestoreParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceBackup":
            suggest = "source_backup"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeRestoreParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_backup: Optional[str] = None,
                 source_snapshot: Optional[str] = None):
        """
        :param str source_backup: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        :param str source_snapshot: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[str]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        return pulumi.get(self, "source_backup")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[str]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        return pulumi.get(self, "source_snapshot")


@pulumi.output_type
class VolumeSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: Optional['outputs.VolumeSnapshotPolicyDailySchedule'] = None,
                 enabled: Optional[bool] = None,
                 hourly_schedule: Optional['outputs.VolumeSnapshotPolicyHourlySchedule'] = None,
                 monthly_schedule: Optional['outputs.VolumeSnapshotPolicyMonthlySchedule'] = None,
                 weekly_schedule: Optional['outputs.VolumeSnapshotPolicyWeeklySchedule'] = None):
        """
        :param 'VolumeSnapshotPolicyDailyScheduleArgs' daily_schedule: Daily schedule policy.
               Structure is documented below.
        :param bool enabled: Enables automated snapshot creation according to defined schedule. Default is false.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        :param 'VolumeSnapshotPolicyHourlyScheduleArgs' hourly_schedule: Hourly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyMonthlyScheduleArgs' monthly_schedule: Monthly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule policy.
               Structure is documented below.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyDailySchedule']:
        """
        Daily schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyHourlySchedule']:
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyMonthlySchedule']:
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyWeeklySchedule']:
        """
        Weekly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class VolumeSnapshotPolicyDailySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyDailySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: int,
                 hour: Optional[int] = None,
                 minute: Optional[int] = None):
        """
        :param int snapshots_to_keep: The maximum number of snapshots to keep for the daily schedule.
        :param int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> int:
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyHourlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyHourlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: int,
                 minute: Optional[int] = None):
        """
        :param int snapshots_to_keep: The maximum number of snapshots to keep for the hourly schedule.
        :param int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> int:
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyMonthlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"
        elif key == "daysOfMonth":
            suggest = "days_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyMonthlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: int,
                 days_of_month: Optional[str] = None,
                 hour: Optional[int] = None,
                 minute: Optional[int] = None):
        """
        :param int snapshots_to_keep: The maximum number of snapshots to keep for the monthly schedule
        :param str days_of_month: Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        :param int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> int:
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[str]:
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        return pulumi.get(self, "days_of_month")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: int,
                 day: Optional[str] = None,
                 hour: Optional[int] = None,
                 minute: Optional[int] = None):
        """
        :param int snapshots_to_keep: The maximum number of snapshots to keep for the weekly schedule.
        :param str day: Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        :param int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> int:
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingThresholdDays":
            suggest = "cooling_threshold_days"
        elif key == "tierAction":
            suggest = "tier_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_threshold_days: Optional[int] = None,
                 tier_action: Optional[str] = None):
        """
        :param int cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 7-183.
               Default is 31.
        :param str tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[int]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 7-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[str]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")


