# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 capacity_gib: pulumi.Input[str],
                 location: pulumi.Input[str],
                 protocols: pulumi.Input[Sequence[pulumi.Input[str]]],
                 share_name: pulumi.Input[str],
                 storage_pool: pulumi.Input[str],
                 backup_config: Optional[pulumi.Input['VolumeBackupConfigArgs']] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_policy: Optional[pulumi.Input['VolumeExportPolicyArgs']] = None,
                 kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 large_capacity: Optional[pulumi.Input[bool]] = None,
                 multiple_endpoints: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restore_parameters: Optional[pulumi.Input['VolumeRestoreParametersArgs']] = None,
                 restricted_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 smb_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_directory: Optional[pulumi.Input[bool]] = None,
                 snapshot_policy: Optional[pulumi.Input['VolumeSnapshotPolicyArgs']] = None,
                 tiering_policy: Optional[pulumi.Input['VolumeTieringPolicyArgs']] = None,
                 unix_permissions: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[str] capacity_gib: Capacity of the volume (in GiB).
        :param pulumi.Input[str] location: Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
               Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        :param pulumi.Input[str] share_name: Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        :param pulumi.Input[str] storage_pool: Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        :param pulumi.Input['VolumeBackupConfigArgs'] backup_config: Backup configuration for the volume.
               Structure is documented below.
        :param pulumi.Input[str] deletion_policy: Policy to determine if the volume should be deleted forcefully.
               Volumes may have nested snapshot resources. Deleting such a volume will fail.
               Setting this parameter to FORCE will delete volumes including nested snapshots.
               Possible values: DEFAULT, FORCE.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input['VolumeExportPolicyArgs'] export_policy: Export policy of the volume for NFSV3 and/or NFSV4.1 access.
               Structure is documented below.
        :param pulumi.Input[bool] kerberos_enabled: Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[bool] large_capacity: Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        :param pulumi.Input[bool] multiple_endpoints: Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
               Only the volume with largeCapacity will be allowed to have multiple endpoints.
        :param pulumi.Input[str] name: The name of the volume. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['VolumeRestoreParametersArgs'] restore_parameters: Used to create this volume from a snapshot (= cloning) or an backup.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_actions: List of actions that are restricted on this volume.
               Each value may be one of: `DELETE`.
        :param pulumi.Input[str] security_style: Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
               Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
               Possible values are: `NTFS`, `UNIX`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] smb_settings: Settings for volumes with SMB access.
               Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        :param pulumi.Input[bool] snapshot_directory: If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        :param pulumi.Input['VolumeSnapshotPolicyArgs'] snapshot_policy: Snapshot policy defines the schedule for automatic snapshot creation.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
               Structure is documented below.
        :param pulumi.Input['VolumeTieringPolicyArgs'] tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param pulumi.Input[str] unix_permissions: Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        """
        pulumi.set(__self__, "capacity_gib", capacity_gib)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "share_name", share_name)
        pulumi.set(__self__, "storage_pool", storage_pool)
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export_policy is not None:
            pulumi.set(__self__, "export_policy", export_policy)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if large_capacity is not None:
            pulumi.set(__self__, "large_capacity", large_capacity)
        if multiple_endpoints is not None:
            pulumi.set(__self__, "multiple_endpoints", multiple_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if restore_parameters is not None:
            pulumi.set(__self__, "restore_parameters", restore_parameters)
        if restricted_actions is not None:
            pulumi.set(__self__, "restricted_actions", restricted_actions)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if smb_settings is not None:
            pulumi.set(__self__, "smb_settings", smb_settings)
        if snapshot_directory is not None:
            pulumi.set(__self__, "snapshot_directory", snapshot_directory)
        if snapshot_policy is not None:
            pulumi.set(__self__, "snapshot_policy", snapshot_policy)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if unix_permissions is not None:
            pulumi.set(__self__, "unix_permissions", unix_permissions)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Input[str]:
        """
        Capacity of the volume (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
        Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> pulumi.Input[str]:
        """
        Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional[pulumi.Input['VolumeBackupConfigArgs']]:
        """
        Backup configuration for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @backup_config.setter
    def backup_config(self, value: Optional[pulumi.Input['VolumeBackupConfigArgs']]):
        pulumi.set(self, "backup_config", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Policy to determine if the volume should be deleted forcefully.
        Volumes may have nested snapshot resources. Deleting such a volume will fail.
        Setting this parameter to FORCE will delete volumes including nested snapshots.
        Possible values: DEFAULT, FORCE.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> Optional[pulumi.Input['VolumeExportPolicyArgs']]:
        """
        Export policy of the volume for NFSV3 and/or NFSV4.1 access.
        Structure is documented below.
        """
        return pulumi.get(self, "export_policy")

    @export_policy.setter
    def export_policy(self, value: Optional[pulumi.Input['VolumeExportPolicyArgs']]):
        pulumi.set(self, "export_policy", value)

    @property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="largeCapacity")
    def large_capacity(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        """
        return pulumi.get(self, "large_capacity")

    @large_capacity.setter
    def large_capacity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "large_capacity", value)

    @property
    @pulumi.getter(name="multipleEndpoints")
    def multiple_endpoints(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
        Only the volume with largeCapacity will be allowed to have multiple endpoints.
        """
        return pulumi.get(self, "multiple_endpoints")

    @multiple_endpoints.setter
    def multiple_endpoints(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="restoreParameters")
    def restore_parameters(self) -> Optional[pulumi.Input['VolumeRestoreParametersArgs']]:
        """
        Used to create this volume from a snapshot (= cloning) or an backup.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_parameters")

    @restore_parameters.setter
    def restore_parameters(self, value: Optional[pulumi.Input['VolumeRestoreParametersArgs']]):
        pulumi.set(self, "restore_parameters", value)

    @property
    @pulumi.getter(name="restrictedActions")
    def restricted_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of actions that are restricted on this volume.
        Each value may be one of: `DELETE`.
        """
        return pulumi.get(self, "restricted_actions")

    @restricted_actions.setter
    def restricted_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_actions", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[str]]:
        """
        Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
        Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
        Possible values are: `NTFS`, `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="smbSettings")
    def smb_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Settings for volumes with SMB access.
        Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        """
        return pulumi.get(self, "smb_settings")

    @smb_settings.setter
    def smb_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "smb_settings", value)

    @property
    @pulumi.getter(name="snapshotDirectory")
    def snapshot_directory(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        """
        return pulumi.get(self, "snapshot_directory")

    @snapshot_directory.setter
    def snapshot_directory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot_directory", value)

    @property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyArgs']]:
        """
        Snapshot policy defines the schedule for automatic snapshot creation.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_policy")

    @snapshot_policy.setter
    def snapshot_policy(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyArgs']]):
        pulumi.set(self, "snapshot_policy", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['VolumeTieringPolicyArgs']]:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['VolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter(name="unixPermissions")
    def unix_permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        """
        return pulumi.get(self, "unix_permissions")

    @unix_permissions.setter
    def unix_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unix_permissions", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 active_directory: Optional[pulumi.Input[str]] = None,
                 backup_config: Optional[pulumi.Input['VolumeBackupConfigArgs']] = None,
                 capacity_gib: Optional[pulumi.Input[str]] = None,
                 cold_tier_size_gib: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 export_policy: Optional[pulumi.Input['VolumeExportPolicyArgs']] = None,
                 has_replication: Optional[pulumi.Input[bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_config: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 large_capacity: Optional[pulumi.Input[bool]] = None,
                 ldap_enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountOptionArgs']]]] = None,
                 multiple_endpoints: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 psa_range: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 replica_zone: Optional[pulumi.Input[str]] = None,
                 restore_parameters: Optional[pulumi.Input['VolumeRestoreParametersArgs']] = None,
                 restricted_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 service_level: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None,
                 smb_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_directory: Optional[pulumi.Input[bool]] = None,
                 snapshot_policy: Optional[pulumi.Input['VolumeSnapshotPolicyArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_details: Optional[pulumi.Input[str]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 tiering_policy: Optional[pulumi.Input['VolumeTieringPolicyArgs']] = None,
                 unix_permissions: Optional[pulumi.Input[str]] = None,
                 used_gib: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[str] active_directory: Reports the resource name of the Active Directory policy being used. Inherited from storage pool.
        :param pulumi.Input['VolumeBackupConfigArgs'] backup_config: Backup configuration for the volume.
               Structure is documented below.
        :param pulumi.Input[str] capacity_gib: Capacity of the volume (in GiB).
        :param pulumi.Input[str] cold_tier_size_gib: Output only. Size of the volume cold tier data in GiB.
        :param pulumi.Input[str] create_time: Create time of the volume. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[str] deletion_policy: Policy to determine if the volume should be deleted forcefully.
               Volumes may have nested snapshot resources. Deleting such a volume will fail.
               Setting this parameter to FORCE will delete volumes including nested snapshots.
               Possible values: DEFAULT, FORCE.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] encryption_type: Reports the data-at-rest encryption type of the volume. Inherited from storage pool.
        :param pulumi.Input['VolumeExportPolicyArgs'] export_policy: Export policy of the volume for NFSV3 and/or NFSV4.1 access.
               Structure is documented below.
        :param pulumi.Input[bool] has_replication: Indicates whether the volume is part of a volume replication relationship.
        :param pulumi.Input[bool] kerberos_enabled: Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        :param pulumi.Input[str] kms_config: Reports the CMEK policy resurce name being used for volume encryption. Inherited from storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[bool] large_capacity: Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        :param pulumi.Input[bool] ldap_enabled: Flag indicating if the volume is NFS LDAP enabled or not. Inherited from storage pool.
        :param pulumi.Input[str] location: Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountOptionArgs']]] mount_options: Reports mount instructions for this volume.
               Structure is documented below.
        :param pulumi.Input[bool] multiple_endpoints: Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
               Only the volume with largeCapacity will be allowed to have multiple endpoints.
        :param pulumi.Input[str] name: The name of the volume. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`. Inherited from storage pool.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
               Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        :param pulumi.Input[str] psa_range: Name of the Private Service Access allocated range. Inherited from storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] replica_zone: Specifies the replica zone for regional volume.
        :param pulumi.Input['VolumeRestoreParametersArgs'] restore_parameters: Used to create this volume from a snapshot (= cloning) or an backup.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_actions: List of actions that are restricted on this volume.
               Each value may be one of: `DELETE`.
        :param pulumi.Input[str] security_style: Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
               Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
               Possible values are: `NTFS`, `UNIX`.
        :param pulumi.Input[str] service_level: Service level of the volume. Inherited from storage pool. Supported values are : PREMIUM, EXTERME, STANDARD, FLEX.
        :param pulumi.Input[str] share_name: Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] smb_settings: Settings for volumes with SMB access.
               Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        :param pulumi.Input[bool] snapshot_directory: If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        :param pulumi.Input['VolumeSnapshotPolicyArgs'] snapshot_policy: Snapshot policy defines the schedule for automatic snapshot creation.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
               Structure is documented below.
        :param pulumi.Input[str] state: State of the volume.
        :param pulumi.Input[str] state_details: State details of the volume.
        :param pulumi.Input[str] storage_pool: Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        :param pulumi.Input['VolumeTieringPolicyArgs'] tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param pulumi.Input[str] unix_permissions: Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        :param pulumi.Input[str] used_gib: Used capacity of the volume (in GiB). This is computed periodically and it does not represent the realtime usage.
        :param pulumi.Input[str] zone: Specifies the active zone for regional volume.
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if capacity_gib is not None:
            pulumi.set(__self__, "capacity_gib", capacity_gib)
        if cold_tier_size_gib is not None:
            pulumi.set(__self__, "cold_tier_size_gib", cold_tier_size_gib)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if export_policy is not None:
            pulumi.set(__self__, "export_policy", export_policy)
        if has_replication is not None:
            pulumi.set(__self__, "has_replication", has_replication)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if kms_config is not None:
            pulumi.set(__self__, "kms_config", kms_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if large_capacity is not None:
            pulumi.set(__self__, "large_capacity", large_capacity)
        if ldap_enabled is not None:
            pulumi.set(__self__, "ldap_enabled", ldap_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if multiple_endpoints is not None:
            pulumi.set(__self__, "multiple_endpoints", multiple_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if psa_range is not None:
            pulumi.set(__self__, "psa_range", psa_range)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if replica_zone is not None:
            pulumi.set(__self__, "replica_zone", replica_zone)
        if restore_parameters is not None:
            pulumi.set(__self__, "restore_parameters", restore_parameters)
        if restricted_actions is not None:
            pulumi.set(__self__, "restricted_actions", restricted_actions)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if service_level is not None:
            pulumi.set(__self__, "service_level", service_level)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if smb_settings is not None:
            pulumi.set(__self__, "smb_settings", smb_settings)
        if snapshot_directory is not None:
            pulumi.set(__self__, "snapshot_directory", snapshot_directory)
        if snapshot_policy is not None:
            pulumi.set(__self__, "snapshot_policy", snapshot_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if storage_pool is not None:
            pulumi.set(__self__, "storage_pool", storage_pool)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if unix_permissions is not None:
            pulumi.set(__self__, "unix_permissions", unix_permissions)
        if used_gib is not None:
            pulumi.set(__self__, "used_gib", used_gib)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Reports the resource name of the Active Directory policy being used. Inherited from storage pool.
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory", value)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional[pulumi.Input['VolumeBackupConfigArgs']]:
        """
        Backup configuration for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @backup_config.setter
    def backup_config(self, value: Optional[pulumi.Input['VolumeBackupConfigArgs']]):
        pulumi.set(self, "backup_config", value)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Capacity of the volume (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter(name="coldTierSizeGib")
    def cold_tier_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Size of the volume cold tier data in GiB.
        """
        return pulumi.get(self, "cold_tier_size_gib")

    @cold_tier_size_gib.setter
    def cold_tier_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_tier_size_gib", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Create time of the volume. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Policy to determine if the volume should be deleted forcefully.
        Volumes may have nested snapshot resources. Deleting such a volume will fail.
        Setting this parameter to FORCE will delete volumes including nested snapshots.
        Possible values: DEFAULT, FORCE.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        Reports the data-at-rest encryption type of the volume. Inherited from storage pool.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> Optional[pulumi.Input['VolumeExportPolicyArgs']]:
        """
        Export policy of the volume for NFSV3 and/or NFSV4.1 access.
        Structure is documented below.
        """
        return pulumi.get(self, "export_policy")

    @export_policy.setter
    def export_policy(self, value: Optional[pulumi.Input['VolumeExportPolicyArgs']]):
        pulumi.set(self, "export_policy", value)

    @property
    @pulumi.getter(name="hasReplication")
    def has_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the volume is part of a volume replication relationship.
        """
        return pulumi.get(self, "has_replication")

    @has_replication.setter
    def has_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_replication", value)

    @property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @property
    @pulumi.getter(name="kmsConfig")
    def kms_config(self) -> Optional[pulumi.Input[str]]:
        """
        Reports the CMEK policy resurce name being used for volume encryption. Inherited from storage pool.
        """
        return pulumi.get(self, "kms_config")

    @kms_config.setter
    def kms_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="largeCapacity")
    def large_capacity(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        """
        return pulumi.get(self, "large_capacity")

    @large_capacity.setter
    def large_capacity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "large_capacity", value)

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the volume is NFS LDAP enabled or not. Inherited from storage pool.
        """
        return pulumi.get(self, "ldap_enabled")

    @ldap_enabled.setter
    def ldap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ldap_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountOptionArgs']]]]:
        """
        Reports mount instructions for this volume.
        Structure is documented below.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountOptionArgs']]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="multipleEndpoints")
    def multiple_endpoints(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
        Only the volume with largeCapacity will be allowed to have multiple endpoints.
        """
        return pulumi.get(self, "multiple_endpoints")

    @multiple_endpoints.setter
    def multiple_endpoints(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        VPC network name with format: `projects/{{project}}/global/networks/{{network}}`. Inherited from storage pool.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
        Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="psaRange")
    def psa_range(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Private Service Access allocated range. Inherited from storage pool.
        """
        return pulumi.get(self, "psa_range")

    @psa_range.setter
    def psa_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psa_range", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="replicaZone")
    def replica_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the replica zone for regional volume.
        """
        return pulumi.get(self, "replica_zone")

    @replica_zone.setter
    def replica_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_zone", value)

    @property
    @pulumi.getter(name="restoreParameters")
    def restore_parameters(self) -> Optional[pulumi.Input['VolumeRestoreParametersArgs']]:
        """
        Used to create this volume from a snapshot (= cloning) or an backup.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_parameters")

    @restore_parameters.setter
    def restore_parameters(self, value: Optional[pulumi.Input['VolumeRestoreParametersArgs']]):
        pulumi.set(self, "restore_parameters", value)

    @property
    @pulumi.getter(name="restrictedActions")
    def restricted_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of actions that are restricted on this volume.
        Each value may be one of: `DELETE`.
        """
        return pulumi.get(self, "restricted_actions")

    @restricted_actions.setter
    def restricted_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_actions", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[str]]:
        """
        Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
        Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
        Possible values are: `NTFS`, `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> Optional[pulumi.Input[str]]:
        """
        Service level of the volume. Inherited from storage pool. Supported values are : PREMIUM, EXTERME, STANDARD, FLEX.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[str]]:
        """
        Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter(name="smbSettings")
    def smb_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Settings for volumes with SMB access.
        Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        """
        return pulumi.get(self, "smb_settings")

    @smb_settings.setter
    def smb_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "smb_settings", value)

    @property
    @pulumi.getter(name="snapshotDirectory")
    def snapshot_directory(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        """
        return pulumi.get(self, "snapshot_directory")

    @snapshot_directory.setter
    def snapshot_directory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot_directory", value)

    @property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> Optional[pulumi.Input['VolumeSnapshotPolicyArgs']]:
        """
        Snapshot policy defines the schedule for automatic snapshot creation.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_policy")

    @snapshot_policy.setter
    def snapshot_policy(self, value: Optional[pulumi.Input['VolumeSnapshotPolicyArgs']]):
        pulumi.set(self, "snapshot_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[str]]:
        """
        State details of the volume.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_details", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['VolumeTieringPolicyArgs']]:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['VolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter(name="unixPermissions")
    def unix_permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        """
        return pulumi.get(self, "unix_permissions")

    @unix_permissions.setter
    def unix_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unix_permissions", value)

    @property
    @pulumi.getter(name="usedGib")
    def used_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Used capacity of the volume (in GiB). This is computed periodically and it does not represent the realtime usage.
        """
        return pulumi.get(self, "used_gib")

    @used_gib.setter
    def used_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "used_gib", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the active zone for regional volume.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config: Optional[pulumi.Input[Union['VolumeBackupConfigArgs', 'VolumeBackupConfigArgsDict']]] = None,
                 capacity_gib: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_policy: Optional[pulumi.Input[Union['VolumeExportPolicyArgs', 'VolumeExportPolicyArgsDict']]] = None,
                 kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 large_capacity: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 multiple_endpoints: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 restore_parameters: Optional[pulumi.Input[Union['VolumeRestoreParametersArgs', 'VolumeRestoreParametersArgsDict']]] = None,
                 restricted_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None,
                 smb_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_directory: Optional[pulumi.Input[bool]] = None,
                 snapshot_policy: Optional[pulumi.Input[Union['VolumeSnapshotPolicyArgs', 'VolumeSnapshotPolicyArgsDict']]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['VolumeTieringPolicyArgs', 'VolumeTieringPolicyArgsDict']]] = None,
                 unix_permissions: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A volume is a file system container in a storage pool that stores application, database, and user data.

        You can create a volume's capacity using the available capacity in the storage pool and you can define and resize the capacity without disruption to any processes.

        Storage pool settings apply to the volumes contained within them automatically.

        To get more information about Volume, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.volumes)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/volumes/overview)
            * [Quickstart](https://cloud.google.com/netapp/volumes/docs/get-started/quickstarts/create-volume)

        ## Example Usage

        ### Netapp Volume Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="test-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        test_volume = gcp.netapp.Volume("test_volume",
            location="us-west2",
            name="test-volume",
            capacity_gib="100",
            share_name="test-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"],
            deletion_policy="DEFAULT")
        ```

        ## Import

        Volume can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Volume can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default projects/{{project}}/locations/{{location}}/volumes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VolumeBackupConfigArgs', 'VolumeBackupConfigArgsDict']] backup_config: Backup configuration for the volume.
               Structure is documented below.
        :param pulumi.Input[str] capacity_gib: Capacity of the volume (in GiB).
        :param pulumi.Input[str] deletion_policy: Policy to determine if the volume should be deleted forcefully.
               Volumes may have nested snapshot resources. Deleting such a volume will fail.
               Setting this parameter to FORCE will delete volumes including nested snapshots.
               Possible values: DEFAULT, FORCE.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Union['VolumeExportPolicyArgs', 'VolumeExportPolicyArgsDict']] export_policy: Export policy of the volume for NFSV3 and/or NFSV4.1 access.
               Structure is documented below.
        :param pulumi.Input[bool] kerberos_enabled: Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[bool] large_capacity: Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        :param pulumi.Input[str] location: Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        :param pulumi.Input[bool] multiple_endpoints: Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
               Only the volume with largeCapacity will be allowed to have multiple endpoints.
        :param pulumi.Input[str] name: The name of the volume. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
               Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        :param pulumi.Input[Union['VolumeRestoreParametersArgs', 'VolumeRestoreParametersArgsDict']] restore_parameters: Used to create this volume from a snapshot (= cloning) or an backup.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_actions: List of actions that are restricted on this volume.
               Each value may be one of: `DELETE`.
        :param pulumi.Input[str] security_style: Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
               Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
               Possible values are: `NTFS`, `UNIX`.
        :param pulumi.Input[str] share_name: Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] smb_settings: Settings for volumes with SMB access.
               Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        :param pulumi.Input[bool] snapshot_directory: If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        :param pulumi.Input[Union['VolumeSnapshotPolicyArgs', 'VolumeSnapshotPolicyArgsDict']] snapshot_policy: Snapshot policy defines the schedule for automatic snapshot creation.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
               Structure is documented below.
        :param pulumi.Input[str] storage_pool: Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        :param pulumi.Input[Union['VolumeTieringPolicyArgs', 'VolumeTieringPolicyArgsDict']] tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param pulumi.Input[str] unix_permissions: Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A volume is a file system container in a storage pool that stores application, database, and user data.

        You can create a volume's capacity using the available capacity in the storage pool and you can define and resize the capacity without disruption to any processes.

        Storage pool settings apply to the volumes contained within them automatically.

        To get more information about Volume, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.volumes)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/volumes/overview)
            * [Quickstart](https://cloud.google.com/netapp/volumes/docs/get-started/quickstarts/create-volume)

        ## Example Usage

        ### Netapp Volume Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="test-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        test_volume = gcp.netapp.Volume("test_volume",
            location="us-west2",
            name="test-volume",
            capacity_gib="100",
            share_name="test-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"],
            deletion_policy="DEFAULT")
        ```

        ## Import

        Volume can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Volume can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default projects/{{project}}/locations/{{location}}/volumes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volume:Volume default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config: Optional[pulumi.Input[Union['VolumeBackupConfigArgs', 'VolumeBackupConfigArgsDict']]] = None,
                 capacity_gib: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_policy: Optional[pulumi.Input[Union['VolumeExportPolicyArgs', 'VolumeExportPolicyArgsDict']]] = None,
                 kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 large_capacity: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 multiple_endpoints: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 restore_parameters: Optional[pulumi.Input[Union['VolumeRestoreParametersArgs', 'VolumeRestoreParametersArgsDict']]] = None,
                 restricted_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None,
                 smb_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_directory: Optional[pulumi.Input[bool]] = None,
                 snapshot_policy: Optional[pulumi.Input[Union['VolumeSnapshotPolicyArgs', 'VolumeSnapshotPolicyArgsDict']]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['VolumeTieringPolicyArgs', 'VolumeTieringPolicyArgsDict']]] = None,
                 unix_permissions: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["backup_config"] = backup_config
            if capacity_gib is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_gib'")
            __props__.__dict__["capacity_gib"] = capacity_gib
            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["description"] = description
            __props__.__dict__["export_policy"] = export_policy
            __props__.__dict__["kerberos_enabled"] = kerberos_enabled
            __props__.__dict__["labels"] = labels
            __props__.__dict__["large_capacity"] = large_capacity
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["multiple_endpoints"] = multiple_endpoints
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if protocols is None and not opts.urn:
                raise TypeError("Missing required property 'protocols'")
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["restore_parameters"] = restore_parameters
            __props__.__dict__["restricted_actions"] = restricted_actions
            __props__.__dict__["security_style"] = security_style
            if share_name is None and not opts.urn:
                raise TypeError("Missing required property 'share_name'")
            __props__.__dict__["share_name"] = share_name
            __props__.__dict__["smb_settings"] = smb_settings
            __props__.__dict__["snapshot_directory"] = snapshot_directory
            __props__.__dict__["snapshot_policy"] = snapshot_policy
            if storage_pool is None and not opts.urn:
                raise TypeError("Missing required property 'storage_pool'")
            __props__.__dict__["storage_pool"] = storage_pool
            __props__.__dict__["tiering_policy"] = tiering_policy
            __props__.__dict__["unix_permissions"] = unix_permissions
            __props__.__dict__["active_directory"] = None
            __props__.__dict__["cold_tier_size_gib"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["encryption_type"] = None
            __props__.__dict__["has_replication"] = None
            __props__.__dict__["kms_config"] = None
            __props__.__dict__["ldap_enabled"] = None
            __props__.__dict__["mount_options"] = None
            __props__.__dict__["network"] = None
            __props__.__dict__["psa_range"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["replica_zone"] = None
            __props__.__dict__["service_level"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
            __props__.__dict__["used_gib"] = None
            __props__.__dict__["zone"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Volume, __self__).__init__(
            'gcp:netapp/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_directory: Optional[pulumi.Input[str]] = None,
            backup_config: Optional[pulumi.Input[Union['VolumeBackupConfigArgs', 'VolumeBackupConfigArgsDict']]] = None,
            capacity_gib: Optional[pulumi.Input[str]] = None,
            cold_tier_size_gib: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deletion_policy: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            encryption_type: Optional[pulumi.Input[str]] = None,
            export_policy: Optional[pulumi.Input[Union['VolumeExportPolicyArgs', 'VolumeExportPolicyArgsDict']]] = None,
            has_replication: Optional[pulumi.Input[bool]] = None,
            kerberos_enabled: Optional[pulumi.Input[bool]] = None,
            kms_config: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            large_capacity: Optional[pulumi.Input[bool]] = None,
            ldap_enabled: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeMountOptionArgs', 'VolumeMountOptionArgsDict']]]]] = None,
            multiple_endpoints: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            psa_range: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            replica_zone: Optional[pulumi.Input[str]] = None,
            restore_parameters: Optional[pulumi.Input[Union['VolumeRestoreParametersArgs', 'VolumeRestoreParametersArgsDict']]] = None,
            restricted_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_style: Optional[pulumi.Input[str]] = None,
            service_level: Optional[pulumi.Input[str]] = None,
            share_name: Optional[pulumi.Input[str]] = None,
            smb_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            snapshot_directory: Optional[pulumi.Input[bool]] = None,
            snapshot_policy: Optional[pulumi.Input[Union['VolumeSnapshotPolicyArgs', 'VolumeSnapshotPolicyArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_details: Optional[pulumi.Input[str]] = None,
            storage_pool: Optional[pulumi.Input[str]] = None,
            tiering_policy: Optional[pulumi.Input[Union['VolumeTieringPolicyArgs', 'VolumeTieringPolicyArgsDict']]] = None,
            unix_permissions: Optional[pulumi.Input[str]] = None,
            used_gib: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_directory: Reports the resource name of the Active Directory policy being used. Inherited from storage pool.
        :param pulumi.Input[Union['VolumeBackupConfigArgs', 'VolumeBackupConfigArgsDict']] backup_config: Backup configuration for the volume.
               Structure is documented below.
        :param pulumi.Input[str] capacity_gib: Capacity of the volume (in GiB).
        :param pulumi.Input[str] cold_tier_size_gib: Output only. Size of the volume cold tier data in GiB.
        :param pulumi.Input[str] create_time: Create time of the volume. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[str] deletion_policy: Policy to determine if the volume should be deleted forcefully.
               Volumes may have nested snapshot resources. Deleting such a volume will fail.
               Setting this parameter to FORCE will delete volumes including nested snapshots.
               Possible values: DEFAULT, FORCE.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] encryption_type: Reports the data-at-rest encryption type of the volume. Inherited from storage pool.
        :param pulumi.Input[Union['VolumeExportPolicyArgs', 'VolumeExportPolicyArgsDict']] export_policy: Export policy of the volume for NFSV3 and/or NFSV4.1 access.
               Structure is documented below.
        :param pulumi.Input[bool] has_replication: Indicates whether the volume is part of a volume replication relationship.
        :param pulumi.Input[bool] kerberos_enabled: Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        :param pulumi.Input[str] kms_config: Reports the CMEK policy resurce name being used for volume encryption. Inherited from storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[bool] large_capacity: Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        :param pulumi.Input[bool] ldap_enabled: Flag indicating if the volume is NFS LDAP enabled or not. Inherited from storage pool.
        :param pulumi.Input[str] location: Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeMountOptionArgs', 'VolumeMountOptionArgsDict']]]] mount_options: Reports mount instructions for this volume.
               Structure is documented below.
        :param pulumi.Input[bool] multiple_endpoints: Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
               Only the volume with largeCapacity will be allowed to have multiple endpoints.
        :param pulumi.Input[str] name: The name of the volume. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`. Inherited from storage pool.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
               Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        :param pulumi.Input[str] psa_range: Name of the Private Service Access allocated range. Inherited from storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] replica_zone: Specifies the replica zone for regional volume.
        :param pulumi.Input[Union['VolumeRestoreParametersArgs', 'VolumeRestoreParametersArgsDict']] restore_parameters: Used to create this volume from a snapshot (= cloning) or an backup.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_actions: List of actions that are restricted on this volume.
               Each value may be one of: `DELETE`.
        :param pulumi.Input[str] security_style: Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
               Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
               Possible values are: `NTFS`, `UNIX`.
        :param pulumi.Input[str] service_level: Service level of the volume. Inherited from storage pool. Supported values are : PREMIUM, EXTERME, STANDARD, FLEX.
        :param pulumi.Input[str] share_name: Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] smb_settings: Settings for volumes with SMB access.
               Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        :param pulumi.Input[bool] snapshot_directory: If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        :param pulumi.Input[Union['VolumeSnapshotPolicyArgs', 'VolumeSnapshotPolicyArgsDict']] snapshot_policy: Snapshot policy defines the schedule for automatic snapshot creation.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
               Structure is documented below.
        :param pulumi.Input[str] state: State of the volume.
        :param pulumi.Input[str] state_details: State details of the volume.
        :param pulumi.Input[str] storage_pool: Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        :param pulumi.Input[Union['VolumeTieringPolicyArgs', 'VolumeTieringPolicyArgsDict']] tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param pulumi.Input[str] unix_permissions: Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        :param pulumi.Input[str] used_gib: Used capacity of the volume (in GiB). This is computed periodically and it does not represent the realtime usage.
        :param pulumi.Input[str] zone: Specifies the active zone for regional volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["active_directory"] = active_directory
        __props__.__dict__["backup_config"] = backup_config
        __props__.__dict__["capacity_gib"] = capacity_gib
        __props__.__dict__["cold_tier_size_gib"] = cold_tier_size_gib
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["export_policy"] = export_policy
        __props__.__dict__["has_replication"] = has_replication
        __props__.__dict__["kerberos_enabled"] = kerberos_enabled
        __props__.__dict__["kms_config"] = kms_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["large_capacity"] = large_capacity
        __props__.__dict__["ldap_enabled"] = ldap_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["mount_options"] = mount_options
        __props__.__dict__["multiple_endpoints"] = multiple_endpoints
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["psa_range"] = psa_range
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["replica_zone"] = replica_zone
        __props__.__dict__["restore_parameters"] = restore_parameters
        __props__.__dict__["restricted_actions"] = restricted_actions
        __props__.__dict__["security_style"] = security_style
        __props__.__dict__["service_level"] = service_level
        __props__.__dict__["share_name"] = share_name
        __props__.__dict__["smb_settings"] = smb_settings
        __props__.__dict__["snapshot_directory"] = snapshot_directory
        __props__.__dict__["snapshot_policy"] = snapshot_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["storage_pool"] = storage_pool
        __props__.__dict__["tiering_policy"] = tiering_policy
        __props__.__dict__["unix_permissions"] = unix_permissions
        __props__.__dict__["used_gib"] = used_gib
        __props__.__dict__["zone"] = zone
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> pulumi.Output[str]:
        """
        Reports the resource name of the Active Directory policy being used. Inherited from storage pool.
        """
        return pulumi.get(self, "active_directory")

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> pulumi.Output[Optional['outputs.VolumeBackupConfig']]:
        """
        Backup configuration for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Output[str]:
        """
        Capacity of the volume (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @property
    @pulumi.getter(name="coldTierSizeGib")
    def cold_tier_size_gib(self) -> pulumi.Output[str]:
        """
        Output only. Size of the volume cold tier data in GiB.
        """
        return pulumi.get(self, "cold_tier_size_gib")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create time of the volume. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Policy to determine if the volume should be deleted forcefully.
        Volumes may have nested snapshot resources. Deleting such a volume will fail.
        Setting this parameter to FORCE will delete volumes including nested snapshots.
        Possible values: DEFAULT, FORCE.
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[str]:
        """
        Reports the data-at-rest encryption type of the volume. Inherited from storage pool.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> pulumi.Output[Optional['outputs.VolumeExportPolicy']]:
        """
        Export policy of the volume for NFSV3 and/or NFSV4.1 access.
        Structure is documented below.
        """
        return pulumi.get(self, "export_policy")

    @property
    @pulumi.getter(name="hasReplication")
    def has_replication(self) -> pulumi.Output[bool]:
        """
        Indicates whether the volume is part of a volume replication relationship.
        """
        return pulumi.get(self, "has_replication")

    @property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
        """
        return pulumi.get(self, "kerberos_enabled")

    @property
    @pulumi.getter(name="kmsConfig")
    def kms_config(self) -> pulumi.Output[str]:
        """
        Reports the CMEK policy resurce name being used for volume encryption. Inherited from storage pool.
        """
        return pulumi.get(self, "kms_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="largeCapacity")
    def large_capacity(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Flag indicating if the volume will be a large capacity volume or a regular volume.
        """
        return pulumi.get(self, "large_capacity")

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> pulumi.Output[bool]:
        """
        Flag indicating if the volume is NFS LDAP enabled or not. Inherited from storage pool.
        """
        return pulumi.get(self, "ldap_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Sequence['outputs.VolumeMountOption']]:
        """
        Reports mount instructions for this volume.
        Structure is documented below.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter(name="multipleEndpoints")
    def multiple_endpoints(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Flag indicating if the volume will have an IP address per node for volumes supporting multiple IP endpoints.
        Only the volume with largeCapacity will be allowed to have multiple endpoints.
        """
        return pulumi.get(self, "multiple_endpoints")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the volume. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        VPC network name with format: `projects/{{project}}/global/networks/{{network}}`. Inherited from storage pool.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[str]]:
        """
        The protocol of the volume. Allowed combinations are `['NFSV3']`, `['NFSV4']`, `['SMB']`, `['NFSV3', 'NFSV4']`, `['SMB', 'NFSV3']` and `['SMB', 'NFSV4']`.
        Each value may be one of: `NFSV3`, `NFSV4`, `SMB`.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="psaRange")
    def psa_range(self) -> pulumi.Output[str]:
        """
        Name of the Private Service Access allocated range. Inherited from storage pool.
        """
        return pulumi.get(self, "psa_range")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="replicaZone")
    def replica_zone(self) -> pulumi.Output[str]:
        """
        Specifies the replica zone for regional volume.
        """
        return pulumi.get(self, "replica_zone")

    @property
    @pulumi.getter(name="restoreParameters")
    def restore_parameters(self) -> pulumi.Output[Optional['outputs.VolumeRestoreParameters']]:
        """
        Used to create this volume from a snapshot (= cloning) or an backup.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_parameters")

    @property
    @pulumi.getter(name="restrictedActions")
    def restricted_actions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of actions that are restricted on this volume.
        Each value may be one of: `DELETE`.
        """
        return pulumi.get(self, "restricted_actions")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Output[str]:
        """
        Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
        Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol.
        Possible values are: `NTFS`, `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Output[str]:
        """
        Service level of the volume. Inherited from storage pool. Supported values are : PREMIUM, EXTERME, STANDARD, FLEX.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Output[str]:
        """
        Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="smbSettings")
    def smb_settings(self) -> pulumi.Output[Sequence[str]]:
        """
        Settings for volumes with SMB access.
        Each value may be one of: `ENCRYPT_DATA`, `BROWSABLE`, `CHANGE_NOTIFY`, `NON_BROWSABLE`, `OPLOCKS`, `SHOW_SNAPSHOT`, `SHOW_PREVIOUS_VERSIONS`, `ACCESS_BASED_ENUMERATION`, `CONTINUOUSLY_AVAILABLE`.
        """
        return pulumi.get(self, "smb_settings")

    @property
    @pulumi.getter(name="snapshotDirectory")
    def snapshot_directory(self) -> pulumi.Output[Optional[bool]]:
        """
        If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
        """
        return pulumi.get(self, "snapshot_directory")

    @property
    @pulumi.getter(name="snapshotPolicy")
    def snapshot_policy(self) -> pulumi.Output[Optional['outputs.VolumeSnapshotPolicy']]:
        """
        Snapshot policy defines the schedule for automatic snapshot creation.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_policy")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[str]:
        """
        State details of the volume.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> pulumi.Output[str]:
        """
        Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
        """
        return pulumi.get(self, "storage_pool")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> pulumi.Output[Optional['outputs.VolumeTieringPolicy']]:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @property
    @pulumi.getter(name="unixPermissions")
    def unix_permissions(self) -> pulumi.Output[str]:
        """
        Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
        """
        return pulumi.get(self, "unix_permissions")

    @property
    @pulumi.getter(name="usedGib")
    def used_gib(self) -> pulumi.Output[str]:
        """
        Used capacity of the volume (in GiB). This is computed periodically and it does not represent the realtime usage.
        """
        return pulumi.get(self, "used_gib")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        Specifies the active zone for regional volume.
        """
        return pulumi.get(self, "zone")

