# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeReplicationArgs', 'VolumeReplication']

@pulumi.input_type
class VolumeReplicationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 replication_schedule: pulumi.Input[str],
                 volume_name: pulumi.Input[str],
                 delete_destination_volume: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_volume_parameters: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']] = None,
                 force_stopping: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_enabled: Optional[pulumi.Input[bool]] = None,
                 wait_for_mirror: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a VolumeReplication resource.
        :param pulumi.Input[str] location: Name of region for this resource. The resource needs to be created in the region of the destination volume.
        :param pulumi.Input[str] replication_schedule: Specifies the replication interval.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        :param pulumi.Input[str] volume_name: The name of the existing source volume.
        :param pulumi.Input[str] description: An description of this resource.
        :param pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs'] destination_volume_parameters: Destination volume parameters.
               Structure is documented below.
        :param pulumi.Input[bool] force_stopping: Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
               currently receives an update and stopping the update might be undesirable. Set this parameter to true
               to stop anyway. All data transferred to the destination will be discarded and content of destination
               volume will remain at the state of the last successful update. Default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name of the replication. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] replication_enabled: Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
               and act independently from the source volume.
               Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
               done to the destination volume with the content of the source volume.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "replication_schedule", replication_schedule)
        pulumi.set(__self__, "volume_name", volume_name)
        if delete_destination_volume is not None:
            pulumi.set(__self__, "delete_destination_volume", delete_destination_volume)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_volume_parameters is not None:
            pulumi.set(__self__, "destination_volume_parameters", destination_volume_parameters)
        if force_stopping is not None:
            pulumi.set(__self__, "force_stopping", force_stopping)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_enabled is not None:
            pulumi.set(__self__, "replication_enabled", replication_enabled)
        if wait_for_mirror is not None:
            pulumi.set(__self__, "wait_for_mirror", wait_for_mirror)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Name of region for this resource. The resource needs to be created in the region of the destination volume.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> pulumi.Input[str]:
        """
        Specifies the replication interval.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_schedule", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[str]:
        """
        The name of the existing source volume.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="deleteDestinationVolume")
    def delete_destination_volume(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_destination_volume")

    @delete_destination_volume.setter
    def delete_destination_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_destination_volume", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationVolumeParameters")
    def destination_volume_parameters(self) -> Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']]:
        """
        Destination volume parameters.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_volume_parameters")

    @destination_volume_parameters.setter
    def destination_volume_parameters(self, value: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']]):
        pulumi.set(self, "destination_volume_parameters", value)

    @property
    @pulumi.getter(name="forceStopping")
    def force_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
        currently receives an update and stopping the update might be undesirable. Set this parameter to true
        to stop anyway. All data transferred to the destination will be discarded and content of destination
        volume will remain at the state of the last successful update. Default is false.
        """
        return pulumi.get(self, "force_stopping")

    @force_stopping.setter
    def force_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stopping", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the replication. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
        and act independently from the source volume.
        Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
        done to the destination volume with the content of the source volume.
        """
        return pulumi.get(self, "replication_enabled")

    @replication_enabled.setter
    def replication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replication_enabled", value)

    @property
    @pulumi.getter(name="waitForMirror")
    def wait_for_mirror(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_mirror")

    @wait_for_mirror.setter
    def wait_for_mirror(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_mirror", value)


@pulumi.input_type
class _VolumeReplicationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_destination_volume: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_volume: Optional[pulumi.Input[str]] = None,
                 destination_volume_parameters: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 force_stopping: Optional[pulumi.Input[bool]] = None,
                 healthy: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mirror_state: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 replication_enabled: Optional[pulumi.Input[bool]] = None,
                 replication_schedule: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 source_volume: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_details: Optional[pulumi.Input[str]] = None,
                 transfer_stats: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReplicationTransferStatArgs']]]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 wait_for_mirror: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering VolumeReplication resources.
        :param pulumi.Input[str] create_time: Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[str] description: An description of this resource.
        :param pulumi.Input[str] destination_volume: Full resource name of destination volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        :param pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs'] destination_volume_parameters: Destination volume parameters.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[bool] force_stopping: Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
               currently receives an update and stopping the update might be undesirable. Set this parameter to true
               to stop anyway. All data transferred to the destination will be discarded and content of destination
               volume will remain at the state of the last successful update. Default is false.
        :param pulumi.Input[bool] healthy: Condition of the relationship. Can be one of the following:
               - true: The replication relationship is healthy. It has not missed the most recent scheduled transfer.
               - false: The replication relationship is not healthy. It has missed the most recent scheduled transfer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Name of region for this resource. The resource needs to be created in the region of the destination volume.
        :param pulumi.Input[str] mirror_state: Indicates the state of the mirror between source and destination volumes. Depending on the amount of data
               in your source volume, PREPARING phase can take hours or days. mirrorState = MIRRORED indicates your baseline
               transfer ended and destination volume became accessible read-only. TRANSFERRING means a MIRRORED volume
               currently receives an update. Updated every 5 minutes.
        :param pulumi.Input[str] name: The name of the replication. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[bool] replication_enabled: Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
               and act independently from the source volume.
               Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
               done to the destination volume with the content of the source volume.
        :param pulumi.Input[str] replication_schedule: Specifies the replication interval.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        :param pulumi.Input[str] role: Reverting a replication can swap source and destination volume roles. This field indicates if the `location` hosts
               the source or destination volume. For resume and revert and resume operations it is critical to understand
               which volume is the source volume, since it will overwrite changes done to the destination volume.
        :param pulumi.Input[str] source_volume: Full resource name of source volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        :param pulumi.Input[str] state: Indicates the state of replication resource. State of the mirror itself is indicated in mirrorState.
        :param pulumi.Input[str] state_details: State details of the replication resource.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeReplicationTransferStatArgs']]] transfer_stats: Replication transfer statistics. All statistics are updated every 5 minutes.
               Structure is documented below.
        :param pulumi.Input[str] volume_name: The name of the existing source volume.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_destination_volume is not None:
            pulumi.set(__self__, "delete_destination_volume", delete_destination_volume)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_volume is not None:
            pulumi.set(__self__, "destination_volume", destination_volume)
        if destination_volume_parameters is not None:
            pulumi.set(__self__, "destination_volume_parameters", destination_volume_parameters)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if force_stopping is not None:
            pulumi.set(__self__, "force_stopping", force_stopping)
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mirror_state is not None:
            pulumi.set(__self__, "mirror_state", mirror_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if replication_enabled is not None:
            pulumi.set(__self__, "replication_enabled", replication_enabled)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if transfer_stats is not None:
            pulumi.set(__self__, "transfer_stats", transfer_stats)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)
        if wait_for_mirror is not None:
            pulumi.set(__self__, "wait_for_mirror", wait_for_mirror)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteDestinationVolume")
    def delete_destination_volume(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_destination_volume")

    @delete_destination_volume.setter
    def delete_destination_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_destination_volume", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationVolume")
    def destination_volume(self) -> Optional[pulumi.Input[str]]:
        """
        Full resource name of destination volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        """
        return pulumi.get(self, "destination_volume")

    @destination_volume.setter
    def destination_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_volume", value)

    @property
    @pulumi.getter(name="destinationVolumeParameters")
    def destination_volume_parameters(self) -> Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']]:
        """
        Destination volume parameters.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_volume_parameters")

    @destination_volume_parameters.setter
    def destination_volume_parameters(self, value: Optional[pulumi.Input['VolumeReplicationDestinationVolumeParametersArgs']]):
        pulumi.set(self, "destination_volume_parameters", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="forceStopping")
    def force_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
        currently receives an update and stopping the update might be undesirable. Set this parameter to true
        to stop anyway. All data transferred to the destination will be discarded and content of destination
        volume will remain at the state of the last successful update. Default is false.
        """
        return pulumi.get(self, "force_stopping")

    @force_stopping.setter
    def force_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stopping", value)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[pulumi.Input[bool]]:
        """
        Condition of the relationship. Can be one of the following:
        - true: The replication relationship is healthy. It has not missed the most recent scheduled transfer.
        - false: The replication relationship is not healthy. It has missed the most recent scheduled transfer.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Name of region for this resource. The resource needs to be created in the region of the destination volume.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mirrorState")
    def mirror_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the state of the mirror between source and destination volumes. Depending on the amount of data
        in your source volume, PREPARING phase can take hours or days. mirrorState = MIRRORED indicates your baseline
        transfer ended and destination volume became accessible read-only. TRANSFERRING means a MIRRORED volume
        currently receives an update. Updated every 5 minutes.
        """
        return pulumi.get(self, "mirror_state")

    @mirror_state.setter
    def mirror_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mirror_state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the replication. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
        and act independently from the source volume.
        Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
        done to the destination volume with the content of the source volume.
        """
        return pulumi.get(self, "replication_enabled")

    @replication_enabled.setter
    def replication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replication_enabled", value)

    @property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the replication interval.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_schedule", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Reverting a replication can swap source and destination volume roles. This field indicates if the `location` hosts
        the source or destination volume. For resume and revert and resume operations it is critical to understand
        which volume is the source volume, since it will overwrite changes done to the destination volume.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[str]]:
        """
        Full resource name of source volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        """
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_volume", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the state of replication resource. State of the mirror itself is indicated in mirrorState.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[str]]:
        """
        State details of the replication resource.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_details", value)

    @property
    @pulumi.getter(name="transferStats")
    def transfer_stats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReplicationTransferStatArgs']]]]:
        """
        Replication transfer statistics. All statistics are updated every 5 minutes.
        Structure is documented below.
        """
        return pulumi.get(self, "transfer_stats")

    @transfer_stats.setter
    def transfer_stats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeReplicationTransferStatArgs']]]]):
        pulumi.set(self, "transfer_stats", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the existing source volume.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="waitForMirror")
    def wait_for_mirror(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_mirror")

    @wait_for_mirror.setter
    def wait_for_mirror(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_mirror", value)


class VolumeReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_destination_volume: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_volume_parameters: Optional[pulumi.Input[Union['VolumeReplicationDestinationVolumeParametersArgs', 'VolumeReplicationDestinationVolumeParametersArgsDict']]] = None,
                 force_stopping: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_enabled: Optional[pulumi.Input[bool]] = None,
                 replication_schedule: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 wait_for_mirror: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Netapp Volume Replication Create

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        source_pool = gcp.netapp.StoragePool("source_pool",
            name="source-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        destination_pool = gcp.netapp.StoragePool("destination_pool",
            name="destination-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        source_volume = gcp.netapp.Volume("source_volume",
            location=source_pool.location,
            name="source-volume",
            capacity_gib="100",
            share_name="source-volume",
            storage_pool=source_pool.name,
            protocols=["NFSV3"],
            deletion_policy="FORCE")
        test_replication = gcp.netapp.VolumeReplication("test_replication",
            location=source_volume.location,
            volume_name=source_volume.name,
            name="test-replication",
            replication_schedule="EVERY_10_MINUTES",
            description="This is a replication resource",
            destination_volume_parameters={
                "storage_pool": destination_pool.id,
                "volume_id": "destination-volume",
                "share_name": "source-volume",
                "description": "This is a replicated volume",
            },
            delete_destination_volume=True,
            wait_for_mirror=True,
            opts = pulumi.ResourceOptions(depends_on=[source_volume]))
        ```

        ## Import

        VolumeReplication can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/replications/{{name}}`

        * `{{project}}/{{location}}/{{volume_name}}/{{name}}`

        * `{{location}}/{{volume_name}}/{{name}}`

        When using the `pulumi import` command, VolumeReplication can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/replications/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default {{project}}/{{location}}/{{volume_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default {{location}}/{{volume_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An description of this resource.
        :param pulumi.Input[Union['VolumeReplicationDestinationVolumeParametersArgs', 'VolumeReplicationDestinationVolumeParametersArgsDict']] destination_volume_parameters: Destination volume parameters.
               Structure is documented below.
        :param pulumi.Input[bool] force_stopping: Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
               currently receives an update and stopping the update might be undesirable. Set this parameter to true
               to stop anyway. All data transferred to the destination will be discarded and content of destination
               volume will remain at the state of the last successful update. Default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Name of region for this resource. The resource needs to be created in the region of the destination volume.
        :param pulumi.Input[str] name: The name of the replication. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] replication_enabled: Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
               and act independently from the source volume.
               Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
               done to the destination volume with the content of the source volume.
        :param pulumi.Input[str] replication_schedule: Specifies the replication interval.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        :param pulumi.Input[str] volume_name: The name of the existing source volume.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Netapp Volume Replication Create

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="test-network")
        source_pool = gcp.netapp.StoragePool("source_pool",
            name="source-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        destination_pool = gcp.netapp.StoragePool("destination_pool",
            name="destination-pool",
            location="us-west2",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        source_volume = gcp.netapp.Volume("source_volume",
            location=source_pool.location,
            name="source-volume",
            capacity_gib="100",
            share_name="source-volume",
            storage_pool=source_pool.name,
            protocols=["NFSV3"],
            deletion_policy="FORCE")
        test_replication = gcp.netapp.VolumeReplication("test_replication",
            location=source_volume.location,
            volume_name=source_volume.name,
            name="test-replication",
            replication_schedule="EVERY_10_MINUTES",
            description="This is a replication resource",
            destination_volume_parameters={
                "storage_pool": destination_pool.id,
                "volume_id": "destination-volume",
                "share_name": "source-volume",
                "description": "This is a replicated volume",
            },
            delete_destination_volume=True,
            wait_for_mirror=True,
            opts = pulumi.ResourceOptions(depends_on=[source_volume]))
        ```

        ## Import

        VolumeReplication can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/replications/{{name}}`

        * `{{project}}/{{location}}/{{volume_name}}/{{name}}`

        * `{{location}}/{{volume_name}}/{{name}}`

        When using the `pulumi import` command, VolumeReplication can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default projects/{{project}}/locations/{{location}}/volumes/{{volume_name}}/replications/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default {{project}}/{{location}}/{{volume_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/volumeReplication:VolumeReplication default {{location}}/{{volume_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VolumeReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_destination_volume: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_volume_parameters: Optional[pulumi.Input[Union['VolumeReplicationDestinationVolumeParametersArgs', 'VolumeReplicationDestinationVolumeParametersArgsDict']]] = None,
                 force_stopping: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_enabled: Optional[pulumi.Input[bool]] = None,
                 replication_schedule: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 wait_for_mirror: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeReplicationArgs.__new__(VolumeReplicationArgs)

            __props__.__dict__["delete_destination_volume"] = delete_destination_volume
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_volume_parameters"] = destination_volume_parameters
            __props__.__dict__["force_stopping"] = force_stopping
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["replication_enabled"] = replication_enabled
            if replication_schedule is None and not opts.urn:
                raise TypeError("Missing required property 'replication_schedule'")
            __props__.__dict__["replication_schedule"] = replication_schedule
            if volume_name is None and not opts.urn:
                raise TypeError("Missing required property 'volume_name'")
            __props__.__dict__["volume_name"] = volume_name
            __props__.__dict__["wait_for_mirror"] = wait_for_mirror
            __props__.__dict__["create_time"] = None
            __props__.__dict__["destination_volume"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["healthy"] = None
            __props__.__dict__["mirror_state"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["source_volume"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
            __props__.__dict__["transfer_stats"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VolumeReplication, __self__).__init__(
            'gcp:netapp/volumeReplication:VolumeReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delete_destination_volume: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_volume: Optional[pulumi.Input[str]] = None,
            destination_volume_parameters: Optional[pulumi.Input[Union['VolumeReplicationDestinationVolumeParametersArgs', 'VolumeReplicationDestinationVolumeParametersArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            force_stopping: Optional[pulumi.Input[bool]] = None,
            healthy: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            mirror_state: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            replication_enabled: Optional[pulumi.Input[bool]] = None,
            replication_schedule: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            source_volume: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_details: Optional[pulumi.Input[str]] = None,
            transfer_stats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeReplicationTransferStatArgs', 'VolumeReplicationTransferStatArgsDict']]]]] = None,
            volume_name: Optional[pulumi.Input[str]] = None,
            wait_for_mirror: Optional[pulumi.Input[bool]] = None) -> 'VolumeReplication':
        """
        Get an existing VolumeReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[str] description: An description of this resource.
        :param pulumi.Input[str] destination_volume: Full resource name of destination volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        :param pulumi.Input[Union['VolumeReplicationDestinationVolumeParametersArgs', 'VolumeReplicationDestinationVolumeParametersArgsDict']] destination_volume_parameters: Destination volume parameters.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[bool] force_stopping: Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
               currently receives an update and stopping the update might be undesirable. Set this parameter to true
               to stop anyway. All data transferred to the destination will be discarded and content of destination
               volume will remain at the state of the last successful update. Default is false.
        :param pulumi.Input[bool] healthy: Condition of the relationship. Can be one of the following:
               - true: The replication relationship is healthy. It has not missed the most recent scheduled transfer.
               - false: The replication relationship is not healthy. It has missed the most recent scheduled transfer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: Name of region for this resource. The resource needs to be created in the region of the destination volume.
        :param pulumi.Input[str] mirror_state: Indicates the state of the mirror between source and destination volumes. Depending on the amount of data
               in your source volume, PREPARING phase can take hours or days. mirrorState = MIRRORED indicates your baseline
               transfer ended and destination volume became accessible read-only. TRANSFERRING means a MIRRORED volume
               currently receives an update. Updated every 5 minutes.
        :param pulumi.Input[str] name: The name of the replication. Needs to be unique per location.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[bool] replication_enabled: Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
               and act independently from the source volume.
               Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
               done to the destination volume with the content of the source volume.
        :param pulumi.Input[str] replication_schedule: Specifies the replication interval.
               Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        :param pulumi.Input[str] role: Reverting a replication can swap source and destination volume roles. This field indicates if the `location` hosts
               the source or destination volume. For resume and revert and resume operations it is critical to understand
               which volume is the source volume, since it will overwrite changes done to the destination volume.
        :param pulumi.Input[str] source_volume: Full resource name of source volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        :param pulumi.Input[str] state: Indicates the state of replication resource. State of the mirror itself is indicated in mirrorState.
        :param pulumi.Input[str] state_details: State details of the replication resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeReplicationTransferStatArgs', 'VolumeReplicationTransferStatArgsDict']]]] transfer_stats: Replication transfer statistics. All statistics are updated every 5 minutes.
               Structure is documented below.
        :param pulumi.Input[str] volume_name: The name of the existing source volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeReplicationState.__new__(_VolumeReplicationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_destination_volume"] = delete_destination_volume
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_volume"] = destination_volume
        __props__.__dict__["destination_volume_parameters"] = destination_volume_parameters
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["force_stopping"] = force_stopping
        __props__.__dict__["healthy"] = healthy
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mirror_state"] = mirror_state
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["replication_enabled"] = replication_enabled
        __props__.__dict__["replication_schedule"] = replication_schedule
        __props__.__dict__["role"] = role
        __props__.__dict__["source_volume"] = source_volume
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["transfer_stats"] = transfer_stats
        __props__.__dict__["volume_name"] = volume_name
        __props__.__dict__["wait_for_mirror"] = wait_for_mirror
        return VolumeReplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteDestinationVolume")
    def delete_destination_volume(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "delete_destination_volume")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationVolume")
    def destination_volume(self) -> pulumi.Output[str]:
        """
        Full resource name of destination volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        """
        return pulumi.get(self, "destination_volume")

    @property
    @pulumi.getter(name="destinationVolumeParameters")
    def destination_volume_parameters(self) -> pulumi.Output[Optional['outputs.VolumeReplicationDestinationVolumeParameters']]:
        """
        Destination volume parameters.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_volume_parameters")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="forceStopping")
    def force_stopping(self) -> pulumi.Output[Optional[bool]]:
        """
        Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
        currently receives an update and stopping the update might be undesirable. Set this parameter to true
        to stop anyway. All data transferred to the destination will be discarded and content of destination
        volume will remain at the state of the last successful update. Default is false.
        """
        return pulumi.get(self, "force_stopping")

    @property
    @pulumi.getter
    def healthy(self) -> pulumi.Output[bool]:
        """
        Condition of the relationship. Can be one of the following:
        - true: The replication relationship is healthy. It has not missed the most recent scheduled transfer.
        - false: The replication relationship is not healthy. It has missed the most recent scheduled transfer.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Name of region for this resource. The resource needs to be created in the region of the destination volume.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mirrorState")
    def mirror_state(self) -> pulumi.Output[str]:
        """
        Indicates the state of the mirror between source and destination volumes. Depending on the amount of data
        in your source volume, PREPARING phase can take hours or days. mirrorState = MIRRORED indicates your baseline
        transfer ended and destination volume became accessible read-only. TRANSFERRING means a MIRRORED volume
        currently receives an update. Updated every 5 minutes.
        """
        return pulumi.get(self, "mirror_state")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the replication. Needs to be unique per location.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
        and act independently from the source volume.
        Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
        done to the destination volume with the content of the source volume.
        """
        return pulumi.get(self, "replication_enabled")

    @property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> pulumi.Output[str]:
        """
        Specifies the replication interval.
        Possible values are: `EVERY_10_MINUTES`, `HOURLY`, `DAILY`.
        """
        return pulumi.get(self, "replication_schedule")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Reverting a replication can swap source and destination volume roles. This field indicates if the `location` hosts
        the source or destination volume. For resume and revert and resume operations it is critical to understand
        which volume is the source volume, since it will overwrite changes done to the destination volume.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> pulumi.Output[str]:
        """
        Full resource name of source volume with format: `projects/{{project}}/locations/{{location}}/volumes/{{volumeId}}`
        """
        return pulumi.get(self, "source_volume")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Indicates the state of replication resource. State of the mirror itself is indicated in mirrorState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[str]:
        """
        State details of the replication resource.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter(name="transferStats")
    def transfer_stats(self) -> pulumi.Output[Sequence['outputs.VolumeReplicationTransferStat']]:
        """
        Replication transfer statistics. All statistics are updated every 5 minutes.
        Structure is documented below.
        """
        return pulumi.get(self, "transfer_stats")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Output[str]:
        """
        The name of the existing source volume.
        """
        return pulumi.get(self, "volume_name")

    @property
    @pulumi.getter(name="waitForMirror")
    def wait_for_mirror(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "wait_for_mirror")

