# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyBasedRouteArgs', 'PolicyBasedRoute']

@pulumi.input_type
class PolicyBasedRouteArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input['PolicyBasedRouteFilterArgs'],
                 network: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 interconnect_attachment: Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_other_routes: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 virtual_machine: Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']] = None):
        """
        The set of arguments for constructing a PolicyBasedRoute resource.
        :param pulumi.Input['PolicyBasedRouteFilterArgs'] filter: The filter to match L4 traffic.
               Structure is documented below.
        :param pulumi.Input[str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs'] interconnect_attachment: The interconnect attachments that this policy-based route applies to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name of the policy based route.
        :param pulumi.Input[str] next_hop_ilb_ip: The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        :param pulumi.Input[str] next_hop_other_routes: Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        :param pulumi.Input[int] priority: The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
               policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
               priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        :param pulumi.Input['PolicyBasedRouteVirtualMachineArgs'] virtual_machine: VM instances to which this policy-based route applies to.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ilb_ip is not None:
            pulumi.set(__self__, "next_hop_ilb_ip", next_hop_ilb_ip)
        if next_hop_other_routes is not None:
            pulumi.set(__self__, "next_hop_other_routes", next_hop_other_routes)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input['PolicyBasedRouteFilterArgs']:
        """
        The filter to match L4 traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input['PolicyBasedRouteFilterArgs']):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']]:
        """
        The interconnect attachments that this policy-based route applies to.
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']]):
        pulumi.set(self, "interconnect_attachment", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopIlbIp")
    def next_hop_ilb_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        """
        return pulumi.get(self, "next_hop_ilb_ip")

    @next_hop_ilb_ip.setter
    def next_hop_ilb_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ilb_ip", value)

    @property
    @pulumi.getter(name="nextHopOtherRoutes")
    def next_hop_other_routes(self) -> Optional[pulumi.Input[str]]:
        """
        Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        """
        return pulumi.get(self, "next_hop_other_routes")

    @next_hop_other_routes.setter
    def next_hop_other_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_other_routes", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
        policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
        priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']]:
        """
        VM instances to which this policy-based route applies to.
        """
        return pulumi.get(self, "virtual_machine")

    @virtual_machine.setter
    def virtual_machine(self, value: Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']]):
        pulumi.set(self, "virtual_machine", value)


@pulumi.input_type
class _PolicyBasedRouteState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filter: Optional[pulumi.Input['PolicyBasedRouteFilterArgs']] = None,
                 interconnect_attachment: Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_other_routes: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 virtual_machine: Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']] = None,
                 warnings: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBasedRouteWarningArgs']]]] = None):
        """
        Input properties used for looking up and filtering PolicyBasedRoute resources.
        :param pulumi.Input[str] create_time: Time when the policy-based route was created.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['PolicyBasedRouteFilterArgs'] filter: The filter to match L4 traffic.
               Structure is documented below.
        :param pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs'] interconnect_attachment: The interconnect attachments that this policy-based route applies to.
        :param pulumi.Input[str] kind: Type of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name of the policy based route.
        :param pulumi.Input[str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[str] next_hop_ilb_ip: The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        :param pulumi.Input[str] next_hop_other_routes: Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        :param pulumi.Input[int] priority: The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
               policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
               priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] update_time: Time when the policy-based route was created.
        :param pulumi.Input['PolicyBasedRouteVirtualMachineArgs'] virtual_machine: VM instances to which this policy-based route applies to.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyBasedRouteWarningArgs']]] warnings: If potential misconfigurations are detected for this route, this field will be populated with warning messages.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if next_hop_ilb_ip is not None:
            pulumi.set(__self__, "next_hop_ilb_ip", next_hop_ilb_ip)
        if next_hop_other_routes is not None:
            pulumi.set(__self__, "next_hop_other_routes", next_hop_other_routes)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the policy-based route was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['PolicyBasedRouteFilterArgs']]:
        """
        The filter to match L4 traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['PolicyBasedRouteFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']]:
        """
        The interconnect attachments that this policy-based route applies to.
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input['PolicyBasedRouteInterconnectAttachmentArgs']]):
        pulumi.set(self, "interconnect_attachment", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Type of this resource.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nextHopIlbIp")
    def next_hop_ilb_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        """
        return pulumi.get(self, "next_hop_ilb_ip")

    @next_hop_ilb_ip.setter
    def next_hop_ilb_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ilb_ip", value)

    @property
    @pulumi.getter(name="nextHopOtherRoutes")
    def next_hop_other_routes(self) -> Optional[pulumi.Input[str]]:
        """
        Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        """
        return pulumi.get(self, "next_hop_other_routes")

    @next_hop_other_routes.setter
    def next_hop_other_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_other_routes", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
        policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
        priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the policy-based route was created.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']]:
        """
        VM instances to which this policy-based route applies to.
        """
        return pulumi.get(self, "virtual_machine")

    @virtual_machine.setter
    def virtual_machine(self, value: Optional[pulumi.Input['PolicyBasedRouteVirtualMachineArgs']]):
        pulumi.set(self, "virtual_machine", value)

    @property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBasedRouteWarningArgs']]]]:
        """
        If potential misconfigurations are detected for this route, this field will be populated with warning messages.
        Structure is documented below.
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBasedRouteWarningArgs']]]]):
        pulumi.set(self, "warnings", value)


class PolicyBasedRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[Union['PolicyBasedRouteFilterArgs', 'PolicyBasedRouteFilterArgsDict']]] = None,
                 interconnect_attachment: Optional[pulumi.Input[Union['PolicyBasedRouteInterconnectAttachmentArgs', 'PolicyBasedRouteInterconnectAttachmentArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_other_routes: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 virtual_machine: Optional[pulumi.Input[Union['PolicyBasedRouteVirtualMachineArgs', 'PolicyBasedRouteVirtualMachineArgsDict']]] = None,
                 __props__=None):
        """
        Policy-based Routes are more powerful routes that route L4 network traffic based on not just destination IP, but also source IP, protocol and more. A Policy-based Route always take precedence when it conflicts with other types of routes.

        To get more information about PolicyBasedRoute, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.global.policyBasedRoutes)
        * How-to Guides
            * [Use policy-based routes](https://cloud.google.com/vpc/docs/use-policy-based-routes#api)

        ## Example Usage

        ### Network Connectivity Policy Based Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.PolicyBasedRoute("default",
            name="my-pbr",
            network=my_network.id,
            filter={
                "protocol_version": "IPV4",
            },
            next_hop_other_routes="DEFAULT_ROUTING")
        ```
        ### Network Connectivity Policy Based Route Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        # This example substitutes an arbitrary internal IP for an internal network
        # load balancer for brevity. Consult https://cloud.google.com/load-balancing/docs/internal
        # to set one up.
        ilb = gcp.compute.GlobalAddress("ilb", name="my-ilb")
        default = gcp.networkconnectivity.PolicyBasedRoute("default",
            name="my-pbr",
            description="My routing policy",
            network=my_network.id,
            priority=2302,
            filter={
                "protocol_version": "IPV4",
                "ip_protocol": "UDP",
                "src_range": "10.0.0.0/24",
                "dest_range": "0.0.0.0/0",
            },
            next_hop_ilb_ip=ilb.address,
            virtual_machine={
                "tags": ["restricted"],
            },
            labels={
                "env": "default",
            })
        ```

        ## Import

        PolicyBasedRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/policyBasedRoutes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PolicyBasedRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default projects/{{project}}/locations/global/policyBasedRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Union['PolicyBasedRouteFilterArgs', 'PolicyBasedRouteFilterArgsDict']] filter: The filter to match L4 traffic.
               Structure is documented below.
        :param pulumi.Input[Union['PolicyBasedRouteInterconnectAttachmentArgs', 'PolicyBasedRouteInterconnectAttachmentArgsDict']] interconnect_attachment: The interconnect attachments that this policy-based route applies to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name of the policy based route.
        :param pulumi.Input[str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[str] next_hop_ilb_ip: The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        :param pulumi.Input[str] next_hop_other_routes: Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        :param pulumi.Input[int] priority: The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
               policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
               priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        :param pulumi.Input[Union['PolicyBasedRouteVirtualMachineArgs', 'PolicyBasedRouteVirtualMachineArgsDict']] virtual_machine: VM instances to which this policy-based route applies to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyBasedRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Policy-based Routes are more powerful routes that route L4 network traffic based on not just destination IP, but also source IP, protocol and more. A Policy-based Route always take precedence when it conflicts with other types of routes.

        To get more information about PolicyBasedRoute, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.global.policyBasedRoutes)
        * How-to Guides
            * [Use policy-based routes](https://cloud.google.com/vpc/docs/use-policy-based-routes#api)

        ## Example Usage

        ### Network Connectivity Policy Based Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.PolicyBasedRoute("default",
            name="my-pbr",
            network=my_network.id,
            filter={
                "protocol_version": "IPV4",
            },
            next_hop_other_routes="DEFAULT_ROUTING")
        ```
        ### Network Connectivity Policy Based Route Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="my-network",
            auto_create_subnetworks=False)
        # This example substitutes an arbitrary internal IP for an internal network
        # load balancer for brevity. Consult https://cloud.google.com/load-balancing/docs/internal
        # to set one up.
        ilb = gcp.compute.GlobalAddress("ilb", name="my-ilb")
        default = gcp.networkconnectivity.PolicyBasedRoute("default",
            name="my-pbr",
            description="My routing policy",
            network=my_network.id,
            priority=2302,
            filter={
                "protocol_version": "IPV4",
                "ip_protocol": "UDP",
                "src_range": "10.0.0.0/24",
                "dest_range": "0.0.0.0/0",
            },
            next_hop_ilb_ip=ilb.address,
            virtual_machine={
                "tags": ["restricted"],
            },
            labels={
                "env": "default",
            })
        ```

        ## Import

        PolicyBasedRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/policyBasedRoutes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PolicyBasedRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default projects/{{project}}/locations/global/policyBasedRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PolicyBasedRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyBasedRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[Union['PolicyBasedRouteFilterArgs', 'PolicyBasedRouteFilterArgsDict']]] = None,
                 interconnect_attachment: Optional[pulumi.Input[Union['PolicyBasedRouteInterconnectAttachmentArgs', 'PolicyBasedRouteInterconnectAttachmentArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_other_routes: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 virtual_machine: Optional[pulumi.Input[Union['PolicyBasedRouteVirtualMachineArgs', 'PolicyBasedRouteVirtualMachineArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyBasedRouteArgs.__new__(PolicyBasedRouteArgs)

            __props__.__dict__["description"] = description
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            __props__.__dict__["interconnect_attachment"] = interconnect_attachment
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["next_hop_ilb_ip"] = next_hop_ilb_ip
            __props__.__dict__["next_hop_other_routes"] = next_hop_other_routes
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["virtual_machine"] = virtual_machine
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["warnings"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PolicyBasedRoute, __self__).__init__(
            'gcp:networkconnectivity/policyBasedRoute:PolicyBasedRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            filter: Optional[pulumi.Input[Union['PolicyBasedRouteFilterArgs', 'PolicyBasedRouteFilterArgsDict']]] = None,
            interconnect_attachment: Optional[pulumi.Input[Union['PolicyBasedRouteInterconnectAttachmentArgs', 'PolicyBasedRouteInterconnectAttachmentArgsDict']]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            next_hop_ilb_ip: Optional[pulumi.Input[str]] = None,
            next_hop_other_routes: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            virtual_machine: Optional[pulumi.Input[Union['PolicyBasedRouteVirtualMachineArgs', 'PolicyBasedRouteVirtualMachineArgsDict']]] = None,
            warnings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyBasedRouteWarningArgs', 'PolicyBasedRouteWarningArgsDict']]]]] = None) -> 'PolicyBasedRoute':
        """
        Get an existing PolicyBasedRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time when the policy-based route was created.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['PolicyBasedRouteFilterArgs', 'PolicyBasedRouteFilterArgsDict']] filter: The filter to match L4 traffic.
               Structure is documented below.
        :param pulumi.Input[Union['PolicyBasedRouteInterconnectAttachmentArgs', 'PolicyBasedRouteInterconnectAttachmentArgsDict']] interconnect_attachment: The interconnect attachments that this policy-based route applies to.
        :param pulumi.Input[str] kind: Type of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name of the policy based route.
        :param pulumi.Input[str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[str] next_hop_ilb_ip: The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        :param pulumi.Input[str] next_hop_other_routes: Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        :param pulumi.Input[int] priority: The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
               policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
               priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] update_time: Time when the policy-based route was created.
        :param pulumi.Input[Union['PolicyBasedRouteVirtualMachineArgs', 'PolicyBasedRouteVirtualMachineArgsDict']] virtual_machine: VM instances to which this policy-based route applies to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyBasedRouteWarningArgs', 'PolicyBasedRouteWarningArgsDict']]]] warnings: If potential misconfigurations are detected for this route, this field will be populated with warning messages.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyBasedRouteState.__new__(_PolicyBasedRouteState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["filter"] = filter
        __props__.__dict__["interconnect_attachment"] = interconnect_attachment
        __props__.__dict__["kind"] = kind
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["next_hop_ilb_ip"] = next_hop_ilb_ip
        __props__.__dict__["next_hop_other_routes"] = next_hop_other_routes
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["virtual_machine"] = virtual_machine
        __props__.__dict__["warnings"] = warnings
        return PolicyBasedRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the policy-based route was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output['outputs.PolicyBasedRouteFilter']:
        """
        The filter to match L4 traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> pulumi.Output[Optional['outputs.PolicyBasedRouteInterconnectAttachment']]:
        """
        The interconnect attachments that this policy-based route applies to.
        """
        return pulumi.get(self, "interconnect_attachment")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        Type of this resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHopIlbIp")
    def next_hop_ilb_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
        """
        return pulumi.get(self, "next_hop_ilb_ip")

    @property
    @pulumi.getter(name="nextHopOtherRoutes")
    def next_hop_other_routes(self) -> pulumi.Output[Optional[str]]:
        """
        Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
        """
        return pulumi.get(self, "next_hop_other_routes")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching
        policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered
        priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the policy-based route was created.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> pulumi.Output[Optional['outputs.PolicyBasedRouteVirtualMachine']]:
        """
        VM instances to which this policy-based route applies to.
        """
        return pulumi.get(self, "virtual_machine")

    @property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[Sequence['outputs.PolicyBasedRouteWarning']]:
        """
        If potential misconfigurations are detected for this route, this field will be populated with warning messages.
        Structure is documented below.
        """
        return pulumi.get(self, "warnings")

