# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpokeArgs', 'Spoke']

@pulumi.input_type
class SpokeArgs:
    def __init__(__self__, *,
                 hub: pulumi.Input[str],
                 location: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']] = None,
                 linked_vpc_network: Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Spoke resource.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs'] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs'] linked_router_appliance_instances: The URIs of linked Router appliance resources
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedVpcNetworkArgs'] linked_vpc_network: VPC network that is associated with the spoke.
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedVpnTunnelsArgs'] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
               Structure is documented below.
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "hub", hub)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpc_network is not None:
            pulumi.set(__self__, "linked_vpc_network", linked_vpc_network)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Input[str]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: pulumi.Input[str]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]:
        """
        The URIs of linked Router appliance resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpcNetwork")
    def linked_vpc_network(self) -> Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']]:
        """
        VPC network that is associated with the spoke.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpc_network")

    @linked_vpc_network.setter
    def linked_vpc_network(self, value: Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']]):
        pulumi.set(self, "linked_vpc_network", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]:
        """
        The URIs of linked VPN tunnel resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SpokeState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']] = None,
                 linked_vpc_network: Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 unique_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Spoke resources.
        :param pulumi.Input[str] create_time: Output only. The time the spoke was created.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs'] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs'] linked_router_appliance_instances: The URIs of linked Router appliance resources
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedVpcNetworkArgs'] linked_vpc_network: VPC network that is associated with the spoke.
               Structure is documented below.
        :param pulumi.Input['SpokeLinkedVpnTunnelsArgs'] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
               Structure is documented below.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] state: Output only. The current lifecycle state of this spoke.
        :param pulumi.Input[str] unique_id: Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        :param pulumi.Input[str] update_time: Output only. The time the spoke was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpc_network is not None:
            pulumi.set(__self__, "linked_vpc_network", linked_vpc_network)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if unique_id is not None:
            pulumi.set(__self__, "unique_id", unique_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time the spoke was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]:
        """
        The URIs of linked Router appliance resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpcNetwork")
    def linked_vpc_network(self) -> Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']]:
        """
        VPC network that is associated with the spoke.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpc_network")

    @linked_vpc_network.setter
    def linked_vpc_network(self, value: Optional[pulumi.Input['SpokeLinkedVpcNetworkArgs']]):
        pulumi.set(self, "linked_vpc_network", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]:
        """
        The URIs of linked VPN tunnel resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The current lifecycle state of this spoke.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @unique_id.setter
    def unique_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time the spoke was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Spoke(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[Union['SpokeLinkedInterconnectAttachmentsArgs', 'SpokeLinkedInterconnectAttachmentsArgsDict']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[Union['SpokeLinkedRouterApplianceInstancesArgs', 'SpokeLinkedRouterApplianceInstancesArgsDict']]] = None,
                 linked_vpc_network: Optional[pulumi.Input[Union['SpokeLinkedVpcNetworkArgs', 'SpokeLinkedVpcNetworkArgsDict']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[Union['SpokeLinkedVpnTunnelsArgs', 'SpokeLinkedVpnTunnelsArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The NetworkConnectivity Spoke resource

        To get more information about Spoke, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1beta/projects.locations.spokes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/overview)

        ## Example Usage

        ### Network Connectivity Spoke Linked Vpc Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="net",
            auto_create_subnetworks=False)
        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            name="spoke1",
            location="global",
            description="A sample spoke with a linked router appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpc_network={
                "exclude_export_ranges": [
                    "198.51.100.0/24",
                    "10.10.0.0/16",
                ],
                "include_export_ranges": [
                    "198.51.100.0/23",
                    "10.0.0.0/8",
                ],
                "uri": network.self_link,
            })
        ```
        ### Network Connectivity Spoke Router Appliance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="tf-test-network_2067",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="tf-test-subnet_40785",
            ip_cidr_range="10.0.0.0/28",
            region="us-central1",
            network=network.self_link)
        instance = gcp.compute.Instance("instance",
            name="tf-test-instance_79169",
            machine_type="e2-medium",
            can_ip_forward=True,
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "projects/debian-cloud/global/images/debian-10-buster-v20210817",
                },
            },
            network_interfaces=[{
                "subnetwork": subnetwork.name,
                "network_ip": "10.0.0.2",
                "access_configs": [{
                    "network_tier": "PREMIUM",
                }],
            }])
        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="tf-test-hub_56529",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            name="tf-test-name_75413",
            location="us-central1",
            description="A sample spoke with a linked routher appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_router_appliance_instances={
                "instances": [{
                    "virtual_machine": instance.self_link,
                    "ip_address": "10.0.0.2",
                }],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```
        ### Network Connectivity Spoke Vpn Tunnel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="basic-hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        network = gcp.compute.Network("network",
            name="basic-network",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="basic-subnetwork",
            ip_cidr_range="10.0.0.0/28",
            region="us-central1",
            network=network.self_link)
        gateway = gcp.compute.HaVpnGateway("gateway",
            name="vpn-gateway",
            network=network.id)
        external_vpn_gw = gcp.compute.ExternalVpnGateway("external_vpn_gw",
            name="external-vpn-gateway",
            redundancy_type="SINGLE_IP_INTERNALLY_REDUNDANT",
            description="An externally managed VPN gateway",
            interfaces=[{
                "id": 0,
                "ip_address": "8.8.8.8",
            }])
        router = gcp.compute.Router("router",
            name="external-vpn-gateway",
            region="us-central1",
            network=network.name,
            bgp={
                "asn": 64514,
            })
        tunnel1 = gcp.compute.VPNTunnel("tunnel1",
            name="tunnel1",
            region="us-central1",
            vpn_gateway=gateway.id,
            peer_external_gateway=external_vpn_gw.id,
            peer_external_gateway_interface=0,
            shared_secret="a secret message",
            router=router.id,
            vpn_gateway_interface=0)
        tunnel2 = gcp.compute.VPNTunnel("tunnel2",
            name="tunnel2",
            region="us-central1",
            vpn_gateway=gateway.id,
            peer_external_gateway=external_vpn_gw.id,
            peer_external_gateway_interface=0,
            shared_secret="a secret message",
            router=router.id.apply(lambda id: f" {id}"),
            vpn_gateway_interface=1)
        router_interface1 = gcp.compute.RouterInterface("router_interface1",
            name="router-interface1",
            router=router.name,
            region="us-central1",
            ip_range="169.254.0.1/30",
            vpn_tunnel=tunnel1.name)
        router_peer1 = gcp.compute.RouterPeer("router_peer1",
            name="router-peer1",
            router=router.name,
            region="us-central1",
            peer_ip_address="169.254.0.2",
            peer_asn=64515,
            advertised_route_priority=100,
            interface=router_interface1.name)
        router_interface2 = gcp.compute.RouterInterface("router_interface2",
            name="router-interface2",
            router=router.name,
            region="us-central1",
            ip_range="169.254.1.1/30",
            vpn_tunnel=tunnel2.name)
        router_peer2 = gcp.compute.RouterPeer("router_peer2",
            name="router-peer2",
            router=router.name,
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=64515,
            advertised_route_priority=100,
            interface=router_interface2.name)
        tunnel1_spoke = gcp.networkconnectivity.Spoke("tunnel1",
            name="vpn-tunnel-1-spoke",
            location="us-central1",
            description="A sample spoke with a linked VPN Tunnel",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpn_tunnels={
                "uris": [tunnel1.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        tunnel2_spoke = gcp.networkconnectivity.Spoke("tunnel2",
            name="vpn-tunnel-2-spoke",
            location="us-central1",
            description="A sample spoke with a linked VPN Tunnel",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpn_tunnels={
                "uris": [tunnel2.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```
        ### Network Connectivity Spoke Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="basic-hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        network = gcp.compute.Network("network",
            name="basic-network",
            auto_create_subnetworks=False)
        router = gcp.compute.Router("router",
            name="external-vpn-gateway",
            region="us-central1",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        interconnect_attachment = gcp.compute.InterconnectAttachment("interconnect-attachment",
            name="partner-interconnect1",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500",
            region="us-central1")
        primary = gcp.networkconnectivity.Spoke("primary",
            name="interconnect-attachment-spoke",
            location="us-central1",
            description="A sample spoke with a linked Interconnect Attachment",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_interconnect_attachments={
                "uris": [interconnect_attachment.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```

        ## Import

        Spoke can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/spokes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Spoke can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default projects/{{project}}/locations/{{location}}/spokes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['SpokeLinkedInterconnectAttachmentsArgs', 'SpokeLinkedInterconnectAttachmentsArgsDict']] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedRouterApplianceInstancesArgs', 'SpokeLinkedRouterApplianceInstancesArgsDict']] linked_router_appliance_instances: The URIs of linked Router appliance resources
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedVpcNetworkArgs', 'SpokeLinkedVpcNetworkArgsDict']] linked_vpc_network: VPC network that is associated with the spoke.
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedVpnTunnelsArgs', 'SpokeLinkedVpnTunnelsArgsDict']] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
               Structure is documented below.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpokeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The NetworkConnectivity Spoke resource

        To get more information about Spoke, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1beta/projects.locations.spokes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/overview)

        ## Example Usage

        ### Network Connectivity Spoke Linked Vpc Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="net",
            auto_create_subnetworks=False)
        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            name="spoke1",
            location="global",
            description="A sample spoke with a linked router appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpc_network={
                "exclude_export_ranges": [
                    "198.51.100.0/24",
                    "10.10.0.0/16",
                ],
                "include_export_ranges": [
                    "198.51.100.0/23",
                    "10.0.0.0/8",
                ],
                "uri": network.self_link,
            })
        ```
        ### Network Connectivity Spoke Router Appliance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="tf-test-network_2067",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="tf-test-subnet_40785",
            ip_cidr_range="10.0.0.0/28",
            region="us-central1",
            network=network.self_link)
        instance = gcp.compute.Instance("instance",
            name="tf-test-instance_79169",
            machine_type="e2-medium",
            can_ip_forward=True,
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "projects/debian-cloud/global/images/debian-10-buster-v20210817",
                },
            },
            network_interfaces=[{
                "subnetwork": subnetwork.name,
                "network_ip": "10.0.0.2",
                "access_configs": [{
                    "network_tier": "PREMIUM",
                }],
            }])
        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="tf-test-hub_56529",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            name="tf-test-name_75413",
            location="us-central1",
            description="A sample spoke with a linked routher appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_router_appliance_instances={
                "instances": [{
                    "virtual_machine": instance.self_link,
                    "ip_address": "10.0.0.2",
                }],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```
        ### Network Connectivity Spoke Vpn Tunnel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="basic-hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        network = gcp.compute.Network("network",
            name="basic-network",
            auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="basic-subnetwork",
            ip_cidr_range="10.0.0.0/28",
            region="us-central1",
            network=network.self_link)
        gateway = gcp.compute.HaVpnGateway("gateway",
            name="vpn-gateway",
            network=network.id)
        external_vpn_gw = gcp.compute.ExternalVpnGateway("external_vpn_gw",
            name="external-vpn-gateway",
            redundancy_type="SINGLE_IP_INTERNALLY_REDUNDANT",
            description="An externally managed VPN gateway",
            interfaces=[{
                "id": 0,
                "ip_address": "8.8.8.8",
            }])
        router = gcp.compute.Router("router",
            name="external-vpn-gateway",
            region="us-central1",
            network=network.name,
            bgp={
                "asn": 64514,
            })
        tunnel1 = gcp.compute.VPNTunnel("tunnel1",
            name="tunnel1",
            region="us-central1",
            vpn_gateway=gateway.id,
            peer_external_gateway=external_vpn_gw.id,
            peer_external_gateway_interface=0,
            shared_secret="a secret message",
            router=router.id,
            vpn_gateway_interface=0)
        tunnel2 = gcp.compute.VPNTunnel("tunnel2",
            name="tunnel2",
            region="us-central1",
            vpn_gateway=gateway.id,
            peer_external_gateway=external_vpn_gw.id,
            peer_external_gateway_interface=0,
            shared_secret="a secret message",
            router=router.id.apply(lambda id: f" {id}"),
            vpn_gateway_interface=1)
        router_interface1 = gcp.compute.RouterInterface("router_interface1",
            name="router-interface1",
            router=router.name,
            region="us-central1",
            ip_range="169.254.0.1/30",
            vpn_tunnel=tunnel1.name)
        router_peer1 = gcp.compute.RouterPeer("router_peer1",
            name="router-peer1",
            router=router.name,
            region="us-central1",
            peer_ip_address="169.254.0.2",
            peer_asn=64515,
            advertised_route_priority=100,
            interface=router_interface1.name)
        router_interface2 = gcp.compute.RouterInterface("router_interface2",
            name="router-interface2",
            router=router.name,
            region="us-central1",
            ip_range="169.254.1.1/30",
            vpn_tunnel=tunnel2.name)
        router_peer2 = gcp.compute.RouterPeer("router_peer2",
            name="router-peer2",
            router=router.name,
            region="us-central1",
            peer_ip_address="169.254.1.2",
            peer_asn=64515,
            advertised_route_priority=100,
            interface=router_interface2.name)
        tunnel1_spoke = gcp.networkconnectivity.Spoke("tunnel1",
            name="vpn-tunnel-1-spoke",
            location="us-central1",
            description="A sample spoke with a linked VPN Tunnel",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpn_tunnels={
                "uris": [tunnel1.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        tunnel2_spoke = gcp.networkconnectivity.Spoke("tunnel2",
            name="vpn-tunnel-2-spoke",
            location="us-central1",
            description="A sample spoke with a linked VPN Tunnel",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_vpn_tunnels={
                "uris": [tunnel2.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```
        ### Network Connectivity Spoke Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_hub = gcp.networkconnectivity.Hub("basic_hub",
            name="basic-hub1",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        network = gcp.compute.Network("network",
            name="basic-network",
            auto_create_subnetworks=False)
        router = gcp.compute.Router("router",
            name="external-vpn-gateway",
            region="us-central1",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        interconnect_attachment = gcp.compute.InterconnectAttachment("interconnect-attachment",
            name="partner-interconnect1",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500",
            region="us-central1")
        primary = gcp.networkconnectivity.Spoke("primary",
            name="interconnect-attachment-spoke",
            location="us-central1",
            description="A sample spoke with a linked Interconnect Attachment",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_interconnect_attachments={
                "uris": [interconnect_attachment.self_link],
                "site_to_site_data_transfer": True,
                "include_import_ranges": ["ALL_IPV4_RANGES"],
            })
        ```

        ## Import

        Spoke can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/spokes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Spoke can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default projects/{{project}}/locations/{{location}}/spokes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SpokeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpokeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[Union['SpokeLinkedInterconnectAttachmentsArgs', 'SpokeLinkedInterconnectAttachmentsArgsDict']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[Union['SpokeLinkedRouterApplianceInstancesArgs', 'SpokeLinkedRouterApplianceInstancesArgsDict']]] = None,
                 linked_vpc_network: Optional[pulumi.Input[Union['SpokeLinkedVpcNetworkArgs', 'SpokeLinkedVpcNetworkArgsDict']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[Union['SpokeLinkedVpnTunnelsArgs', 'SpokeLinkedVpnTunnelsArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpokeArgs.__new__(SpokeArgs)

            __props__.__dict__["description"] = description
            if hub is None and not opts.urn:
                raise TypeError("Missing required property 'hub'")
            __props__.__dict__["hub"] = hub
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
            __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
            __props__.__dict__["linked_vpc_network"] = linked_vpc_network
            __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["unique_id"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Spoke, __self__).__init__(
            'gcp:networkconnectivity/spoke:Spoke',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            hub: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            linked_interconnect_attachments: Optional[pulumi.Input[Union['SpokeLinkedInterconnectAttachmentsArgs', 'SpokeLinkedInterconnectAttachmentsArgsDict']]] = None,
            linked_router_appliance_instances: Optional[pulumi.Input[Union['SpokeLinkedRouterApplianceInstancesArgs', 'SpokeLinkedRouterApplianceInstancesArgsDict']]] = None,
            linked_vpc_network: Optional[pulumi.Input[Union['SpokeLinkedVpcNetworkArgs', 'SpokeLinkedVpcNetworkArgsDict']]] = None,
            linked_vpn_tunnels: Optional[pulumi.Input[Union['SpokeLinkedVpnTunnelsArgs', 'SpokeLinkedVpnTunnelsArgsDict']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            unique_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Spoke':
        """
        Get an existing Spoke resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Output only. The time the spoke was created.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['SpokeLinkedInterconnectAttachmentsArgs', 'SpokeLinkedInterconnectAttachmentsArgsDict']] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedRouterApplianceInstancesArgs', 'SpokeLinkedRouterApplianceInstancesArgsDict']] linked_router_appliance_instances: The URIs of linked Router appliance resources
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedVpcNetworkArgs', 'SpokeLinkedVpcNetworkArgsDict']] linked_vpc_network: VPC network that is associated with the spoke.
               Structure is documented below.
        :param pulumi.Input[Union['SpokeLinkedVpnTunnelsArgs', 'SpokeLinkedVpnTunnelsArgsDict']] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
               Structure is documented below.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] state: Output only. The current lifecycle state of this spoke.
        :param pulumi.Input[str] unique_id: Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        :param pulumi.Input[str] update_time: Output only. The time the spoke was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpokeState.__new__(_SpokeState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["hub"] = hub
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
        __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
        __props__.__dict__["linked_vpc_network"] = linked_vpc_network
        __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["unique_id"] = unique_id
        __props__.__dict__["update_time"] = update_time
        return Spoke(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The time the spoke was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Output[str]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> pulumi.Output[Optional['outputs.SpokeLinkedInterconnectAttachments']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> pulumi.Output[Optional['outputs.SpokeLinkedRouterApplianceInstances']]:
        """
        The URIs of linked Router appliance resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @property
    @pulumi.getter(name="linkedVpcNetwork")
    def linked_vpc_network(self) -> pulumi.Output[Optional['outputs.SpokeLinkedVpcNetwork']]:
        """
        VPC network that is associated with the spoke.
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpc_network")

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> pulumi.Output[Optional['outputs.SpokeLinkedVpnTunnels']]:
        """
        The URIs of linked VPN tunnel resources
        Structure is documented below.
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The current lifecycle state of this spoke.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[str]:
        """
        Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time the spoke was last updated.
        """
        return pulumi.get(self, "update_time")

