# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddressGroupIamBindingCondition',
    'AddressGroupIamMemberCondition',
    'AuthorizationPolicyRule',
    'AuthorizationPolicyRuleDestination',
    'AuthorizationPolicyRuleDestinationHttpHeaderMatch',
    'AuthorizationPolicyRuleSource',
    'ClientTlsPolicyClientCertificate',
    'ClientTlsPolicyClientCertificateCertificateProviderInstance',
    'ClientTlsPolicyClientCertificateGrpcEndpoint',
    'ClientTlsPolicyServerValidationCa',
    'ClientTlsPolicyServerValidationCaCertificateProviderInstance',
    'ClientTlsPolicyServerValidationCaGrpcEndpoint',
    'SecurityProfileThreatPreventionProfile',
    'SecurityProfileThreatPreventionProfileSeverityOverride',
    'SecurityProfileThreatPreventionProfileThreatOverride',
    'ServerTlsPolicyMtlsPolicy',
    'ServerTlsPolicyMtlsPolicyClientValidationCa',
    'ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance',
    'ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint',
    'ServerTlsPolicyServerCertificate',
    'ServerTlsPolicyServerCertificateCertificateProviderInstance',
    'ServerTlsPolicyServerCertificateGrpcEndpoint',
]

@pulumi.output_type
class AddressGroupIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AddressGroupIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AuthorizationPolicyRule(dict):
    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.AuthorizationPolicyRuleDestination']] = None,
                 sources: Optional[Sequence['outputs.AuthorizationPolicyRuleSource']] = None):
        """
        :param Sequence['AuthorizationPolicyRuleDestinationArgs'] destinations: List of attributes for the traffic destination. All of the destinations must match. A destination is a match if a request matches all the specified hosts, ports, methods and headers.
               If not set, the action specified in the 'action' field will be applied without any rule checks for the destination.
               Structure is documented below.
        :param Sequence['AuthorizationPolicyRuleSourceArgs'] sources: List of attributes for the traffic source. All of the sources must match. A source is a match if both principals and ipBlocks match.
               If not set, the action specified in the 'action' field will be applied without any rule checks for the source.
               Structure is documented below.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.AuthorizationPolicyRuleDestination']]:
        """
        List of attributes for the traffic destination. All of the destinations must match. A destination is a match if a request matches all the specified hosts, ports, methods and headers.
        If not set, the action specified in the 'action' field will be applied without any rule checks for the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AuthorizationPolicyRuleSource']]:
        """
        List of attributes for the traffic source. All of the sources must match. A source is a match if both principals and ipBlocks match.
        If not set, the action specified in the 'action' field will be applied without any rule checks for the source.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class AuthorizationPolicyRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaderMatch":
            suggest = "http_header_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[str],
                 methods: Sequence[str],
                 ports: Sequence[int],
                 http_header_match: Optional['outputs.AuthorizationPolicyRuleDestinationHttpHeaderMatch'] = None):
        """
        :param Sequence[str] hosts: List of host names to match. Matched against the ":authority" header in http requests. At least one host should match. Each host can be an exact match, or a prefix match (example "mydomain.*") or a suffix match (example "*.myorg.com") or a presence (any) match "*".
        :param Sequence[str] methods: A list of HTTP methods to match. At least one method should match. Should not be set for gRPC services.
        :param Sequence[int] ports: List of destination ports to match. At least one port should match.
        :param 'AuthorizationPolicyRuleDestinationHttpHeaderMatchArgs' http_header_match: Match against key:value pair in http header. Provides a flexible match based on HTTP headers, for potentially advanced use cases. At least one header should match.
               Avoid using header matches to make authorization decisions unless there is a strong guarantee that requests arrive through a trusted client or proxy.
               Structure is documented below.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "ports", ports)
        if http_header_match is not None:
            pulumi.set(__self__, "http_header_match", http_header_match)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[str]:
        """
        List of host names to match. Matched against the ":authority" header in http requests. At least one host should match. Each host can be an exact match, or a prefix match (example "mydomain.*") or a suffix match (example "*.myorg.com") or a presence (any) match "*".
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> Sequence[str]:
        """
        A list of HTTP methods to match. At least one method should match. Should not be set for gRPC services.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[int]:
        """
        List of destination ports to match. At least one port should match.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="httpHeaderMatch")
    def http_header_match(self) -> Optional['outputs.AuthorizationPolicyRuleDestinationHttpHeaderMatch']:
        """
        Match against key:value pair in http header. Provides a flexible match based on HTTP headers, for potentially advanced use cases. At least one header should match.
        Avoid using header matches to make authorization decisions unless there is a strong guarantee that requests arrive through a trusted client or proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "http_header_match")


@pulumi.output_type
class AuthorizationPolicyRuleDestinationHttpHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleDestinationHttpHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleDestinationHttpHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleDestinationHttpHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 regex_match: str):
        """
        :param str header_name: The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method".
        :param str regex_match: The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port specified in the HTTP request, use a headerMatch with headerName set to Host and a regular expression that satisfies the RFC2616 Host header's port specifier.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method".
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> str:
        """
        The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port specified in the HTTP request, use a headerMatch with headerName set to Host and a regular expression that satisfies the RFC2616 Host header's port specifier.
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class AuthorizationPolicyRuleSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlocks":
            suggest = "ip_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationPolicyRuleSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationPolicyRuleSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationPolicyRuleSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_blocks: Optional[Sequence[str]] = None,
                 principals: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] ip_blocks: List of CIDR ranges to match based on source IP address. At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone should be avoided.
               The IP addresses of any load balancers or proxies should be considered untrusted.
        :param Sequence[str] principals: List of peer identities to match for authorization. At least one principal should match. Each peer can be an exact match, or a prefix match (example, "namespace/*") or a suffix match (example, "*/service-account") or a presence match "*".
               Authorization based on the principal name without certificate validation (configured by ServerTlsPolicy resource) is considered insecure.
        """
        if ip_blocks is not None:
            pulumi.set(__self__, "ip_blocks", ip_blocks)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter(name="ipBlocks")
    def ip_blocks(self) -> Optional[Sequence[str]]:
        """
        List of CIDR ranges to match based on source IP address. At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone should be avoided.
        The IP addresses of any load balancers or proxies should be considered untrusted.
        """
        return pulumi.get(self, "ip_blocks")

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence[str]]:
        """
        List of peer identities to match for authorization. At least one principal should match. Each peer can be an exact match, or a prefix match (example, "namespace/*") or a suffix match (example, "*/service-account") or a presence match "*".
        Authorization based on the principal name without certificate validation (configured by ServerTlsPolicy resource) is considered insecure.
        """
        return pulumi.get(self, "principals")


@pulumi.output_type
class ClientTlsPolicyClientCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ClientTlsPolicyClientCertificateCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ClientTlsPolicyClientCertificateGrpcEndpoint'] = None):
        """
        :param 'ClientTlsPolicyClientCertificateCertificateProviderInstanceArgs' certificate_provider_instance: The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
               Structure is documented below.
        :param 'ClientTlsPolicyClientCertificateGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ClientTlsPolicyClientCertificateCertificateProviderInstance']:
        """
        The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ClientTlsPolicyClientCertificateGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ClientTlsPolicyClientCertificateCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificateCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificateCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificateCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: str):
        """
        :param str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ClientTlsPolicyClientCertificateGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyClientCertificateGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyClientCertificateGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyClientCertificateGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: str):
        """
        :param str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class ClientTlsPolicyServerValidationCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ClientTlsPolicyServerValidationCaCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ClientTlsPolicyServerValidationCaGrpcEndpoint'] = None):
        """
        :param 'ClientTlsPolicyServerValidationCaCertificateProviderInstanceArgs' certificate_provider_instance: The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
               Structure is documented below.
        :param 'ClientTlsPolicyServerValidationCaGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ClientTlsPolicyServerValidationCaCertificateProviderInstance']:
        """
        The certificate provider instance specification that will be passed to the data plane, which will be used to load necessary credential information.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ClientTlsPolicyServerValidationCaGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ClientTlsPolicyServerValidationCaCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCaCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCaCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCaCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: str):
        """
        :param str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ClientTlsPolicyServerValidationCaGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientTlsPolicyServerValidationCaGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientTlsPolicyServerValidationCaGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientTlsPolicyServerValidationCaGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: str):
        """
        :param str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class SecurityProfileThreatPreventionProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "severityOverrides":
            suggest = "severity_overrides"
        elif key == "threatOverrides":
            suggest = "threat_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileThreatPreventionProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileThreatPreventionProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileThreatPreventionProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 severity_overrides: Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileSeverityOverride']] = None,
                 threat_overrides: Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileThreatOverride']] = None):
        """
        :param Sequence['SecurityProfileThreatPreventionProfileSeverityOverrideArgs'] severity_overrides: The configuration for overriding threats actions by severity match.
               Structure is documented below.
        :param Sequence['SecurityProfileThreatPreventionProfileThreatOverrideArgs'] threat_overrides: The configuration for overriding threats actions by threat id match.
               If a threat is matched both by configuration provided in severity overrides
               and threat overrides, the threat overrides action is applied.
               Structure is documented below.
        """
        if severity_overrides is not None:
            pulumi.set(__self__, "severity_overrides", severity_overrides)
        if threat_overrides is not None:
            pulumi.set(__self__, "threat_overrides", threat_overrides)

    @property
    @pulumi.getter(name="severityOverrides")
    def severity_overrides(self) -> Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileSeverityOverride']]:
        """
        The configuration for overriding threats actions by severity match.
        Structure is documented below.
        """
        return pulumi.get(self, "severity_overrides")

    @property
    @pulumi.getter(name="threatOverrides")
    def threat_overrides(self) -> Optional[Sequence['outputs.SecurityProfileThreatPreventionProfileThreatOverride']]:
        """
        The configuration for overriding threats actions by threat id match.
        If a threat is matched both by configuration provided in severity overrides
        and threat overrides, the threat overrides action is applied.
        Structure is documented below.
        """
        return pulumi.get(self, "threat_overrides")


@pulumi.output_type
class SecurityProfileThreatPreventionProfileSeverityOverride(dict):
    def __init__(__self__, *,
                 action: str,
                 severity: str):
        """
        :param str action: Threat action override.
               Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        :param str severity: Severity level to match.
               Possible values are: `CRITICAL`, `HIGH`, `INFORMATIONAL`, `LOW`, `MEDIUM`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Threat action override.
        Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity level to match.
        Possible values are: `CRITICAL`, `HIGH`, `INFORMATIONAL`, `LOW`, `MEDIUM`.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class SecurityProfileThreatPreventionProfileThreatOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threatId":
            suggest = "threat_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileThreatPreventionProfileThreatOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileThreatPreventionProfileThreatOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileThreatPreventionProfileThreatOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 threat_id: str,
                 type: Optional[str] = None):
        """
        :param str action: Threat action.
               Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        :param str threat_id: Vendor-specific ID of a threat to override.
        :param str type: (Output)
               Type of threat.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "threat_id", threat_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Threat action.
        Possible values are: `ALERT`, `ALLOW`, `DEFAULT_ACTION`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="threatId")
    def threat_id(self) -> str:
        """
        Vendor-specific ID of a threat to override.
        """
        return pulumi.get(self, "threat_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        Type of threat.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientValidationCas":
            suggest = "client_validation_cas"
        elif key == "clientValidationMode":
            suggest = "client_validation_mode"
        elif key == "clientValidationTrustConfig":
            suggest = "client_validation_trust_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_validation_cas: Optional[Sequence['outputs.ServerTlsPolicyMtlsPolicyClientValidationCa']] = None,
                 client_validation_mode: Optional[str] = None,
                 client_validation_trust_config: Optional[str] = None):
        """
        :param Sequence['ServerTlsPolicyMtlsPolicyClientValidationCaArgs'] client_validation_cas: Required if the policy is to be used with Traffic Director. For external HTTPS load balancers it must be empty.
               Defines the mechanism to obtain the Certificate Authority certificate to validate the client certificate.
               Structure is documented below.
        :param str client_validation_mode: When the client presents an invalid certificate or no certificate to the load balancer, the clientValidationMode specifies how the client connection is handled.
               Required if the policy is to be used with the external HTTPS load balancing. For Traffic Director it must be empty.
               Possible values are: `CLIENT_VALIDATION_MODE_UNSPECIFIED`, `ALLOW_INVALID_OR_MISSING_CLIENT_CERT`, `REJECT_INVALID`.
        :param str client_validation_trust_config: Reference to the TrustConfig from certificatemanager.googleapis.com namespace.
               If specified, the chain validation will be performed against certificates configured in the given TrustConfig.
               Allowed only if the policy is to be used with external HTTPS load balancers.
        """
        if client_validation_cas is not None:
            pulumi.set(__self__, "client_validation_cas", client_validation_cas)
        if client_validation_mode is not None:
            pulumi.set(__self__, "client_validation_mode", client_validation_mode)
        if client_validation_trust_config is not None:
            pulumi.set(__self__, "client_validation_trust_config", client_validation_trust_config)

    @property
    @pulumi.getter(name="clientValidationCas")
    def client_validation_cas(self) -> Optional[Sequence['outputs.ServerTlsPolicyMtlsPolicyClientValidationCa']]:
        """
        Required if the policy is to be used with Traffic Director. For external HTTPS load balancers it must be empty.
        Defines the mechanism to obtain the Certificate Authority certificate to validate the client certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "client_validation_cas")

    @property
    @pulumi.getter(name="clientValidationMode")
    def client_validation_mode(self) -> Optional[str]:
        """
        When the client presents an invalid certificate or no certificate to the load balancer, the clientValidationMode specifies how the client connection is handled.
        Required if the policy is to be used with the external HTTPS load balancing. For Traffic Director it must be empty.
        Possible values are: `CLIENT_VALIDATION_MODE_UNSPECIFIED`, `ALLOW_INVALID_OR_MISSING_CLIENT_CERT`, `REJECT_INVALID`.
        """
        return pulumi.get(self, "client_validation_mode")

    @property
    @pulumi.getter(name="clientValidationTrustConfig")
    def client_validation_trust_config(self) -> Optional[str]:
        """
        Reference to the TrustConfig from certificatemanager.googleapis.com namespace.
        If specified, the chain validation will be performed against certificates configured in the given TrustConfig.
        Allowed only if the policy is to be used with external HTTPS load balancers.
        """
        return pulumi.get(self, "client_validation_trust_config")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint'] = None):
        """
        :param 'ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceArgs' certificate_provider_instance: Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
               Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
               Structure is documented below.
        :param 'ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance']:
        """
        Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
        Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: str):
        """
        :param str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: str):
        """
        :param str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


@pulumi.output_type
class ServerTlsPolicyServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateProviderInstance":
            suggest = "certificate_provider_instance"
        elif key == "grpcEndpoint":
            suggest = "grpc_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_provider_instance: Optional['outputs.ServerTlsPolicyServerCertificateCertificateProviderInstance'] = None,
                 grpc_endpoint: Optional['outputs.ServerTlsPolicyServerCertificateGrpcEndpoint'] = None):
        """
        :param 'ServerTlsPolicyServerCertificateCertificateProviderInstanceArgs' certificate_provider_instance: Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
               Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
               Structure is documented below.
        :param 'ServerTlsPolicyServerCertificateGrpcEndpointArgs' grpc_endpoint: gRPC specific configuration to access the gRPC server to obtain the cert and private key.
               Structure is documented below.
        """
        if certificate_provider_instance is not None:
            pulumi.set(__self__, "certificate_provider_instance", certificate_provider_instance)
        if grpc_endpoint is not None:
            pulumi.set(__self__, "grpc_endpoint", grpc_endpoint)

    @property
    @pulumi.getter(name="certificateProviderInstance")
    def certificate_provider_instance(self) -> Optional['outputs.ServerTlsPolicyServerCertificateCertificateProviderInstance']:
        """
        Optional if policy is to be used with Traffic Director. For external HTTPS load balancer must be empty.
        Defines a mechanism to provision server identity (public and private keys). Cannot be combined with allowOpen as a permissive mode that allows both plain text and TLS is not supported.
        Structure is documented below.
        """
        return pulumi.get(self, "certificate_provider_instance")

    @property
    @pulumi.getter(name="grpcEndpoint")
    def grpc_endpoint(self) -> Optional['outputs.ServerTlsPolicyServerCertificateGrpcEndpoint']:
        """
        gRPC specific configuration to access the gRPC server to obtain the cert and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_endpoint")


@pulumi.output_type
class ServerTlsPolicyServerCertificateCertificateProviderInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificateCertificateProviderInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificateCertificateProviderInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificateCertificateProviderInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plugin_instance: str):
        """
        :param str plugin_instance: Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        pulumi.set(__self__, "plugin_instance", plugin_instance)

    @property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> str:
        """
        Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class ServerTlsPolicyServerCertificateGrpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUri":
            suggest = "target_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTlsPolicyServerCertificateGrpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTlsPolicyServerCertificateGrpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTlsPolicyServerCertificateGrpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_uri: str):
        """
        :param str target_uri: The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        pulumi.set(__self__, "target_uri", target_uri)

    @property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> str:
        """
        The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
        """
        return pulumi.get(self, "target_uri")


