# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerTlsPolicyArgs', 'ServerTlsPolicy']

@pulumi.input_type
class ServerTlsPolicyArgs:
    def __init__(__self__, *,
                 allow_open: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mtls_policy: Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_certificate: Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']] = None):
        """
        The set of arguments for constructing a ServerTlsPolicy resource.
        :param pulumi.Input[bool] allow_open: This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
               Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
               Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the ServerTlsPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of the server tls policy.
               The default value is `global`.
        :param pulumi.Input['ServerTlsPolicyMtlsPolicyArgs'] mtls_policy: This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
               Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the ServerTlsPolicy resource.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ServerTlsPolicyServerCertificateArgs'] server_certificate: Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
               Structure is documented below.
        """
        if allow_open is not None:
            pulumi.set(__self__, "allow_open", allow_open)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mtls_policy is not None:
            pulumi.set(__self__, "mtls_policy", mtls_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)

    @property
    @pulumi.getter(name="allowOpen")
    def allow_open(self) -> Optional[pulumi.Input[bool]]:
        """
        This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
        Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
        Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        """
        return pulumi.get(self, "allow_open")

    @allow_open.setter
    def allow_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_open", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the ServerTlsPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the server tls policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mtlsPolicy")
    def mtls_policy(self) -> Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']]:
        """
        This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
        Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
        Structure is documented below.
        """
        return pulumi.get(self, "mtls_policy")

    @mtls_policy.setter
    def mtls_policy(self, value: Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']]):
        pulumi.set(self, "mtls_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ServerTlsPolicy resource.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']]:
        """
        Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
        Structure is documented below.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']]):
        pulumi.set(self, "server_certificate", value)


@pulumi.input_type
class _ServerTlsPolicyState:
    def __init__(__self__, *,
                 allow_open: Optional[pulumi.Input[bool]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mtls_policy: Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 server_certificate: Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerTlsPolicy resources.
        :param pulumi.Input[bool] allow_open: This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
               Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
               Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        :param pulumi.Input[str] create_time: Time the ServerTlsPolicy was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the ServerTlsPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of the server tls policy.
               The default value is `global`.
        :param pulumi.Input['ServerTlsPolicyMtlsPolicyArgs'] mtls_policy: This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
               Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the ServerTlsPolicy resource.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['ServerTlsPolicyServerCertificateArgs'] server_certificate: Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
               Structure is documented below.
        :param pulumi.Input[str] update_time: Time the ServerTlsPolicy was updated in UTC.
        """
        if allow_open is not None:
            pulumi.set(__self__, "allow_open", allow_open)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mtls_policy is not None:
            pulumi.set(__self__, "mtls_policy", mtls_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="allowOpen")
    def allow_open(self) -> Optional[pulumi.Input[bool]]:
        """
        This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
        Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
        Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        """
        return pulumi.get(self, "allow_open")

    @allow_open.setter
    def allow_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_open", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the ServerTlsPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the ServerTlsPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the server tls policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mtlsPolicy")
    def mtls_policy(self) -> Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']]:
        """
        This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
        Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
        Structure is documented below.
        """
        return pulumi.get(self, "mtls_policy")

    @mtls_policy.setter
    def mtls_policy(self, value: Optional[pulumi.Input['ServerTlsPolicyMtlsPolicyArgs']]):
        pulumi.set(self, "mtls_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ServerTlsPolicy resource.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']]:
        """
        Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
        Structure is documented below.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input['ServerTlsPolicyServerCertificateArgs']]):
        pulumi.set(self, "server_certificate", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the ServerTlsPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class ServerTlsPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_open: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mtls_policy: Optional[pulumi.Input[Union['ServerTlsPolicyMtlsPolicyArgs', 'ServerTlsPolicyMtlsPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_certificate: Optional[pulumi.Input[Union['ServerTlsPolicyServerCertificateArgs', 'ServerTlsPolicyServerCertificateArgsDict']]] = None,
                 __props__=None):
        """
        ClientTlsPolicy is a resource that specifies how a client should authenticate connections to backends of a service. This resource itself does not affect configuration unless it is attached to a backend service resource.

        To get more information about ServerTlsPolicy, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-security/rest/v1beta1/projects.locations.serverTlsPolicies)

        ## Example Usage

        ### Network Security Server Tls Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            allow_open=False,
            server_certificate={
                "certificate_provider_instance": {
                    "plugin_instance": "google_cloud_private_spiffe",
                },
            },
            mtls_policy={
                "client_validation_cas": [{
                    "grpc_endpoint": {
                        "target_uri": "unix:mypath",
                    },
                }],
            })
        ```
        ### Network Security Server Tls Policy Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "ALLOW_INVALID_OR_MISSING_CLIENT_CERT",
            })
        ```
        ### Network Security Server Tls Policy Server Cert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            location="global",
            allow_open=False,
            server_certificate={
                "grpc_endpoint": {
                    "target_uri": "unix:mypath",
                },
            })
        ```
        ### Network Security Server Tls Policy Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample trust config description",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "REJECT_INVALID",
                "client_validation_trust_config": default_trust_config.name.apply(lambda name: f"projects/{project.number}/locations/global/trustConfigs/{name}"),
            },
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        ServerTlsPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serverTlsPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServerTlsPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default projects/{{project}}/locations/{{location}}/serverTlsPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_open: This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
               Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
               Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the ServerTlsPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of the server tls policy.
               The default value is `global`.
        :param pulumi.Input[Union['ServerTlsPolicyMtlsPolicyArgs', 'ServerTlsPolicyMtlsPolicyArgsDict']] mtls_policy: This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
               Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the ServerTlsPolicy resource.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ServerTlsPolicyServerCertificateArgs', 'ServerTlsPolicyServerCertificateArgsDict']] server_certificate: Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerTlsPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ClientTlsPolicy is a resource that specifies how a client should authenticate connections to backends of a service. This resource itself does not affect configuration unless it is attached to a backend service resource.

        To get more information about ServerTlsPolicy, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-security/rest/v1beta1/projects.locations.serverTlsPolicies)

        ## Example Usage

        ### Network Security Server Tls Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            allow_open=False,
            server_certificate={
                "certificate_provider_instance": {
                    "plugin_instance": "google_cloud_private_spiffe",
                },
            },
            mtls_policy={
                "client_validation_cas": [{
                    "grpc_endpoint": {
                        "target_uri": "unix:mypath",
                    },
                }],
            })
        ```
        ### Network Security Server Tls Policy Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "ALLOW_INVALID_OR_MISSING_CLIENT_CERT",
            })
        ```
        ### Network Security Server Tls Policy Server Cert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            location="global",
            allow_open=False,
            server_certificate={
                "grpc_endpoint": {
                    "target_uri": "unix:mypath",
                },
            })
        ```
        ### Network Security Server Tls Policy Mtls

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample trust config description",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default = gcp.networksecurity.ServerTlsPolicy("default",
            name="my-server-tls-policy",
            description="my description",
            location="global",
            allow_open=False,
            mtls_policy={
                "client_validation_mode": "REJECT_INVALID",
                "client_validation_trust_config": default_trust_config.name.apply(lambda name: f"projects/{project.number}/locations/global/trustConfigs/{name}"),
            },
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        ServerTlsPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serverTlsPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServerTlsPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default projects/{{project}}/locations/{{location}}/serverTlsPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServerTlsPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerTlsPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_open: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mtls_policy: Optional[pulumi.Input[Union['ServerTlsPolicyMtlsPolicyArgs', 'ServerTlsPolicyMtlsPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_certificate: Optional[pulumi.Input[Union['ServerTlsPolicyServerCertificateArgs', 'ServerTlsPolicyServerCertificateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerTlsPolicyArgs.__new__(ServerTlsPolicyArgs)

            __props__.__dict__["allow_open"] = allow_open
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["mtls_policy"] = mtls_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["server_certificate"] = server_certificate
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServerTlsPolicy, __self__).__init__(
            'gcp:networksecurity/serverTlsPolicy:ServerTlsPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_open: Optional[pulumi.Input[bool]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            mtls_policy: Optional[pulumi.Input[Union['ServerTlsPolicyMtlsPolicyArgs', 'ServerTlsPolicyMtlsPolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            server_certificate: Optional[pulumi.Input[Union['ServerTlsPolicyServerCertificateArgs', 'ServerTlsPolicyServerCertificateArgsDict']]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'ServerTlsPolicy':
        """
        Get an existing ServerTlsPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_open: This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
               Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
               Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        :param pulumi.Input[str] create_time: Time the ServerTlsPolicy was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the ServerTlsPolicy resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of the server tls policy.
               The default value is `global`.
        :param pulumi.Input[Union['ServerTlsPolicyMtlsPolicyArgs', 'ServerTlsPolicyMtlsPolicyArgsDict']] mtls_policy: This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
               Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the ServerTlsPolicy resource.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['ServerTlsPolicyServerCertificateArgs', 'ServerTlsPolicyServerCertificateArgsDict']] server_certificate: Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
               Structure is documented below.
        :param pulumi.Input[str] update_time: Time the ServerTlsPolicy was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerTlsPolicyState.__new__(_ServerTlsPolicyState)

        __props__.__dict__["allow_open"] = allow_open
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mtls_policy"] = mtls_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["server_certificate"] = server_certificate
        __props__.__dict__["update_time"] = update_time
        return ServerTlsPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowOpen")
    def allow_open(self) -> pulumi.Output[Optional[bool]]:
        """
        This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
        Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
        Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
        """
        return pulumi.get(self, "allow_open")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the ServerTlsPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of label tags associated with the ServerTlsPolicy resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the server tls policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mtlsPolicy")
    def mtls_policy(self) -> pulumi.Output[Optional['outputs.ServerTlsPolicyMtlsPolicy']]:
        """
        This field is required if the policy is used with external HTTPS load balancers. This field can be empty for Traffic Director.
        Defines a mechanism to provision peer validation certificates for peer to peer authentication (Mutual TLS - mTLS). If not specified, client certificate will not be requested. The connection is treated as TLS and not mTLS. If allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections.
        Structure is documented below.
        """
        return pulumi.get(self, "mtls_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the ServerTlsPolicy resource.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> pulumi.Output[Optional['outputs.ServerTlsPolicyServerCertificate']]:
        """
        Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
        Structure is documented below.
        """
        return pulumi.get(self, "server_certificate")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the ServerTlsPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

