# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuntimeIamPolicyResult',
    'AwaitableGetRuntimeIamPolicyResult',
    'get_runtime_iam_policy',
    'get_runtime_iam_policy_output',
]

@pulumi.output_type
class GetRuntimeIamPolicyResult:
    """
    A collection of values returned by getRuntimeIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, location=None, policy_data=None, project=None, runtime_name=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if runtime_name and not isinstance(runtime_name, str):
            raise TypeError("Expected argument 'runtime_name' to be a str")
        pulumi.set(__self__, "runtime_name", runtime_name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `notebooks.RuntimeIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> str:
        return pulumi.get(self, "runtime_name")


class AwaitableGetRuntimeIamPolicyResult(GetRuntimeIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuntimeIamPolicyResult(
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project,
            runtime_name=self.runtime_name)


def get_runtime_iam_policy(location: Optional[str] = None,
                           project: Optional[str] = None,
                           runtime_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuntimeIamPolicyResult:
    """
    Retrieves the current IAM policy data for runtime

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.notebooks.get_runtime_iam_policy(project=runtime["project"],
        location=runtime["location"],
        runtime_name=runtime["name"])
    ```


    :param str location: A reference to the zone where the machine resides. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param str runtime_name: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['runtimeName'] = runtime_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:notebooks/getRuntimeIamPolicy:getRuntimeIamPolicy', __args__, opts=opts, typ=GetRuntimeIamPolicyResult).value

    return AwaitableGetRuntimeIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        runtime_name=pulumi.get(__ret__, 'runtime_name'))


@_utilities.lift_output_func(get_runtime_iam_policy)
def get_runtime_iam_policy_output(location: Optional[pulumi.Input[Optional[str]]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  runtime_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRuntimeIamPolicyResult]:
    """
    Retrieves the current IAM policy data for runtime

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.notebooks.get_runtime_iam_policy(project=runtime["project"],
        location=runtime["location"],
        runtime_name=runtime["name"])
    ```


    :param str location: A reference to the zone where the machine resides. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param str runtime_name: Used to find the parent resource to bind the IAM policy to
    """
    ...
