# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuntimeArgs', 'Runtime']

@pulumi.input_type
class RuntimeArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 access_config: Optional[pulumi.Input['RuntimeAccessConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 software_config: Optional[pulumi.Input['RuntimeSoftwareConfigArgs']] = None,
                 virtual_machine: Optional[pulumi.Input['RuntimeVirtualMachineArgs']] = None):
        """
        The set of arguments for constructing a Runtime resource.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
               
               
               - - -
        :param pulumi.Input['RuntimeAccessConfigArgs'] access_config: The config settings for accessing runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels to associate with this runtime. Label **keys** must
               contain 1 to 63 characters, and must conform to [RFC 1035]
               (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
               empty, but, if present, must contain 1 to 63 characters, and must
               conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
               more than 32 labels can be associated with a cluster.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] name: The name specified for the Notebook runtime.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RuntimeSoftwareConfigArgs'] software_config: The config settings for software inside the runtime.
               Structure is documented below.
        :param pulumi.Input['RuntimeVirtualMachineArgs'] virtual_machine: Use a Compute Engine VM image to start the managed notebook instance.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        A reference to the zone where the machine resides.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['RuntimeAccessConfigArgs']]:
        """
        The config settings for accessing runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['RuntimeAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels to associate with this runtime. Label **keys** must
        contain 1 to 63 characters, and must conform to [RFC 1035]
        (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
        empty, but, if present, must contain 1 to 63 characters, and must
        conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
        more than 32 labels can be associated with a cluster.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name specified for the Notebook runtime.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['RuntimeSoftwareConfigArgs']]:
        """
        The config settings for software inside the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['RuntimeSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional[pulumi.Input['RuntimeVirtualMachineArgs']]:
        """
        Use a Compute Engine VM image to start the managed notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine")

    @virtual_machine.setter
    def virtual_machine(self, value: Optional[pulumi.Input['RuntimeVirtualMachineArgs']]):
        pulumi.set(self, "virtual_machine", value)


@pulumi.input_type
class _RuntimeState:
    def __init__(__self__, *,
                 access_config: Optional[pulumi.Input['RuntimeAccessConfigArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 health_state: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 software_config: Optional[pulumi.Input['RuntimeSoftwareConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 virtual_machine: Optional[pulumi.Input['RuntimeVirtualMachineArgs']] = None):
        """
        Input properties used for looking up and filtering Runtime resources.
        :param pulumi.Input['RuntimeAccessConfigArgs'] access_config: The config settings for accessing runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] health_state: The health state of this runtime. For a list of possible output
               values, see `https://cloud.google.com/vertex-ai/docs/workbench/
               reference/rest/v1/projects.locations.runtimes#healthstate`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels to associate with this runtime. Label **keys** must
               contain 1 to 63 characters, and must conform to [RFC 1035]
               (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
               empty, but, if present, must contain 1 to 63 characters, and must
               conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
               more than 32 labels can be associated with a cluster.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['RuntimeMetricArgs']]] metrics: Contains Runtime daemon metrics such as Service status and JupyterLab
               status
               Structure is documented below.
        :param pulumi.Input[str] name: The name specified for the Notebook runtime.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['RuntimeSoftwareConfigArgs'] software_config: The config settings for software inside the runtime.
               Structure is documented below.
        :param pulumi.Input[str] state: The state of this runtime.
        :param pulumi.Input['RuntimeVirtualMachineArgs'] virtual_machine: Use a Compute Engine VM image to start the managed notebook instance.
               Structure is documented below.
        """
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if health_state is not None:
            pulumi.set(__self__, "health_state", health_state)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['RuntimeAccessConfigArgs']]:
        """
        The config settings for accessing runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['RuntimeAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> Optional[pulumi.Input[str]]:
        """
        The health state of this runtime. For a list of possible output
        values, see `https://cloud.google.com/vertex-ai/docs/workbench/
        reference/rest/v1/projects.locations.runtimes#healthstate`.
        """
        return pulumi.get(self, "health_state")

    @health_state.setter
    def health_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_state", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels to associate with this runtime. Label **keys** must
        contain 1 to 63 characters, and must conform to [RFC 1035]
        (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
        empty, but, if present, must contain 1 to 63 characters, and must
        conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
        more than 32 labels can be associated with a cluster.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the zone where the machine resides.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeMetricArgs']]]]:
        """
        Contains Runtime daemon metrics such as Service status and JupyterLab
        status
        Structure is documented below.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name specified for the Notebook runtime.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['RuntimeSoftwareConfigArgs']]:
        """
        The config settings for software inside the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['RuntimeSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of this runtime.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional[pulumi.Input['RuntimeVirtualMachineArgs']]:
        """
        Use a Compute Engine VM image to start the managed notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine")

    @virtual_machine.setter
    def virtual_machine(self, value: Optional[pulumi.Input['RuntimeVirtualMachineArgs']]):
        pulumi.set(self, "virtual_machine", value)


class Runtime(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[Union['RuntimeAccessConfigArgs', 'RuntimeAccessConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 software_config: Optional[pulumi.Input[Union['RuntimeSoftwareConfigArgs', 'RuntimeSoftwareConfigArgsDict']]] = None,
                 virtual_machine: Optional[pulumi.Input[Union['RuntimeVirtualMachineArgs', 'RuntimeVirtualMachineArgsDict']]] = None,
                 __props__=None):
        """
        A Cloud AI Platform Notebook runtime.

        > **Note:** Due to limitations of the Notebooks Runtime API, many fields
        in this resource do not properly detect drift. These fields will also not
        appear in state once imported.

        To get more information about Runtime, see:

        * [API documentation](https://cloud.google.com/ai-platform/notebooks/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/ai-platform-notebooks)

        ## Example Usage

        ### Notebook Runtime Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime = gcp.notebooks.Runtime("runtime",
            name="notebooks-runtime",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            })
        ```
        ### Notebook Runtime Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_gpu = gcp.notebooks.Runtime("runtime_gpu",
            name="notebooks-runtime-gpu",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "install_gpu_driver": True,
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                    "accelerator_config": {
                        "core_count": 1,
                        "type": "NVIDIA_TESLA_V100",
                    },
                },
            })
        ```
        ### Notebook Runtime Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-container",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                    "container_images": [
                        {
                            "repository": "gcr.io/deeplearning-platform-release/base-cpu",
                            "tag": "latest",
                        },
                        {
                            "repository": "gcr.io/deeplearning-platform-release/beam-notebooks",
                            "tag": "latest",
                        },
                    ],
                },
            })
        ```
        ### Notebook Runtime Kernels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-kernel",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "kernels": [{
                    "repository": "gcr.io/deeplearning-platform-release/base-cpu",
                    "tag": "latest",
                }],
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            },
            labels={
                "k": "val",
            })
        ```
        ### Notebook Runtime Script

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-script",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "post_startup_script_behavior": "RUN_EVERY_START",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            },
            labels={
                "k": "val",
            })
        ```

        ## Import

        Runtime can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/runtimes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Runtime can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default projects/{{project}}/locations/{{location}}/runtimes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RuntimeAccessConfigArgs', 'RuntimeAccessConfigArgsDict']] access_config: The config settings for accessing runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels to associate with this runtime. Label **keys** must
               contain 1 to 63 characters, and must conform to [RFC 1035]
               (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
               empty, but, if present, must contain 1 to 63 characters, and must
               conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
               more than 32 labels can be associated with a cluster.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
               
               
               - - -
        :param pulumi.Input[str] name: The name specified for the Notebook runtime.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RuntimeSoftwareConfigArgs', 'RuntimeSoftwareConfigArgsDict']] software_config: The config settings for software inside the runtime.
               Structure is documented below.
        :param pulumi.Input[Union['RuntimeVirtualMachineArgs', 'RuntimeVirtualMachineArgsDict']] virtual_machine: Use a Compute Engine VM image to start the managed notebook instance.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuntimeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud AI Platform Notebook runtime.

        > **Note:** Due to limitations of the Notebooks Runtime API, many fields
        in this resource do not properly detect drift. These fields will also not
        appear in state once imported.

        To get more information about Runtime, see:

        * [API documentation](https://cloud.google.com/ai-platform/notebooks/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/ai-platform-notebooks)

        ## Example Usage

        ### Notebook Runtime Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime = gcp.notebooks.Runtime("runtime",
            name="notebooks-runtime",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            })
        ```
        ### Notebook Runtime Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_gpu = gcp.notebooks.Runtime("runtime_gpu",
            name="notebooks-runtime-gpu",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "install_gpu_driver": True,
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                    "accelerator_config": {
                        "core_count": 1,
                        "type": "NVIDIA_TESLA_V100",
                    },
                },
            })
        ```
        ### Notebook Runtime Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-container",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                    "container_images": [
                        {
                            "repository": "gcr.io/deeplearning-platform-release/base-cpu",
                            "tag": "latest",
                        },
                        {
                            "repository": "gcr.io/deeplearning-platform-release/beam-notebooks",
                            "tag": "latest",
                        },
                    ],
                },
            })
        ```
        ### Notebook Runtime Kernels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-kernel",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "kernels": [{
                    "repository": "gcr.io/deeplearning-platform-release/base-cpu",
                    "tag": "latest",
                }],
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            },
            labels={
                "k": "val",
            })
        ```
        ### Notebook Runtime Script

        ```python
        import pulumi
        import pulumi_gcp as gcp

        runtime_container = gcp.notebooks.Runtime("runtime_container",
            name="notebooks-runtime-script",
            location="us-central1",
            access_config={
                "access_type": "SINGLE_USER",
                "runtime_owner": "admin@hashicorptest.com",
            },
            software_config={
                "post_startup_script_behavior": "RUN_EVERY_START",
            },
            virtual_machine={
                "virtual_machine_config": {
                    "machine_type": "n1-standard-4",
                    "data_disk": {
                        "initialize_params": {
                            "disk_size_gb": 100,
                            "disk_type": "PD_STANDARD",
                        },
                    },
                },
            },
            labels={
                "k": "val",
            })
        ```

        ## Import

        Runtime can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/runtimes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Runtime can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default projects/{{project}}/locations/{{location}}/runtimes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:notebooks/runtime:Runtime default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RuntimeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuntimeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[Union['RuntimeAccessConfigArgs', 'RuntimeAccessConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 software_config: Optional[pulumi.Input[Union['RuntimeSoftwareConfigArgs', 'RuntimeSoftwareConfigArgsDict']]] = None,
                 virtual_machine: Optional[pulumi.Input[Union['RuntimeVirtualMachineArgs', 'RuntimeVirtualMachineArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuntimeArgs.__new__(RuntimeArgs)

            __props__.__dict__["access_config"] = access_config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["software_config"] = software_config
            __props__.__dict__["virtual_machine"] = virtual_machine
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["health_state"] = None
            __props__.__dict__["metrics"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Runtime, __self__).__init__(
            'gcp:notebooks/runtime:Runtime',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_config: Optional[pulumi.Input[Union['RuntimeAccessConfigArgs', 'RuntimeAccessConfigArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            health_state: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuntimeMetricArgs', 'RuntimeMetricArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            software_config: Optional[pulumi.Input[Union['RuntimeSoftwareConfigArgs', 'RuntimeSoftwareConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            virtual_machine: Optional[pulumi.Input[Union['RuntimeVirtualMachineArgs', 'RuntimeVirtualMachineArgsDict']]] = None) -> 'Runtime':
        """
        Get an existing Runtime resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RuntimeAccessConfigArgs', 'RuntimeAccessConfigArgsDict']] access_config: The config settings for accessing runtime.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] health_state: The health state of this runtime. For a list of possible output
               values, see `https://cloud.google.com/vertex-ai/docs/workbench/
               reference/rest/v1/projects.locations.runtimes#healthstate`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels to associate with this runtime. Label **keys** must
               contain 1 to 63 characters, and must conform to [RFC 1035]
               (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
               empty, but, if present, must contain 1 to 63 characters, and must
               conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
               more than 32 labels can be associated with a cluster.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuntimeMetricArgs', 'RuntimeMetricArgsDict']]]] metrics: Contains Runtime daemon metrics such as Service status and JupyterLab
               status
               Structure is documented below.
        :param pulumi.Input[str] name: The name specified for the Notebook runtime.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['RuntimeSoftwareConfigArgs', 'RuntimeSoftwareConfigArgsDict']] software_config: The config settings for software inside the runtime.
               Structure is documented below.
        :param pulumi.Input[str] state: The state of this runtime.
        :param pulumi.Input[Union['RuntimeVirtualMachineArgs', 'RuntimeVirtualMachineArgsDict']] virtual_machine: Use a Compute Engine VM image to start the managed notebook instance.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuntimeState.__new__(_RuntimeState)

        __props__.__dict__["access_config"] = access_config
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["health_state"] = health_state
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["software_config"] = software_config
        __props__.__dict__["state"] = state
        __props__.__dict__["virtual_machine"] = virtual_machine
        return Runtime(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Output[Optional['outputs.RuntimeAccessConfig']]:
        """
        The config settings for accessing runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> pulumi.Output[str]:
        """
        The health state of this runtime. For a list of possible output
        values, see `https://cloud.google.com/vertex-ai/docs/workbench/
        reference/rest/v1/projects.locations.runtimes#healthstate`.
        """
        return pulumi.get(self, "health_state")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The labels to associate with this runtime. Label **keys** must
        contain 1 to 63 characters, and must conform to [RFC 1035]
        (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
        empty, but, if present, must contain 1 to 63 characters, and must
        conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
        more than 32 labels can be associated with a cluster.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        A reference to the zone where the machine resides.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.RuntimeMetric']]:
        """
        Contains Runtime daemon metrics such as Service status and JupyterLab
        status
        Structure is documented below.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name specified for the Notebook runtime.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> pulumi.Output['outputs.RuntimeSoftwareConfig']:
        """
        The config settings for software inside the runtime.
        Structure is documented below.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of this runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> pulumi.Output[Optional['outputs.RuntimeVirtualMachine']]:
        """
        Use a Compute Engine VM image to start the managed notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine")

