# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClientConfigResult',
    'AwaitableGetClientConfigResult',
    'get_client_config',
    'get_client_config_output',
]

@pulumi.output_type
class GetClientConfigResult:
    """
    A collection of values returned by getClientConfig.
    """
    def __init__(__self__, access_token=None, default_labels=None, id=None, project=None, region=None, zone=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if default_labels and not isinstance(default_labels, dict):
            raise TypeError("Expected argument 'default_labels' to be a dict")
        pulumi.set(__self__, "default_labels", default_labels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        The OAuth2 access token used by the client to authenticate against the Google Cloud API.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="defaultLabels")
    def default_labels(self) -> Mapping[str, str]:
        """
        The default labels configured on the provider.
        """
        return pulumi.get(self, "default_labels")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project to apply any resources to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region to operate under.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone to operate under.
        """
        return pulumi.get(self, "zone")


class AwaitableGetClientConfigResult(GetClientConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientConfigResult(
            access_token=self.access_token,
            default_labels=self.default_labels,
            id=self.id,
            project=self.project,
            region=self.region,
            zone=self.zone)


def get_client_config(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientConfigResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    current = gcp.organizations.get_client_config()
    pulumi.export("project", current.project)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getClientConfig:getClientConfig', __args__, opts=opts, typ=GetClientConfigResult).value

    return AwaitableGetClientConfigResult(
        access_token=pulumi.get(__ret__, 'access_token'),
        default_labels=pulumi.get(__ret__, 'default_labels'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        zone=pulumi.get(__ret__, 'zone'))


@_utilities.lift_output_func(get_client_config)
def get_client_config_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClientConfigResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    current = gcp.organizations.get_client_config()
    pulumi.export("project", current.project)
    ```
    """
    ...
