# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[str],
                 dry_run_spec: Optional[pulumi.Input['PolicyDryRunSpecArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input['PolicySpecArgs']] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[str] parent: The parent of the resource.
               
               
               - - -
        :param pulumi.Input['PolicyDryRunSpecArgs'] dry_run_spec: Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
               Structure is documented below.
        :param pulumi.Input[str] name: Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        :param pulumi.Input['PolicySpecArgs'] spec: Basic information about the Organization Policy.
               Structure is documented below.
        """
        pulumi.set(__self__, "parent", parent)
        if dry_run_spec is not None:
            pulumi.set(__self__, "dry_run_spec", dry_run_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        The parent of the resource.


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="dryRunSpec")
    def dry_run_spec(self) -> Optional[pulumi.Input['PolicyDryRunSpecArgs']]:
        """
        Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "dry_run_spec")

    @dry_run_spec.setter
    def dry_run_spec(self, value: Optional[pulumi.Input['PolicyDryRunSpecArgs']]):
        pulumi.set(self, "dry_run_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PolicySpecArgs']]:
        """
        Basic information about the Organization Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PolicySpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 dry_run_spec: Optional[pulumi.Input['PolicyDryRunSpecArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input['PolicySpecArgs']] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input['PolicyDryRunSpecArgs'] dry_run_spec: Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
               Structure is documented below.
        :param pulumi.Input[str] etag: Optional. An opaque tag indicating the current state of the policy, used for concurrency control. This 'etag' is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[str] name: Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        :param pulumi.Input[str] parent: The parent of the resource.
               
               
               - - -
        :param pulumi.Input['PolicySpecArgs'] spec: Basic information about the Organization Policy.
               Structure is documented below.
        """
        if dry_run_spec is not None:
            pulumi.set(__self__, "dry_run_spec", dry_run_spec)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="dryRunSpec")
    def dry_run_spec(self) -> Optional[pulumi.Input['PolicyDryRunSpecArgs']]:
        """
        Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "dry_run_spec")

    @dry_run_spec.setter
    def dry_run_spec(self, value: Optional[pulumi.Input['PolicyDryRunSpecArgs']]):
        pulumi.set(self, "dry_run_spec", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An opaque tag indicating the current state of the policy, used for concurrency control. This 'etag' is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The parent of the resource.


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PolicySpecArgs']]:
        """
        Basic information about the Organization Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PolicySpecArgs']]):
        pulumi.set(self, "spec", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run_spec: Optional[pulumi.Input[Union['PolicyDryRunSpecArgs', 'PolicyDryRunSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[Union['PolicySpecArgs', 'PolicySpecArgsDict']]] = None,
                 __props__=None):
        """
        Defines an organization policy which is used to specify constraints for configurations of Google Cloud resources.

        To get more information about Policy, see:

        * [API documentation](https://cloud.google.com/resource-manager/docs/reference/orgpolicy/rest/v2/organizations.policies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints)
            * [Supported Services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services)

        ## Example Usage

        ### Org Policy Policy Enforce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Project("basic",
            project_id="id",
            name="id",
            org_id="123456789",
            deletion_policy="DELETE")
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"projects/{name}/policies/iam.disableServiceAccountKeyUpload"),
            parent=basic.name.apply(lambda name: f"projects/{name}"),
            spec={
                "rules": [{
                    "enforce": "FALSE",
                }],
            })
        ```
        ### Org Policy Policy Folder

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Folder("basic",
            parent="organizations/123456789",
            display_name="folder",
            deletion_protection=False)
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"{name}/policies/gcp.resourceLocations"),
            parent=basic.name,
            spec={
                "inherit_from_parent": True,
                "rules": [{
                    "deny_all": "TRUE",
                }],
            })
        ```
        ### Org Policy Policy Organization

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.orgpolicy.Policy("primary",
            name="organizations/123456789/policies/gcp.detailedAuditLoggingMode",
            parent="organizations/123456789",
            spec={
                "reset": True,
            })
        ```
        ### Org Policy Policy Project

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Project("basic",
            project_id="id",
            name="id",
            org_id="123456789",
            deletion_policy="DELETE")
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"projects/{name}/policies/gcp.resourceLocations"),
            parent=basic.name.apply(lambda name: f"projects/{name}"),
            spec={
                "rules": [
                    {
                        "condition": {
                            "description": "A sample condition for the policy",
                            "expression": "resource.matchTagId('tagKeys/123', 'tagValues/345')",
                            "location": "sample-location.log",
                            "title": "sample-condition",
                        },
                        "values": {
                            "allowed_values": ["projects/allowed-project"],
                            "denied_values": ["projects/denied-project"],
                        },
                    },
                    {
                        "allow_all": "TRUE",
                    },
                ],
            })
        ```
        ### Org Policy Policy Dry Run Spec

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade_37559",
            parent="organizations/123456789",
            display_name="Disable GKE auto upgrade",
            description="Only allow GKE NodePool resource to be created or updated if AutoUpgrade is not enabled where this custom constraint is enforced.",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=["CREATE"],
            resource_types=["container.googleapis.com/NodePool"])
        primary = gcp.orgpolicy.Policy("primary",
            name=constraint.name.apply(lambda name: f"organizations/123456789/policies/{name}"),
            parent="organizations/123456789",
            spec={
                "rules": [{
                    "enforce": "FALSE",
                }],
            },
            dry_run_spec={
                "inherit_from_parent": False,
                "reset": False,
                "rules": [{
                    "enforce": "FALSE",
                }],
            })
        ```

        ## Import

        Policy can be imported using any of these accepted formats:

        * `{{parent}}/policies/{{name}}`

        When using the `pulumi import` command, Policy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:orgpolicy/policy:Policy default {{parent}}/policies/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyDryRunSpecArgs', 'PolicyDryRunSpecArgsDict']] dry_run_spec: Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
               Structure is documented below.
        :param pulumi.Input[str] name: Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        :param pulumi.Input[str] parent: The parent of the resource.
               
               
               - - -
        :param pulumi.Input[Union['PolicySpecArgs', 'PolicySpecArgsDict']] spec: Basic information about the Organization Policy.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines an organization policy which is used to specify constraints for configurations of Google Cloud resources.

        To get more information about Policy, see:

        * [API documentation](https://cloud.google.com/resource-manager/docs/reference/orgpolicy/rest/v2/organizations.policies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints)
            * [Supported Services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services)

        ## Example Usage

        ### Org Policy Policy Enforce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Project("basic",
            project_id="id",
            name="id",
            org_id="123456789",
            deletion_policy="DELETE")
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"projects/{name}/policies/iam.disableServiceAccountKeyUpload"),
            parent=basic.name.apply(lambda name: f"projects/{name}"),
            spec={
                "rules": [{
                    "enforce": "FALSE",
                }],
            })
        ```
        ### Org Policy Policy Folder

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Folder("basic",
            parent="organizations/123456789",
            display_name="folder",
            deletion_protection=False)
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"{name}/policies/gcp.resourceLocations"),
            parent=basic.name,
            spec={
                "inherit_from_parent": True,
                "rules": [{
                    "deny_all": "TRUE",
                }],
            })
        ```
        ### Org Policy Policy Organization

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.orgpolicy.Policy("primary",
            name="organizations/123456789/policies/gcp.detailedAuditLoggingMode",
            parent="organizations/123456789",
            spec={
                "reset": True,
            })
        ```
        ### Org Policy Policy Project

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.organizations.Project("basic",
            project_id="id",
            name="id",
            org_id="123456789",
            deletion_policy="DELETE")
        primary = gcp.orgpolicy.Policy("primary",
            name=basic.name.apply(lambda name: f"projects/{name}/policies/gcp.resourceLocations"),
            parent=basic.name.apply(lambda name: f"projects/{name}"),
            spec={
                "rules": [
                    {
                        "condition": {
                            "description": "A sample condition for the policy",
                            "expression": "resource.matchTagId('tagKeys/123', 'tagValues/345')",
                            "location": "sample-location.log",
                            "title": "sample-condition",
                        },
                        "values": {
                            "allowed_values": ["projects/allowed-project"],
                            "denied_values": ["projects/denied-project"],
                        },
                    },
                    {
                        "allow_all": "TRUE",
                    },
                ],
            })
        ```
        ### Org Policy Policy Dry Run Spec

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade_37559",
            parent="organizations/123456789",
            display_name="Disable GKE auto upgrade",
            description="Only allow GKE NodePool resource to be created or updated if AutoUpgrade is not enabled where this custom constraint is enforced.",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=["CREATE"],
            resource_types=["container.googleapis.com/NodePool"])
        primary = gcp.orgpolicy.Policy("primary",
            name=constraint.name.apply(lambda name: f"organizations/123456789/policies/{name}"),
            parent="organizations/123456789",
            spec={
                "rules": [{
                    "enforce": "FALSE",
                }],
            },
            dry_run_spec={
                "inherit_from_parent": False,
                "reset": False,
                "rules": [{
                    "enforce": "FALSE",
                }],
            })
        ```

        ## Import

        Policy can be imported using any of these accepted formats:

        * `{{parent}}/policies/{{name}}`

        When using the `pulumi import` command, Policy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:orgpolicy/policy:Policy default {{parent}}/policies/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run_spec: Optional[pulumi.Input[Union['PolicyDryRunSpecArgs', 'PolicyDryRunSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[Union['PolicySpecArgs', 'PolicySpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["dry_run_spec"] = dry_run_spec
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["spec"] = spec
            __props__.__dict__["etag"] = None
        super(Policy, __self__).__init__(
            'gcp:orgpolicy/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run_spec: Optional[pulumi.Input[Union['PolicyDryRunSpecArgs', 'PolicyDryRunSpecArgsDict']]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[Union['PolicySpecArgs', 'PolicySpecArgsDict']]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyDryRunSpecArgs', 'PolicyDryRunSpecArgsDict']] dry_run_spec: Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
               Structure is documented below.
        :param pulumi.Input[str] etag: Optional. An opaque tag indicating the current state of the policy, used for concurrency control. This 'etag' is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[str] name: Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        :param pulumi.Input[str] parent: The parent of the resource.
               
               
               - - -
        :param pulumi.Input[Union['PolicySpecArgs', 'PolicySpecArgsDict']] spec: Basic information about the Organization Policy.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["dry_run_spec"] = dry_run_spec
        __props__.__dict__["etag"] = etag
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["spec"] = spec
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRunSpec")
    def dry_run_spec(self) -> pulumi.Output[Optional['outputs.PolicyDryRunSpec']]:
        """
        Dry-run policy. Audit-only policy, can be used to monitor how the policy would have impacted the existing and future resources if it's enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "dry_run_spec")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Optional. An opaque tag indicating the current state of the policy, used for concurrency control. This 'etag' is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The parent of the resource.


        - - -
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.PolicySpec']]:
        """
        Basic information about the Organization Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

