# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GuestPoliciesArgs', 'GuestPolicies']

@pulumi.input_type
class GuestPoliciesArgs:
    def __init__(__self__, *,
                 assignment: pulumi.Input['GuestPoliciesAssignmentArgs'],
                 guest_policy_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 package_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recipes: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]] = None):
        """
        The set of arguments for constructing a GuestPolicies resource.
        :param pulumi.Input['GuestPoliciesAssignmentArgs'] assignment: Specifies the VM instances that are assigned to this policy. This allows you to target sets
               or groups of VM instances by different parameters such as labels, names, OS, or zones.
               If left empty, all VM instances underneath this policy are targeted.
               At the same level in the resource hierarchy (that is within a project), the service prevents
               the creation of multiple policies that conflict with each other.
               For more information, see how the service
               [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
               Structure is documented below.
        :param pulumi.Input[str] guest_policy_id: The logical name of the guest policy in the project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the project.
        :param pulumi.Input[str] description: Description of the guest policy. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this guest policy. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]] package_repositories: A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
               they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
               available.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]] packages: The software packages to be managed by this policy.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]] recipes: A list of Recipes to install on the VM instance.
        """
        pulumi.set(__self__, "assignment", assignment)
        pulumi.set(__self__, "guest_policy_id", guest_policy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if package_repositories is not None:
            pulumi.set(__self__, "package_repositories", package_repositories)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recipes is not None:
            pulumi.set(__self__, "recipes", recipes)

    @property
    @pulumi.getter
    def assignment(self) -> pulumi.Input['GuestPoliciesAssignmentArgs']:
        """
        Specifies the VM instances that are assigned to this policy. This allows you to target sets
        or groups of VM instances by different parameters such as labels, names, OS, or zones.
        If left empty, all VM instances underneath this policy are targeted.
        At the same level in the resource hierarchy (that is within a project), the service prevents
        the creation of multiple policies that conflict with each other.
        For more information, see how the service
        [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
        Structure is documented below.
        """
        return pulumi.get(self, "assignment")

    @assignment.setter
    def assignment(self, value: pulumi.Input['GuestPoliciesAssignmentArgs']):
        pulumi.set(self, "assignment", value)

    @property
    @pulumi.getter(name="guestPolicyId")
    def guest_policy_id(self) -> pulumi.Input[str]:
        """
        The logical name of the guest policy in the project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the project.
        """
        return pulumi.get(self, "guest_policy_id")

    @guest_policy_id.setter
    def guest_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "guest_policy_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the guest policy. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The etag for this guest policy. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="packageRepositories")
    def package_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]]:
        """
        A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
        they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
        available.
        """
        return pulumi.get(self, "package_repositories")

    @package_repositories.setter
    def package_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]]):
        pulumi.set(self, "package_repositories", value)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]]:
        """
        The software packages to be managed by this policy.
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]]:
        """
        A list of Recipes to install on the VM instance.
        """
        return pulumi.get(self, "recipes")

    @recipes.setter
    def recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]]):
        pulumi.set(self, "recipes", value)


@pulumi.input_type
class _GuestPoliciesState:
    def __init__(__self__, *,
                 assignment: Optional[pulumi.Input['GuestPoliciesAssignmentArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 guest_policy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recipes: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GuestPolicies resources.
        :param pulumi.Input['GuestPoliciesAssignmentArgs'] assignment: Specifies the VM instances that are assigned to this policy. This allows you to target sets
               or groups of VM instances by different parameters such as labels, names, OS, or zones.
               If left empty, all VM instances underneath this policy are targeted.
               At the same level in the resource hierarchy (that is within a project), the service prevents
               the creation of multiple policies that conflict with each other.
               For more information, see how the service
               [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
               Structure is documented below.
        :param pulumi.Input[str] create_time: Time this guest policy was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: Description of the guest policy. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this guest policy. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[str] guest_policy_id: The logical name of the guest policy in the project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the project.
        :param pulumi.Input[str] name: Unique name of the resource in this project using one of the following forms: projects/{project_number}/guestPolicies/{guestPolicyId}.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]] package_repositories: A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
               they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
               available.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]] packages: The software packages to be managed by this policy.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]] recipes: A list of Recipes to install on the VM instance.
        :param pulumi.Input[str] update_time: Last time this guest policy was updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        """
        if assignment is not None:
            pulumi.set(__self__, "assignment", assignment)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if guest_policy_id is not None:
            pulumi.set(__self__, "guest_policy_id", guest_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_repositories is not None:
            pulumi.set(__self__, "package_repositories", package_repositories)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recipes is not None:
            pulumi.set(__self__, "recipes", recipes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def assignment(self) -> Optional[pulumi.Input['GuestPoliciesAssignmentArgs']]:
        """
        Specifies the VM instances that are assigned to this policy. This allows you to target sets
        or groups of VM instances by different parameters such as labels, names, OS, or zones.
        If left empty, all VM instances underneath this policy are targeted.
        At the same level in the resource hierarchy (that is within a project), the service prevents
        the creation of multiple policies that conflict with each other.
        For more information, see how the service
        [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
        Structure is documented below.
        """
        return pulumi.get(self, "assignment")

    @assignment.setter
    def assignment(self, value: Optional[pulumi.Input['GuestPoliciesAssignmentArgs']]):
        pulumi.set(self, "assignment", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time this guest policy was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the guest policy. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The etag for this guest policy. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="guestPolicyId")
    def guest_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The logical name of the guest policy in the project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the project.
        """
        return pulumi.get(self, "guest_policy_id")

    @guest_policy_id.setter
    def guest_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_policy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the resource in this project using one of the following forms: projects/{project_number}/guestPolicies/{guestPolicyId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageRepositories")
    def package_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]]:
        """
        A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
        they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
        available.
        """
        return pulumi.get(self, "package_repositories")

    @package_repositories.setter
    def package_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageRepositoryArgs']]]]):
        pulumi.set(self, "package_repositories", value)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]]:
        """
        The software packages to be managed by this policy.
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesPackageArgs']]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]]:
        """
        A list of Recipes to install on the VM instance.
        """
        return pulumi.get(self, "recipes")

    @recipes.setter
    def recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArgs']]]]):
        pulumi.set(self, "recipes", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time this guest policy was updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class GuestPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment: Optional[pulumi.Input[Union['GuestPoliciesAssignmentArgs', 'GuestPoliciesAssignmentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 guest_policy_id: Optional[pulumi.Input[str]] = None,
                 package_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageRepositoryArgs', 'GuestPoliciesPackageRepositoryArgsDict']]]]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageArgs', 'GuestPoliciesPackageArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesRecipeArgs', 'GuestPoliciesRecipeArgsDict']]]]] = None,
                 __props__=None):
        """
        An OS Config resource representing a guest configuration policy. These policies represent
        the desired state for VM instance guest environments including packages to install or remove,
        package repository configurations, and software to install.

        To get more information about GuestPolicies, see:

        * [API documentation](https://cloud.google.com/compute/docs/osconfig/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/os-config-management)

        ## Example Usage

        ### Os Config Guest Policies Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.Instance("foobar",
            name="guest-policy-inst",
            machine_type="e2-medium",
            zone="us-central1-a",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            },
            network_interfaces=[{
                "network": "default",
            }],
            metadata={
                "foo": "bar",
            })
        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "instances": [foobar.id],
            },
            packages=[{
                "name": "my-package",
                "desired_state": "UPDATED",
            }])
        ```
        ### Os Config Guest Policies Packages

        ```python
        import pulumi
        import pulumi_gcp as gcp

        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "group_labels": [
                    {
                        "labels": {
                            "color": "red",
                            "env": "test",
                        },
                    },
                    {
                        "labels": {
                            "color": "blue",
                            "env": "test",
                        },
                    },
                ],
            },
            packages=[
                {
                    "name": "my-package",
                    "desired_state": "INSTALLED",
                },
                {
                    "name": "bad-package-1",
                    "desired_state": "REMOVED",
                },
                {
                    "name": "bad-package-2",
                    "desired_state": "REMOVED",
                    "manager": "APT",
                },
            ],
            package_repositories=[
                {
                    "apt": {
                        "uri": "https://packages.cloud.google.com/apt",
                        "archive_type": "DEB",
                        "distribution": "cloud-sdk-stretch",
                        "components": ["main"],
                    },
                },
                {
                    "yum": {
                        "id": "google-cloud-sdk",
                        "display_name": "Google Cloud SDK",
                        "base_url": "https://packages.cloud.google.com/yum/repos/cloud-sdk-el7-x86_64",
                        "gpg_keys": [
                            "https://packages.cloud.google.com/yum/doc/yum-key.gpg",
                            "https://packages.cloud.google.com/yum/doc/rpm-package-key.gpg",
                        ],
                    },
                },
            ])
        ```
        ### Os Config Guest Policies Recipes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "zones": [
                    "us-east1-b",
                    "us-east1-d",
                ],
            },
            recipes=[{
                "name": "guest-policy-recipe",
                "desired_state": "INSTALLED",
                "artifacts": [{
                    "id": "guest-policy-artifact-id",
                    "gcs": {
                        "bucket": "my-bucket",
                        "object": "executable.msi",
                        "generation": 1546030865175603,
                    },
                }],
                "install_steps": [{
                    "msi_installation": {
                        "artifact_id": "guest-policy-artifact-id",
                    },
                }],
            }])
        ```

        ## Import

        GuestPolicies can be imported using any of these accepted formats:

        * `projects/{{project}}/guestPolicies/{{guest_policy_id}}`

        * `{{project}}/{{guest_policy_id}}`

        * `{{guest_policy_id}}`

        When using the `pulumi import` command, GuestPolicies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default projects/{{project}}/guestPolicies/{{guest_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default {{project}}/{{guest_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default {{guest_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GuestPoliciesAssignmentArgs', 'GuestPoliciesAssignmentArgsDict']] assignment: Specifies the VM instances that are assigned to this policy. This allows you to target sets
               or groups of VM instances by different parameters such as labels, names, OS, or zones.
               If left empty, all VM instances underneath this policy are targeted.
               At the same level in the resource hierarchy (that is within a project), the service prevents
               the creation of multiple policies that conflict with each other.
               For more information, see how the service
               [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
               Structure is documented below.
        :param pulumi.Input[str] description: Description of the guest policy. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this guest policy. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[str] guest_policy_id: The logical name of the guest policy in the project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageRepositoryArgs', 'GuestPoliciesPackageRepositoryArgsDict']]]] package_repositories: A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
               they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
               available.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageArgs', 'GuestPoliciesPackageArgsDict']]]] packages: The software packages to be managed by this policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesRecipeArgs', 'GuestPoliciesRecipeArgsDict']]]] recipes: A list of Recipes to install on the VM instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GuestPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An OS Config resource representing a guest configuration policy. These policies represent
        the desired state for VM instance guest environments including packages to install or remove,
        package repository configurations, and software to install.

        To get more information about GuestPolicies, see:

        * [API documentation](https://cloud.google.com/compute/docs/osconfig/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/os-config-management)

        ## Example Usage

        ### Os Config Guest Policies Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.Instance("foobar",
            name="guest-policy-inst",
            machine_type="e2-medium",
            zone="us-central1-a",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            },
            network_interfaces=[{
                "network": "default",
            }],
            metadata={
                "foo": "bar",
            })
        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "instances": [foobar.id],
            },
            packages=[{
                "name": "my-package",
                "desired_state": "UPDATED",
            }])
        ```
        ### Os Config Guest Policies Packages

        ```python
        import pulumi
        import pulumi_gcp as gcp

        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "group_labels": [
                    {
                        "labels": {
                            "color": "red",
                            "env": "test",
                        },
                    },
                    {
                        "labels": {
                            "color": "blue",
                            "env": "test",
                        },
                    },
                ],
            },
            packages=[
                {
                    "name": "my-package",
                    "desired_state": "INSTALLED",
                },
                {
                    "name": "bad-package-1",
                    "desired_state": "REMOVED",
                },
                {
                    "name": "bad-package-2",
                    "desired_state": "REMOVED",
                    "manager": "APT",
                },
            ],
            package_repositories=[
                {
                    "apt": {
                        "uri": "https://packages.cloud.google.com/apt",
                        "archive_type": "DEB",
                        "distribution": "cloud-sdk-stretch",
                        "components": ["main"],
                    },
                },
                {
                    "yum": {
                        "id": "google-cloud-sdk",
                        "display_name": "Google Cloud SDK",
                        "base_url": "https://packages.cloud.google.com/yum/repos/cloud-sdk-el7-x86_64",
                        "gpg_keys": [
                            "https://packages.cloud.google.com/yum/doc/yum-key.gpg",
                            "https://packages.cloud.google.com/yum/doc/rpm-package-key.gpg",
                        ],
                    },
                },
            ])
        ```
        ### Os Config Guest Policies Recipes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        guest_policies = gcp.osconfig.GuestPolicies("guest_policies",
            guest_policy_id="guest-policy",
            assignment={
                "zones": [
                    "us-east1-b",
                    "us-east1-d",
                ],
            },
            recipes=[{
                "name": "guest-policy-recipe",
                "desired_state": "INSTALLED",
                "artifacts": [{
                    "id": "guest-policy-artifact-id",
                    "gcs": {
                        "bucket": "my-bucket",
                        "object": "executable.msi",
                        "generation": 1546030865175603,
                    },
                }],
                "install_steps": [{
                    "msi_installation": {
                        "artifact_id": "guest-policy-artifact-id",
                    },
                }],
            }])
        ```

        ## Import

        GuestPolicies can be imported using any of these accepted formats:

        * `projects/{{project}}/guestPolicies/{{guest_policy_id}}`

        * `{{project}}/{{guest_policy_id}}`

        * `{{guest_policy_id}}`

        When using the `pulumi import` command, GuestPolicies can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default projects/{{project}}/guestPolicies/{{guest_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default {{project}}/{{guest_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/guestPolicies:GuestPolicies default {{guest_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param GuestPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GuestPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment: Optional[pulumi.Input[Union['GuestPoliciesAssignmentArgs', 'GuestPoliciesAssignmentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 guest_policy_id: Optional[pulumi.Input[str]] = None,
                 package_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageRepositoryArgs', 'GuestPoliciesPackageRepositoryArgsDict']]]]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageArgs', 'GuestPoliciesPackageArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesRecipeArgs', 'GuestPoliciesRecipeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GuestPoliciesArgs.__new__(GuestPoliciesArgs)

            if assignment is None and not opts.urn:
                raise TypeError("Missing required property 'assignment'")
            __props__.__dict__["assignment"] = assignment
            __props__.__dict__["description"] = description
            __props__.__dict__["etag"] = etag
            if guest_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'guest_policy_id'")
            __props__.__dict__["guest_policy_id"] = guest_policy_id
            __props__.__dict__["package_repositories"] = package_repositories
            __props__.__dict__["packages"] = packages
            __props__.__dict__["project"] = project
            __props__.__dict__["recipes"] = recipes
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(GuestPolicies, __self__).__init__(
            'gcp:osconfig/guestPolicies:GuestPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignment: Optional[pulumi.Input[Union['GuestPoliciesAssignmentArgs', 'GuestPoliciesAssignmentArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            guest_policy_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageRepositoryArgs', 'GuestPoliciesPackageRepositoryArgsDict']]]]] = None,
            packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageArgs', 'GuestPoliciesPackageArgsDict']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            recipes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesRecipeArgs', 'GuestPoliciesRecipeArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'GuestPolicies':
        """
        Get an existing GuestPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GuestPoliciesAssignmentArgs', 'GuestPoliciesAssignmentArgsDict']] assignment: Specifies the VM instances that are assigned to this policy. This allows you to target sets
               or groups of VM instances by different parameters such as labels, names, OS, or zones.
               If left empty, all VM instances underneath this policy are targeted.
               At the same level in the resource hierarchy (that is within a project), the service prevents
               the creation of multiple policies that conflict with each other.
               For more information, see how the service
               [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
               Structure is documented below.
        :param pulumi.Input[str] create_time: Time this guest policy was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: Description of the guest policy. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this guest policy. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[str] guest_policy_id: The logical name of the guest policy in the project with the following restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the project.
        :param pulumi.Input[str] name: Unique name of the resource in this project using one of the following forms: projects/{project_number}/guestPolicies/{guestPolicyId}.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageRepositoryArgs', 'GuestPoliciesPackageRepositoryArgsDict']]]] package_repositories: A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
               they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
               available.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesPackageArgs', 'GuestPoliciesPackageArgsDict']]]] packages: The software packages to be managed by this policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GuestPoliciesRecipeArgs', 'GuestPoliciesRecipeArgsDict']]]] recipes: A list of Recipes to install on the VM instance.
        :param pulumi.Input[str] update_time: Last time this guest policy was updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GuestPoliciesState.__new__(_GuestPoliciesState)

        __props__.__dict__["assignment"] = assignment
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["guest_policy_id"] = guest_policy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["package_repositories"] = package_repositories
        __props__.__dict__["packages"] = packages
        __props__.__dict__["project"] = project
        __props__.__dict__["recipes"] = recipes
        __props__.__dict__["update_time"] = update_time
        return GuestPolicies(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def assignment(self) -> pulumi.Output['outputs.GuestPoliciesAssignment']:
        """
        Specifies the VM instances that are assigned to this policy. This allows you to target sets
        or groups of VM instances by different parameters such as labels, names, OS, or zones.
        If left empty, all VM instances underneath this policy are targeted.
        At the same level in the resource hierarchy (that is within a project), the service prevents
        the creation of multiple policies that conflict with each other.
        For more information, see how the service
        [handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).
        Structure is documented below.
        """
        return pulumi.get(self, "assignment")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time this guest policy was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the guest policy. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The etag for this guest policy. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="guestPolicyId")
    def guest_policy_id(self) -> pulumi.Output[str]:
        """
        The logical name of the guest policy in the project with the following restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the project.
        """
        return pulumi.get(self, "guest_policy_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name of the resource in this project using one of the following forms: projects/{project_number}/guestPolicies/{guestPolicyId}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageRepositories")
    def package_repositories(self) -> pulumi.Output[Optional[Sequence['outputs.GuestPoliciesPackageRepository']]]:
        """
        A list of package repositories to configure on the VM instance. This is done before any other configs are applied so
        they can use these repos. Package repositories are only configured if the corresponding package manager(s) are
        available.
        """
        return pulumi.get(self, "package_repositories")

    @property
    @pulumi.getter
    def packages(self) -> pulumi.Output[Optional[Sequence['outputs.GuestPoliciesPackage']]]:
        """
        The software packages to be managed by this policy.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def recipes(self) -> pulumi.Output[Optional[Sequence['outputs.GuestPoliciesRecipe']]]:
        """
        A list of Recipes to install on the VM instance.
        """
        return pulumi.get(self, "recipes")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Last time this guest policy was updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

