# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DefaultServiceAccountsArgs', 'DefaultServiceAccounts']

@pulumi.input_type
class DefaultServiceAccountsArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 project: pulumi.Input[str],
                 restore_policy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DefaultServiceAccounts resource.
        :param pulumi.Input[str] action: The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        :param pulumi.Input[str] project: The project ID where service accounts are created.
        :param pulumi.Input[str] restore_policy: The action to be performed in the default service accounts on the resource destroy.
               Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
               If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
               If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "project", project)
        if restore_policy is not None:
            pulumi.set(__self__, "restore_policy", restore_policy)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The project ID where service accounts are created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="restorePolicy")
    def restore_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The action to be performed in the default service accounts on the resource destroy.
        Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
        If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
        If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        """
        return pulumi.get(self, "restore_policy")

    @restore_policy.setter
    def restore_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_policy", value)


@pulumi.input_type
class _DefaultServiceAccountsState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restore_policy: Optional[pulumi.Input[str]] = None,
                 service_accounts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DefaultServiceAccounts resources.
        :param pulumi.Input[str] action: The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        :param pulumi.Input[str] project: The project ID where service accounts are created.
        :param pulumi.Input[str] restore_policy: The action to be performed in the default service accounts on the resource destroy.
               Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
               If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
               If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_accounts: The Service Accounts changed by this resource. It is used for `REVERT` the `action` on the destroy.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if restore_policy is not None:
            pulumi.set(__self__, "restore_policy", restore_policy)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project ID where service accounts are created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="restorePolicy")
    def restore_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The action to be performed in the default service accounts on the resource destroy.
        Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
        If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
        If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        """
        return pulumi.get(self, "restore_policy")

    @restore_policy.setter
    def restore_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_policy", value)

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Service Accounts changed by this resource. It is used for `REVERT` the `action` on the destroy.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "service_accounts", value)


class DefaultServiceAccounts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restore_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows management of Google Cloud Platform project default service accounts.

        When certain service APIs are enabled, Google Cloud Platform automatically creates service accounts to help get started, but
        this is not recommended for production environments as per [Google's documentation](https://cloud.google.com/iam/docs/service-accounts#default).
        See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.

        > **WARNING** Some Google Cloud products do not work if the default service accounts are deleted so it is better to `DEPRIVILEGE` as
        Google **CAN NOT** recover service accounts that have been deleted for more than 30 days.
        Also Google recommends using the `constraints/iam.automaticIamGrantsForDefaultServiceAccounts` [constraint](https://www.terraform.io/docs/providers/google/r/google_organization_policy.html)
        to disable automatic IAM Grants to default service accounts.

        > This resource works on a best-effort basis, as no API formally describes the default service accounts
        and it is for users who are unable to use constraints. If the default service accounts change their name
        or additional service accounts are added, this resource will need to be updated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.projects.DefaultServiceAccounts("my_project",
            project="my-project-id",
            action="DELETE")
        ```

        To enable the default service accounts on the resource destroy:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.projects.DefaultServiceAccounts("my_project",
            project="my-project-id",
            action="DISABLE",
            restore_policy="REVERT")
        ```

        ## Import

        This resource does not support import

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        :param pulumi.Input[str] project: The project ID where service accounts are created.
        :param pulumi.Input[str] restore_policy: The action to be performed in the default service accounts on the resource destroy.
               Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
               If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
               If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultServiceAccountsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of Google Cloud Platform project default service accounts.

        When certain service APIs are enabled, Google Cloud Platform automatically creates service accounts to help get started, but
        this is not recommended for production environments as per [Google's documentation](https://cloud.google.com/iam/docs/service-accounts#default).
        See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.

        > **WARNING** Some Google Cloud products do not work if the default service accounts are deleted so it is better to `DEPRIVILEGE` as
        Google **CAN NOT** recover service accounts that have been deleted for more than 30 days.
        Also Google recommends using the `constraints/iam.automaticIamGrantsForDefaultServiceAccounts` [constraint](https://www.terraform.io/docs/providers/google/r/google_organization_policy.html)
        to disable automatic IAM Grants to default service accounts.

        > This resource works on a best-effort basis, as no API formally describes the default service accounts
        and it is for users who are unable to use constraints. If the default service accounts change their name
        or additional service accounts are added, this resource will need to be updated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.projects.DefaultServiceAccounts("my_project",
            project="my-project-id",
            action="DELETE")
        ```

        To enable the default service accounts on the resource destroy:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.projects.DefaultServiceAccounts("my_project",
            project="my-project-id",
            action="DISABLE",
            restore_policy="REVERT")
        ```

        ## Import

        This resource does not support import

        :param str resource_name: The name of the resource.
        :param DefaultServiceAccountsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultServiceAccountsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restore_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultServiceAccountsArgs.__new__(DefaultServiceAccountsArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["restore_policy"] = restore_policy
            __props__.__dict__["service_accounts"] = None
        super(DefaultServiceAccounts, __self__).__init__(
            'gcp:projects/defaultServiceAccounts:DefaultServiceAccounts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            restore_policy: Optional[pulumi.Input[str]] = None,
            service_accounts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'DefaultServiceAccounts':
        """
        Get an existing DefaultServiceAccounts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        :param pulumi.Input[str] project: The project ID where service accounts are created.
        :param pulumi.Input[str] restore_policy: The action to be performed in the default service accounts on the resource destroy.
               Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
               If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
               If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_accounts: The Service Accounts changed by this resource. It is used for `REVERT` the `action` on the destroy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultServiceAccountsState.__new__(_DefaultServiceAccountsState)

        __props__.__dict__["action"] = action
        __props__.__dict__["project"] = project
        __props__.__dict__["restore_policy"] = restore_policy
        __props__.__dict__["service_accounts"] = service_accounts
        return DefaultServiceAccounts(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The action to be performed in the default service accounts. Valid values are: `DEPRIVILEGE`, `DELETE`, `DISABLE`. Note that `DEPRIVILEGE` action will ignore the REVERT configuration in the restore_policy
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project ID where service accounts are created.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="restorePolicy")
    def restore_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The action to be performed in the default service accounts on the resource destroy.
        Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
        If set to REVERT it attempts to restore all default SAs but the DEPRIVILEGE action.
        If set to REVERT_AND_IGNORE_FAILURE it is the same behavior as REVERT but ignores errors returned by the API.
        """
        return pulumi.get(self, "restore_policy")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The Service Accounts changed by this resource. It is used for `REVERT` the `action` on the destroy.
        """
        return pulumi.get(self, "service_accounts")

