# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTopicIamPolicyResult',
    'AwaitableGetTopicIamPolicyResult',
    'get_topic_iam_policy',
    'get_topic_iam_policy_output',
]

@pulumi.output_type
class GetTopicIamPolicyResult:
    """
    A collection of values returned by getTopicIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, policy_data=None, project=None, topic=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `pubsub.TopicIAMPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def topic(self) -> str:
        return pulumi.get(self, "topic")


class AwaitableGetTopicIamPolicyResult(GetTopicIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicIamPolicyResult(
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project,
            topic=self.topic)


def get_topic_iam_policy(project: Optional[str] = None,
                         topic: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicIamPolicyResult:
    """
    Retrieves the current IAM policy data for topic

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.pubsub.get_topic_iam_policy(project=example["project"],
        topic=example["name"])
    ```


    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param str topic: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['topic'] = topic
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:pubsub/getTopicIamPolicy:getTopicIamPolicy', __args__, opts=opts, typ=GetTopicIamPolicyResult).value

    return AwaitableGetTopicIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        topic=pulumi.get(__ret__, 'topic'))


@_utilities.lift_output_func(get_topic_iam_policy)
def get_topic_iam_policy_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                                topic: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicIamPolicyResult]:
    """
    Retrieves the current IAM policy data for topic

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.pubsub.get_topic_iam_policy(project=example["project"],
        topic=example["name"])
    ```


    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param str topic: Used to find the parent resource to bind the IAM policy to
    """
    ...
