# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LiteSubscriptionDeliveryConfig',
    'LiteTopicPartitionConfig',
    'LiteTopicPartitionConfigCapacity',
    'LiteTopicReservationConfig',
    'LiteTopicRetentionConfig',
    'SchemaIamBindingCondition',
    'SchemaIamMemberCondition',
    'SubscriptionBigqueryConfig',
    'SubscriptionCloudStorageConfig',
    'SubscriptionCloudStorageConfigAvroConfig',
    'SubscriptionDeadLetterPolicy',
    'SubscriptionExpirationPolicy',
    'SubscriptionIAMBindingCondition',
    'SubscriptionIAMMemberCondition',
    'SubscriptionPushConfig',
    'SubscriptionPushConfigNoWrapper',
    'SubscriptionPushConfigOidcToken',
    'SubscriptionRetryPolicy',
    'TopicIAMBindingCondition',
    'TopicIAMMemberCondition',
    'TopicIngestionDataSourceSettings',
    'TopicIngestionDataSourceSettingsAwsKinesis',
    'TopicMessageStoragePolicy',
    'TopicSchemaSettings',
    'GetSubscriptionBigqueryConfigResult',
    'GetSubscriptionCloudStorageConfigResult',
    'GetSubscriptionCloudStorageConfigAvroConfigResult',
    'GetSubscriptionDeadLetterPolicyResult',
    'GetSubscriptionExpirationPolicyResult',
    'GetSubscriptionPushConfigResult',
    'GetSubscriptionPushConfigNoWrapperResult',
    'GetSubscriptionPushConfigOidcTokenResult',
    'GetSubscriptionRetryPolicyResult',
    'GetTopicIngestionDataSourceSettingResult',
    'GetTopicIngestionDataSourceSettingAwsKineseResult',
    'GetTopicMessageStoragePolicyResult',
    'GetTopicSchemaSettingResult',
]

@pulumi.output_type
class LiteSubscriptionDeliveryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryRequirement":
            suggest = "delivery_requirement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteSubscriptionDeliveryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteSubscriptionDeliveryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteSubscriptionDeliveryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_requirement: str):
        """
        :param str delivery_requirement: When this subscription should send messages to subscribers relative to messages persistence in storage.
               Possible values are: `DELIVER_IMMEDIATELY`, `DELIVER_AFTER_STORED`, `DELIVERY_REQUIREMENT_UNSPECIFIED`.
        """
        pulumi.set(__self__, "delivery_requirement", delivery_requirement)

    @property
    @pulumi.getter(name="deliveryRequirement")
    def delivery_requirement(self) -> str:
        """
        When this subscription should send messages to subscribers relative to messages persistence in storage.
        Possible values are: `DELIVER_IMMEDIATELY`, `DELIVER_AFTER_STORED`, `DELIVERY_REQUIREMENT_UNSPECIFIED`.
        """
        return pulumi.get(self, "delivery_requirement")


@pulumi.output_type
class LiteTopicPartitionConfig(dict):
    def __init__(__self__, *,
                 count: int,
                 capacity: Optional['outputs.LiteTopicPartitionConfigCapacity'] = None):
        """
        :param int count: The number of partitions in the topic. Must be at least 1.
        :param 'LiteTopicPartitionConfigCapacityArgs' capacity: The capacity configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "count", count)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of partitions in the topic. Must be at least 1.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.LiteTopicPartitionConfigCapacity']:
        """
        The capacity configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class LiteTopicPartitionConfigCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMibPerSec":
            suggest = "publish_mib_per_sec"
        elif key == "subscribeMibPerSec":
            suggest = "subscribe_mib_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicPartitionConfigCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicPartitionConfigCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicPartitionConfigCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_mib_per_sec: int,
                 subscribe_mib_per_sec: int):
        """
        :param int publish_mib_per_sec: Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        :param int subscribe_mib_per_sec: Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        pulumi.set(__self__, "publish_mib_per_sec", publish_mib_per_sec)
        pulumi.set(__self__, "subscribe_mib_per_sec", subscribe_mib_per_sec)

    @property
    @pulumi.getter(name="publishMibPerSec")
    def publish_mib_per_sec(self) -> int:
        """
        Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        return pulumi.get(self, "publish_mib_per_sec")

    @property
    @pulumi.getter(name="subscribeMibPerSec")
    def subscribe_mib_per_sec(self) -> int:
        """
        Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        return pulumi.get(self, "subscribe_mib_per_sec")


@pulumi.output_type
class LiteTopicReservationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputReservation":
            suggest = "throughput_reservation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicReservationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicReservationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicReservationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_reservation: Optional[str] = None):
        """
        :param str throughput_reservation: The Reservation to use for this topic's throughput capacity.
        """
        if throughput_reservation is not None:
            pulumi.set(__self__, "throughput_reservation", throughput_reservation)

    @property
    @pulumi.getter(name="throughputReservation")
    def throughput_reservation(self) -> Optional[str]:
        """
        The Reservation to use for this topic's throughput capacity.
        """
        return pulumi.get(self, "throughput_reservation")


@pulumi.output_type
class LiteTopicRetentionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "perPartitionBytes":
            suggest = "per_partition_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicRetentionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicRetentionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicRetentionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 per_partition_bytes: str,
                 period: Optional[str] = None):
        """
        :param str per_partition_bytes: The provisioned storage, in bytes, per partition. If the number of bytes stored
               in any of the topic's partitions grows beyond this value, older messages will be
               dropped to make room for newer ones, regardless of the value of period.
        :param str period: How long a published message is retained. If unset, messages will be retained as
               long as the bytes retained for each partition is below perPartitionBytes. A
               duration in seconds with up to nine fractional digits, terminated by 's'.
               Example: "3.5s".
        """
        pulumi.set(__self__, "per_partition_bytes", per_partition_bytes)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter(name="perPartitionBytes")
    def per_partition_bytes(self) -> str:
        """
        The provisioned storage, in bytes, per partition. If the number of bytes stored
        in any of the topic's partitions grows beyond this value, older messages will be
        dropped to make room for newer ones, regardless of the value of period.
        """
        return pulumi.get(self, "per_partition_bytes")

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        How long a published message is retained. If unset, messages will be retained as
        long as the bytes retained for each partition is below perPartitionBytes. A
        duration in seconds with up to nine fractional digits, terminated by 's'.
        Example: "3.5s".
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class SchemaIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SchemaIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionBigqueryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropUnknownFields":
            suggest = "drop_unknown_fields"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "useTableSchema":
            suggest = "use_table_schema"
        elif key == "useTopicSchema":
            suggest = "use_topic_schema"
        elif key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionBigqueryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionBigqueryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionBigqueryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 drop_unknown_fields: Optional[bool] = None,
                 service_account_email: Optional[str] = None,
                 use_table_schema: Optional[bool] = None,
                 use_topic_schema: Optional[bool] = None,
                 write_metadata: Optional[bool] = None):
        """
        :param str table: The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        :param bool drop_unknown_fields: When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
               are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
               and any messages with extra fields are not written and remain in the subscription's backlog.
        :param str service_account_email: The service account to use to write to BigQuery. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param bool use_table_schema: When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
               must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        :param bool use_topic_schema: When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
               Only one of use_topic_schema and use_table_schema can be set.
        :param bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
               The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        pulumi.set(__self__, "table", table)
        if drop_unknown_fields is not None:
            pulumi.set(__self__, "drop_unknown_fields", drop_unknown_fields)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if use_table_schema is not None:
            pulumi.set(__self__, "use_table_schema", use_table_schema)
        if use_topic_schema is not None:
            pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        if write_metadata is not None:
            pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="dropUnknownFields")
    def drop_unknown_fields(self) -> Optional[bool]:
        """
        When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
        are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
        and any messages with extra fields are not written and remain in the subscription's backlog.
        """
        return pulumi.get(self, "drop_unknown_fields")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[str]:
        """
        The service account to use to write to BigQuery. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="useTableSchema")
    def use_table_schema(self) -> Optional[bool]:
        """
        When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
        must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_table_schema")

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> Optional[bool]:
        """
        When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
        Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> Optional[bool]:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
        The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionCloudStorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroConfig":
            suggest = "avro_config"
        elif key == "filenameDatetimeFormat":
            suggest = "filename_datetime_format"
        elif key == "filenamePrefix":
            suggest = "filename_prefix"
        elif key == "filenameSuffix":
            suggest = "filename_suffix"
        elif key == "maxBytes":
            suggest = "max_bytes"
        elif key == "maxDuration":
            suggest = "max_duration"
        elif key == "maxMessages":
            suggest = "max_messages"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionCloudStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionCloudStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionCloudStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 avro_config: Optional['outputs.SubscriptionCloudStorageConfigAvroConfig'] = None,
                 filename_datetime_format: Optional[str] = None,
                 filename_prefix: Optional[str] = None,
                 filename_suffix: Optional[str] = None,
                 max_bytes: Optional[int] = None,
                 max_duration: Optional[str] = None,
                 max_messages: Optional[int] = None,
                 service_account_email: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str bucket: User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        :param 'SubscriptionCloudStorageConfigAvroConfigArgs' avro_config: If set, message data will be written to Cloud Storage in Avro format.
               Structure is documented below.
        :param str filename_datetime_format: User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        :param str filename_prefix: User-provided prefix for Cloud Storage filename.
        :param str filename_suffix: User-provided suffix for Cloud Storage filename. Must not end in "/".
        :param int max_bytes: The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
               The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        :param str max_duration: The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
               May not exceed the subscription's acknowledgement deadline.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param int max_messages: The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        :param str service_account_email: The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param str state: (Output)
               An output-only field that indicates whether or not the subscription can receive messages.
        """
        pulumi.set(__self__, "bucket", bucket)
        if avro_config is not None:
            pulumi.set(__self__, "avro_config", avro_config)
        if filename_datetime_format is not None:
            pulumi.set(__self__, "filename_datetime_format", filename_datetime_format)
        if filename_prefix is not None:
            pulumi.set(__self__, "filename_prefix", filename_prefix)
        if filename_suffix is not None:
            pulumi.set(__self__, "filename_suffix", filename_suffix)
        if max_bytes is not None:
            pulumi.set(__self__, "max_bytes", max_bytes)
        if max_duration is not None:
            pulumi.set(__self__, "max_duration", max_duration)
        if max_messages is not None:
            pulumi.set(__self__, "max_messages", max_messages)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="avroConfig")
    def avro_config(self) -> Optional['outputs.SubscriptionCloudStorageConfigAvroConfig']:
        """
        If set, message data will be written to Cloud Storage in Avro format.
        Structure is documented below.
        """
        return pulumi.get(self, "avro_config")

    @property
    @pulumi.getter(name="filenameDatetimeFormat")
    def filename_datetime_format(self) -> Optional[str]:
        """
        User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        """
        return pulumi.get(self, "filename_datetime_format")

    @property
    @pulumi.getter(name="filenamePrefix")
    def filename_prefix(self) -> Optional[str]:
        """
        User-provided prefix for Cloud Storage filename.
        """
        return pulumi.get(self, "filename_prefix")

    @property
    @pulumi.getter(name="filenameSuffix")
    def filename_suffix(self) -> Optional[str]:
        """
        User-provided suffix for Cloud Storage filename. Must not end in "/".
        """
        return pulumi.get(self, "filename_suffix")

    @property
    @pulumi.getter(name="maxBytes")
    def max_bytes(self) -> Optional[int]:
        """
        The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
        The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        """
        return pulumi.get(self, "max_bytes")

    @property
    @pulumi.getter(name="maxDuration")
    def max_duration(self) -> Optional[str]:
        """
        The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
        May not exceed the subscription's acknowledgement deadline.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_duration")

    @property
    @pulumi.getter(name="maxMessages")
    def max_messages(self) -> Optional[int]:
        """
        The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        """
        return pulumi.get(self, "max_messages")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[str]:
        """
        The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        An output-only field that indicates whether or not the subscription can receive messages.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SubscriptionCloudStorageConfigAvroConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useTopicSchema":
            suggest = "use_topic_schema"
        elif key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionCloudStorageConfigAvroConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionCloudStorageConfigAvroConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionCloudStorageConfigAvroConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_topic_schema: Optional[bool] = None,
                 write_metadata: Optional[bool] = None):
        """
        :param bool use_topic_schema: When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        :param bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        if use_topic_schema is not None:
            pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        if write_metadata is not None:
            pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> Optional[bool]:
        """
        When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> Optional[bool]:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionDeadLetterPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deadLetterTopic":
            suggest = "dead_letter_topic"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionDeadLetterPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionDeadLetterPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionDeadLetterPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dead_letter_topic: Optional[str] = None,
                 max_delivery_attempts: Optional[int] = None):
        """
        :param str dead_letter_topic: The name of the topic to which dead letter messages should be published.
               Format is `projects/{project}/topics/{topic}`.
               The Cloud Pub/Sub service account associated with the enclosing subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Publish() to this topic.
               The operation will fail if the topic does not exist.
               Users should ensure that there is a subscription attached to this topic
               since messages published to a topic with no subscriptions are lost.
        :param int max_delivery_attempts: The maximum number of delivery attempts for any message. The value must be
               between 5 and 100.
               The number of delivery attempts is defined as 1 + (the sum of number of
               NACKs and number of times the acknowledgement deadline has been exceeded for the message).
               A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
               client libraries may automatically extend ack_deadlines.
               This field will be honored on a best effort basis.
               If this parameter is 0, a default value of 5 is used.
        """
        if dead_letter_topic is not None:
            pulumi.set(__self__, "dead_letter_topic", dead_letter_topic)
        if max_delivery_attempts is not None:
            pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="deadLetterTopic")
    def dead_letter_topic(self) -> Optional[str]:
        """
        The name of the topic to which dead letter messages should be published.
        Format is `projects/{project}/topics/{topic}`.
        The Cloud Pub/Sub service account associated with the enclosing subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Publish() to this topic.
        The operation will fail if the topic does not exist.
        Users should ensure that there is a subscription attached to this topic
        since messages published to a topic with no subscriptions are lost.
        """
        return pulumi.get(self, "dead_letter_topic")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> Optional[int]:
        """
        The maximum number of delivery attempts for any message. The value must be
        between 5 and 100.
        The number of delivery attempts is defined as 1 + (the sum of number of
        NACKs and number of times the acknowledgement deadline has been exceeded for the message).
        A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
        client libraries may automatically extend ack_deadlines.
        This field will be honored on a best effort basis.
        If this parameter is 0, a default value of 5 is used.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class SubscriptionExpirationPolicy(dict):
    def __init__(__self__, *,
                 ttl: str):
        """
        :param str ttl: Specifies the "time-to-live" duration for an associated resource. The
               resource expires if it is not active for a period of ttl.
               If ttl is set to "", the associated resource never expires.
               A duration in seconds with up to nine fractional digits, terminated by 's'.
               Example - "3.5s".
        """
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Specifies the "time-to-live" duration for an associated resource. The
        resource expires if it is not active for a period of ttl.
        If ttl is set to "", the associated resource never expires.
        A duration in seconds with up to nine fractional digits, terminated by 's'.
        Example - "3.5s".
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class SubscriptionIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionPushConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pushEndpoint":
            suggest = "push_endpoint"
        elif key == "noWrapper":
            suggest = "no_wrapper"
        elif key == "oidcToken":
            suggest = "oidc_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 push_endpoint: str,
                 attributes: Optional[Mapping[str, str]] = None,
                 no_wrapper: Optional['outputs.SubscriptionPushConfigNoWrapper'] = None,
                 oidc_token: Optional['outputs.SubscriptionPushConfigOidcToken'] = None):
        """
        :param str push_endpoint: A URL locating the endpoint to which messages should be pushed.
               For example, a Webhook endpoint might use
               "https://example.com/push".
        :param Mapping[str, str] attributes: Endpoint configuration attributes.
               Every endpoint has a set of API supported attributes that can
               be used to control different aspects of the message delivery.
               The currently supported attribute is x-goog-version, which you
               can use to change the format of the pushed message. This
               attribute indicates the version of the data expected by
               the endpoint. This controls the shape of the pushed message
               (i.e., its fields and metadata). The endpoint version is
               based on the version of the Pub/Sub API.
               If not present during the subscriptions.create call,
               it will default to the version of the API used to make
               such call. If not present during a subscriptions.modifyPushConfig
               call, its value will not be changed. subscriptions.get
               calls will always return a valid version, even if the
               subscription was created without this attribute.
               The possible values for this attribute are:
               - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
               - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        :param 'SubscriptionPushConfigNoWrapperArgs' no_wrapper: When set, the payload to the push endpoint is not wrapped.Sets the
               `data` field as the HTTP body for delivery.
               Structure is documented below.
        :param 'SubscriptionPushConfigOidcTokenArgs' oidc_token: If specified, Pub/Sub will generate and attach an OIDC JWT token as
               an Authorization header in the HTTP request for every pushed message.
               Structure is documented below.
        """
        pulumi.set(__self__, "push_endpoint", push_endpoint)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if no_wrapper is not None:
            pulumi.set(__self__, "no_wrapper", no_wrapper)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)

    @property
    @pulumi.getter(name="pushEndpoint")
    def push_endpoint(self) -> str:
        """
        A URL locating the endpoint to which messages should be pushed.
        For example, a Webhook endpoint might use
        "https://example.com/push".
        """
        return pulumi.get(self, "push_endpoint")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, str]]:
        """
        Endpoint configuration attributes.
        Every endpoint has a set of API supported attributes that can
        be used to control different aspects of the message delivery.
        The currently supported attribute is x-goog-version, which you
        can use to change the format of the pushed message. This
        attribute indicates the version of the data expected by
        the endpoint. This controls the shape of the pushed message
        (i.e., its fields and metadata). The endpoint version is
        based on the version of the Pub/Sub API.
        If not present during the subscriptions.create call,
        it will default to the version of the API used to make
        such call. If not present during a subscriptions.modifyPushConfig
        call, its value will not be changed. subscriptions.get
        calls will always return a valid version, even if the
        subscription was created without this attribute.
        The possible values for this attribute are:
        - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
        - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="noWrapper")
    def no_wrapper(self) -> Optional['outputs.SubscriptionPushConfigNoWrapper']:
        """
        When set, the payload to the push endpoint is not wrapped.Sets the
        `data` field as the HTTP body for delivery.
        Structure is documented below.
        """
        return pulumi.get(self, "no_wrapper")

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional['outputs.SubscriptionPushConfigOidcToken']:
        """
        If specified, Pub/Sub will generate and attach an OIDC JWT token as
        an Authorization header in the HTTP request for every pushed message.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_token")


@pulumi.output_type
class SubscriptionPushConfigNoWrapper(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfigNoWrapper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfigNoWrapper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfigNoWrapper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 write_metadata: bool):
        """
        :param bool write_metadata: When true, writes the Pub/Sub message metadata to
               `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
               Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
        """
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> bool:
        """
        When true, writes the Pub/Sub message metadata to
        `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
        Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionPushConfigOidcToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfigOidcToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfigOidcToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfigOidcToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email: str,
                 audience: Optional[str] = None):
        """
        :param str service_account_email: Service account email to be used for generating the OIDC token.
               The caller (for subscriptions.create, subscriptions.patch, and
               subscriptions.modifyPushConfig RPCs) must have the
               iam.serviceAccounts.actAs permission for the service account.
        :param str audience: Audience to be used when generating OIDC token. The audience claim
               identifies the recipients that the JWT is intended for. The audience
               value is a single case-sensitive string. Having multiple values (array)
               for the audience field is not supported. More info about the OIDC JWT
               token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
               Note: if not specified, the Push endpoint URL will be used.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        Service account email to be used for generating the OIDC token.
        The caller (for subscriptions.create, subscriptions.patch, and
        subscriptions.modifyPushConfig RPCs) must have the
        iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Audience to be used when generating OIDC token. The audience claim
        identifies the recipients that the JWT is intended for. The audience
        value is a single case-sensitive string. Having multiple values (array)
        for the audience field is not supported. More info about the OIDC JWT
        token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
        Note: if not specified, the Push endpoint URL will be used.
        """
        return pulumi.get(self, "audience")


@pulumi.output_type
class SubscriptionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBackoff":
            suggest = "maximum_backoff"
        elif key == "minimumBackoff":
            suggest = "minimum_backoff"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_backoff: Optional[str] = None,
                 minimum_backoff: Optional[str] = None):
        """
        :param str maximum_backoff: The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str minimum_backoff: The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if maximum_backoff is not None:
            pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        if minimum_backoff is not None:
            pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> Optional[str]:
        """
        The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> Optional[str]:
        """
        The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")


@pulumi.output_type
class TopicIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TopicIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TopicIngestionDataSourceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsKinesis":
            suggest = "aws_kinesis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_kinesis: Optional['outputs.TopicIngestionDataSourceSettingsAwsKinesis'] = None):
        """
        :param 'TopicIngestionDataSourceSettingsAwsKinesisArgs' aws_kinesis: Settings for ingestion from Amazon Kinesis Data Streams.
               Structure is documented below.
        """
        if aws_kinesis is not None:
            pulumi.set(__self__, "aws_kinesis", aws_kinesis)

    @property
    @pulumi.getter(name="awsKinesis")
    def aws_kinesis(self) -> Optional['outputs.TopicIngestionDataSourceSettingsAwsKinesis']:
        """
        Settings for ingestion from Amazon Kinesis Data Streams.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_kinesis")


@pulumi.output_type
class TopicIngestionDataSourceSettingsAwsKinesis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRoleArn":
            suggest = "aws_role_arn"
        elif key == "consumerArn":
            suggest = "consumer_arn"
        elif key == "gcpServiceAccount":
            suggest = "gcp_service_account"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsAwsKinesis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsAwsKinesis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsAwsKinesis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_role_arn: str,
                 consumer_arn: str,
                 gcp_service_account: str,
                 stream_arn: str):
        """
        :param str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               Kinesis. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param str consumer_arn: The Kinesis consumer ARN to used for ingestion in
               Enhanced Fan-Out mode. The consumer must be already
               created and ready to be used.
        :param str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Kinesis (via a `AssumeRoleWithWebIdentity` call for the provided
               role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
               equals to this service account number.
        :param str stream_arn: The Kinesis stream ARN to ingest data from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        Kinesis. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> str:
        """
        The Kinesis consumer ARN to used for ingestion in
        Enhanced Fan-Out mode. The consumer must be already
        created and ready to be used.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Kinesis (via a `AssumeRoleWithWebIdentity` call for the provided
        role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        """
        The Kinesis stream ARN to ingest data from.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class TopicMessageStoragePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedPersistenceRegions":
            suggest = "allowed_persistence_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicMessageStoragePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicMessageStoragePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicMessageStoragePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_persistence_regions: Sequence[str]):
        """
        :param Sequence[str] allowed_persistence_regions: A list of IDs of GCP regions where messages that are published to
               the topic may be persisted in storage. Messages published by
               publishers running in non-allowed GCP regions (or running outside
               of GCP altogether) will be routed for storage in one of the
               allowed regions. An empty list means that no regions are allowed,
               and is not a valid configuration.
        """
        pulumi.set(__self__, "allowed_persistence_regions", allowed_persistence_regions)

    @property
    @pulumi.getter(name="allowedPersistenceRegions")
    def allowed_persistence_regions(self) -> Sequence[str]:
        """
        A list of IDs of GCP regions where messages that are published to
        the topic may be persisted in storage. Messages published by
        publishers running in non-allowed GCP regions (or running outside
        of GCP altogether) will be routed for storage in one of the
        allowed regions. An empty list means that no regions are allowed,
        and is not a valid configuration.
        """
        return pulumi.get(self, "allowed_persistence_regions")


@pulumi.output_type
class TopicSchemaSettings(dict):
    def __init__(__self__, *,
                 schema: str,
                 encoding: Optional[str] = None):
        """
        :param str schema: The name of the schema that messages published should be
               validated against. Format is projects/{project}/schemas/{schema}.
               The value of this field will be _deleted-schema_
               if the schema has been deleted.
        :param str encoding: The encoding of messages validated against schema.
               Default value is `ENCODING_UNSPECIFIED`.
               Possible values are: `ENCODING_UNSPECIFIED`, `JSON`, `BINARY`.
        """
        pulumi.set(__self__, "schema", schema)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The name of the schema that messages published should be
        validated against. Format is projects/{project}/schemas/{schema}.
        The value of this field will be _deleted-schema_
        if the schema has been deleted.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The encoding of messages validated against schema.
        Default value is `ENCODING_UNSPECIFIED`.
        Possible values are: `ENCODING_UNSPECIFIED`, `JSON`, `BINARY`.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class GetSubscriptionBigqueryConfigResult(dict):
    def __init__(__self__, *,
                 drop_unknown_fields: bool,
                 service_account_email: str,
                 table: str,
                 use_table_schema: bool,
                 use_topic_schema: bool,
                 write_metadata: bool):
        """
        :param bool drop_unknown_fields: When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
               are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
               and any messages with extra fields are not written and remain in the subscription's backlog.
        :param str service_account_email: The service account to use to write to BigQuery. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param str table: The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        :param bool use_table_schema: When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
               must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        :param bool use_topic_schema: When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
               Only one of use_topic_schema and use_table_schema can be set.
        :param bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
               The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        pulumi.set(__self__, "drop_unknown_fields", drop_unknown_fields)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "use_table_schema", use_table_schema)
        pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="dropUnknownFields")
    def drop_unknown_fields(self) -> bool:
        """
        When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
        are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
        and any messages with extra fields are not written and remain in the subscription's backlog.
        """
        return pulumi.get(self, "drop_unknown_fields")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        The service account to use to write to BigQuery. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="useTableSchema")
    def use_table_schema(self) -> bool:
        """
        When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
        must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_table_schema")

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> bool:
        """
        When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
        Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> bool:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
        The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionCloudStorageConfigResult(dict):
    def __init__(__self__, *,
                 avro_configs: Sequence['outputs.GetSubscriptionCloudStorageConfigAvroConfigResult'],
                 bucket: str,
                 filename_datetime_format: str,
                 filename_prefix: str,
                 filename_suffix: str,
                 max_bytes: int,
                 max_duration: str,
                 max_messages: int,
                 service_account_email: str,
                 state: str):
        """
        :param Sequence['GetSubscriptionCloudStorageConfigAvroConfigArgs'] avro_configs: If set, message data will be written to Cloud Storage in Avro format.
        :param str bucket: User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        :param str filename_datetime_format: User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        :param str filename_prefix: User-provided prefix for Cloud Storage filename.
        :param str filename_suffix: User-provided suffix for Cloud Storage filename. Must not end in "/".
        :param int max_bytes: The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
               The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        :param str max_duration: The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
               May not exceed the subscription's acknowledgement deadline.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param int max_messages: The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        :param str service_account_email: The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param str state: An output-only field that indicates whether or not the subscription can receive messages.
        """
        pulumi.set(__self__, "avro_configs", avro_configs)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "filename_datetime_format", filename_datetime_format)
        pulumi.set(__self__, "filename_prefix", filename_prefix)
        pulumi.set(__self__, "filename_suffix", filename_suffix)
        pulumi.set(__self__, "max_bytes", max_bytes)
        pulumi.set(__self__, "max_duration", max_duration)
        pulumi.set(__self__, "max_messages", max_messages)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="avroConfigs")
    def avro_configs(self) -> Sequence['outputs.GetSubscriptionCloudStorageConfigAvroConfigResult']:
        """
        If set, message data will be written to Cloud Storage in Avro format.
        """
        return pulumi.get(self, "avro_configs")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="filenameDatetimeFormat")
    def filename_datetime_format(self) -> str:
        """
        User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        """
        return pulumi.get(self, "filename_datetime_format")

    @property
    @pulumi.getter(name="filenamePrefix")
    def filename_prefix(self) -> str:
        """
        User-provided prefix for Cloud Storage filename.
        """
        return pulumi.get(self, "filename_prefix")

    @property
    @pulumi.getter(name="filenameSuffix")
    def filename_suffix(self) -> str:
        """
        User-provided suffix for Cloud Storage filename. Must not end in "/".
        """
        return pulumi.get(self, "filename_suffix")

    @property
    @pulumi.getter(name="maxBytes")
    def max_bytes(self) -> int:
        """
        The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
        The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        """
        return pulumi.get(self, "max_bytes")

    @property
    @pulumi.getter(name="maxDuration")
    def max_duration(self) -> str:
        """
        The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
        May not exceed the subscription's acknowledgement deadline.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_duration")

    @property
    @pulumi.getter(name="maxMessages")
    def max_messages(self) -> int:
        """
        The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        """
        return pulumi.get(self, "max_messages")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        An output-only field that indicates whether or not the subscription can receive messages.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetSubscriptionCloudStorageConfigAvroConfigResult(dict):
    def __init__(__self__, *,
                 use_topic_schema: bool,
                 write_metadata: bool):
        """
        :param bool use_topic_schema: When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        :param bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> bool:
        """
        When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> bool:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionDeadLetterPolicyResult(dict):
    def __init__(__self__, *,
                 dead_letter_topic: str,
                 max_delivery_attempts: int):
        """
        :param str dead_letter_topic: The name of the topic to which dead letter messages should be published.
               Format is 'projects/{project}/topics/{topic}'.
               
               The Cloud Pub/Sub service account associated with the enclosing subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Publish() to this topic.
               
               The operation will fail if the topic does not exist.
               Users should ensure that there is a subscription attached to this topic
               since messages published to a topic with no subscriptions are lost.
        :param int max_delivery_attempts: The maximum number of delivery attempts for any message. The value must be
               between 5 and 100.
               
               The number of delivery attempts is defined as 1 + (the sum of number of
               NACKs and number of times the acknowledgement deadline has been exceeded for the message).
               
               A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
               client libraries may automatically extend ack_deadlines.
               
               This field will be honored on a best effort basis.
               
               If this parameter is 0, a default value of 5 is used.
        """
        pulumi.set(__self__, "dead_letter_topic", dead_letter_topic)
        pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="deadLetterTopic")
    def dead_letter_topic(self) -> str:
        """
        The name of the topic to which dead letter messages should be published.
        Format is 'projects/{project}/topics/{topic}'.

        The Cloud Pub/Sub service account associated with the enclosing subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Publish() to this topic.

        The operation will fail if the topic does not exist.
        Users should ensure that there is a subscription attached to this topic
        since messages published to a topic with no subscriptions are lost.
        """
        return pulumi.get(self, "dead_letter_topic")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> int:
        """
        The maximum number of delivery attempts for any message. The value must be
        between 5 and 100.

        The number of delivery attempts is defined as 1 + (the sum of number of
        NACKs and number of times the acknowledgement deadline has been exceeded for the message).

        A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
        client libraries may automatically extend ack_deadlines.

        This field will be honored on a best effort basis.

        If this parameter is 0, a default value of 5 is used.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class GetSubscriptionExpirationPolicyResult(dict):
    def __init__(__self__, *,
                 ttl: str):
        """
        :param str ttl: Specifies the "time-to-live" duration for an associated resource. The
               resource expires if it is not active for a period of ttl.
               If ttl is set to "", the associated resource never expires.
               A duration in seconds with up to nine fractional digits, terminated by 's'.
               Example - "3.5s".
        """
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Specifies the "time-to-live" duration for an associated resource. The
        resource expires if it is not active for a period of ttl.
        If ttl is set to "", the associated resource never expires.
        A duration in seconds with up to nine fractional digits, terminated by 's'.
        Example - "3.5s".
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetSubscriptionPushConfigResult(dict):
    def __init__(__self__, *,
                 attributes: Mapping[str, str],
                 no_wrappers: Sequence['outputs.GetSubscriptionPushConfigNoWrapperResult'],
                 oidc_tokens: Sequence['outputs.GetSubscriptionPushConfigOidcTokenResult'],
                 push_endpoint: str):
        """
        :param Mapping[str, str] attributes: Endpoint configuration attributes.
               
               Every endpoint has a set of API supported attributes that can
               be used to control different aspects of the message delivery.
               
               The currently supported attribute is x-goog-version, which you
               can use to change the format of the pushed message. This
               attribute indicates the version of the data expected by
               the endpoint. This controls the shape of the pushed message
               (i.e., its fields and metadata). The endpoint version is
               based on the version of the Pub/Sub API.
               
               If not present during the subscriptions.create call,
               it will default to the version of the API used to make
               such call. If not present during a subscriptions.modifyPushConfig
               call, its value will not be changed. subscriptions.get
               calls will always return a valid version, even if the
               subscription was created without this attribute.
               
               The possible values for this attribute are:
               
               - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
               - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        :param Sequence['GetSubscriptionPushConfigNoWrapperArgs'] no_wrappers: When set, the payload to the push endpoint is not wrapped.Sets the
               'data' field as the HTTP body for delivery.
        :param Sequence['GetSubscriptionPushConfigOidcTokenArgs'] oidc_tokens: If specified, Pub/Sub will generate and attach an OIDC JWT token as
               an Authorization header in the HTTP request for every pushed message.
        :param str push_endpoint: A URL locating the endpoint to which messages should be pushed.
               For example, a Webhook endpoint might use
               "https://example.com/push".
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "no_wrappers", no_wrappers)
        pulumi.set(__self__, "oidc_tokens", oidc_tokens)
        pulumi.set(__self__, "push_endpoint", push_endpoint)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, str]:
        """
        Endpoint configuration attributes.

        Every endpoint has a set of API supported attributes that can
        be used to control different aspects of the message delivery.

        The currently supported attribute is x-goog-version, which you
        can use to change the format of the pushed message. This
        attribute indicates the version of the data expected by
        the endpoint. This controls the shape of the pushed message
        (i.e., its fields and metadata). The endpoint version is
        based on the version of the Pub/Sub API.

        If not present during the subscriptions.create call,
        it will default to the version of the API used to make
        such call. If not present during a subscriptions.modifyPushConfig
        call, its value will not be changed. subscriptions.get
        calls will always return a valid version, even if the
        subscription was created without this attribute.

        The possible values for this attribute are:

        - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
        - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="noWrappers")
    def no_wrappers(self) -> Sequence['outputs.GetSubscriptionPushConfigNoWrapperResult']:
        """
        When set, the payload to the push endpoint is not wrapped.Sets the
        'data' field as the HTTP body for delivery.
        """
        return pulumi.get(self, "no_wrappers")

    @property
    @pulumi.getter(name="oidcTokens")
    def oidc_tokens(self) -> Sequence['outputs.GetSubscriptionPushConfigOidcTokenResult']:
        """
        If specified, Pub/Sub will generate and attach an OIDC JWT token as
        an Authorization header in the HTTP request for every pushed message.
        """
        return pulumi.get(self, "oidc_tokens")

    @property
    @pulumi.getter(name="pushEndpoint")
    def push_endpoint(self) -> str:
        """
        A URL locating the endpoint to which messages should be pushed.
        For example, a Webhook endpoint might use
        "https://example.com/push".
        """
        return pulumi.get(self, "push_endpoint")


@pulumi.output_type
class GetSubscriptionPushConfigNoWrapperResult(dict):
    def __init__(__self__, *,
                 write_metadata: bool):
        """
        :param bool write_metadata: When true, writes the Pub/Sub message metadata to
               'x-goog-pubsub-<KEY>:<VAL>' headers of the HTTP request. Writes the
               Pub/Sub message attributes to '<KEY>:<VAL>' headers of the HTTP request.
        """
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> bool:
        """
        When true, writes the Pub/Sub message metadata to
        'x-goog-pubsub-<KEY>:<VAL>' headers of the HTTP request. Writes the
        Pub/Sub message attributes to '<KEY>:<VAL>' headers of the HTTP request.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionPushConfigOidcTokenResult(dict):
    def __init__(__self__, *,
                 audience: str,
                 service_account_email: str):
        """
        :param str audience: Audience to be used when generating OIDC token. The audience claim
               identifies the recipients that the JWT is intended for. The audience
               value is a single case-sensitive string. Having multiple values (array)
               for the audience field is not supported. More info about the OIDC JWT
               token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
               Note: if not specified, the Push endpoint URL will be used.
        :param str service_account_email: Service account email to be used for generating the OIDC token.
               The caller (for subscriptions.create, subscriptions.patch, and
               subscriptions.modifyPushConfig RPCs) must have the
               iam.serviceAccounts.actAs permission for the service account.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "service_account_email", service_account_email)

    @property
    @pulumi.getter
    def audience(self) -> str:
        """
        Audience to be used when generating OIDC token. The audience claim
        identifies the recipients that the JWT is intended for. The audience
        value is a single case-sensitive string. Having multiple values (array)
        for the audience field is not supported. More info about the OIDC JWT
        token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
        Note: if not specified, the Push endpoint URL will be used.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        Service account email to be used for generating the OIDC token.
        The caller (for subscriptions.create, subscriptions.patch, and
        subscriptions.modifyPushConfig RPCs) must have the
        iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")


@pulumi.output_type
class GetSubscriptionRetryPolicyResult(dict):
    def __init__(__self__, *,
                 maximum_backoff: str,
                 minimum_backoff: str):
        """
        :param str maximum_backoff: The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str minimum_backoff: The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> str:
        """
        The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> str:
        """
        The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingResult(dict):
    def __init__(__self__, *,
                 aws_kineses: Sequence['outputs.GetTopicIngestionDataSourceSettingAwsKineseResult']):
        """
        :param Sequence['GetTopicIngestionDataSourceSettingAwsKineseArgs'] aws_kineses: Settings for ingestion from Amazon Kinesis Data Streams.
        """
        pulumi.set(__self__, "aws_kineses", aws_kineses)

    @property
    @pulumi.getter(name="awsKineses")
    def aws_kineses(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingAwsKineseResult']:
        """
        Settings for ingestion from Amazon Kinesis Data Streams.
        """
        return pulumi.get(self, "aws_kineses")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingAwsKineseResult(dict):
    def __init__(__self__, *,
                 aws_role_arn: str,
                 consumer_arn: str,
                 gcp_service_account: str,
                 stream_arn: str):
        """
        :param str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               Kinesis. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param str consumer_arn: The Kinesis consumer ARN to used for ingestion in
               Enhanced Fan-Out mode. The consumer must be already
               created and ready to be used.
        :param str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Kinesis (via a 'AssumeRoleWithWebIdentity' call for the provided
               role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
               equals to this service account number.
        :param str stream_arn: The Kinesis stream ARN to ingest data from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        Kinesis. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> str:
        """
        The Kinesis consumer ARN to used for ingestion in
        Enhanced Fan-Out mode. The consumer must be already
        created and ready to be used.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Kinesis (via a 'AssumeRoleWithWebIdentity' call for the provided
        role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        """
        The Kinesis stream ARN to ingest data from.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class GetTopicMessageStoragePolicyResult(dict):
    def __init__(__self__, *,
                 allowed_persistence_regions: Sequence[str]):
        """
        :param Sequence[str] allowed_persistence_regions: A list of IDs of GCP regions where messages that are published to
               the topic may be persisted in storage. Messages published by
               publishers running in non-allowed GCP regions (or running outside
               of GCP altogether) will be routed for storage in one of the
               allowed regions. An empty list means that no regions are allowed,
               and is not a valid configuration.
        """
        pulumi.set(__self__, "allowed_persistence_regions", allowed_persistence_regions)

    @property
    @pulumi.getter(name="allowedPersistenceRegions")
    def allowed_persistence_regions(self) -> Sequence[str]:
        """
        A list of IDs of GCP regions where messages that are published to
        the topic may be persisted in storage. Messages published by
        publishers running in non-allowed GCP regions (or running outside
        of GCP altogether) will be routed for storage in one of the
        allowed regions. An empty list means that no regions are allowed,
        and is not a valid configuration.
        """
        return pulumi.get(self, "allowed_persistence_regions")


@pulumi.output_type
class GetTopicSchemaSettingResult(dict):
    def __init__(__self__, *,
                 encoding: str,
                 schema: str):
        """
        :param str encoding: The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
        :param str schema: The name of the schema that messages published should be
               validated against. Format is projects/{project}/schemas/{schema}.
               The value of this field will be _deleted-schema_
               if the schema has been deleted.
        """
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The name of the schema that messages published should be
        validated against. Format is projects/{project}/schemas/{schema}.
        The value of this field will be _deleted-schema_
        if the schema has been deleted.
        """
        return pulumi.get(self, "schema")


