# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterDiscoveryEndpointArgs',
    'ClusterDiscoveryEndpointArgsDict',
    'ClusterDiscoveryEndpointPscConfigArgs',
    'ClusterDiscoveryEndpointPscConfigArgsDict',
    'ClusterMaintenancePolicyArgs',
    'ClusterMaintenancePolicyArgsDict',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindowArgsDict',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict',
    'ClusterMaintenanceScheduleArgs',
    'ClusterMaintenanceScheduleArgsDict',
    'ClusterPscConfigArgs',
    'ClusterPscConfigArgsDict',
    'ClusterPscConnectionArgs',
    'ClusterPscConnectionArgsDict',
    'ClusterStateInfoArgs',
    'ClusterStateInfoArgsDict',
    'ClusterStateInfoUpdateInfoArgs',
    'ClusterStateInfoUpdateInfoArgsDict',
    'ClusterZoneDistributionConfigArgs',
    'ClusterZoneDistributionConfigArgsDict',
    'InstanceMaintenancePolicyArgs',
    'InstanceMaintenancePolicyArgsDict',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict',
    'InstanceMaintenanceScheduleArgs',
    'InstanceMaintenanceScheduleArgsDict',
    'InstanceNodeArgs',
    'InstanceNodeArgsDict',
    'InstancePersistenceConfigArgs',
    'InstancePersistenceConfigArgsDict',
    'InstanceServerCaCertArgs',
    'InstanceServerCaCertArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterDiscoveryEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[str]]
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        Output only. The port number of the exposed Redis endpoint.
        """
        psc_config: NotRequired[pulumi.Input['ClusterDiscoveryEndpointPscConfigArgsDict']]
        """
        Output only. Customer configuration for where the endpoint
        is created and accessed from.
        Structure is documented below.
        """
elif False:
    ClusterDiscoveryEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterDiscoveryEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 psc_config: Optional[pulumi.Input['ClusterDiscoveryEndpointPscConfigArgs']] = None):
        """
        :param pulumi.Input[str] address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param pulumi.Input[int] port: Output only. The port number of the exposed Redis endpoint.
        :param pulumi.Input['ClusterDiscoveryEndpointPscConfigArgs'] psc_config: Output only. Customer configuration for where the endpoint
               is created and accessed from.
               Structure is documented below.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Output only. The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['ClusterDiscoveryEndpointPscConfigArgs']]:
        """
        Output only. Customer configuration for where the endpoint
        is created and accessed from.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['ClusterDiscoveryEndpointPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)


if not MYPY:
    class ClusterDiscoveryEndpointPscConfigArgsDict(TypedDict):
        network: NotRequired[pulumi.Input[str]]
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
elif False:
    ClusterDiscoveryEndpointPscConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterDiscoveryEndpointPscConfigArgs:
    def __init__(__self__, *,
                 network: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] network: The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)


if not MYPY:
    class ClusterMaintenancePolicyArgsDict(TypedDict):
        create_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        update_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        weekly_maintenance_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgsDict']]]]
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
elif False:
    ClusterMaintenancePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs']]]] = None):
        """
        :param pulumi.Input[str] create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] update_time: (Output)
               Output only. The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs']]] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if weekly_maintenance_windows is not None:
            pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs']]]]:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")

    @weekly_maintenance_windows.setter
    def weekly_maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs']]]]):
        pulumi.set(self, "weekly_maintenance_windows", value)


if not MYPY:
    class ClusterMaintenancePolicyWeeklyMaintenanceWindowArgsDict(TypedDict):
        day: pulumi.Input[str]
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        start_time: pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict']
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        duration: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
elif False:
    ClusterMaintenancePolicyWeeklyMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[str],
                 start_time: pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'],
                 duration: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        :param pulumi.Input[str] duration: (Output)
               Output only. Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[str]:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']:
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)


if not MYPY:
    class ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[int]]
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        nanos: NotRequired[pulumi.Input[int]]
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
elif False:
    ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class ClusterMaintenanceScheduleArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        schedule_deadline_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
elif False:
    ClusterMaintenanceScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceScheduleArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 schedule_deadline_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @schedule_deadline_time.setter
    def schedule_deadline_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_deadline_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterPscConfigArgsDict(TypedDict):
        network: pulumi.Input[str]
        """
        Required. The consumer network where the network address of
        the discovery endpoint will be reserved, in the form of
        projects/{network_project_id_or_number}/global/networks/{network_id}.

        - - -
        """
elif False:
    ClusterPscConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPscConfigArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network: Required. The consumer network where the network address of
               the discovery endpoint will be reserved, in the form of
               projects/{network_project_id_or_number}/global/networks/{network_id}.
               
               - - -
        """
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        Required. The consumer network where the network address of
        the discovery endpoint will be reserved, in the form of
        projects/{network_project_id_or_number}/global/networks/{network_id}.

        - - -
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)


if not MYPY:
    class ClusterPscConnectionArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[str]]
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        forwarding_rule: NotRequired[pulumi.Input[str]]
        """
        Output only. The URI of the consumer side forwarding rule. Example: projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
        """
        network: NotRequired[pulumi.Input[str]]
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        project_id: NotRequired[pulumi.Input[str]]
        """
        Output only. The consumer projectId where the forwarding rule is created from.
        """
        psc_connection_id: NotRequired[pulumi.Input[str]]
        """
        Output only. The PSC connection id of the forwarding rule connected to the service attachment.
        """
elif False:
    ClusterPscConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPscConnectionArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 forwarding_rule: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 psc_connection_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param pulumi.Input[str] forwarding_rule: Output only. The URI of the consumer side forwarding rule. Example: projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
        :param pulumi.Input[str] network: The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        :param pulumi.Input[str] project_id: Output only. The consumer projectId where the forwarding rule is created from.
        :param pulumi.Input[str] psc_connection_id: Output only. The PSC connection id of the forwarding rule connected to the service attachment.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The URI of the consumer side forwarding rule. Example: projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
        """
        return pulumi.get(self, "forwarding_rule")

    @forwarding_rule.setter
    def forwarding_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forwarding_rule", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The consumer projectId where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The PSC connection id of the forwarding rule connected to the service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @psc_connection_id.setter
    def psc_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_connection_id", value)


if not MYPY:
    class ClusterStateInfoArgsDict(TypedDict):
        update_info: NotRequired[pulumi.Input['ClusterStateInfoUpdateInfoArgsDict']]
        """
        A nested object resource
        Structure is documented below.
        """
elif False:
    ClusterStateInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStateInfoArgs:
    def __init__(__self__, *,
                 update_info: Optional[pulumi.Input['ClusterStateInfoUpdateInfoArgs']] = None):
        """
        :param pulumi.Input['ClusterStateInfoUpdateInfoArgs'] update_info: A nested object resource
               Structure is documented below.
        """
        if update_info is not None:
            pulumi.set(__self__, "update_info", update_info)

    @property
    @pulumi.getter(name="updateInfo")
    def update_info(self) -> Optional[pulumi.Input['ClusterStateInfoUpdateInfoArgs']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "update_info")

    @update_info.setter
    def update_info(self, value: Optional[pulumi.Input['ClusterStateInfoUpdateInfoArgs']]):
        pulumi.set(self, "update_info", value)


if not MYPY:
    class ClusterStateInfoUpdateInfoArgsDict(TypedDict):
        target_replica_count: NotRequired[pulumi.Input[int]]
        """
        Target number of replica nodes per shard.
        """
        target_shard_count: NotRequired[pulumi.Input[int]]
        """
        Target number of shards for redis cluster.
        """
elif False:
    ClusterStateInfoUpdateInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStateInfoUpdateInfoArgs:
    def __init__(__self__, *,
                 target_replica_count: Optional[pulumi.Input[int]] = None,
                 target_shard_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] target_replica_count: Target number of replica nodes per shard.
        :param pulumi.Input[int] target_shard_count: Target number of shards for redis cluster.
        """
        if target_replica_count is not None:
            pulumi.set(__self__, "target_replica_count", target_replica_count)
        if target_shard_count is not None:
            pulumi.set(__self__, "target_shard_count", target_shard_count)

    @property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of replica nodes per shard.
        """
        return pulumi.get(self, "target_replica_count")

    @target_replica_count.setter
    def target_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_replica_count", value)

    @property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of shards for redis cluster.
        """
        return pulumi.get(self, "target_shard_count")

    @target_shard_count.setter
    def target_shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_shard_count", value)


if not MYPY:
    class ClusterZoneDistributionConfigArgsDict(TypedDict):
        mode: NotRequired[pulumi.Input[str]]
        """
        Immutable. The mode for zone distribution for Memorystore Redis cluster.
        If not provided, MULTI_ZONE will be used as default
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        Immutable. The zone for single zone Memorystore Redis cluster.
        """
elif False:
    ClusterZoneDistributionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterZoneDistributionConfigArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mode: Immutable. The mode for zone distribution for Memorystore Redis cluster.
               If not provided, MULTI_ZONE will be used as default
               Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        :param pulumi.Input[str] zone: Immutable. The zone for single zone Memorystore Redis cluster.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The mode for zone distribution for Memorystore Redis cluster.
        If not provided, MULTI_ZONE will be used as default
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The zone for single zone Memorystore Redis cluster.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class InstanceMaintenancePolicyArgsDict(TypedDict):
        create_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        update_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        weekly_maintenance_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict']]]]
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
elif False:
    InstanceMaintenancePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]]] = None):
        """
        :param pulumi.Input[str] create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param pulumi.Input[str] update_time: (Output)
               Output only. The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if weekly_maintenance_windows is not None:
            pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]]]:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")

    @weekly_maintenance_windows.setter
    def weekly_maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]]]):
        pulumi.set(self, "weekly_maintenance_windows", value)


if not MYPY:
    class InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict(TypedDict):
        day: pulumi.Input[str]
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        start_time: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict']
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        duration: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
elif False:
    InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[str],
                 start_time: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'],
                 duration: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        :param pulumi.Input[str] duration: (Output)
               Output only. Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[str]:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']:
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)


if not MYPY:
    class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[int]]
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        nanos: NotRequired[pulumi.Input[int]]
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
elif False:
    InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class InstanceMaintenanceScheduleArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        schedule_deadline_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
elif False:
    InstanceMaintenanceScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenanceScheduleArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 schedule_deadline_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @schedule_deadline_time.setter
    def schedule_deadline_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_deadline_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class InstanceNodeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Node identifying string. e.g. 'node-0', 'node-1'
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Location of the node.
        """
elif False:
    InstanceNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNodeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: (Output)
               Node identifying string. e.g. 'node-0', 'node-1'
        :param pulumi.Input[str] zone: (Output)
               Location of the node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Node identifying string. e.g. 'node-0', 'node-1'
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Location of the node.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class InstancePersistenceConfigArgsDict(TypedDict):
        persistence_mode: NotRequired[pulumi.Input[str]]
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
        - RDB: RDB based Persistence is enabled.
        Possible values are: `DISABLED`, `RDB`.
        """
        rdb_next_snapshot_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The next time that a snapshot attempt is scheduled to occur.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        rdb_snapshot_period: NotRequired[pulumi.Input[str]]
        """
        Optional. Available snapshot periods for scheduling.
        - ONE_HOUR:	Snapshot every 1 hour.
        - SIX_HOURS:	Snapshot every 6 hours.
        - TWELVE_HOURS:	Snapshot every 12 hours.
        - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
        Possible values are: `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        """
        rdb_snapshot_start_time: NotRequired[pulumi.Input[str]]
        """
        Optional. Date and time that the first snapshot was/will be attempted,
        and to which future snapshots will be aligned. If not provided,
        the current time will be used.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
        and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
elif False:
    InstancePersistenceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePersistenceConfigArgs:
    def __init__(__self__, *,
                 persistence_mode: Optional[pulumi.Input[str]] = None,
                 rdb_next_snapshot_time: Optional[pulumi.Input[str]] = None,
                 rdb_snapshot_period: Optional[pulumi.Input[str]] = None,
                 rdb_snapshot_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] persistence_mode: Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
               - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
               - RDB: RDB based Persistence is enabled.
               Possible values are: `DISABLED`, `RDB`.
        :param pulumi.Input[str] rdb_next_snapshot_time: (Output)
               Output only. The next time that a snapshot attempt is scheduled to occur.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] rdb_snapshot_period: Optional. Available snapshot periods for scheduling.
               - ONE_HOUR:	Snapshot every 1 hour.
               - SIX_HOURS:	Snapshot every 6 hours.
               - TWELVE_HOURS:	Snapshot every 12 hours.
               - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
               Possible values are: `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        :param pulumi.Input[str] rdb_snapshot_start_time: Optional. Date and time that the first snapshot was/will be attempted,
               and to which future snapshots will be aligned. If not provided,
               the current time will be used.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
               and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if persistence_mode is not None:
            pulumi.set(__self__, "persistence_mode", persistence_mode)
        if rdb_next_snapshot_time is not None:
            pulumi.set(__self__, "rdb_next_snapshot_time", rdb_next_snapshot_time)
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
        - RDB: RDB based Persistence is enabled.
        Possible values are: `DISABLED`, `RDB`.
        """
        return pulumi.get(self, "persistence_mode")

    @persistence_mode.setter
    def persistence_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistence_mode", value)

    @property
    @pulumi.getter(name="rdbNextSnapshotTime")
    def rdb_next_snapshot_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The next time that a snapshot attempt is scheduled to occur.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_next_snapshot_time")

    @rdb_next_snapshot_time.setter
    def rdb_next_snapshot_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdb_next_snapshot_time", value)

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Available snapshot periods for scheduling.
        - ONE_HOUR:	Snapshot every 1 hour.
        - SIX_HOURS:	Snapshot every 6 hours.
        - TWELVE_HOURS:	Snapshot every 12 hours.
        - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
        Possible values are: `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @rdb_snapshot_period.setter
    def rdb_snapshot_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdb_snapshot_period", value)

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Date and time that the first snapshot was/will be attempted,
        and to which future snapshots will be aligned. If not provided,
        the current time will be used.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
        and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_snapshot_start_time")

    @rdb_snapshot_start_time.setter
    def rdb_snapshot_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdb_snapshot_start_time", value)


if not MYPY:
    class InstanceServerCaCertArgsDict(TypedDict):
        cert: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The certificate data in PEM format.
        """
        create_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the certificate was created.
        """
        expire_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the certificate expires.
        """
        serial_number: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Serial number, as extracted from the certificate.
        """
        sha1_fingerprint: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Sha1 Fingerprint of the certificate.
        """
elif False:
    InstanceServerCaCertArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceServerCaCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cert: (Output)
               The certificate data in PEM format.
        :param pulumi.Input[str] create_time: (Output)
               The time when the certificate was created.
        :param pulumi.Input[str] expire_time: (Output)
               The time when the certificate expires.
        :param pulumi.Input[str] serial_number: (Output)
               Serial number, as extracted from the certificate.
        :param pulumi.Input[str] sha1_fingerprint: (Output)
               Sha1 Fingerprint of the certificate.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The certificate data in PEM format.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the certificate expires.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Sha1 Fingerprint of the certificate.
        """
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1_fingerprint", value)


