# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 psc_configs: pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]],
                 shard_count: pulumi.Input[int],
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
               "AUTH_MODE_DISABLED"]
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
               operation will fail. Default value is true.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
        :param pulumi.Input[str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[str] node_type: The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
               ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
               documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
               Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
               "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        :param pulumi.Input['ClusterZoneDistributionConfigArgs'] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "shard_count", shard_count)
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @psc_configs.setter
    def psc_configs(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]):
        pulumi.set(self, "psc_configs", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Input[int]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
        "AUTH_MODE_DISABLED"]
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_mode", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
        operation will fail. Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
        ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
        documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "redis_configs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
        Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
        "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 precise_size_gb: Optional[pulumi.Input[float]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]] = None,
                 psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 size_gb: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
               "AUTH_MODE_DISABLED"]
        :param pulumi.Input[str] create_time: The timestamp associated with the cluster creation request. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
               operation will fail. Default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]] discovery_endpoints: Output only. Endpoints created on each given network,
               for Redis clients to connect to the cluster.
               Currently only one endpoint is supported.
               Structure is documented below.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[str] node_type: The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
               ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        :param pulumi.Input[float] precise_size_gb: Output only. Redis memory precise size in GB for the entire cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]] psc_connections: Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
               documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[int] size_gb: Output only. Redis memory size in GB for the entire cluster.
        :param pulumi.Input[str] state: The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]] state_infos: Output only. Additional information about the current state of the cluster.
               Structure is documented below.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
               Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
               "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        :param pulumi.Input[str] uid: System assigned, unique identifier for the cluster.
        :param pulumi.Input['ClusterZoneDistributionConfigArgs'] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if discovery_endpoints is not None:
            pulumi.set(__self__, "discovery_endpoints", discovery_endpoints)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if precise_size_gb is not None:
            pulumi.set(__self__, "precise_size_gb", precise_size_gb)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if psc_connections is not None:
            pulumi.set(__self__, "psc_connections", psc_connections)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_infos is not None:
            pulumi.set(__self__, "state_infos", state_infos)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
        "AUTH_MODE_DISABLED"]
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_mode", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp associated with the cluster creation request. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
        operation will fail. Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]]:
        """
        Output only. Endpoints created on each given network,
        for Redis clients to connect to the cluster.
        Currently only one endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @discovery_endpoints.setter
    def discovery_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]]):
        pulumi.set(self, "discovery_endpoints", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
        ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="preciseSizeGb")
    def precise_size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Output only. Redis memory precise size in GB for the entire cluster.
        """
        return pulumi.get(self, "precise_size_gb")

    @precise_size_gb.setter
    def precise_size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precise_size_gb", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @psc_configs.setter
    def psc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]):
        pulumi.set(self, "psc_configs", value)

    @property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]]:
        """
        Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @psc_connections.setter
    def psc_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]]):
        pulumi.set(self, "psc_connections", value)

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
        documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "redis_configs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Output only. Redis memory size in GB for the entire cluster.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]]:
        """
        Output only. Additional information about the current state of the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @state_infos.setter
    def state_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]]):
        pulumi.set(self, "state_infos", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
        Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
        "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        System assigned, unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Google Cloud Redis Cluster instance.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/cluster/reference/rest/v1/projects.locations.clusters)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/cluster/)

        ## Example Usage

        ### Redis Cluster Ha

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="mysubnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="mypolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        cluster_ha = gcp.redis.Cluster("cluster-ha",
            name="ha-cluster",
            shard_count=3,
            psc_configs=[{
                "network": producer_net.id,
            }],
            region="us-central1",
            replica_count=1,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Ha Single Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="mysubnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="mypolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        cluster_ha_single_zone = gcp.redis.Cluster("cluster-ha-single-zone",
            name="ha-cluster-single-zone",
            shard_count=3,
            psc_configs=[{
                "network": producer_net.id,
            }],
            region="us-central1",
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-f",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
               "AUTH_MODE_DISABLED"]
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
               operation will fail. Default value is true.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
        :param pulumi.Input[str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[str] node_type: The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
               ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
               documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
               Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
               "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        :param pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Redis Cluster instance.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/cluster/reference/rest/v1/projects.locations.clusters)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/cluster/)

        ## Example Usage

        ### Redis Cluster Ha

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="mysubnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="mypolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        cluster_ha = gcp.redis.Cluster("cluster-ha",
            name="ha-cluster",
            shard_count=3,
            psc_configs=[{
                "network": producer_net.id,
            }],
            region="us-central1",
            replica_count=1,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Ha Single Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="mysubnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="mypolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
            })
        cluster_ha_single_zone = gcp.redis.Cluster("cluster-ha-single-zone",
            name="ha-cluster-single-zone",
            shard_count=3,
            psc_configs=[{
                "network": producer_net.id,
            }],
            region="us-central1",
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-f",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["authorization_mode"] = authorization_mode
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["project"] = project
            if psc_configs is None and not opts.urn:
                raise TypeError("Missing required property 'psc_configs'")
            __props__.__dict__["psc_configs"] = psc_configs
            __props__.__dict__["redis_configs"] = redis_configs
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_count"] = replica_count
            if shard_count is None and not opts.urn:
                raise TypeError("Missing required property 'shard_count'")
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["zone_distribution_config"] = zone_distribution_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["discovery_endpoints"] = None
            __props__.__dict__["maintenance_schedules"] = None
            __props__.__dict__["precise_size_gb"] = None
            __props__.__dict__["psc_connections"] = None
            __props__.__dict__["size_gb"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_infos"] = None
            __props__.__dict__["uid"] = None
        super(Cluster, __self__).__init__(
            'gcp:redis/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_mode: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
            discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterDiscoveryEndpointArgs', 'ClusterDiscoveryEndpointArgsDict']]]]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
            maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceScheduleArgs', 'ClusterMaintenanceScheduleArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            precise_size_gb: Optional[pulumi.Input[float]] = None,
            project: Optional[pulumi.Input[str]] = None,
            psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
            psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConnectionArgs', 'ClusterPscConnectionArgsDict']]]]] = None,
            redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replica_count: Optional[pulumi.Input[int]] = None,
            shard_count: Optional[pulumi.Input[int]] = None,
            size_gb: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterStateInfoArgs', 'ClusterStateInfoArgsDict']]]]] = None,
            transit_encryption_mode: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
               "AUTH_MODE_DISABLED"]
        :param pulumi.Input[str] create_time: The timestamp associated with the cluster creation request. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
               operation will fail. Default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterDiscoveryEndpointArgs', 'ClusterDiscoveryEndpointArgsDict']]]] discovery_endpoints: Output only. Endpoints created on each given network,
               for Redis clients to connect to the cluster.
               Currently only one endpoint is supported.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceScheduleArgs', 'ClusterMaintenanceScheduleArgsDict']]]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[str] node_type: The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
               ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        :param pulumi.Input[float] precise_size_gb: Output only. Redis memory precise size in GB for the entire cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConnectionArgs', 'ClusterPscConnectionArgsDict']]]] psc_connections: Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
               documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[int] size_gb: Output only. Redis memory size in GB for the entire cluster.
        :param pulumi.Input[str] state: The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterStateInfoArgs', 'ClusterStateInfoArgsDict']]]] state_infos: Output only. Additional information about the current state of the cluster.
               Structure is documented below.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
               Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
               "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        :param pulumi.Input[str] uid: System assigned, unique identifier for the cluster.
        :param pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["authorization_mode"] = authorization_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["discovery_endpoints"] = discovery_endpoints
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedules"] = maintenance_schedules
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["precise_size_gb"] = precise_size_gb
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_configs"] = psc_configs
        __props__.__dict__["psc_connections"] = psc_connections
        __props__.__dict__["redis_configs"] = redis_configs
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["size_gb"] = size_gb
        __props__.__dict__["state"] = state
        __props__.__dict__["state_infos"] = state_infos
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        __props__.__dict__["uid"] = uid
        __props__.__dict__["zone_distribution_config"] = zone_distribution_config
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH",
        "AUTH_MODE_DISABLED"]
        """
        return pulumi.get(self, "authorization_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp associated with the cluster creation request. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not. If the value if set to true, any delete cluster
        operation will fail. Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterDiscoveryEndpoint']]:
        """
        Output only. Endpoints created on each given network,
        for Redis clients to connect to the cluster.
        Currently only one endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.ClusterMaintenancePolicy']]:
        """
        Maintenance policy for a cluster
        """
        return pulumi.get(self, "maintenance_policy")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> pulumi.Output[Sequence['outputs.ClusterMaintenanceSchedule']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The nodeType for the Redis cluster. If not provided, REDIS_HIGHMEM_MEDIUM will be used as default Possible values:
        ["REDIS_SHARED_CORE_NANO", "REDIS_HIGHMEM_MEDIUM", "REDIS_HIGHMEM_XLARGE", "REDIS_STANDARD_SMALL"]
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="preciseSizeGb")
    def precise_size_gb(self) -> pulumi.Output[float]:
        """
        Output only. Redis memory precise size in GB for the entire cluster.
        """
        return pulumi.get(self, "precise_size_gb")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> pulumi.Output[Sequence['outputs.ClusterPscConfig']]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> pulumi.Output[Sequence['outputs.ClusterPscConnection']]:
        """
        Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters. Please check Memorystore
        documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[Optional[int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[int]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> pulumi.Output[int]:
        """
        Output only. Redis memory size in GB for the entire cluster.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> pulumi.Output[Sequence['outputs.ClusterStateInfo']]:
        """
        Output only. Additional information about the current state of the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. The in-transit encryption for the Redis cluster. If not provided, encryption is disabled for the cluster.
        Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
        "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
        """
        return pulumi.get(self, "transit_encryption_mode")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System assigned, unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> pulumi.Output[Optional['outputs.ClusterZoneDistributionConfig']]:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        """
        return pulumi.get(self, "zone_distribution_config")

