# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegionalSecretVersionResult',
    'AwaitableGetRegionalSecretVersionResult',
    'get_regional_secret_version',
    'get_regional_secret_version_output',
]

@pulumi.output_type
class GetRegionalSecretVersionResult:
    """
    A collection of values returned by getRegionalSecretVersion.
    """
    def __init__(__self__, create_time=None, customer_managed_encryptions=None, destroy_time=None, enabled=None, id=None, location=None, name=None, project=None, secret=None, secret_data=None, version=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if customer_managed_encryptions and not isinstance(customer_managed_encryptions, list):
            raise TypeError("Expected argument 'customer_managed_encryptions' to be a list")
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        if destroy_time and not isinstance(destroy_time, str):
            raise TypeError("Expected argument 'destroy_time' to be a str")
        pulumi.set(__self__, "destroy_time", destroy_time)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if secret_data and not isinstance(secret_data, str):
            raise TypeError("Expected argument 'secret_data' to be a str")
        pulumi.set(__self__, "secret_data", secret_data)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the regional secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetRegionalSecretVersionCustomerManagedEncryptionResult']:
        """
        The customer-managed encryption configuration of the regional secret. Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> str:
        """
        The time at which the regional secret was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if the current state of the regional SecretVersion is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the regional SecretVersion. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secret(self) -> str:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> str:
        """
        The secret data. No larger than 64KiB.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


class AwaitableGetRegionalSecretVersionResult(GetRegionalSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalSecretVersionResult(
            create_time=self.create_time,
            customer_managed_encryptions=self.customer_managed_encryptions,
            destroy_time=self.destroy_time,
            enabled=self.enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project,
            secret=self.secret,
            secret_data=self.secret_data,
            version=self.version)


def get_regional_secret_version(location: Optional[str] = None,
                                project: Optional[str] = None,
                                secret: Optional[str] = None,
                                version: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalSecretVersionResult:
    """
    Get the value and metadata from a Secret Manager regional secret version. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions). If you don't need the metadata (i.e., if you want to use a more limited role to access the regional secret version only), see also the secretmanager_get_regional_secret_version_access datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.secretmanager.get_regional_secret_version(secret="my-secret",
        location="us-central1")
    ```


    :param str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:secretmanager/getRegionalSecretVersion:getRegionalSecretVersion', __args__, opts=opts, typ=GetRegionalSecretVersionResult).value

    return AwaitableGetRegionalSecretVersionResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        customer_managed_encryptions=pulumi.get(__ret__, 'customer_managed_encryptions'),
        destroy_time=pulumi.get(__ret__, 'destroy_time'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        secret=pulumi.get(__ret__, 'secret'),
        secret_data=pulumi.get(__ret__, 'secret_data'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_regional_secret_version)
def get_regional_secret_version_output(location: Optional[pulumi.Input[Optional[str]]] = None,
                                       project: Optional[pulumi.Input[Optional[str]]] = None,
                                       secret: Optional[pulumi.Input[str]] = None,
                                       version: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionalSecretVersionResult]:
    """
    Get the value and metadata from a Secret Manager regional secret version. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions). If you don't need the metadata (i.e., if you want to use a more limited role to access the regional secret version only), see also the secretmanager_get_regional_secret_version_access datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.secretmanager.get_regional_secret_version(secret="my-secret",
        location="us-central1")
    ```


    :param str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    ...
