# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionalSecretVersionAccessResult',
    'AwaitableGetRegionalSecretVersionAccessResult',
    'get_regional_secret_version_access',
    'get_regional_secret_version_access_output',
]

@pulumi.output_type
class GetRegionalSecretVersionAccessResult:
    """
    A collection of values returned by getRegionalSecretVersionAccess.
    """
    def __init__(__self__, id=None, location=None, name=None, project=None, secret=None, secret_data=None, version=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if secret_data and not isinstance(secret_data, str):
            raise TypeError("Expected argument 'secret_data' to be a str")
        pulumi.set(__self__, "secret_data", secret_data)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the regional SecretVersion. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secret(self) -> str:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> str:
        """
        The secret data. No larger than 64KiB.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


class AwaitableGetRegionalSecretVersionAccessResult(GetRegionalSecretVersionAccessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalSecretVersionAccessResult(
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project,
            secret=self.secret,
            secret_data=self.secret_data,
            version=self.version)


def get_regional_secret_version_access(location: Optional[str] = None,
                                       project: Optional[str] = None,
                                       secret: Optional[str] = None,
                                       version: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalSecretVersionAccessResult:
    """
    Get the value from a Secret Manager regional secret version. This is similar to the secretmanager.RegionalSecretVersion datasource, but it only requires the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions/access).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    latest = gcp.secretmanager.get_regional_secret_version_access(secret="my-secret",
        location="us-central1")
    ```


    :param str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:secretmanager/getRegionalSecretVersionAccess:getRegionalSecretVersionAccess', __args__, opts=opts, typ=GetRegionalSecretVersionAccessResult).value

    return AwaitableGetRegionalSecretVersionAccessResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        secret=pulumi.get(__ret__, 'secret'),
        secret_data=pulumi.get(__ret__, 'secret_data'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_regional_secret_version_access)
def get_regional_secret_version_access_output(location: Optional[pulumi.Input[Optional[str]]] = None,
                                              project: Optional[pulumi.Input[Optional[str]]] = None,
                                              secret: Optional[pulumi.Input[str]] = None,
                                              version: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionalSecretVersionAccessResult]:
    """
    Get the value from a Secret Manager regional secret version. This is similar to the secretmanager.RegionalSecretVersion datasource, but it only requires the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions/access).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    latest = gcp.secretmanager.get_regional_secret_version_access(secret="my-secret",
        location="us-central1")
    ```


    :param str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    ...
