# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegionalSecretsResult',
    'AwaitableGetRegionalSecretsResult',
    'get_regional_secrets',
    'get_regional_secrets_output',
]

@pulumi.output_type
class GetRegionalSecretsResult:
    """
    A collection of values returned by getRegionalSecrets.
    """
    def __init__(__self__, filter=None, id=None, location=None, project=None, secrets=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location in which the resource belongs.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetRegionalSecretsSecretResult']:
        """
        A list of regional secrets present in the specified location and matching the filter. Structure is defined below.
        """
        return pulumi.get(self, "secrets")


class AwaitableGetRegionalSecretsResult(GetRegionalSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalSecretsResult(
            filter=self.filter,
            id=self.id,
            location=self.location,
            project=self.project,
            secrets=self.secrets)


def get_regional_secrets(filter: Optional[str] = None,
                         location: Optional[str] = None,
                         project: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalSecretsResult:
    """
    Use this data source to list the Secret Manager Regional Secrets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    secrets = gcp.secretmanager.get_regional_secrets(location="us-central1")
    ```


    :param str filter: Filter string, adhering to the rules in [List-operation filtering](https://cloud.google.com/secret-manager/docs/filtering). List only secrets matching the filter. If filter is empty, all regional secrets are listed from the specified location.
    :param str location: The location of the regional secret.
    :param str project: The ID of the project.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:secretmanager/getRegionalSecrets:getRegionalSecrets', __args__, opts=opts, typ=GetRegionalSecretsResult).value

    return AwaitableGetRegionalSecretsResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'),
        secrets=pulumi.get(__ret__, 'secrets'))


@_utilities.lift_output_func(get_regional_secrets)
def get_regional_secrets_output(filter: Optional[pulumi.Input[Optional[str]]] = None,
                                location: Optional[pulumi.Input[str]] = None,
                                project: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionalSecretsResult]:
    """
    Use this data source to list the Secret Manager Regional Secrets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    secrets = gcp.secretmanager.get_regional_secrets(location="us-central1")
    ```


    :param str filter: Filter string, adhering to the rules in [List-operation filtering](https://cloud.google.com/secret-manager/docs/filtering). List only secrets matching the filter. If filter is empty, all regional secrets are listed from the specified location.
    :param str location: The location of the regional secret.
    :param str project: The ID of the project.
    """
    ...
