# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RegionalSecretCustomerManagedEncryption',
    'RegionalSecretIamBindingCondition',
    'RegionalSecretIamMemberCondition',
    'RegionalSecretRotation',
    'RegionalSecretTopic',
    'RegionalSecretVersionCustomerManagedEncryption',
    'SecretIamBindingCondition',
    'SecretIamMemberCondition',
    'SecretReplication',
    'SecretReplicationAuto',
    'SecretReplicationAutoCustomerManagedEncryption',
    'SecretReplicationUserManaged',
    'SecretReplicationUserManagedReplica',
    'SecretReplicationUserManagedReplicaCustomerManagedEncryption',
    'SecretRotation',
    'SecretTopic',
    'GetRegionalSecretCustomerManagedEncryptionResult',
    'GetRegionalSecretRotationResult',
    'GetRegionalSecretTopicResult',
    'GetRegionalSecretVersionCustomerManagedEncryptionResult',
    'GetRegionalSecretsSecretResult',
    'GetRegionalSecretsSecretCustomerManagedEncryptionResult',
    'GetRegionalSecretsSecretRotationResult',
    'GetRegionalSecretsSecretTopicResult',
    'GetSecretReplicationResult',
    'GetSecretReplicationAutoResult',
    'GetSecretReplicationAutoCustomerManagedEncryptionResult',
    'GetSecretReplicationUserManagedResult',
    'GetSecretReplicationUserManagedReplicaResult',
    'GetSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult',
    'GetSecretRotationResult',
    'GetSecretTopicResult',
    'GetSecretsSecretResult',
    'GetSecretsSecretReplicationResult',
    'GetSecretsSecretReplicationAutoResult',
    'GetSecretsSecretReplicationAutoCustomerManagedEncryptionResult',
    'GetSecretsSecretReplicationUserManagedResult',
    'GetSecretsSecretReplicationUserManagedReplicaResult',
    'GetSecretsSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult',
    'GetSecretsSecretRotationResult',
    'GetSecretsSecretTopicResult',
]

@pulumi.output_type
class RegionalSecretCustomerManagedEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegionalSecretCustomerManagedEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegionalSecretCustomerManagedEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegionalSecretCustomerManagedEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class RegionalSecretIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RegionalSecretIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RegionalSecretRotation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextRotationTime":
            suggest = "next_rotation_time"
        elif key == "rotationPeriod":
            suggest = "rotation_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegionalSecretRotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegionalSecretRotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegionalSecretRotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_rotation_time: Optional[str] = None,
                 rotation_period: Optional[str] = None):
        """
        :param str next_rotation_time: Timestamp in UTC at which the Secret is scheduled to rotate.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str rotation_period: The Duration between rotation notifications. Must be in seconds and at least 3600s (1h)
               and at most 3153600000s (100 years). If rotationPeriod is set, `next_rotation_time` must
               be set. `next_rotation_time` will be advanced by this period when the service
               automatically sends rotation notifications.
        """
        if next_rotation_time is not None:
            pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> Optional[str]:
        """
        Timestamp in UTC at which the Secret is scheduled to rotate.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[str]:
        """
        The Duration between rotation notifications. Must be in seconds and at least 3600s (1h)
        and at most 3153600000s (100 years). If rotationPeriod is set, `next_rotation_time` must
        be set. `next_rotation_time` will be advanced by this period when the service
        automatically sends rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class RegionalSecretTopic(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to, in the following format:
               projects/*/topics/*. For publication to succeed, the Secret Manager Service
               Agent service account must have pubsub.publisher permissions on the topic.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to, in the following format:
        projects/*/topics/*. For publication to succeed, the Secret Manager Service
        Agent service account must have pubsub.publisher permissions on the topic.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RegionalSecretVersionCustomerManagedEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegionalSecretVersionCustomerManagedEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegionalSecretVersionCustomerManagedEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegionalSecretVersionCustomerManagedEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_version_name: Optional[str] = None):
        """
        :param str kms_key_version_name: (Output)
               The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[str]:
        """
        (Output)
        The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        return pulumi.get(self, "kms_key_version_name")


@pulumi.output_type
class SecretIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecretIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecretReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userManaged":
            suggest = "user_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto: Optional['outputs.SecretReplicationAuto'] = None,
                 user_managed: Optional['outputs.SecretReplicationUserManaged'] = None):
        """
        :param 'SecretReplicationAutoArgs' auto: The Secret will automatically be replicated without any restrictions.
               Structure is documented below.
        :param 'SecretReplicationUserManagedArgs' user_managed: The Secret will be replicated to the regions specified by the user.
               Structure is documented below.
        """
        if auto is not None:
            pulumi.set(__self__, "auto", auto)
        if user_managed is not None:
            pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter
    def auto(self) -> Optional['outputs.SecretReplicationAuto']:
        """
        The Secret will automatically be replicated without any restrictions.
        Structure is documented below.
        """
        return pulumi.get(self, "auto")

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> Optional['outputs.SecretReplicationUserManaged']:
        """
        The Secret will be replicated to the regions specified by the user.
        Structure is documented below.
        """
        return pulumi.get(self, "user_managed")


@pulumi.output_type
class SecretReplicationAuto(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedEncryption":
            suggest = "customer_managed_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationAuto. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationAuto.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationAuto.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_encryption: Optional['outputs.SecretReplicationAutoCustomerManagedEncryption'] = None):
        """
        :param 'SecretReplicationAutoCustomerManagedEncryptionArgs' customer_managed_encryption: The customer-managed encryption configuration of the Secret.
               If no configuration is provided, Google-managed default
               encryption is used.
               Structure is documented below.
        """
        if customer_managed_encryption is not None:
            pulumi.set(__self__, "customer_managed_encryption", customer_managed_encryption)

    @property
    @pulumi.getter(name="customerManagedEncryption")
    def customer_managed_encryption(self) -> Optional['outputs.SecretReplicationAutoCustomerManagedEncryption']:
        """
        The customer-managed encryption configuration of the Secret.
        If no configuration is provided, Google-managed default
        encryption is used.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryption")


@pulumi.output_type
class SecretReplicationAutoCustomerManagedEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationAutoCustomerManagedEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationAutoCustomerManagedEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationAutoCustomerManagedEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
               
               - - -
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.

        - - -
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class SecretReplicationUserManaged(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.SecretReplicationUserManagedReplica']):
        """
        :param Sequence['SecretReplicationUserManagedReplicaArgs'] replicas: The list of Replicas for this Secret. Cannot be empty.
               Structure is documented below.
        """
        pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.SecretReplicationUserManagedReplica']:
        """
        The list of Replicas for this Secret. Cannot be empty.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class SecretReplicationUserManagedReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedEncryption":
            suggest = "customer_managed_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationUserManagedReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationUserManagedReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationUserManagedReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 customer_managed_encryption: Optional['outputs.SecretReplicationUserManagedReplicaCustomerManagedEncryption'] = None):
        """
        :param str location: The canonical IDs of the location to replicate data. For example: "us-east1".
        :param 'SecretReplicationUserManagedReplicaCustomerManagedEncryptionArgs' customer_managed_encryption: Customer Managed Encryption for the secret.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if customer_managed_encryption is not None:
            pulumi.set(__self__, "customer_managed_encryption", customer_managed_encryption)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="customerManagedEncryption")
    def customer_managed_encryption(self) -> Optional['outputs.SecretReplicationUserManagedReplicaCustomerManagedEncryption']:
        """
        Customer Managed Encryption for the secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryption")


@pulumi.output_type
class SecretReplicationUserManagedReplicaCustomerManagedEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationUserManagedReplicaCustomerManagedEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationUserManagedReplicaCustomerManagedEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationUserManagedReplicaCustomerManagedEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
               
               - - -
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.

        - - -
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class SecretRotation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextRotationTime":
            suggest = "next_rotation_time"
        elif key == "rotationPeriod":
            suggest = "rotation_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretRotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretRotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretRotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_rotation_time: Optional[str] = None,
                 rotation_period: Optional[str] = None):
        """
        :param str next_rotation_time: Timestamp in UTC at which the Secret is scheduled to rotate.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str rotation_period: The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
               If rotationPeriod is set, `next_rotation_time` must be set. `next_rotation_time` will be advanced by this period when the service automatically sends rotation notifications.
        """
        if next_rotation_time is not None:
            pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> Optional[str]:
        """
        Timestamp in UTC at which the Secret is scheduled to rotate.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[str]:
        """
        The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
        If rotationPeriod is set, `next_rotation_time` must be set. `next_rotation_time` will be advanced by this period when the service automatically sends rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class SecretTopic(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*/topics/*.
               For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*/topics/*.
        For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRegionalSecretCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetRegionalSecretRotationResult(dict):
    def __init__(__self__, *,
                 next_rotation_time: str,
                 rotation_period: str):
        """
        :param str next_rotation_time: Timestamp in UTC at which the Secret is scheduled to rotate.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str rotation_period: The Duration between rotation notifications. Must be in seconds and at least 3600s (1h)
               and at most 3153600000s (100 years). If rotationPeriod is set, 'next_rotation_time' must
               be set. 'next_rotation_time' will be advanced by this period when the service
               automatically sends rotation notifications.
        """
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> str:
        """
        Timestamp in UTC at which the Secret is scheduled to rotate.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> str:
        """
        The Duration between rotation notifications. Must be in seconds and at least 3600s (1h)
        and at most 3153600000s (100 years). If rotationPeriod is set, 'next_rotation_time' must
        be set. 'next_rotation_time' will be advanced by this period when the service
        automatically sends rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class GetRegionalSecretTopicResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to, in the following format:
               projects/*/topics/*. For publication to succeed, the Secret Manager Service
               Agent service account must have pubsub.publisher permissions on the topic.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to, in the following format:
        projects/*/topics/*. For publication to succeed, the Secret Manager Service
        Agent service account must have pubsub.publisher permissions on the topic.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRegionalSecretVersionCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_version_name: str):
        """
        :param str kms_key_version_name: The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> str:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        return pulumi.get(self, "kms_key_version_name")


@pulumi.output_type
class GetRegionalSecretsSecretResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 create_time: str,
                 customer_managed_encryptions: Sequence['outputs.GetRegionalSecretsSecretCustomerManagedEncryptionResult'],
                 effective_annotations: Mapping[str, str],
                 effective_labels: Mapping[str, str],
                 expire_time: str,
                 labels: Mapping[str, str],
                 location: str,
                 name: str,
                 project: str,
                 pulumi_labels: Mapping[str, str],
                 rotations: Sequence['outputs.GetRegionalSecretsSecretRotationResult'],
                 secret_id: str,
                 topics: Sequence['outputs.GetRegionalSecretsSecretTopicResult'],
                 ttl: str,
                 version_aliases: Mapping[str, str],
                 version_destroy_ttl: str):
        """
        :param Mapping[str, str] annotations: Custom metadata about the regional secret.
        :param str create_time: The time at which the regional secret was created.
        :param Sequence['GetRegionalSecretsSecretCustomerManagedEncryptionArgs'] customer_managed_encryptions: Customer Managed Encryption for the regional secret.
               Structure is documented below.
        :param str expire_time: Timestamp in UTC when the regional secret is scheduled to expire.
        :param Mapping[str, str] labels: The labels assigned to this regional secret.
        :param str location: The location of the regional secret.
        :param str name: The resource name of the Pub/Sub topic that will be published to.
        :param str project: The ID of the project.
        :param Mapping[str, str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param Sequence['GetRegionalSecretsSecretRotationArgs'] rotations: The rotation time and period for a regional secret.
               Structure is documented below.
        :param str secret_id: The unique name of the resource.
        :param Sequence['GetRegionalSecretsSecretTopicArgs'] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane operations are called on the regional secret or its versions.
               Structure is documented below.
        :param str ttl: The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s". Only one of 'ttl' or 'expire_time' can be provided.
        :param Mapping[str, str] version_aliases: Mapping from version alias to version name.
        :param str version_destroy_ttl: The version destroy ttl for the regional secret version.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        pulumi.set(__self__, "effective_annotations", effective_annotations)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "rotations", rotations)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "topics", topics)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "version_aliases", version_aliases)
        pulumi.set(__self__, "version_destroy_ttl", version_destroy_ttl)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Custom metadata about the regional secret.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the regional secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetRegionalSecretsSecretCustomerManagedEncryptionResult']:
        """
        Customer Managed Encryption for the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Mapping[str, str]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Timestamp in UTC when the regional secret is scheduled to expire.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels assigned to this regional secret.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the regional secret.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def rotations(self) -> Sequence['outputs.GetRegionalSecretsSecretRotationResult']:
        """
        The rotation time and period for a regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "rotations")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The unique name of the resource.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def topics(self) -> Sequence['outputs.GetRegionalSecretsSecretTopicResult']:
        """
        A list of up to 10 Pub/Sub topics to which messages are published when control plane operations are called on the regional secret or its versions.
        Structure is documented below.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        The TTL for the regional secret. A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s". Only one of 'ttl' or 'expire_time' can be provided.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> Mapping[str, str]:
        """
        Mapping from version alias to version name.
        """
        return pulumi.get(self, "version_aliases")

    @property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> str:
        """
        The version destroy ttl for the regional secret version.
        """
        return pulumi.get(self, "version_destroy_ttl")


@pulumi.output_type
class GetRegionalSecretsSecretCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetRegionalSecretsSecretRotationResult(dict):
    def __init__(__self__, *,
                 next_rotation_time: str,
                 rotation_period: str):
        """
        :param str next_rotation_time: Timestamp in UTC at which the secret is scheduled to rotate.
        :param str rotation_period: The Duration between rotation notifications.
        """
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> str:
        """
        Timestamp in UTC at which the secret is scheduled to rotate.
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> str:
        """
        The Duration between rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class GetRegionalSecretsSecretTopicResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecretReplicationResult(dict):
    def __init__(__self__, *,
                 autos: Sequence['outputs.GetSecretReplicationAutoResult'],
                 user_manageds: Sequence['outputs.GetSecretReplicationUserManagedResult']):
        """
        :param Sequence['GetSecretReplicationAutoArgs'] autos: The Secret will automatically be replicated without any restrictions.
        :param Sequence['GetSecretReplicationUserManagedArgs'] user_manageds: The Secret will be replicated to the regions specified by the user.
        """
        pulumi.set(__self__, "autos", autos)
        pulumi.set(__self__, "user_manageds", user_manageds)

    @property
    @pulumi.getter
    def autos(self) -> Sequence['outputs.GetSecretReplicationAutoResult']:
        """
        The Secret will automatically be replicated without any restrictions.
        """
        return pulumi.get(self, "autos")

    @property
    @pulumi.getter(name="userManageds")
    def user_manageds(self) -> Sequence['outputs.GetSecretReplicationUserManagedResult']:
        """
        The Secret will be replicated to the regions specified by the user.
        """
        return pulumi.get(self, "user_manageds")


@pulumi.output_type
class GetSecretReplicationAutoResult(dict):
    def __init__(__self__, *,
                 customer_managed_encryptions: Sequence['outputs.GetSecretReplicationAutoCustomerManagedEncryptionResult']):
        """
        :param Sequence['GetSecretReplicationAutoCustomerManagedEncryptionArgs'] customer_managed_encryptions: The customer-managed encryption configuration of the Secret.
               If no configuration is provided, Google-managed default
               encryption is used.
        """
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetSecretReplicationAutoCustomerManagedEncryptionResult']:
        """
        The customer-managed encryption configuration of the Secret.
        If no configuration is provided, Google-managed default
        encryption is used.
        """
        return pulumi.get(self, "customer_managed_encryptions")


@pulumi.output_type
class GetSecretReplicationAutoCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetSecretReplicationUserManagedResult(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.GetSecretReplicationUserManagedReplicaResult']):
        """
        :param Sequence['GetSecretReplicationUserManagedReplicaArgs'] replicas: The list of Replicas for this Secret. Cannot be empty.
        """
        pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetSecretReplicationUserManagedReplicaResult']:
        """
        The list of Replicas for this Secret. Cannot be empty.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class GetSecretReplicationUserManagedReplicaResult(dict):
    def __init__(__self__, *,
                 customer_managed_encryptions: Sequence['outputs.GetSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult'],
                 location: str):
        """
        :param Sequence['GetSecretReplicationUserManagedReplicaCustomerManagedEncryptionArgs'] customer_managed_encryptions: Customer Managed Encryption for the secret.
        :param str location: The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult']:
        """
        Customer Managed Encryption for the secret.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GetSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetSecretRotationResult(dict):
    def __init__(__self__, *,
                 next_rotation_time: str,
                 rotation_period: str):
        """
        :param str next_rotation_time: Timestamp in UTC at which the Secret is scheduled to rotate.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str rotation_period: The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
               If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
        """
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> str:
        """
        Timestamp in UTC at which the Secret is scheduled to rotate.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> str:
        """
        The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
        If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class GetSecretTopicResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*/topics/*.
               For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*/topics/*.
        For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 create_time: str,
                 effective_annotations: Mapping[str, str],
                 effective_labels: Mapping[str, str],
                 expire_time: str,
                 labels: Mapping[str, str],
                 name: str,
                 project: str,
                 pulumi_labels: Mapping[str, str],
                 replications: Sequence['outputs.GetSecretsSecretReplicationResult'],
                 rotations: Sequence['outputs.GetSecretsSecretRotationResult'],
                 secret_id: str,
                 topics: Sequence['outputs.GetSecretsSecretTopicResult'],
                 ttl: str,
                 version_aliases: Mapping[str, str],
                 version_destroy_ttl: str):
        """
        :param Mapping[str, str] annotations: Custom metadata about the secret.
        :param str create_time: The time at which the Secret was created.
        :param str expire_time: Timestamp in UTC when the Secret is scheduled to expire.
        :param Mapping[str, str] labels: The labels assigned to this Secret.
        :param str name: The resource name of the Pub/Sub topic that will be published to.
        :param str project: The ID of the project.
        :param Mapping[str, str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param Sequence['GetSecretsSecretReplicationArgs'] replications: The replication policy of the secret data attached to the Secret.
               Structure is documented below.
        :param Sequence['GetSecretsSecretRotationArgs'] rotations: The rotation time and period for a Secret.
               Structure is documented below.
        :param str secret_id: This must be unique within the project.
        :param Sequence['GetSecretsSecretTopicArgs'] topics: A list of up to 10 Pub/Sub topics to which messages are published when control plane operations are called on the secret or its versions.
               Structure is documented below.
        :param str ttl: The TTL for the Secret.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
               Only one of 'ttl' or 'expire_time' can be provided.
        :param Mapping[str, str] version_aliases: Mapping from version alias to version name.
        :param str version_destroy_ttl: Secret Version TTL after destruction request.
               This is a part of the delayed delete feature on Secret Version.
               For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
               on calling destroy instead the version goes to a disabled state and
               the actual destruction happens after this TTL expires.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "effective_annotations", effective_annotations)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "replications", replications)
        pulumi.set(__self__, "rotations", rotations)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "topics", topics)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "version_aliases", version_aliases)
        pulumi.set(__self__, "version_destroy_ttl", version_destroy_ttl)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Custom metadata about the secret.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the Secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Mapping[str, str]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Timestamp in UTC when the Secret is scheduled to expire.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels assigned to this Secret.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def replications(self) -> Sequence['outputs.GetSecretsSecretReplicationResult']:
        """
        The replication policy of the secret data attached to the Secret.
        Structure is documented below.
        """
        return pulumi.get(self, "replications")

    @property
    @pulumi.getter
    def rotations(self) -> Sequence['outputs.GetSecretsSecretRotationResult']:
        """
        The rotation time and period for a Secret.
        Structure is documented below.
        """
        return pulumi.get(self, "rotations")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        This must be unique within the project.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def topics(self) -> Sequence['outputs.GetSecretsSecretTopicResult']:
        """
        A list of up to 10 Pub/Sub topics to which messages are published when control plane operations are called on the secret or its versions.
        Structure is documented below.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        The TTL for the Secret.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        Only one of 'ttl' or 'expire_time' can be provided.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> Mapping[str, str]:
        """
        Mapping from version alias to version name.
        """
        return pulumi.get(self, "version_aliases")

    @property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> str:
        """
        Secret Version TTL after destruction request.
        This is a part of the delayed delete feature on Secret Version.
        For secret with versionDestroyTtl>0, version destruction doesn't happen immediately
        on calling destroy instead the version goes to a disabled state and
        the actual destruction happens after this TTL expires.
        """
        return pulumi.get(self, "version_destroy_ttl")


@pulumi.output_type
class GetSecretsSecretReplicationResult(dict):
    def __init__(__self__, *,
                 autos: Sequence['outputs.GetSecretsSecretReplicationAutoResult'],
                 user_manageds: Sequence['outputs.GetSecretsSecretReplicationUserManagedResult']):
        """
        :param Sequence['GetSecretsSecretReplicationAutoArgs'] autos: The Secret will automatically be replicated without any restrictions.
               Structure is documented below.
        :param Sequence['GetSecretsSecretReplicationUserManagedArgs'] user_manageds: The Secret will be replicated to the regions specified by the user.
               Structure is documented below.
        """
        pulumi.set(__self__, "autos", autos)
        pulumi.set(__self__, "user_manageds", user_manageds)

    @property
    @pulumi.getter
    def autos(self) -> Sequence['outputs.GetSecretsSecretReplicationAutoResult']:
        """
        The Secret will automatically be replicated without any restrictions.
        Structure is documented below.
        """
        return pulumi.get(self, "autos")

    @property
    @pulumi.getter(name="userManageds")
    def user_manageds(self) -> Sequence['outputs.GetSecretsSecretReplicationUserManagedResult']:
        """
        The Secret will be replicated to the regions specified by the user.
        Structure is documented below.
        """
        return pulumi.get(self, "user_manageds")


@pulumi.output_type
class GetSecretsSecretReplicationAutoResult(dict):
    def __init__(__self__, *,
                 customer_managed_encryptions: Sequence['outputs.GetSecretsSecretReplicationAutoCustomerManagedEncryptionResult']):
        """
        :param Sequence['GetSecretsSecretReplicationAutoCustomerManagedEncryptionArgs'] customer_managed_encryptions: Customer Managed Encryption for the secret.
               Structure is documented below.
        """
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetSecretsSecretReplicationAutoCustomerManagedEncryptionResult']:
        """
        Customer Managed Encryption for the secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")


@pulumi.output_type
class GetSecretsSecretReplicationAutoCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetSecretsSecretReplicationUserManagedResult(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.GetSecretsSecretReplicationUserManagedReplicaResult']):
        """
        :param Sequence['GetSecretsSecretReplicationUserManagedReplicaArgs'] replicas: The list of Replicas for this Secret.
               Structure is documented below.
        """
        pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetSecretsSecretReplicationUserManagedReplicaResult']:
        """
        The list of Replicas for this Secret.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class GetSecretsSecretReplicationUserManagedReplicaResult(dict):
    def __init__(__self__, *,
                 customer_managed_encryptions: Sequence['outputs.GetSecretsSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult'],
                 location: str):
        """
        :param Sequence['GetSecretsSecretReplicationUserManagedReplicaCustomerManagedEncryptionArgs'] customer_managed_encryptions: Customer Managed Encryption for the secret.
               Structure is documented below.
        :param str location: The canonical IDs of the location to replicate data.
        """
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetSecretsSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult']:
        """
        Customer Managed Encryption for the secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The canonical IDs of the location to replicate data.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GetSecretsSecretReplicationUserManagedReplicaCustomerManagedEncryptionResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination secret.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetSecretsSecretRotationResult(dict):
    def __init__(__self__, *,
                 next_rotation_time: str,
                 rotation_period: str):
        """
        :param str next_rotation_time: Timestamp in UTC at which the Secret is scheduled to rotate.
        :param str rotation_period: The Duration between rotation notifications.
        """
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        pulumi.set(__self__, "rotation_period", rotation_period)

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> str:
        """
        Timestamp in UTC at which the Secret is scheduled to rotate.
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> str:
        """
        The Duration between rotation notifications.
        """
        return pulumi.get(self, "rotation_period")


@pulumi.output_type
class GetSecretsSecretTopicResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The resource name of the Pub/Sub topic that will be published to.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the Pub/Sub topic that will be published to.
        """
        return pulumi.get(self, "name")


