# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionalSecretVersionArgs', 'RegionalSecretVersion']

@pulumi.input_type
class RegionalSecretVersionArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 secret_data: pulumi.Input[str],
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a RegionalSecretVersion resource.
        :param pulumi.Input[str] secret: Secret Manager regional secret resource.
               
               
               - - -
        :param pulumi.Input[str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] deletion_policy: The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[bool] enabled: The current state of the regional secret version.
        :param pulumi.Input[bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "secret_data", secret_data)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_secret_data_base64 is not None:
            pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret Manager regional secret resource.


        - - -
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Input[str]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The current state of the regional secret version.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @is_secret_data_base64.setter
    def is_secret_data_base64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret_data_base64", value)


@pulumi.input_type
class _RegionalSecretVersionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 customer_managed_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretVersionCustomerManagedEncryptionArgs']]]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 destroy_time: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegionalSecretVersion resources.
        :param pulumi.Input[str] create_time: The time at which the regional secret version was created.
        :param pulumi.Input[Sequence[pulumi.Input['RegionalSecretVersionCustomerManagedEncryptionArgs']]] customer_managed_encryptions: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[str] deletion_policy: The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[str] destroy_time: The time at which the regional secret version was destroyed. Only present if state is DESTROYED.
        :param pulumi.Input[bool] enabled: The current state of the regional secret version.
        :param pulumi.Input[bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[str] location: Location of Secret Manager regional secret resource.
        :param pulumi.Input[str] name: The resource name of the regional secret version. Format:
               `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        :param pulumi.Input[str] secret: Secret Manager regional secret resource.
               
               
               - - -
        :param pulumi.Input[str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] version: The version of the Regional Secret.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if customer_managed_encryptions is not None:
            pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if destroy_time is not None:
            pulumi.set(__self__, "destroy_time", destroy_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_secret_data_base64 is not None:
            pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the regional secret version was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretVersionCustomerManagedEncryptionArgs']]]]:
        """
        The customer-managed encryption configuration of the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @customer_managed_encryptions.setter
    def customer_managed_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionalSecretVersionCustomerManagedEncryptionArgs']]]]):
        pulumi.set(self, "customer_managed_encryptions", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the regional secret version was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @destroy_time.setter
    def destroy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destroy_time", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The current state of the regional secret version.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @is_secret_data_base64.setter
    def is_secret_data_base64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret_data_base64", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of Secret Manager regional secret resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the regional secret version. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret Manager regional secret resource.


        - - -
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Regional Secret.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class RegionalSecretVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[bool]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A regional secret version resource.

        ## Example Usage

        ### Regional Secret Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_basic = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        ```
        ### Regional Secret Version With Base64 Data

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_base64 = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_base64",
            secret=secret_basic.id,
            secret_data=std.filebase64(input="secret-data.pfx").result,
            is_secret_data_base64=True)
        ```
        ### Regional Secret Version Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_disabled = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_disabled",
            secret=secret_basic.id,
            secret_data="secret-data",
            enabled=False)
        ```
        ### Regional Secret Version Deletion Policy Abandon

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_deletion_policy = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_deletion_policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="ABANDON")
        ```
        ### Regional Secret Version Deletion Policy Disable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_deletion_policy = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_deletion_policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="DISABLE")
        ```

        ## Import

        RegionalSecretVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`

        When using the `pulumi import` command, RegionalSecretVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecretVersion:RegionalSecretVersion default projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deletion_policy: The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[bool] enabled: The current state of the regional secret version.
        :param pulumi.Input[bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[str] secret: Secret Manager regional secret resource.
               
               
               - - -
        :param pulumi.Input[str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionalSecretVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A regional secret version resource.

        ## Example Usage

        ### Regional Secret Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_basic = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        ```
        ### Regional Secret Version With Base64 Data

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_base64 = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_base64",
            secret=secret_basic.id,
            secret_data=std.filebase64(input="secret-data.pfx").result,
            is_secret_data_base64=True)
        ```
        ### Regional Secret Version Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_disabled = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_disabled",
            secret=secret_basic.id,
            secret_data="secret-data",
            enabled=False)
        ```
        ### Regional Secret Version Deletion Policy Abandon

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_deletion_policy = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_deletion_policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="ABANDON")
        ```
        ### Regional Secret Version Deletion Policy Disable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.RegionalSecret("secret-basic",
            secret_id="secret-version",
            location="us-central1")
        regional_secret_version_deletion_policy = gcp.secretmanager.RegionalSecretVersion("regional_secret_version_deletion_policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="DISABLE")
        ```

        ## Import

        RegionalSecretVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`

        When using the `pulumi import` command, RegionalSecretVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/regionalSecretVersion:RegionalSecretVersion default projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionalSecretVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionalSecretVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[bool]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionalSecretVersionArgs.__new__(RegionalSecretVersionArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["is_secret_data_base64"] = is_secret_data_base64
            if secret is None and not opts.urn:
                raise TypeError("Missing required property 'secret'")
            __props__.__dict__["secret"] = secret
            if secret_data is None and not opts.urn:
                raise TypeError("Missing required property 'secret_data'")
            __props__.__dict__["secret_data"] = None if secret_data is None else pulumi.Output.secret(secret_data)
            __props__.__dict__["create_time"] = None
            __props__.__dict__["customer_managed_encryptions"] = None
            __props__.__dict__["destroy_time"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionalSecretVersion, __self__).__init__(
            'gcp:secretmanager/regionalSecretVersion:RegionalSecretVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            customer_managed_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretVersionCustomerManagedEncryptionArgs', 'RegionalSecretVersionCustomerManagedEncryptionArgsDict']]]]] = None,
            deletion_policy: Optional[pulumi.Input[str]] = None,
            destroy_time: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            is_secret_data_base64: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            secret_data: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'RegionalSecretVersion':
        """
        Get an existing RegionalSecretVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time at which the regional secret version was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionalSecretVersionCustomerManagedEncryptionArgs', 'RegionalSecretVersionCustomerManagedEncryptionArgsDict']]]] customer_managed_encryptions: The customer-managed encryption configuration of the regional secret.
               Structure is documented below.
        :param pulumi.Input[str] deletion_policy: The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[str] destroy_time: The time at which the regional secret version was destroyed. Only present if state is DESTROYED.
        :param pulumi.Input[bool] enabled: The current state of the regional secret version.
        :param pulumi.Input[bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[str] location: Location of Secret Manager regional secret resource.
        :param pulumi.Input[str] name: The resource name of the regional secret version. Format:
               `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        :param pulumi.Input[str] secret: Secret Manager regional secret resource.
               
               
               - - -
        :param pulumi.Input[str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] version: The version of the Regional Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionalSecretVersionState.__new__(_RegionalSecretVersionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["customer_managed_encryptions"] = customer_managed_encryptions
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["destroy_time"] = destroy_time
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["is_secret_data_base64"] = is_secret_data_base64
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["secret"] = secret
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["version"] = version
        return RegionalSecretVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which the regional secret version was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> pulumi.Output[Sequence['outputs.RegionalSecretVersionCustomerManagedEncryption']]:
        """
        The customer-managed encryption configuration of the regional secret.
        Structure is documented below.
        """
        return pulumi.get(self, "customer_managed_encryptions")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The deletion policy for the regional secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> pulumi.Output[str]:
        """
        The time at which the regional secret version was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The current state of the regional secret version.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of Secret Manager regional secret resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the regional secret version. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        Secret Manager regional secret resource.


        - - -
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[str]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the Regional Secret.
        """
        return pulumi.get(self, "version")

