# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['V2FolderMuteConfigArgs', 'V2FolderMuteConfig']

@pulumi.input_type
class V2FolderMuteConfigArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 folder: pulumi.Input[str],
                 mute_config_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a V2FolderMuteConfig resource.
        :param pulumi.Input[str] filter: An expression that defines the filter to apply across create/update
               events of findings. While creating a filter string, be mindful of
               the scope in which the mute configuration is being created. E.g.,
               If a filter contains project = X but is created under the
               project = Y scope, it might not match any findings.
        :param pulumi.Input[str] folder: The folder whose Cloud Security Command Center the Mute
               Config lives in.
        :param pulumi.Input[str] mute_config_id: Unique identifier provided by the client within the parent scope.
               
               
               - - -
        :param pulumi.Input[str] type: The type of the mute config.
        :param pulumi.Input[str] description: A description of the mute config.
        :param pulumi.Input[str] location: location Id is provided by folder. If not provided, Use global as default.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "folder", folder)
        pulumi.set(__self__, "mute_config_id", mute_config_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        An expression that defines the filter to apply across create/update
        events of findings. While creating a filter string, be mindful of
        the scope in which the mute configuration is being created. E.g.,
        If a filter contains project = X but is created under the
        project = Y scope, it might not match any findings.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Input[str]:
        """
        The folder whose Cloud Security Command Center the Mute
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[str]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="muteConfigId")
    def mute_config_id(self) -> pulumi.Input[str]:
        """
        Unique identifier provided by the client within the parent scope.


        - - -
        """
        return pulumi.get(self, "mute_config_id")

    @mute_config_id.setter
    def mute_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "mute_config_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the mute config.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the mute config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        location Id is provided by folder. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _V2FolderMuteConfigState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 most_recent_editor: Optional[pulumi.Input[str]] = None,
                 mute_config_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering V2FolderMuteConfig resources.
        :param pulumi.Input[str] create_time: The time at which the mute config was created. This field is set by
               the server and will be ignored if provided on config creation.
        :param pulumi.Input[str] description: A description of the mute config.
        :param pulumi.Input[str] filter: An expression that defines the filter to apply across create/update
               events of findings. While creating a filter string, be mindful of
               the scope in which the mute configuration is being created. E.g.,
               If a filter contains project = X but is created under the
               project = Y scope, it might not match any findings.
        :param pulumi.Input[str] folder: The folder whose Cloud Security Command Center the Mute
               Config lives in.
        :param pulumi.Input[str] location: location Id is provided by folder. If not provided, Use global as default.
        :param pulumi.Input[str] most_recent_editor: Email address of the user who last edited the mute config. This
               field is set by the server and will be ignored if provided on
               config creation or update.
        :param pulumi.Input[str] mute_config_id: Unique identifier provided by the client within the parent scope.
               
               
               - - -
        :param pulumi.Input[str] name: Name of the mute config. Its format is
               organizations/{organization}/locations/global/muteConfigs/{configId},
               folders/{folder}/locations/global/muteConfigs/{configId},
               or projects/{project}/locations/global/muteConfigs/{configId}
        :param pulumi.Input[str] type: The type of the mute config.
        :param pulumi.Input[str] update_time: Output only. The most recent time at which the mute config was
               updated. This field is set by the server and will be ignored if
               provided on config creation or update.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if most_recent_editor is not None:
            pulumi.set(__self__, "most_recent_editor", most_recent_editor)
        if mute_config_id is not None:
            pulumi.set(__self__, "mute_config_id", mute_config_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the mute config was created. This field is set by
        the server and will be ignored if provided on config creation.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the mute config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        An expression that defines the filter to apply across create/update
        events of findings. While creating a filter string, be mindful of
        the scope in which the mute configuration is being created. E.g.,
        If a filter contains project = X but is created under the
        project = Y scope, it might not match any findings.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The folder whose Cloud Security Command Center the Mute
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        location Id is provided by folder. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the user who last edited the mute config. This
        field is set by the server and will be ignored if provided on
        config creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @most_recent_editor.setter
    def most_recent_editor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "most_recent_editor", value)

    @property
    @pulumi.getter(name="muteConfigId")
    def mute_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier provided by the client within the parent scope.


        - - -
        """
        return pulumi.get(self, "mute_config_id")

    @mute_config_id.setter
    def mute_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mute_config_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the mute config. Its format is
        organizations/{organization}/locations/global/muteConfigs/{configId},
        folders/{folder}/locations/global/muteConfigs/{configId},
        or projects/{project}/locations/global/muteConfigs/{configId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the mute config.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The most recent time at which the mute config was
        updated. This field is set by the server and will be ignored if
        provided on config creation or update.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class V2FolderMuteConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mute_config_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Mute Findings is a volume management feature in Security Command Center
        that lets you manually or programmatically hide irrelevant findings,
        and create filters to automatically silence existing and future
        findings based on criteria you specify.

        To get more information about FolderMuteConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/folders.muteConfigs)

        ## Example Usage

        ### Scc V2 Folder Mute Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name")
        default = gcp.securitycenter.V2FolderMuteConfig("default",
            mute_config_id="my-config",
            folder=folder.folder_id,
            location="global",
            description="My custom Cloud Security Command Center Finding Folder mute Configuration",
            filter="severity = \\"HIGH\\"",
            type="STATIC")
        ```

        ## Import

        FolderMuteConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/locations/{{location}}/muteConfigs/{{mute_config_id}}`

        * `{{folder}}/{{location}}/{{mute_config_id}}`

        When using the `pulumi import` command, FolderMuteConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderMuteConfig:V2FolderMuteConfig default folders/{{folder}}/locations/{{location}}/muteConfigs/{{mute_config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderMuteConfig:V2FolderMuteConfig default {{folder}}/{{location}}/{{mute_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the mute config.
        :param pulumi.Input[str] filter: An expression that defines the filter to apply across create/update
               events of findings. While creating a filter string, be mindful of
               the scope in which the mute configuration is being created. E.g.,
               If a filter contains project = X but is created under the
               project = Y scope, it might not match any findings.
        :param pulumi.Input[str] folder: The folder whose Cloud Security Command Center the Mute
               Config lives in.
        :param pulumi.Input[str] location: location Id is provided by folder. If not provided, Use global as default.
        :param pulumi.Input[str] mute_config_id: Unique identifier provided by the client within the parent scope.
               
               
               - - -
        :param pulumi.Input[str] type: The type of the mute config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2FolderMuteConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Mute Findings is a volume management feature in Security Command Center
        that lets you manually or programmatically hide irrelevant findings,
        and create filters to automatically silence existing and future
        findings based on criteria you specify.

        To get more information about FolderMuteConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v2/folders.muteConfigs)

        ## Example Usage

        ### Scc V2 Folder Mute Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name")
        default = gcp.securitycenter.V2FolderMuteConfig("default",
            mute_config_id="my-config",
            folder=folder.folder_id,
            location="global",
            description="My custom Cloud Security Command Center Finding Folder mute Configuration",
            filter="severity = \\"HIGH\\"",
            type="STATIC")
        ```

        ## Import

        FolderMuteConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/locations/{{location}}/muteConfigs/{{mute_config_id}}`

        * `{{folder}}/{{location}}/{{mute_config_id}}`

        When using the `pulumi import` command, FolderMuteConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderMuteConfig:V2FolderMuteConfig default folders/{{folder}}/locations/{{location}}/muteConfigs/{{mute_config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/v2FolderMuteConfig:V2FolderMuteConfig default {{folder}}/{{location}}/{{mute_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param V2FolderMuteConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2FolderMuteConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mute_config_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2FolderMuteConfigArgs.__new__(V2FolderMuteConfigArgs)

            __props__.__dict__["description"] = description
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            __props__.__dict__["location"] = location
            if mute_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'mute_config_id'")
            __props__.__dict__["mute_config_id"] = mute_config_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["most_recent_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(V2FolderMuteConfig, __self__).__init__(
            'gcp:securitycenter/v2FolderMuteConfig:V2FolderMuteConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            filter: Optional[pulumi.Input[str]] = None,
            folder: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            most_recent_editor: Optional[pulumi.Input[str]] = None,
            mute_config_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'V2FolderMuteConfig':
        """
        Get an existing V2FolderMuteConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time at which the mute config was created. This field is set by
               the server and will be ignored if provided on config creation.
        :param pulumi.Input[str] description: A description of the mute config.
        :param pulumi.Input[str] filter: An expression that defines the filter to apply across create/update
               events of findings. While creating a filter string, be mindful of
               the scope in which the mute configuration is being created. E.g.,
               If a filter contains project = X but is created under the
               project = Y scope, it might not match any findings.
        :param pulumi.Input[str] folder: The folder whose Cloud Security Command Center the Mute
               Config lives in.
        :param pulumi.Input[str] location: location Id is provided by folder. If not provided, Use global as default.
        :param pulumi.Input[str] most_recent_editor: Email address of the user who last edited the mute config. This
               field is set by the server and will be ignored if provided on
               config creation or update.
        :param pulumi.Input[str] mute_config_id: Unique identifier provided by the client within the parent scope.
               
               
               - - -
        :param pulumi.Input[str] name: Name of the mute config. Its format is
               organizations/{organization}/locations/global/muteConfigs/{configId},
               folders/{folder}/locations/global/muteConfigs/{configId},
               or projects/{project}/locations/global/muteConfigs/{configId}
        :param pulumi.Input[str] type: The type of the mute config.
        :param pulumi.Input[str] update_time: Output only. The most recent time at which the mute config was
               updated. This field is set by the server and will be ignored if
               provided on config creation or update.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2FolderMuteConfigState.__new__(_V2FolderMuteConfigState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["folder"] = folder
        __props__.__dict__["location"] = location
        __props__.__dict__["most_recent_editor"] = most_recent_editor
        __props__.__dict__["mute_config_id"] = mute_config_id
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return V2FolderMuteConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which the mute config was created. This field is set by
        the server and will be ignored if provided on config creation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the mute config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[str]:
        """
        An expression that defines the filter to apply across create/update
        events of findings. While creating a filter string, be mindful of
        the scope in which the mute configuration is being created. E.g.,
        If a filter contains project = X but is created under the
        project = Y scope, it might not match any findings.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[str]:
        """
        The folder whose Cloud Security Command Center the Mute
        Config lives in.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        location Id is provided by folder. If not provided, Use global as default.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> pulumi.Output[str]:
        """
        Email address of the user who last edited the mute config. This
        field is set by the server and will be ignored if provided on
        config creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @property
    @pulumi.getter(name="muteConfigId")
    def mute_config_id(self) -> pulumi.Output[str]:
        """
        Unique identifier provided by the client within the parent scope.


        - - -
        """
        return pulumi.get(self, "mute_config_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the mute config. Its format is
        organizations/{organization}/locations/global/muteConfigs/{configId},
        folders/{folder}/locations/global/muteConfigs/{configId},
        or projects/{project}/locations/global/muteConfigs/{configId}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the mute config.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The most recent time at which the mute config was
        updated. This field is set by the server and will be ignored if
        provided on config creation or update.
        """
        return pulumi.get(self, "update_time")

