# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetV2RuntimeVersionsResult',
    'AwaitableGetV2RuntimeVersionsResult',
    'get_v2_runtime_versions',
    'get_v2_runtime_versions_output',
]

@pulumi.output_type
class GetV2RuntimeVersionsResult:
    """
    A collection of values returned by getV2RuntimeVersions.
    """
    def __init__(__self__, id=None, project=None, versions=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[str]:
        """
        The list of runtime versions available for the given project and zone.
        """
        return pulumi.get(self, "versions")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetV2RuntimeVersionsResult(GetV2RuntimeVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetV2RuntimeVersionsResult(
            id=self.id,
            project=self.project,
            versions=self.versions,
            zone=self.zone)


def get_v2_runtime_versions(project: Optional[str] = None,
                            zone: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetV2RuntimeVersionsResult:
    """
    Get runtime versions available for a project. For more information see the [official documentation](https://cloud.google.com/tpu/docs/) and [API](https://cloud.google.com/tpu/docs/reference/rest/v2/projects.locations.runtimeVersions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_runtime_versions()
    ```

    ### Configure Basic TPU VM With Available Version

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_runtime_versions()
    tpu = gcp.tpu.V2Vm("tpu",
        name="test-tpu",
        zone="us-central1-b",
        runtime_version=available.versions[0])
    ```


    :param str project: The project to list versions for. If it
           is not provided, the provider project is used.
    :param str zone: The zone to list versions for. If it
           is not provided, the provider zone is used.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:tpu/getV2RuntimeVersions:getV2RuntimeVersions', __args__, opts=opts, typ=GetV2RuntimeVersionsResult).value

    return AwaitableGetV2RuntimeVersionsResult(
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        versions=pulumi.get(__ret__, 'versions'),
        zone=pulumi.get(__ret__, 'zone'))


@_utilities.lift_output_func(get_v2_runtime_versions)
def get_v2_runtime_versions_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                                   zone: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetV2RuntimeVersionsResult]:
    """
    Get runtime versions available for a project. For more information see the [official documentation](https://cloud.google.com/tpu/docs/) and [API](https://cloud.google.com/tpu/docs/reference/rest/v2/projects.locations.runtimeVersions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_runtime_versions()
    ```

    ### Configure Basic TPU VM With Available Version

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_runtime_versions()
    tpu = gcp.tpu.V2Vm("tpu",
        name="test-tpu",
        zone="us-central1-b",
        runtime_version=available.versions[0])
    ```


    :param str project: The project to list versions for. If it
           is not provided, the provider project is used.
    :param str zone: The zone to list versions for. If it
           is not provided, the provider zone is used.
    """
    ...
