# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'NodeNetworkEndpoint',
    'NodeSchedulingConfig',
    'V2VmAcceleratorConfig',
    'V2VmDataDisk',
    'V2VmNetworkConfig',
    'V2VmNetworkEndpoint',
    'V2VmNetworkEndpointAccessConfig',
    'V2VmSchedulingConfig',
    'V2VmServiceAccount',
    'V2VmShieldedInstanceConfig',
    'V2VmSymptom',
]

@pulumi.output_type
class NodeNetworkEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeNetworkEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeNetworkEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeNetworkEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str ip_address: (Output)
               The IP address of this network endpoint.
        :param int port: (Output)
               The port of this network endpoint.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        (Output)
        The IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class NodeSchedulingConfig(dict):
    def __init__(__self__, *,
                 preemptible: bool):
        """
        :param bool preemptible: Defines whether the TPU instance is preemptible.
        """
        pulumi.set(__self__, "preemptible", preemptible)

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        """
        Defines whether the TPU instance is preemptible.
        """
        return pulumi.get(self, "preemptible")


@pulumi.output_type
class V2VmAcceleratorConfig(dict):
    def __init__(__self__, *,
                 topology: str,
                 type: str):
        """
        :param str topology: Topology of TPU in chips.
        :param str type: Type of TPU.
               Possible values are: `V2`, `V3`, `V4`, `V5P`.
        """
        pulumi.set(__self__, "topology", topology)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def topology(self) -> str:
        """
        Topology of TPU in chips.
        """
        return pulumi.get(self, "topology")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of TPU.
        Possible values are: `V2`, `V3`, `V4`, `V5P`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class V2VmDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDisk":
            suggest = "source_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_disk: str,
                 mode: Optional[str] = None):
        """
        :param str source_disk: Specifies the full path to an existing disk. For example:
               "projects/my-project/zones/us-central1-c/disks/my-disk".
        :param str mode: The mode in which to attach this disk. If not specified, the default is READ_WRITE
               mode. Only applicable to dataDisks.
               Default value is `READ_WRITE`.
               Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        pulumi.set(__self__, "source_disk", source_disk)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> str:
        """
        Specifies the full path to an existing disk. For example:
        "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The mode in which to attach this disk. If not specified, the default is READ_WRITE
        mode. Only applicable to dataDisks.
        Default value is `READ_WRITE`.
        Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class V2VmNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canIpForward":
            suggest = "can_ip_forward"
        elif key == "enableExternalIps":
            suggest = "enable_external_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_ip_forward: Optional[bool] = None,
                 enable_external_ips: Optional[bool] = None,
                 network: Optional[str] = None,
                 subnetwork: Optional[str] = None):
        """
        :param bool can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source
               IPs. This is required if you plan to use the TPU workers to forward routes.
        :param bool enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to
               false, the specified subnetwork or network should have Private Google Access enabled.
        :param str network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine
               network. If both network and subnetwork are specified, the given subnetwork must belong
               to the given network. If network is not specified, it will be looked up from the
               subnetwork if one is provided, or otherwise use "default".
        :param str subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
               Engine subnetwork. If both network and subnetwork are specified, the given subnetwork
               must belong to the given network. If subnetwork is not specified, the subnetwork with the
               same name as the network will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[bool]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[bool]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If both network and subnetwork are specified, the given subnetwork must belong
        to the given network. If network is not specified, it will be looked up from the
        subnetwork if one is provided, or otherwise use "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If both network and subnetwork are specified, the given subnetwork
        must belong to the given network. If subnetwork is not specified, the subnetwork with the
        same name as the network will be used.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class V2VmNetworkEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_configs: Optional[Sequence['outputs.V2VmNetworkEndpointAccessConfig']] = None,
                 ip_address: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param Sequence['V2VmNetworkEndpointAccessConfigArgs'] access_configs: (Output)
               The access config for the TPU worker.
               Structure is documented below.
        :param str ip_address: (Output)
               The internal IP address of this network endpoint.
        :param int port: (Output)
               The port of this network endpoint.
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[Sequence['outputs.V2VmNetworkEndpointAccessConfig']]:
        """
        (Output)
        The access config for the TPU worker.
        Structure is documented below.
        """
        return pulumi.get(self, "access_configs")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        (Output)
        The internal IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class V2VmNetworkEndpointAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIp":
            suggest = "external_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkEndpointAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkEndpointAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkEndpointAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_ip: Optional[str] = None):
        """
        :param str external_ip: (Output)
               An external IP address associated with the TPU worker.
        """
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[str]:
        """
        (Output)
        An external IP address associated with the TPU worker.
        """
        return pulumi.get(self, "external_ip")


@pulumi.output_type
class V2VmSchedulingConfig(dict):
    def __init__(__self__, *,
                 preemptible: Optional[bool] = None,
                 reserved: Optional[bool] = None):
        """
        :param bool preemptible: Defines whether the node is preemptible.
        :param bool reserved: Whether the node is created under a reservation.
        """
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[bool]:
        """
        Defines whether the node is preemptible.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter
    def reserved(self) -> Optional[bool]:
        """
        Whether the node is created under a reservation.
        """
        return pulumi.get(self, "reserved")


@pulumi.output_type
class V2VmServiceAccount(dict):
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 scopes: Optional[Sequence[str]] = None):
        """
        :param str email: Email address of the service account. If empty, default Compute service account will be used.
        :param Sequence[str] scopes: The list of scopes to be made available for this service account. If empty, access to all
               Cloud APIs will be allowed.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email address of the service account. If empty, default Compute service account will be used.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        The list of scopes to be made available for this service account. If empty, access to all
        Cloud APIs will be allowed.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class V2VmShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableSecureBoot":
            suggest = "enable_secure_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_secure_boot: bool):
        """
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        """
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class V2VmSymptom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "symptomType":
            suggest = "symptom_type"
        elif key == "workerId":
            suggest = "worker_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmSymptom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmSymptom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmSymptom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[str] = None,
                 details: Optional[str] = None,
                 symptom_type: Optional[str] = None,
                 worker_id: Optional[str] = None):
        """
        :param str create_time: (Output)
               Timestamp when the Symptom is created.
        :param str details: (Output)
               Detailed information of the current Symptom.
        :param str symptom_type: (Output)
               Type of the Symptom.
        :param str worker_id: (Output)
               A string used to uniquely distinguish a worker within a TPU node.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if symptom_type is not None:
            pulumi.set(__self__, "symptom_type", symptom_type)
        if worker_id is not None:
            pulumi.set(__self__, "worker_id", worker_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        (Output)
        Timestamp when the Symptom is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        """
        (Output)
        Detailed information of the current Symptom.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="symptomType")
    def symptom_type(self) -> Optional[str]:
        """
        (Output)
        Type of the Symptom.
        """
        return pulumi.get(self, "symptom_type")

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[str]:
        """
        (Output)
        A string used to uniquely distinguish a worker within a TPU node.
        """
        return pulumi.get(self, "worker_id")


