# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalAccessRuleArgs', 'ExternalAccessRule']

@pulumi.input_type
class ExternalAccessRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 destination_ip_ranges: pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]],
                 destination_ports: pulumi.Input[Sequence[pulumi.Input[str]]],
                 ip_protocol: pulumi.Input[str],
                 parent: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 source_ip_ranges: pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]],
                 source_ports: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExternalAccessRule resource.
        :param pulumi.Input[str] action: The action that the external access rule performs.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]] destination_ip_ranges: If destination ranges are specified, the external access rule applies only to
               traffic that has a destination IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: A list of destination ports to which the external access rule applies.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which the external access rule applies.
        :param pulumi.Input[str] parent: The resource name of the network policy.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        :param pulumi.Input[int] priority: External access rule priority, which determines the external access rule to use when multiple rules apply.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]] source_ip_ranges: If source ranges are specified, the external access rule applies only to
               traffic that has a source IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ports: A list of source ports to which the external access rule applies.
        :param pulumi.Input[str] description: User-provided description for the external access rule.
        :param pulumi.Input[str] name: The ID of the external access rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination_ip_ranges", destination_ip_ranges)
        pulumi.set(__self__, "destination_ports", destination_ports)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        pulumi.set(__self__, "source_ports", source_ports)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action that the external access rule performs.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="destinationIpRanges")
    def destination_ip_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]]:
        """
        If destination ranges are specified, the external access rule applies only to
        traffic that has a destination IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_ip_ranges")

    @destination_ip_ranges.setter
    def destination_ip_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]]):
        pulumi.set(self, "destination_ip_ranges", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of destination ports to which the external access rule applies.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[str]:
        """
        The IP protocol to which the external access rule applies.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        The resource name of the network policy.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        External access rule priority, which determines the external access rule to use when multiple rules apply.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]]:
        """
        If source ranges are specified, the external access rule applies only to
        traffic that has a source IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]]):
        pulumi.set(self, "source_ip_ranges", value)

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of source ports to which the external access rule applies.
        """
        return pulumi.get(self, "source_ports")

    @source_ports.setter
    def source_ports(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "source_ports", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description for the external access rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the external access rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExternalAccessRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]]] = None,
                 source_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalAccessRule resources.
        :param pulumi.Input[str] action: The action that the external access rule performs.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: User-provided description for the external access rule.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]] destination_ip_ranges: If destination ranges are specified, the external access rule applies only to
               traffic that has a destination IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: A list of destination ports to which the external access rule applies.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which the external access rule applies.
        :param pulumi.Input[str] name: The ID of the external access rule.
        :param pulumi.Input[str] parent: The resource name of the network policy.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        :param pulumi.Input[int] priority: External access rule priority, which determines the external access rule to use when multiple rules apply.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]] source_ip_ranges: If source ranges are specified, the external access rule applies only to
               traffic that has a source IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ports: A list of source ports to which the external access rule applies.
        :param pulumi.Input[str] state: State of the Cluster.
        :param pulumi.Input[str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_ranges is not None:
            pulumi.set(__self__, "destination_ip_ranges", destination_ip_ranges)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if source_ports is not None:
            pulumi.set(__self__, "source_ports", source_ports)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The action that the external access rule performs.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description for the external access rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationIpRanges")
    def destination_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]]]:
        """
        If destination ranges are specified, the external access rule applies only to
        traffic that has a destination IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_ip_ranges")

    @destination_ip_ranges.setter
    def destination_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleDestinationIpRangeArgs']]]]):
        pulumi.set(self, "destination_ip_ranges", value)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of destination ports to which the external access rule applies.
        """
        return pulumi.get(self, "destination_ports")

    @destination_ports.setter
    def destination_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_ports", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which the external access rule applies.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the external access rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the network policy.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        External access rule priority, which determines the external access rule to use when multiple rules apply.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]]]:
        """
        If source ranges are specified, the external access rule applies only to
        traffic that has a source IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAccessRuleSourceIpRangeArgs']]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of source ports to which the external access rule applies.
        """
        return pulumi.get(self, "source_ports")

    @source_ports.setter
    def source_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ports", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the Cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class ExternalAccessRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleDestinationIpRangeArgs', 'ExternalAccessRuleDestinationIpRangeArgsDict']]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleSourceIpRangeArgs', 'ExternalAccessRuleSourceIpRangeArgsDict']]]]] = None,
                 source_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        External access firewall rules for filtering incoming traffic destined to `ExternalAddress` resources.

        To get more information about ExternalAccessRule, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies.externalAccessRules)

        ## Example Usage

        ### Vmware Engine External Access Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_access_rule_nw = gcp.vmwareengine.Network("external-access-rule-nw",
            name="sample-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        external_access_rule_np = gcp.vmwareengine.NetworkPolicy("external-access-rule-np",
            location="us-west1",
            name="sample-np",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=external_access_rule_nw.id)
        vmw_engine_external_access_rule = gcp.vmwareengine.ExternalAccessRule("vmw-engine-external-access-rule",
            name="sample-external-access-rule",
            parent=external_access_rule_np.id,
            priority=101,
            action="DENY",
            ip_protocol="TCP",
            source_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            source_ports=["80"],
            destination_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            destination_ports=["433"])
        ```
        ### Vmware Engine External Access Rule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_access_rule_nw = gcp.vmwareengine.Network("external-access-rule-nw",
            name="sample-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        external_access_rule_pc = gcp.vmwareengine.PrivateCloud("external-access-rule-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            network_config={
                "management_cidr": "192.168.50.0/24",
                "vmware_engine_network": external_access_rule_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 3,
                }],
            })
        external_access_rule_np = gcp.vmwareengine.NetworkPolicy("external-access-rule-np",
            location="us-west1",
            name="sample-np",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=external_access_rule_nw.id)
        external_access_rule_ea = gcp.vmwareengine.ExternalAddress("external-access-rule-ea",
            name="sample-ea",
            parent=external_access_rule_pc.id,
            internal_ip="192.168.0.65")
        vmw_engine_external_access_rule = gcp.vmwareengine.ExternalAccessRule("vmw-engine-external-access-rule",
            name="sample-external-access-rule",
            parent=external_access_rule_np.id,
            description="Sample Description",
            priority=101,
            action="ALLOW",
            ip_protocol="tcp",
            source_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            source_ports=["80"],
            destination_ip_ranges=[{
                "external_address": external_access_rule_ea.id,
            }],
            destination_ports=["433"])
        ```

        ## Import

        ExternalAccessRule can be imported using any of these accepted formats:

        * `{{parent}}/externalAccessRules/{{name}}`

        When using the `pulumi import` command, ExternalAccessRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/externalAccessRule:ExternalAccessRule default {{parent}}/externalAccessRules/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action that the external access rule performs.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[str] description: User-provided description for the external access rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleDestinationIpRangeArgs', 'ExternalAccessRuleDestinationIpRangeArgsDict']]]] destination_ip_ranges: If destination ranges are specified, the external access rule applies only to
               traffic that has a destination IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: A list of destination ports to which the external access rule applies.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which the external access rule applies.
        :param pulumi.Input[str] name: The ID of the external access rule.
        :param pulumi.Input[str] parent: The resource name of the network policy.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        :param pulumi.Input[int] priority: External access rule priority, which determines the external access rule to use when multiple rules apply.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleSourceIpRangeArgs', 'ExternalAccessRuleSourceIpRangeArgsDict']]]] source_ip_ranges: If source ranges are specified, the external access rule applies only to
               traffic that has a source IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ports: A list of source ports to which the external access rule applies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalAccessRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        External access firewall rules for filtering incoming traffic destined to `ExternalAddress` resources.

        To get more information about ExternalAccessRule, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies.externalAccessRules)

        ## Example Usage

        ### Vmware Engine External Access Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_access_rule_nw = gcp.vmwareengine.Network("external-access-rule-nw",
            name="sample-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        external_access_rule_np = gcp.vmwareengine.NetworkPolicy("external-access-rule-np",
            location="us-west1",
            name="sample-np",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=external_access_rule_nw.id)
        vmw_engine_external_access_rule = gcp.vmwareengine.ExternalAccessRule("vmw-engine-external-access-rule",
            name="sample-external-access-rule",
            parent=external_access_rule_np.id,
            priority=101,
            action="DENY",
            ip_protocol="TCP",
            source_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            source_ports=["80"],
            destination_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            destination_ports=["433"])
        ```
        ### Vmware Engine External Access Rule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_access_rule_nw = gcp.vmwareengine.Network("external-access-rule-nw",
            name="sample-nw",
            location="global",
            type="STANDARD",
            description="PC network description.")
        external_access_rule_pc = gcp.vmwareengine.PrivateCloud("external-access-rule-pc",
            location="us-west1-a",
            name="sample-pc",
            description="Sample test PC.",
            network_config={
                "management_cidr": "192.168.50.0/24",
                "vmware_engine_network": external_access_rule_nw.id,
            },
            management_cluster={
                "cluster_id": "sample-mgmt-cluster",
                "node_type_configs": [{
                    "node_type_id": "standard-72",
                    "node_count": 3,
                }],
            })
        external_access_rule_np = gcp.vmwareengine.NetworkPolicy("external-access-rule-np",
            location="us-west1",
            name="sample-np",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=external_access_rule_nw.id)
        external_access_rule_ea = gcp.vmwareengine.ExternalAddress("external-access-rule-ea",
            name="sample-ea",
            parent=external_access_rule_pc.id,
            internal_ip="192.168.0.65")
        vmw_engine_external_access_rule = gcp.vmwareengine.ExternalAccessRule("vmw-engine-external-access-rule",
            name="sample-external-access-rule",
            parent=external_access_rule_np.id,
            description="Sample Description",
            priority=101,
            action="ALLOW",
            ip_protocol="tcp",
            source_ip_ranges=[{
                "ip_address_range": "0.0.0.0/0",
            }],
            source_ports=["80"],
            destination_ip_ranges=[{
                "external_address": external_access_rule_ea.id,
            }],
            destination_ports=["433"])
        ```

        ## Import

        ExternalAccessRule can be imported using any of these accepted formats:

        * `{{parent}}/externalAccessRules/{{name}}`

        When using the `pulumi import` command, ExternalAccessRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/externalAccessRule:ExternalAccessRule default {{parent}}/externalAccessRules/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ExternalAccessRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalAccessRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleDestinationIpRangeArgs', 'ExternalAccessRuleDestinationIpRangeArgsDict']]]]] = None,
                 destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleSourceIpRangeArgs', 'ExternalAccessRuleSourceIpRangeArgsDict']]]]] = None,
                 source_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalAccessRuleArgs.__new__(ExternalAccessRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if destination_ip_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'destination_ip_ranges'")
            __props__.__dict__["destination_ip_ranges"] = destination_ip_ranges
            if destination_ports is None and not opts.urn:
                raise TypeError("Missing required property 'destination_ports'")
            __props__.__dict__["destination_ports"] = destination_ports
            if ip_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'ip_protocol'")
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if source_ip_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'source_ip_ranges'")
            __props__.__dict__["source_ip_ranges"] = source_ip_ranges
            if source_ports is None and not opts.urn:
                raise TypeError("Missing required property 'source_ports'")
            __props__.__dict__["source_ports"] = source_ports
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(ExternalAccessRule, __self__).__init__(
            'gcp:vmwareengine/externalAccessRule:ExternalAccessRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleDestinationIpRangeArgs', 'ExternalAccessRuleDestinationIpRangeArgsDict']]]]] = None,
            destination_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ip_protocol: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleSourceIpRangeArgs', 'ExternalAccessRuleSourceIpRangeArgsDict']]]]] = None,
            source_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'ExternalAccessRule':
        """
        Get an existing ExternalAccessRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action that the external access rule performs.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: User-provided description for the external access rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleDestinationIpRangeArgs', 'ExternalAccessRuleDestinationIpRangeArgsDict']]]] destination_ip_ranges: If destination ranges are specified, the external access rule applies only to
               traffic that has a destination IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_ports: A list of destination ports to which the external access rule applies.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which the external access rule applies.
        :param pulumi.Input[str] name: The ID of the external access rule.
        :param pulumi.Input[str] parent: The resource name of the network policy.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        :param pulumi.Input[int] priority: External access rule priority, which determines the external access rule to use when multiple rules apply.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalAccessRuleSourceIpRangeArgs', 'ExternalAccessRuleSourceIpRangeArgsDict']]]] source_ip_ranges: If source ranges are specified, the external access rule applies only to
               traffic that has a source IP address in these ranges.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ports: A list of source ports to which the external access rule applies.
        :param pulumi.Input[str] state: State of the Cluster.
        :param pulumi.Input[str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalAccessRuleState.__new__(_ExternalAccessRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_ip_ranges"] = destination_ip_ranges
        __props__.__dict__["destination_ports"] = destination_ports
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["priority"] = priority
        __props__.__dict__["source_ip_ranges"] = source_ip_ranges
        __props__.__dict__["source_ports"] = source_ports
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return ExternalAccessRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The action that the external access rule performs.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-provided description for the external access rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIpRanges")
    def destination_ip_ranges(self) -> pulumi.Output[Sequence['outputs.ExternalAccessRuleDestinationIpRange']]:
        """
        If destination ranges are specified, the external access rule applies only to
        traffic that has a destination IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_ip_ranges")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of destination ports to which the external access rule applies.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[str]:
        """
        The IP protocol to which the external access rule applies.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the external access rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The resource name of the network policy.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-west1-a/networkPolicies/my-policy
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        External access rule priority, which determines the external access rule to use when multiple rules apply.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> pulumi.Output[Sequence['outputs.ExternalAccessRuleSourceIpRange']]:
        """
        If source ranges are specified, the external access rule applies only to
        traffic that has a source IP address in these ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "source_ip_ranges")

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of source ports to which the external access rule applies.
        """
        return pulumi.get(self, "source_ports")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the Cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

